/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.MyPoint;
import com.dvidearts.jengine.MySprite;

public class Rocket {
    public boolean alive;
    public byte direction;
    public short distanceTraveled;
    public Object object;
    private byte speed;
    private Game game;

    public Rocket(Game g, MySprite spr) {
        this.game = g;
        this.speed = 0;
        this.direction = 0;
        this.distanceTraveled = 0;
        this.speed = (byte)8;
        this.alive = false;
        this.object = new Object(spr);
        this.object.sprite.setOffset(this.game.x - this.object.sprite.getWidth() / 2, this.game.y - this.object.sprite.getHeight() / 2);
    }

    public void Start(MyPoint p, byte bDirection) {
        this.object.sortOffset = 0;
        this.distanceTraveled = 0;
        this.direction = bDirection;
        int offset = this.object.sprite.getWidth() / 4;
        int yoffset = this.game.TILE_SIZE / 10 * 8;
        switch (this.direction) {
            case 0: {
                this.object.ptWorld.set(p.x, p.y - yoffset);
                this.object.sprite.setFrame(9);
                this.object.sprite.defineCollisionRectangle(offset, offset, -offset, -offset);
                break;
            }
            case 1: {
                this.object.ptWorld.set(p.x, p.y);
                this.object.sprite.setFrame(10);
                this.object.sprite.defineCollisionRectangle(offset, offset, -offset, -offset);
                break;
            }
            case 2: {
                this.object.sprite.setFrame(12);
                this.object.ptWorld.set(p.x, p.y - yoffset);
                this.object.sprite.defineCollisionRectangle(offset, this.game.TILE_SIZE / 20 * 15, -offset, this.game.TILE_SIZE / 20 * 2);
                this.object.sortOffset = (short)(-yoffset / 1);
                break;
            }
            case 3: {
                this.object.sprite.setFrame(11);
                this.object.ptWorld.set(p.x, p.y - yoffset);
                this.object.sprite.defineCollisionRectangle(offset, this.game.TILE_SIZE / 20 * 15, -offset, this.game.TILE_SIZE / 20 * 2);
                this.object.sortOffset = (short)(-yoffset / 1);
            }
        }
        this.alive = true;
    }

    public void update(Game game, World world) {
        if (game.popup.isActive) {
            return;
        }
        if (this.alive) {
            this.distanceTraveled = (short)(this.distanceTraveled + 1);
            if (this.distanceTraveled > 30) {
                this.alive = false;
                game.playscreen.world.startExplode(this.object.ptWorld);
                return;
            }
            switch (this.direction) {
                case 0: {
                    this.object.ptWorld.y -= this.speed;
                    break;
                }
                case 1: {
                    this.object.ptWorld.y += this.speed;
                    break;
                }
                case 2: {
                    this.object.ptWorld.x -= this.speed;
                    break;
                }
                case 3: {
                    this.object.ptWorld.x += this.speed;
                }
            }
            this.object.update(game, world);
        }
    }

    public void free() {
        this.object.free();
        this.object = null;
    }
}

