/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.dvj2me;

import com.dvidearts.dvj2me.dvColor;
import com.dvidearts.dvj2me.dvPoint;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class dvSprite {
    private Image[] image;
    private int xo;
    private int yo;
    private int frame;
    public int colx;
    public int coly;
    public int colw;
    public int colh;
    private int x;
    private int y;
    private int width;
    private int height;
    private int numFrames;
    private int sequenceSize;
    public short[] frameSequence;
    private boolean makeImageArray;

    public dvSprite(Image img) {
        this.makeImageArray = false;
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.numFrames = 1;
        this.image = new Image[this.numFrames];
        this.image[0] = img;
        this.initDefaults();
    }

    public dvSprite(Image[] img) {
        if (img == null || img.length == 0) {
            return;
        }
        this.makeImageArray = false;
        this.width = img[0].getWidth();
        this.height = img[0].getHeight();
        this.numFrames = img.length;
        this.image = img;
        this.initDefaults();
    }

    public dvSprite(Image img, int frameWidth, int frameHeight) {
        this.makeImageArray = true;
        this.width = frameWidth;
        this.height = frameHeight;
        try {
            this.image = dvSprite.createImageArray(img, frameWidth, frameHeight);
        }
        catch (Exception e) {
            System.out.println("Exception::dvSprite::" + e.getMessage());
        }
        this.numFrames = this.image.length;
        this.initDefaults();
    }

    public dvSprite(dvSprite sprite) {
        int i;
        this.makeImageArray = sprite.makeImageArray;
        this.width = sprite.width;
        this.height = sprite.height;
        if (this.makeImageArray) {
            dvSprite.freeImageArray(this.image);
            this.image = new Image[sprite.image.length];
            i = 0;
            while (i < sprite.image.length) {
                this.image[i] = Image.createImage((Image)sprite.image[i]);
                ++i;
            }
        } else {
            this.image = sprite.image;
        }
        this.xo = sprite.xo;
        this.yo = sprite.yo;
        this.frame = sprite.frame;
        this.colx = sprite.colx;
        this.coly = sprite.coly;
        this.colw = sprite.colw;
        this.colh = sprite.colh;
        this.x = sprite.x;
        this.y = sprite.y;
        this.numFrames = sprite.numFrames;
        this.sequenceSize = sprite.sequenceSize;
        this.frameSequence = new short[this.sequenceSize];
        i = 0;
        while (i < this.sequenceSize) {
            this.frameSequence[i] = sprite.frameSequence[i];
            ++i;
        }
    }

    private void initDefaults() {
        this.frame = 0;
        this.x = 0;
        this.y = 0;
        this.xo = 0;
        this.yo = 0;
        this.colx = 0;
        this.coly = 0;
        this.colw = 0;
        this.colh = 0;
        this.frameSequence = new short[this.numFrames];
        int i = 0;
        while (i < this.numFrames) {
            this.frameSequence[i] = (short)i;
            ++i;
        }
        this.sequenceSize = this.numFrames;
    }

    public void free() {
        if (this.makeImageArray) {
            dvSprite.freeImageArray(this.image);
        }
        this.frameSequence = null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getXOffset() {
        return this.xo;
    }

    public int getYOffset() {
        return this.yo;
    }

    public int getWidth() {
        return this.width;
    }

    public void setOffset(int sx, int sy) {
        this.xo = sx;
        this.yo = sy;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrame() {
        return this.frame;
    }

    public Image getFrame(int i) {
        if (this.image == null || i < 0 || i >= this.getFrameSequenceLength()) {
            return null;
        }
        return this.image[i];
    }

    public void setPosition(dvPoint p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void setPosition(int X, int Y) {
        this.x = X;
        this.y = Y;
    }

    public void setFrame(int f) {
        if (f < this.getFrameSequenceLength() && f >= 0) {
            this.frame = f;
        }
    }

    public int getFrameSequenceLength() {
        if (this.image == null) {
            return 0;
        }
        return this.sequenceSize;
    }

    public void paint(Graphics g) {
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image[this.frameSequence[this.frame]], this.x + this.xo, this.y + this.yo, 20);
    }

    public void nextFrame() {
        ++this.frame;
        if (this.frame >= this.getFrameSequenceLength()) {
            this.frame = 0;
        }
    }

    public void prevFrame() {
        --this.frame;
        if (this.frame < 0) {
            this.frame = this.getFrameSequenceLength() - 1;
            if (this.frame < 0) {
                this.frame = 0;
            }
        }
    }

    public void setFrameSequence(short[] sequence) {
        this.frameSequence = sequence;
        this.sequenceSize = this.frameSequence.length;
    }

    public boolean collidesWith(int ix, int iy, int iw, int ih) {
        int nx = this.x + this.xo;
        int ny = this.y + this.yo;
        return nx + this.colx < ix + iw && nx + this.colw + this.getWidth() > ix && ny + this.coly < iy + ih && ny + this.colh + this.getHeight() > iy;
    }

    public boolean collidesWith(dvPoint p) {
        int nx = this.x + this.xo;
        int ny = this.y + this.yo;
        return nx + this.colx < p.x && nx + this.colw + this.getWidth() > p.x && ny + this.coly < p.y && ny + this.colh + this.getHeight() > p.y;
    }

    public boolean collidesWith(Image img, int ix, int iy) {
        return this.collidesWith(ix, iy, img.getWidth(), img.getHeight());
    }

    public boolean collidesWith(dvSprite s, int ix, int iy) {
        return this.collidesWith(ix + s.colx + s.getXOffset(), iy + s.coly + s.getYOffset(), s.getWidth() + s.colw - s.colx, s.getHeight() + s.colh - s.coly);
    }

    public boolean collideOnX(Image img, int ix) {
        int nx = this.x + this.xo;
        return nx + this.colx < ix + img.getWidth() && nx + this.colw + this.getWidth() > ix;
    }

    public boolean collidesOnY(Image img, int iy) {
        int ny = this.y + this.yo;
        return ny + this.coly < iy + img.getHeight() && ny + this.colh + this.getHeight() > iy;
    }

    public boolean collidesWith(dvSprite s) {
        return this.collidesWith(s.getX() + s.colx + s.getXOffset(), s.getY() + s.coly + s.getYOffset(), s.getWidth() + s.colw - s.colx, s.getHeight() + s.colh - s.coly);
    }

    public void defineCollisionRectangle(int ix, int iy, int iwidth, int iheight) {
        this.colx = ix;
        this.coly = iy;
        this.colw = iwidth;
        this.colh = iheight;
    }

    public boolean isOnScreen(int iScreenX, int iScreenY, int iScreenWidth, int iScreenHeight) {
        int nx = this.x + this.xo;
        int ny = this.y + this.yo;
        return nx < iScreenX + iScreenWidth && nx + this.getWidth() > iScreenX && ny < iScreenY + iScreenHeight && ny + this.getHeight() > iScreenY;
    }

    public void drawCollisionRectangle(Graphics g, dvColor c) {
        g.setColor(c.r, c.r, c.b);
        g.drawRect(this.x + this.xo + this.colx, this.y + this.yo + this.coly, this.width + this.colw - this.colx, this.height + this.colh - this.coly);
    }

    public void swapImage(Image[] img) {
        this.image = img;
    }

    public static Image[] createImageArray(Image img, int frameWidth, int frameHeight) throws Exception {
        int nrows;
        int ncols = img.getWidth() / frameWidth;
        int tNumFrames = ncols * (nrows = img.getHeight() / frameHeight);
        if (tNumFrames == 0) {
            return null;
        }
        Image[] tImg = new Image[tNumFrames];
        int count = 0;
        int r = 0;
        while (r < nrows) {
            int c = 0;
            while (c < ncols) {
                int tx = frameWidth * count;
                int row = tx / img.getWidth();
                int startx = tx - row * img.getWidth();
                int starty = row * frameHeight;
                try {
                    tImg[count] = Image.createImage((Image)img, (int)startx, (int)starty, (int)frameWidth, (int)frameHeight, (int)0);
                }
                catch (Exception e) {
                    throw new Exception("createImageArray::" + e.getMessage());
                }
                ++count;
                ++c;
            }
            ++r;
        }
        return tImg;
    }

    public static void freeImageArray(Image[] tImg) {
        if (tImg == null) {
            return;
        }
        int i = 0;
        while (i < tImg.length) {
            tImg[i] = null;
            ++i;
        }
        tImg = null;
    }
}

