/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.dvj2me;

import com.dvidearts.dvj2me.dvGameBase;
import com.dvidearts.dvj2me.dvPoint;
import com.dvidearts.dvj2me.dvScreen;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class dvRender
extends Canvas
implements CommandListener,
Runnable {
    public dvScreen currScreen = null;
    private dvGameBase game;
    private char input = (char)32;
    private int MAX_FPS;
    private int maxcurrentframes;
    public int lastKeyCode = 0;
    private short numRepaints;
    private boolean dimset = false;
    private boolean isClipping;
    public boolean keyUp = false;
    public boolean keyDown = false;
    public boolean keyLeft = false;
    public boolean keyRight = false;
    public boolean keySpace = false;
    private int numKeys;
    private short oresh;
    private short oresw;
    private short clipx;
    private short clipy;
    private short clipw;
    private short cliph;
    private int[] key;
    private static final byte MAX_KEYS = 5;
    private Image offscreen;
    private Graphics g2;
    private dvPoint _drag;
    private dvPoint _lastdrag;

    public dvRender(dvGameBase g, int framesPerSecond) {
        this.game = g;
        this.isClipping = false;
        this.offscreen = null;
        if (framesPerSecond < 1) {
            framesPerSecond = 1;
        }
        this.MAX_FPS = 1000 / framesPerSecond;
        this.maxcurrentframes = framesPerSecond;
        this.setFullScreenMode(true);
        this.setCommandListener(this);
        this.setDimentions();
        this.numRepaints = 0;
        this.dimset = false;
        this.key = new int[5];
        int i = 0;
        while (i < 5) {
            this.key[i] = -1;
            ++i;
        }
        this.numKeys = 0;
        this._drag = new dvPoint(0, 0);
        this._lastdrag = new dvPoint(0, 0);
    }

    public int getMaxFramesPerSecond() {
        return this.maxcurrentframes;
    }

    private void setDimentions() {
        this.game.width = (short)this.getWidth();
        this.game.height = (short)this.getHeight();
        this.game.wcenter = (short)(this.game.width / 2);
        this.game.hcenter = (short)(this.game.height / 2);
        if (this.game.width >= 320 && this.game.height >= 480) {
            this.game.buildType = 0;
            this.game.resw = (short)320;
            this.game.resh = (short)480;
        } else if (this.game.width >= 320 && this.game.height >= 320) {
            this.game.buildType = 1;
            this.game.resw = (short)320;
            this.game.resh = (short)320;
        } else if (this.game.width >= 240 && this.game.height >= 240) {
            this.game.buildType = (byte)2;
            this.game.resw = (short)240;
            this.game.resh = (short)240;
        } else if (this.game.width >= 240 && this.game.height >= 160) {
            this.game.buildType = (byte)3;
            this.game.resw = (short)240;
            this.game.resh = (short)160;
        } else {
            this.game.buildType = (byte)4;
            this.game.resw = (short)176;
            this.game.resh = (short)220;
        }
        this.game.x = (short)(this.game.wcenter - this.game.resw / 2);
        this.game.y = (short)(this.game.hcenter - this.game.resh / 2);
        this.game.reswc = (short)(this.game.x + this.game.resw / 2);
        this.game.reshc = (short)(this.game.y + this.game.resh / 2);
        this.clipx = this.game.x;
        this.clipy = this.game.y;
        this.cliph = this.oresh = this.game.resh;
        this.clipw = this.oresw = this.game.resw;
        this.initClipping();
    }

    public void setBuildType(byte val) {
        boolean isSet = false;
        switch (val) {
            case 4: {
                this.game.resw = (short)176;
                this.game.resh = (short)220;
                isSet = true;
                break;
            }
            case 3: {
                this.game.resw = (short)240;
                this.game.resh = (short)160;
                isSet = true;
                break;
            }
            case 2: {
                this.game.resw = (short)240;
                this.game.resh = (short)240;
                isSet = true;
                break;
            }
            case 1: {
                this.game.resw = (short)320;
                this.game.resh = (short)320;
                isSet = true;
                break;
            }
            case 0: {
                this.game.resw = (short)320;
                this.game.resh = (short)480;
                isSet = true;
            }
        }
        if (isSet) {
            this.game.buildType = val;
            this.game.x = (short)(this.game.wcenter - this.game.resw / 2);
            this.game.y = (short)(this.game.hcenter - this.game.resh / 2);
            this.game.reswc = (short)(this.game.x + this.game.resw / 2);
            this.game.reshc = (short)(this.game.y + this.game.resh / 2);
            this.clipx = this.game.x;
            this.clipy = this.game.y;
            this.cliph = this.oresh = this.game.resh;
            this.clipw = this.oresw = this.game.resw;
            this.initClipping();
        }
    }

    public short getOriginalResHeight() {
        return this.oresh;
    }

    public short getOriginalResWidth() {
        return this.oresw;
    }

    public void run() {
        while (!this.game.isExit()) {
            long startTime = System.currentTimeMillis();
            if (this.currScreen != null) {
                this.keyUp = false;
                this.keyDown = false;
                this.keyLeft = false;
                this.keyRight = false;
                this.keySpace = false;
                if (this.numKeys == 0) {
                    this.currScreen.Process(0);
                } else {
                    int i = 0;
                    while (i < 5) {
                        if (this.key[i] != -1) {
                            switch (this.key[i]) {
                                case 6: {
                                    this.keyDown = true;
                                    break;
                                }
                                case 1: {
                                    this.keyUp = true;
                                    break;
                                }
                                case 2: {
                                    this.keyLeft = true;
                                    break;
                                }
                                case 5: {
                                    this.keyRight = true;
                                    break;
                                }
                                case 8: {
                                    this.keySpace = true;
                                }
                            }
                            this.currScreen.Process(this.key[i]);
                        }
                        ++i;
                    }
                }
                if (this.game.dvpopup != null) {
                    this.game.dvpopup.update();
                }
            }
            this.repaint();
            long timeTaken = System.currentTimeMillis() - startTime;
            if (timeTaken < (long)this.MAX_FPS) {
                try {
                    Thread.sleep((long)this.MAX_FPS - timeTaken);
                }
                catch (Exception exception) {}
                continue;
            }
            Thread.yield();
        }
        this.game.free();
    }

    private void initClipping() {
        this.isClipping = this.game.width > this.game.resw || this.game.height > this.game.resh;
    }

    public void paint(Graphics g) {
        if (!this.dimset) {
            this.numRepaints = (short)(this.numRepaints + 1);
            if (this.numRepaints > 2) {
                this.numRepaints = (short)2;
                this.setDimentions();
                this.dimset = true;
                this.offscreen = Image.createImage((int)this.getWidth(), (int)this.getHeight());
                this.g2 = this.offscreen.getGraphics();
                this.initClipping();
            }
            return;
        }
        if (this.currScreen == null) {
            return;
        }
        this.game.currframe = (short)(this.game.currframe + 1);
        if (this.game.currframe > this.maxcurrentframes) {
            this.game.currframe = 0;
        }
        this.currScreen.Render(this.g2);
        if (this.game.dvpopup != null && this.game.dvpopup.IsActive()) {
            this.game.dvpopup.draw(this.g2, this.game.x, this.game.y, this.game.resw, this.game.resh);
        }
        if (this.isClipping) {
            this.clip(this.g2, this.clipx, this.clipy, this.clipw, this.cliph);
        }
        g.drawImage(this.offscreen, 0, 0, 20);
    }

    public void ClearScreen(Graphics grx, int r, int g, int b) {
        if (this.currScreen == null) {
            return;
        }
        grx.setColor(r, g, b);
        grx.fillRect(0, 0, (int)this.game.width, (int)this.game.height);
    }

    public char getInput() {
        return this.input;
    }

    public void clearKeys() {
        int i = 0;
        while (i < 5) {
            this.key[i] = -1;
            ++i;
        }
        this.numKeys = 0;
    }

    protected void keyReleased(int keyCode) {
        if (this.currScreen == null) {
            return;
        }
        int ga = this.getMappedGameAction(keyCode);
        int i = 0;
        while (i < 5) {
            if (ga == this.key[i]) {
                this.key[i] = -1;
                --this.numKeys;
                i = 5;
                break;
            }
            ++i;
        }
        this.currScreen.keyReleased(ga);
    }

    protected void keyPressed(int keyCode) {
        if (this.numKeys >= 5) {
            return;
        }
        this.lastKeyCode = keyCode;
        if (this.currScreen == null) {
            return;
        }
        int ga = this.getMappedGameAction(keyCode);
        boolean found = false;
        int i = 0;
        while (i < 5) {
            if (ga == this.key[i]) {
                found = true;
                i = 5;
                break;
            }
            ++i;
        }
        if (!found) {
            i = 0;
            while (i < 5) {
                if (this.key[i] == -1) {
                    this.key[i] = ga;
                    ++this.numKeys;
                    i = 5;
                    break;
                }
                ++i;
            }
        }
        this.currScreen.keyPressed(ga);
    }

    public int getMappedGameAction(int code) {
        int ga = this.getGameAction(code);
        this.input = (char)126;
        if (code > 0) {
            this.input = (char)code;
        }
        if (code == 53 || this.input == '5' || this.input == ' ' || this.input == 'd' && code != 52) {
            ga = 8;
        } else if (code == 50 || this.input == '2' || this.input == 'e' && code != 49) {
            ga = 1;
        } else if (code == 56 || this.input == '8' || this.input == 'x') {
            ga = 6;
        } else if (code == 52 || this.input == '4' || this.input == 's') {
            ga = 2;
        } else if (code == 54 || this.input == '6' || this.input == 'f' && code != 52) {
            ga = 5;
        } else if (code == 35 || this.input == 'q') {
            this.input = (char)35;
            ga = 0;
        } else if (code == 42 || this.input == 'a' || code == 130) {
            this.input = (char)42;
            ga = 0;
        } else if (code == 48 || code == 137 || code == 32) {
            ga = 0;
            this.input = (char)48;
        } else if (this.input == 'r' || this.input == 'c' || this.input == 'u' || this.input == 'n' || this.input == 'l' || this.input == 'a' || this.input == 'q' || this.input == 'z') {
            ga = 0;
        }
        return ga;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (this.currScreen == null) {
            return;
        }
        this.currScreen.commandAction(command, displayable);
    }

    private void clip(Graphics g, int ix, int iy, int iw, int ih) {
        int xw = ix + iw;
        int yh = iy + ih;
        g.setColor(0, 0, 0);
        if (iy > 0) {
            g.fillRect(0, 0, (int)this.game.width, iy);
        }
        if (yh < this.game.height) {
            g.fillRect(0, yh, (int)this.game.width, this.game.height - yh);
        }
        if (ix > 0) {
            g.fillRect(0, 0, ix, (int)this.game.height);
        }
        if (xw < this.game.width) {
            g.fillRect(xw, 0, this.game.width - xw, (int)this.game.height);
        }
    }

    public void setClip(int ix, int iy, int iw, int ih) {
        if (ix >= 0) {
            this.clipx = (short)ix;
        }
        if (iy >= 0) {
            this.clipy = (short)iy;
        }
        if (iw >= 0) {
            this.clipw = (short)iw;
        }
        if (ih >= 0) {
            this.cliph = (short)ih;
        }
    }

    public short getClipX() {
        return this.clipx;
    }

    public short getClipY() {
        return this.clipy;
    }

    public short getClipWidth() {
        return this.clipw;
    }

    public short getClipHeight() {
        return this.cliph;
    }

    protected void pointerPressed(int x, int y) {
        if (this.currScreen == null) {
            return;
        }
        dvPoint point = new dvPoint(x, y);
        this.currScreen.pointerPressed(point);
        point = null;
    }

    protected void pointerReleased(int x, int y) {
        if (this.currScreen == null) {
            return;
        }
        dvPoint point = new dvPoint(x, y);
        this._lastdrag.x = 0;
        this._drag.x = 0;
        this._lastdrag.y = 0;
        this._drag.y = 0;
        this.currScreen.pointerReleased(point);
        point = null;
    }

    protected void pointerDragged(int x, int y) {
        if (this.currScreen == null) {
            return;
        }
        dvPoint point = new dvPoint(x, y);
        if (this._lastdrag.x == 0 && this._lastdrag.y == 0) {
            this._lastdrag.x = point.x;
            this._lastdrag.y = point.y;
        } else {
            this._drag.x = point.x - this._lastdrag.x;
            this._drag.y = point.y - this._lastdrag.y;
            this._lastdrag.x = point.x;
            this._lastdrag.y = point.y;
        }
        this.currScreen.pointerDragged(point, this._drag);
        point = null;
    }
}

