/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public final class Battle {
    static GameEngine engine;
    MyGameCanvas canvas;
    Fighter[] fr;
    Fighter[] fl;
    public Skill skill;
    private Item item;
    static int index;
    byte range;
    static final byte ROLEMAX = 10;
    static int wait;
    static byte curSt;
    byte lastSt = 0;
    public static int battleResult;
    public static short[] round;
    public static byte addMoney;
    public static byte addExp;
    static boolean canEscape;
    static boolean canLose;
    static boolean autoRun;
    static int turn;
    static boolean stopBattle;
    static boolean isEscape;
    static byte curBattleEvent;
    protected static final byte B_WAIT = -1;
    protected static final byte B_READY = 0;
    protected static final byte B_RUN = 1;
    protected static final byte B_FRACTION = 2;
    protected static final byte B_FLACTION = 3;
    protected static final byte B_SELECTAIM = 4;
    protected static final byte B_ACTIONREADY = 5;
    protected static final byte B_RUNACTION = 6;
    protected static final byte B_ITEM = 7;
    protected static final byte B_USEITEM = 8;
    protected static final byte B_SKILL = 9;
    protected static final byte B_OVER = 10;
    protected static final byte B_SHOP = 11;
    protected static final byte B_BUYSURE = 12;
    public static final short S1 = 70;
    public static final short S2 = 45;
    public static final short H1 = 150;
    public static final short H2 = 200;
    public static final short H3 = 250;
    public Fighter[] aimTeam;
    boolean actionOver;
    public static final byte PERS = 40;
    public int runSkillIndex;
    boolean actionOverDelay;
    static final byte EPADD1 = 4;
    static final byte EPADD2 = 2;
    boolean isConHit;
    boolean isCounterstrike;
    byte aimIndex;
    public static final short[] imgbattleBgImgs;
    short[][] starPos = new short[20][3];
    byte[] hillPos = new byte[]{-1, 0, 1, 2, 1, 0};
    byte[][] adNum = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, -12, -18, -26, -30, -32, -35, -35, -35}};
    Vector VhitNum = new Vector();
    public static int frIndex;
    public static int frIndex1;
    byte actionIndex = 0;
    private byte wordIndex;
    private byte wordTurn;
    byte bagMax = (byte)28;
    byte btFrameIndex;
    byte btFrameIndex1;
    byte skillFrameIndex;
    byte skillFrameIndex1;
    byte skillMax = 0;
    byte shopIndex;
    byte shopIndex1;
    byte shopMax = (byte)17;
    byte[] shopDat = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    byte e = 1;
    byte m = 1;
    boolean isLevelUp;
    byte[] curLv = new byte[3];
    String[] battleOverInfo;
    int infoIndex;
    Vector itemDataBTV;
    Vector itemIndexBTV;
    byte tempIndex;
    Event event;
    short pathIndex;

    public Battle(GameEngine en) {
        engine = en;
        this.canvas = MyGameCanvas.me;
    }

    public void free() {
        this.fr = null;
        this.fl = null;
        this.skill = null;
        this.item = null;
    }

    public void initBattle(byte[] rightTeam, byte[][] leftTeam) {
        int i;
        this.fr = new Fighter[rightTeam.length];
        for (i = 0; i < rightTeam.length; ++i) {
            if (rightTeam[i] > 3) continue;
            this.fr[i] = GameEngine.role[rightTeam[i]];
            Fighter cfr_ignored_0 = this.fr[i];
            Fighter.ep = (short)20;
        }
        this.fl = new Fighter[leftTeam.length];
        for (i = 0; i < leftTeam.length; ++i) {
            this.fl[i] = new Fighter(engine);
            this.fl[i].initFighter(leftTeam[i][0], leftTeam[i][1], GameEngine.enemyNames[i], GameEngine.enemyLevel[i]);
        }
        Battle.engine.superBomb = false;
        this.initBattleValue();
        this.clearHitValue();
        autoRun = false;
        isEscape = false;
        GameEngine.isBattle = true;
        turn = 0;
        this.runSkillIndex = 0;
        this.actionOver = false;
        frIndex = 0;
        this.initStar();
    }

    private void initBattleValue() {
        int i;
        switch (this.fr.length) {
            case 1: {
                this.fr[0].x = GameMap.screenWidth - 70;
                this.fr[0].y = 200;
                break;
            }
            case 2: {
                this.fr[0].x = GameMap.screenWidth - 45;
                this.fr[0].y = 150;
                this.fr[1].x = GameMap.screenWidth - 45;
                this.fr[1].y = 250;
                break;
            }
            case 3: {
                this.fr[0].x = GameMap.screenWidth - 45;
                this.fr[0].y = 150;
                this.fr[1].x = GameMap.screenWidth - 70;
                this.fr[1].y = 200;
                this.fr[2].x = GameMap.screenWidth - 45;
                this.fr[2].y = 250;
            }
        }
        switch (this.fl.length) {
            case 1: {
                if (this.fl[0].modle == 2) {
                    this.fl[0].x = 34;
                    this.fl[0].y = 244;
                    break;
                }
                if (this.fl[0].modle == 7) {
                    this.fl[0].x = 40;
                    this.fl[0].y = 220;
                    break;
                }
                this.fl[0].x = 70;
                this.fl[0].y = 200;
                break;
            }
            case 2: {
                this.fl[0].x = 45;
                this.fl[0].y = 150;
                this.fl[1].x = 45;
                this.fl[1].y = 250;
                break;
            }
            case 3: {
                this.fl[0].x = 45;
                this.fl[0].y = 150;
                this.fl[1].x = 70;
                this.fl[1].y = 200;
                this.fl[2].x = 45;
                this.fl[2].y = 250;
            }
        }
        for (i = 0; i < this.fr.length; ++i) {
            this.fr[i].bx = this.fr[i].x;
            this.fr[i].by = this.fr[i].y;
            this.fr[i].isEnemy = false;
            this.fr[i].setStatus((byte)0);
            this.fr[i].index = GameEngine.nextInt(7);
            this.fr[i].lossHpIndex = 0;
            this.fr[i].isTurnOver = false;
            this.newBuff(this.fr[i]);
        }
        for (i = 0; i < this.fl.length; ++i) {
            this.fl[i].bx = this.fl[i].x;
            this.fl[i].by = this.fl[i].y;
            this.fl[i].isEnemy = true;
            this.fl[i].setStatus((byte)0);
            this.fl[i].isTurnOver = false;
            this.newBuff(this.fl[i]);
        }
        this.clearHitValue();
    }

    private void clearHitValue() {
        int i;
        for (i = 0; i < this.fr.length; ++i) {
            this.fr[i].isFlash = false;
            this.fr[i].isHited = false;
            this.fr[i].hitNum = null;
        }
        for (i = 0; i < this.fl.length; ++i) {
            this.fl[i].isFlash = false;
            this.fl[i].isHited = false;
            this.fl[i].hitNum = null;
        }
    }

    public void setBattleST(byte st) {
        index = 0;
        this.lastSt = curSt;
        curSt = st;
    }

    void initSkill(int skIndex) {
        this.skill = null;
        this.skill = new Skill(engine);
        this.skill = GameEngine.sk[skIndex];
        this.range = this.skill.range;
    }

    private byte getRoleNormalAttackIndex(Fighter f) {
        switch (f.type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 7;
            }
            case 2: {
                return 14;
            }
        }
        return 35;
    }

    void createAimTeam(int range) {
        this.aimTeam = null;
        switch (range) {
            case 0: 
            case 1: 
            case 5: {
                this.aimTeam = new Fighter[1];
                if (range == 0) {
                    this.aimIndex = this.actionIndex;
                }
                this.aimTeam[0] = this.actionIndex < 10 ? this.fr[this.aimIndex] : this.fl[this.aimIndex];
                break;
            }
            case 3: {
                this.aimTeam = new Fighter[1];
                this.aimTeam[0] = this.actionIndex < 10 ? this.fl[this.aimIndex] : this.fr[this.aimIndex];
                break;
            }
            case 12: {
                byte live0 = this.getTotalLive(this.actionIndex < 10 ? this.fl : this.fr);
                this.aimTeam = new Fighter[live0 > 1 ? 2 : 1];
                if (live0 == 1) {
                    this.aimIndex = this.getLive(true, 0);
                    this.aimTeam[0] = this.actionIndex < 10 ? this.fl[this.aimIndex] : this.fr[this.aimIndex];
                    break;
                }
                if (live0 == 2 && (this.actionIndex < 10 ? this.fl.length == 2 : this.fr.length == 2)) {
                    this.aimTeam[0] = this.actionIndex < 10 ? this.fl[0] : this.fr[0];
                    this.aimTeam[1] = this.actionIndex < 10 ? this.fl[1] : this.fr[1];
                    break;
                }
                if (this.aimIndex == 0 || this.aimIndex == 1) {
                    this.aimTeam[0] = this.actionIndex < 10 ? this.fl[this.aimIndex] : this.fr[this.aimIndex];
                    Fighter fighter = this.aimTeam[1] = this.actionIndex < 10 ? this.fl[this.aimIndex + 1] : this.fr[this.aimIndex + 1];
                }
                if (this.aimIndex != 2) break;
                this.aimTeam[0] = this.actionIndex < 10 ? this.fl[0] : this.fr[0];
                this.aimTeam[1] = this.actionIndex < 10 ? this.fl[2] : this.fr[2];
                break;
            }
            case 4: {
                byte live = this.getTotalLive(this.actionIndex < 10 ? this.fl : this.fr);
                this.aimTeam = new Fighter[live];
                if (this.actionIndex < 10) {
                    int temp = 0;
                    block8: for (int j = 0; j < this.aimTeam.length; ++j) {
                        for (int i = j + temp; i < this.fl.length; ++i) {
                            if (this.fl[i].hp > 0) {
                                this.aimTeam[j] = this.fl[i];
                                continue block8;
                            }
                            temp = (byte)(temp + 1);
                        }
                    }
                } else {
                    int temp = 0;
                    block10: for (int j = 0; j < this.aimTeam.length; ++j) {
                        for (int i = j + temp; i < this.fr.length; ++i) {
                            if (this.fr[i].hp > 0) {
                                this.aimTeam[j] = this.fr[i];
                                continue block10;
                            }
                            temp = (byte)(temp + 1);
                        }
                    }
                }
                break;
            }
            case 2: {
                byte live2 = this.getTotalLive(this.actionIndex < 10 ? this.fr : this.fl);
                this.aimTeam = new Fighter[live2];
                if (this.actionIndex < 10) {
                    int temp = 0;
                    block12: for (int j = 0; j < this.aimTeam.length; ++j) {
                        for (int i = j + temp; i < this.fr.length; ++i) {
                            if (this.fr[i].hp > 0) {
                                this.aimTeam[j] = this.fr[i];
                                continue block12;
                            }
                            temp = (byte)(temp + 1);
                        }
                    }
                } else {
                    int temp = 0;
                    block14: for (int j = 0; j < this.aimTeam.length; ++j) {
                        for (int i = j + temp; i < this.fl.length; ++i) {
                            if (this.fl[i].hp > 0) {
                                this.aimTeam[j] = this.fl[i];
                                continue block14;
                            }
                            temp = (byte)(temp + 1);
                        }
                    }
                }
                break;
            }
            case 11: {
                int i;
                this.aimTeam = new Fighter[this.fr.length + this.fl.length];
                for (i = 0; i < this.fr.length; ++i) {
                    this.aimTeam[i] = this.fr[i];
                }
                for (i = this.fr.length; i < this.aimTeam.length; ++i) {
                    this.aimTeam[i] = this.fl[i - this.fr.length];
                }
                break;
            }
        }
    }

    void initActionVaule(Fighter af) {
        for (int i = 0; i < this.aimTeam.length; ++i) {
            this.aimTeam[i].hitNum = new int[this.skill.hitIndex.length];
            if (this.skill.formula != 1) {
                this.aimTeam[i].isHited = this.aimTeam[i].hp > 0 || this.range == 5;
                af.isFlash = false;
            } else {
                this.aimTeam[i].isHited = (!Tools.percent(this.aimTeam[i].miss) || this.aimTeam[i].buff[3][0] != 0) && this.aimTeam[i].hp > 0;
                af.isFlash = Tools.percent(af.flash) && this.aimTeam[i].isHited;
            }
            this.getHitVaule(af, this.aimTeam[i], this.skill);
        }
    }

    private void getHitVaule(Fighter role, Fighter enemy, Skill sk) {
        block6: for (int i = 0; i < enemy.hitNum.length; ++i) {
            switch (sk.formula) {
                case 0: {
                    enemy.hitNum[i] = Math.max(GameEngine.cureFormula(role, enemy, sk), 1);
                    continue block6;
                }
                case 1: {
                    enemy.hitNum[i] = GameEngine.commonFormula(role, enemy, sk, true);
                    continue block6;
                }
                case 2: {
                    enemy.hitNum[i] = GameEngine.commonFormula(role, enemy, sk, false);
                    continue block6;
                }
                case 3: {
                    enemy.hitNum[i] = GameEngine.cureFormula(role, enemy, sk);
                    continue block6;
                }
                default: {
                    enemy.hitNum[i] = 0;
                }
            }
        }
    }

    private void setFighterStatus(Fighter f, byte state) {
        if (f.curStatus != state) {
            f.setStatus(state);
        }
    }

    private void actionOver(Fighter af) {
        boolean tmp = af.isTurnOver;
        af.isTurnOver = true;
        this.actionOver = true;
        this.setBattleST((byte)1);
        this.runSkillIndex = 0;
        this.clearHitValue();
        wait = 0;
        frIndex = 0;
        frIndex1 = 0;
        this.skillFrameIndex = 0;
        this.skillFrameIndex1 = 0;
        this.shopIndex = 0;
        this.shopIndex1 = 0;
        if (!this.isCounterstrike) {
            af.speedIndex = 0;
        } else {
            af.isTurnOver = tmp;
        }
        this.isCounterstrike = false;
    }

    private void removeSleepBuff(Fighter f, int hurtNum) {
    }

    boolean isAction(int id) {
        if (curSt == 0 || this.actionIndex > 10) {
            return false;
        }
        return this.actionIndex == id;
    }

    private boolean battleFalse() {
        for (int i = 0; i < this.fr.length; ++i) {
            if (this.fr[i].hp <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean battleWin() {
        for (int i = 0; i < this.fl.length; ++i) {
            if (this.fl[i].hp <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean checkTurnOver() {
        int i;
        for (i = 0; i < this.fr.length; ++i) {
            if (this.fr[i].isTurnOver || this.fr[i].hp <= 0) continue;
            return false;
        }
        for (i = 0; i < this.fl.length; ++i) {
            if (this.fl[i].isTurnOver || this.fl[i].hp <= 0) continue;
            return false;
        }
        ++turn;
        return true;
    }

    private void setAllRoleTurn() {
        int i;
        for (i = 0; i < this.fr.length; ++i) {
            this.fr[i].isTurnOver = false;
        }
        for (i = 0; i < this.fl.length; ++i) {
            this.fl[i].isTurnOver = false;
        }
    }

    public byte getAcitonFighterIndex() {
        int i;
        byte turn = 0;
        int speed = -1;
        for (i = 0; i < this.fr.length; ++i) {
            if (this.fr[i].isTurnOver || this.fr[i].hp <= 0 || this.getRoleSpe(this.fr[i]) <= speed) continue;
            speed = this.getRoleSpe(this.fr[i]);
            turn = (byte)i;
        }
        for (i = 0; i < this.fl.length; ++i) {
            if (this.fl[i].isTurnOver || this.fl[i].hp <= 0 || this.getRoleSpe(this.fl[i]) <= speed) continue;
            speed = this.getRoleSpe(this.fl[i]);
            turn = (byte)(i + 10);
        }
        GameMap.setOff(0, 0);
        return turn;
    }

    private int getRoleSpe(Fighter r) {
        short spe = r.speed;
        return spe;
    }

    private void runFlAction() {
        byte emyIndex = (byte)(this.actionIndex - 10);
        this.emyAI(this.fl[emyIndex]);
        this.createAimTeam(this.range);
        this.initActionVaule(this.fl[emyIndex]);
        wait = 0;
        this.setBattleST((byte)6);
    }

    private void emyAI(Fighter r) {
        byte skillType = this.getSkillType(r.AItype, r);
        if (skillType > r.skillData.length - 1) {
            skillType = 0;
        }
        this.initSkill(r.skillData[skillType]);
        this.aimIndex = this.getEmyAIAim(this.range);
    }

    byte getSkillType(int AIType, Fighter r) {
        int AIturn = 1;
        switch (AIType) {
            case 0: {
                return (byte)GameEngine.nextInt(r.skillData.length - 1);
            }
            case 1: {
                AIturn = 8;
                if (turn % AIturn == 0) {
                    return 0;
                }
                return (byte)(turn % AIturn == 1 ? 1 : 0);
            }
            case 2: {
                AIturn = 5;
                if (turn % AIturn == 0) {
                    return 0;
                }
                if (turn % AIturn == 1) {
                    return 1;
                }
                if (turn % AIturn == 2) {
                    return 2;
                }
                if (turn % AIturn == 3) {
                    return 3;
                }
                return 4;
            }
            case 3: {
                AIturn = 7;
                if (turn % AIturn == 0) {
                    return 0;
                }
                if (turn % AIturn == 1) {
                    return 1;
                }
                if (turn % AIturn == 2) {
                    return 2;
                }
                if (turn % AIturn == 3) {
                    return 3;
                }
                if (turn % AIturn == 4) {
                    return 4;
                }
                if (turn % AIturn == 5) {
                    return 5;
                }
                return 6;
            }
            case 4: {
                AIturn = 8;
                if (turn % AIturn == 0) {
                    return 0;
                }
                if (turn % AIturn == 1) {
                    return 1;
                }
                if (turn % AIturn == 2) {
                    return 2;
                }
                if (turn % AIturn == 3) {
                    return 3;
                }
                if (turn % AIturn == 4) {
                    return 4;
                }
                if (turn % AIturn == 5) {
                    return 5;
                }
                if (turn % AIturn == 6) {
                    return 6;
                }
                return 7;
            }
        }
        return 0;
    }

    private byte getEmyAIAim(byte range) {
        byte rndAim = 0;
        switch (range) {
            case 0: {
                rndAim = (byte)(this.actionIndex - 10);
                break;
            }
            case 1: {
                rndAim = (byte)GameEngine.nextInt(this.fl.length - 1);
                while (this.fl[rndAim].hp <= 0) {
                    rndAim = (byte)GameEngine.nextInt(this.fl.length - 1);
                }
                break;
            }
            case 3: {
                rndAim = (byte)GameEngine.nextInt(this.fr.length - 1);
                while (this.fr[rndAim].hp <= 0) {
                    rndAim = (byte)GameEngine.nextInt(this.fr.length - 1);
                }
                break;
            }
            case 2: 
            case 4: 
            case 11: {
                rndAim = 0;
            }
        }
        return rndAim;
    }

    byte getTotalLive(Fighter[] f) {
        byte live = 0;
        for (int i = 0; i < f.length; ++i) {
            if (f[i].hp <= 0) continue;
            live = (byte)(live + 1);
        }
        return live;
    }

    private void runAction(Fighter af) {
        block46: {
            block47: {
                switch (this.skill.fashion) {
                    case 0: {
                        if (wait == 0) {
                            af.setSpurtXY(this.aimTeam[0].x + (this.aimTeam[0].isEnemy ? 50 : -20 + this.getEmyAttX(af.modle)), this.aimTeam[0].y);
                            this.setFighterStatus(af, (byte)5);
                            if (af.type == 2 && !af.isEnemy) {
                                af.drawCurIndexEffect(2, this.aimTeam[0].x + 2, this.aimTeam[0].y + 1, 42, 0, this.aimTeam[0].y + 31);
                            }
                            if (af.type == 8 && af.isEnemy) {
                                af.drawCurIndexEffect(2, this.aimTeam[0].x + 2, this.aimTeam[0].y + 1, 46, 0, this.aimTeam[0].y + 31);
                            }
                            for (int i = 0; i < this.aimTeam.length; ++i) {
                                if (this.skill.formula != 1 || this.aimTeam[i].isHited) continue;
                                this.setFighterStatus(this.aimTeam[i], (byte)7);
                            }
                            this.runHurt(af);
                            this.drawBattleInfo(this.skill.name);
                            break;
                        }
                        if (wait != 1) break;
                        if (af.type == 0 && !af.isEnemy) {
                            this.setFighterStatus(af, (byte)6);
                            break;
                        }
                        if (af.type == 1 && !af.isEnemy) {
                            this.setFighterStatus(af, (byte)14);
                            break;
                        }
                        if ((af.type == 2 || af.type == 12 || af.type == 5) && af.isEnemy) {
                            this.setFighterStatus(af, (byte)6);
                            break;
                        }
                        this.setFighterStatus(af, (byte)13);
                        break;
                    }
                    case 1: {
                        if (wait == 0) {
                            af.setSpurtXY(this.aimTeam[0].x + (this.aimTeam[0].isEnemy ? 60 : -60), this.aimTeam[0].y);
                            this.setFighterStatus(af, (byte)8);
                            this.runHurt(af);
                            this.drawBattleInfo(this.skill.name);
                            break;
                        }
                        if (wait != 1) break;
                        this.setFighterStatus(af, (byte)6);
                        break;
                    }
                    case 6: {
                        if (wait == 0) {
                            af.setSpurtXY(this.aimTeam[0].x + (this.aimTeam[0].isEnemy ? 60 : -60), this.aimTeam[0].y);
                            this.setFighterStatus(af, (byte)9);
                            this.runHurt(af);
                            this.drawBattleInfo(this.skill.name);
                            break;
                        }
                        if (wait != 1) break;
                        this.setFighterStatus(af, (byte)6);
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (wait == 0) {
                            this.setFighterStatus(af, (byte)12);
                            this.drawBattleInfo(this.skill.name);
                            break;
                        }
                        if (wait == 1) {
                            this.setFighterStatus(af, (byte)1);
                            if (this.skill.effectType != 0) {
                                if (this.skill.fashion == 3) {
                                    engine.drawSkillEft(this.skill.effectType, this.aimTeam, af.isEnemy ? 1 : 0);
                                } else {
                                    engine.drawSkillEft(this.skill.effectType, af.isEnemy ? 1 : 0);
                                }
                            }
                            this.runHurt(af);
                            this.drawBattleInfo(this.skill.name);
                            break;
                        }
                        if (wait < 2) break;
                        if (!af.isEnemy) {
                            if (wait == 2) {
                                this.setFighterStatus(af, af.type == 1 ? (byte)13 : 0);
                            }
                        } else if (af.isEnemy && wait == 2) {
                            ++wait;
                        }
                        if (wait != 3) break;
                        this.setFighterStatus(af, (byte)0);
                        break;
                    }
                    case 2: {
                        if (wait == 0) {
                            this.setFighterStatus(af, (byte)12);
                            this.drawBattleInfo(this.skill.name);
                            break;
                        }
                        if (wait == 1) {
                            this.setFighterStatus(af, (byte)1);
                            if (this.skill.effectType != 0) {
                                engine.drawSkillEft(this.skill.effectType, this.aimTeam, af.isEnemy ? 1 : 0);
                            }
                            this.runHurt(af);
                            this.drawBattleInfo(this.skill.name);
                            break;
                        }
                        if (wait == 2) {
                            if (af.type == 1) {
                                this.setFighterStatus(af, (byte)13);
                                break;
                            }
                            this.setFighterStatus(af, (byte)0);
                            break;
                        }
                        if (wait != 3) break;
                        this.setFighterStatus(af, (byte)0);
                        break;
                    }
                    case 5: {
                        if (wait != 0) break;
                        this.setFighterStatus(af, (byte)7);
                        this.drawBattleInfo(this.skill.name);
                        if (af.index == 1) {
                            boolean bl = isEscape = Tools.percent(af.escapePercent);
                        }
                        if (af.index < 9) break;
                        if (isEscape) {
                            af.setStatus((byte)0);
                            this.battleOverClear();
                            frIndex = 0;
                            frIndex1 = 0;
                            this.skillFrameIndex = 0;
                            this.skillFrameIndex1 = 0;
                            this.shopIndex = 0;
                            this.shopIndex1 = 0;
                            MyGameCanvas.setST((byte)14);
                            break;
                        }
                        if (af.index == 9) {
                            MyGameCanvas.setInfo(new String[]{"\u9003\u8dd1\u5931\u8d25\uff01"});
                        }
                        if (af.index < af.motion.length - 1) break;
                        af.setStatus((byte)0);
                        af.x = af.bx;
                        af.y = af.by;
                        wait = 3;
                    }
                }
                if (wait < 2) break block46;
                if (wait == 2) {
                    this.runBuff(af, this.aimTeam);
                    engine.removeBuff(this.skill.removeBuff, this.aimTeam[0]);
                }
                if (wait != 2 || af.type != 1) {
                    ++wait;
                }
                if (af.type != 1) break block46;
                if (Fighter.lastStatus == 6) break block47;
                if (Fighter.lastStatus == 13) break block47;
                if (Fighter.lastStatus != 14) break block46;
            }
            ++wait;
        }
        if (!this.actionOverDelay && wait >= 8) {
            this.actionOverDelay = true;
            wait = 10;
        }
        if (this.actionOverDelay) {
            if (wait == 10) {
                this.HOT(this.isCounterstrike ? this.aimTeam[0] : af, 15);
            }
            if (wait == 15) {
                this.recoverMp(this.isCounterstrike ? this.aimTeam[0] : af, 20);
            }
            if (wait == 20) {
                this.recoverEp(this.isCounterstrike ? this.aimTeam[0] : af, 30);
            }
            if (wait == 30) {
                this.actionOverDelay = false;
                this.actionOver(af);
            }
        }
    }

    private byte getEmyAttX(byte emyModle) {
        byte num = 0;
        switch (emyModle) {
            case 0: {
                num = 0;
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 14: 
            case 17: {
                num = -25;
                break;
            }
            case 2: {
                num = -35;
                break;
            }
            case 4: 
            case 5: 
            case 18: {
                num = -30;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                num = -15;
                break;
            }
            case 10: 
            case 15: {
                num = -50;
                break;
            }
            case 6: {
                num = -40;
                break;
            }
            case 11: {
                num = -20;
            }
        }
        return num;
    }

    private void runHurt(Fighter af) {
        for (int i = 0; i < this.skill.hitIndex.length; ++i) {
            int j;
            if (this.runSkillIndex == this.skill.hitIndex[i]) {
                for (j = 0; j < this.aimTeam.length; ++j) {
                    if (this.skill.formula == 3) {
                        this.cure(this.aimTeam[j], this.aimTeam[j].hitNum[i]);
                    } else {
                        this.hurt(this.aimTeam[j], this.aimTeam[j].hitNum[i], af.isFlash, i == this.skill.hitIndex.length - 1);
                        if (this.aimTeam[j].isHited && this.skill.formula == 1 && af.absorb != 0) {
                            int cureNum = this.aimTeam[j].hitNum[i] * af.absorb / 100;
                            af.hp += cureNum;
                            af.hp = Math.min(af.hp, af.hp_max);
                            this.addHitNum(Math.abs(cureNum), 5, af.x, af.y, 2000);
                        }
                    }
                    if (i != 0) continue;
                    this.hurtGetEp(af, this.aimTeam[i].isHited);
                    this.hurtedGetEp(this.aimTeam[i]);
                }
            }
            if (this.runSkillIndex != this.skill.hitIndex[i] + 1) continue;
            for (j = 0; j < this.aimTeam.length && this.aimTeam[j].isHited; ++j) {
                this.addHitNum(Math.abs(this.aimTeam[j].hitNum[i]), this.skill.formula == 3 && this.skill.buffType == 0 ? 5 : (af.isFlash && this.skill.formula == 1 ? 1 : 0), this.aimTeam[j].x + 18, this.aimTeam[j].y, 2000);
                if (!af.isFlash) continue;
                Effect.AddEffectList(0, 0, 25, 0, 2000);
            }
        }
        ++this.runSkillIndex;
    }

    private void hurt(Fighter hf, int hurtValue, boolean isFlash, boolean lastHit) {
        if (!hf.isHited) {
            this.addHitNum(1, 6, hf.x, hf.y, hf.y);
            return;
        }
        hf.hp -= hurtValue;
        this.setLossHpIndex(hf, Math.min(hf.hp, hurtValue));
        if (isFlash && this.skill.formula == 1) {
            GameEngine.drawColorScreenBG(0xFF0000, 350);
        }
        if (hf.hp <= 0 && lastHit) {
            hf.hp = 0;
            hf.buff = new short[8][2];
            if (hf.curStatus != 4 && hf.isInjure) {
                hf.setStatus((byte)3);
                hf.isInjure = false;
            }
        } else {
            hf.setStatus((byte)2);
        }
    }

    void hurtGetEp(Fighter f, boolean isHited) {
        if (!isHited) {
            return;
        }
        Fighter.ep = (short)(Fighter.ep + (4 + f.getMoreEp));
        Fighter.ep = (short)Math.min(f.ep_max, Fighter.ep);
    }

    void hurtedGetEp(Fighter f) {
        if (!f.isHited || this.skill.fashion == 3) {
            return;
        }
        Fighter.ep = (short)(Fighter.ep + (2 + f.getMoreEp));
        Fighter.ep = (short)Math.min(f.ep_max, Fighter.ep);
    }

    private void cure(Fighter hf, int cureNum) {
        if (!hf.isHited) {
            return;
        }
        hf.hp += cureNum;
        hf.hp = Math.min(hf.hp, hf.hp_max);
        engine.removeBuff(this.skill.removeBuff, hf);
    }

    private void runBuff(Fighter af, Fighter[] f) {
        for (int i = 0; i < f.length; ++i) {
            if (!this.canBuff(f[i], this.skill)) continue;
            f[i].buff[this.skill.buffType][0] = this.skill.buffTurn;
            f[i].buff[this.skill.buffType][1] = this.skill.buffValue;
            if (this.skill.buffType != 2) continue;
            int dap = 100 + af.dap;
            int immPer = f[i].pimm + f[i].buff[5][1];
            f[i].buff[this.skill.buffType][1] = (short)Math.max((af.attack - f[i].def / 2) * (dap - immPer) / 100, 1);
        }
    }

    private boolean canBuff(Fighter f, Skill sk) {
        if (sk.buffType == 0 || !f.isHited || f.buff[this.skill.buffType][0] != 0 && f.buff[this.skill.buffType][1] > this.skill.buffValue || f.hp <= 0) {
            return false;
        }
        int hitPercent = this.skill.buffMZ;
        switch (sk.buffType) {
            case 3: {
                hitPercent -= f.dotImm;
                break;
            }
            case 2: {
                hitPercent -= f.dotImm;
            }
        }
        return Tools.percent(hitPercent);
    }

    boolean runConHit(Fighter f) {
        if (this.isConHit || this.isCounterstrike || this.skill.formula != 1 || this.aimTeam[0].hp <= 0 || !this.aimTeam[0].isHited) {
            return false;
        }
        this.isConHit = true;
        this.initActionVaule(f);
        wait = 0;
        this.runSkillIndex = 0;
        this.addHitNum(1, 2, f.x, f.y, f.y);
        return true;
    }

    boolean runCounterstrike(Fighter af, Fighter[] hf) {
        if (hf == null || this.isConHit || this.isCounterstrike || this.skill.formula != 1 || hf[0].hp <= 0 || !hf[0].isHited) {
            return false;
        }
        this.actionOver(af);
        this.setBattleST((byte)6);
        this.isCounterstrike = true;
        if (this.actionIndex < 10) {
            this.aimIndex = (byte)(this.aimIndex + 10);
        }
        byte tmp = this.actionIndex;
        this.actionIndex = this.aimIndex;
        this.aimIndex = tmp;
        this.initSkill(this.actionIndex < 10 ? this.getRoleNormalAttackIndex(this.fr[this.actionIndex]) : this.fl[this.actionIndex - 10].skillData[0]);
        this.aimTeam = new Fighter[1];
        this.aimTeam[0] = af;
        this.initActionVaule(hf[0]);
        wait = 0;
        this.runSkillIndex = 0;
        this.addHitNum(1, 3, hf[0].x, hf[0].y, hf[0].y);
        return true;
    }

    private void HOT(Fighter f, int waitVal) {
        byte tmp = f.hpRecover;
        if (f.hp <= 0 || tmp == 0) {
            wait = waitVal;
            return;
        }
        short hitNum = (short)Math.max(1, tmp * f.hp_max / 100);
        f.hp += hitNum;
        f.hp = Math.min(f.hp, f.hp_max);
        this.addHitNum(Math.abs(hitNum), 5, f.x + 10, f.y, f.y);
    }

    private void recoverMp(Fighter f, int waitVal) {
        if (f.hp <= 0 || f.mpRecover == 0) {
            wait = waitVal;
            return;
        }
        short hitNum = (short)Math.max(1, f.mpRecover * f.mp_max / 100);
        f.mp = (short)(f.mp + hitNum);
        f.mp = (short)Math.min(f.mp, f.mp_max);
        this.addHitNum(Math.abs(hitNum), 5, f.x + 10, f.y, f.y);
    }

    private void recoverEp(Fighter f, int waitVal) {
        if (f.hp <= 0 || f.epRecover == 0) {
            wait = waitVal;
            return;
        }
        short hitNum = f.epRecover;
        Fighter.ep = (short)(Fighter.ep + hitNum);
        Fighter.ep = (short)Math.min(Fighter.ep, f.ep_max);
        this.addHitNum(Math.abs(hitNum), 5, f.x + 10, f.y, f.y);
    }

    private void runAutoAttack() {
        this.initSkill(this.getRoleNormalAttackIndex(this.fr[this.actionIndex]));
        this.aimIndex = this.getRndEnemyAim();
        this.createAimTeam(this.range);
        this.initActionVaule(this.fr[this.actionIndex]);
        this.setBattleST((byte)6);
        wait = 0;
    }

    private byte getRndEnemyAim() {
        byte rndAim = 0;
        do {
            rndAim = (byte)GameEngine.nextInt(this.fl.length - 1);
        } while (this.fl[rndAim].hp <= 0);
        return rndAim;
    }

    private void runUseItem(Fighter af) {
        int i;
        if (wait == 0) {
            this.setFighterStatus(af, (byte)12);
        }
        if (wait == 9) {
            this.setFighterStatus(af, (byte)0);
            for (i = 0; i < this.aimTeam.length; ++i) {
                Effect.AddEffectList(this.aimTeam[i].x, this.aimTeam[i].y, 22, 0, this.aimTeam[i].y + 31);
            }
        }
        if (wait >= 14) {
            block11: for (i = 0; i < this.aimTeam.length; ++i) {
                if (wait == 14) {
                    switch (this.item.type) {
                        case 0: {
                            short numHp = (short)engine.addHpFormula(this.item.property1, this.aimTeam[i].hp_max, this.item.property2, this.aimTeam[i].pesticide);
                            this.addHitNum(numHp, 5, this.aimTeam[i].x, this.aimTeam[i].y, this.aimTeam[i].y);
                            this.aimTeam[i].hp += numHp;
                            this.aimTeam[i].hp = Math.min(this.aimTeam[i].hp, this.aimTeam[i].hp_max);
                            break;
                        }
                        case 1: {
                            short numMp = (short)engine.addHpFormula(this.item.property1, this.aimTeam[i].mp_max, this.item.property2, this.aimTeam[i].pesticide);
                            this.addHitNum(numMp, 5, this.aimTeam[i].x, this.aimTeam[i].y, this.aimTeam[i].y);
                            this.aimTeam[i].mp = (short)(this.aimTeam[i].mp + numMp);
                            this.aimTeam[i].mp = (short)Math.min(this.aimTeam[i].mp, this.aimTeam[i].mp_max);
                            break;
                        }
                        case 2: {
                            short numHp1 = (short)engine.addHpFormula(this.item.property1, this.aimTeam[i].hp_max, 0, this.aimTeam[i].pesticide);
                            this.addHitNum(numHp1, 5, this.aimTeam[i].x, this.aimTeam[i].y, this.aimTeam[i].y);
                            this.aimTeam[i].hp += numHp1;
                            this.aimTeam[i].hp = Math.min(this.aimTeam[i].hp, this.aimTeam[i].hp_max);
                            break;
                        }
                        case 5: {
                            short numEp = (short)engine.addHpFormula(this.item.property1, this.aimTeam[i].ep_max, this.item.property2, this.aimTeam[i].pesticide);
                            this.addHitNum(numEp, 5, this.aimTeam[i].x, this.aimTeam[i].y, this.aimTeam[i].y);
                            Fighter cfr_ignored_0 = this.aimTeam[i];
                            Fighter.ep = (short)(Fighter.ep + numEp);
                            Fighter cfr_ignored_1 = this.aimTeam[i];
                            Fighter cfr_ignored_2 = this.aimTeam[i];
                            Fighter.ep = (short)Math.min(Fighter.ep, this.aimTeam[i].ep_max);
                            break;
                        }
                        case 4: {
                            short numHp2 = (short)engine.addHpFormula(this.item.property1, this.aimTeam[i].hp_max, this.item.property2, this.aimTeam[i].pesticide);
                            this.addHitNum(numHp2, 5, this.aimTeam[i].x, this.aimTeam[i].y, this.aimTeam[i].y);
                            this.aimTeam[i].hp = numHp2;
                            this.aimTeam[i].hp = Math.min(this.aimTeam[i].hp, this.aimTeam[i].hp_max);
                            break;
                        }
                        default: {
                            wait = 17;
                        }
                    }
                }
                if (wait != 18) continue;
                switch (this.item.type) {
                    case 2: {
                        short numMp = (short)engine.addHpFormula(this.item.property2, this.aimTeam[i].mp_max, 0, this.aimTeam[i].pesticide);
                        this.addHitNum(numMp, 5, this.aimTeam[i].x, this.aimTeam[i].y, this.aimTeam[i].y);
                        this.aimTeam[i].mp = (short)(this.aimTeam[i].mp + numMp);
                        this.aimTeam[i].mp = (short)Math.min(this.aimTeam[i].mp, this.aimTeam[i].mp_max);
                        continue block11;
                    }
                    default: {
                        wait = 25;
                    }
                }
            }
        }
        if (++wait >= 26) {
            engine.removeBuff(this.item.removeBuff, this.aimTeam[0]);
            this.actionOver(af);
        }
    }

    private void runActionReady(Fighter f) {
        if (wait < 15) {
            if (f.buff[2][0] == 0) {
                wait = 15;
            } else {
                this.drawBattleInfo(f.name + "\u6bd2\u53d1");
                if (wait == 1) {
                    // empty if block
                }
                if (wait == 4) {
                    this.DOT(f);
                }
            }
        }
        if (wait >= 15) {
            if (f.buff[3][0] > 0) {
                this.drawBattleInfo(f.name + "\u660f\u8ff7\u4e2d");
            } else {
                wait = 22;
            }
        }
        if (wait >= 22) {
            if (f.buff[3][0] > 0) {
                short[] sArray = f.buff[3];
                sArray[0] = (short)(sArray[0] - 1);
                this.removeBuff(f);
                this.actionOver(f);
                return;
            }
            if (f.buff[5][0] > 0) {
                short[] sArray = f.buff[5];
                sArray[0] = (short)(sArray[0] - 1);
            }
            this.removeBuff(f);
            this.setBattleST(f.isEnemy ? (byte)3 : 2);
            wait = 0;
        }
        ++wait;
    }

    private void DOT(Fighter f) {
        short hitNum = (short)(f.buff[2][1] * (4 - f.buff[2][0]) * 80 / 100 / 4);
        f.hp -= hitNum;
        this.addHitNum(hitNum, 0, f.x, f.y, f.y + 100);
        this.setFighterStatus(f, (byte)2);
        short[] sArray = f.buff[2];
        sArray[0] = (short)(sArray[0] - 1);
        if (f.hp <= 0) {
            f.setSpurtXY(GameEngine.nextInt(10, 12), GameEngine.nextInt(20) * (GameEngine.nextInt(1) == 0 ? -1 : 1));
            this.setFighterStatus(f, (byte)4);
            f.hp = 0;
            this.actionOver(f);
        } else {
            this.setFighterStatus(f, (byte)2);
        }
    }

    void removeBuff(Fighter f) {
        for (int i = 0; i < f.buff.length; ++i) {
            if (f.buff[i][0] != 0) continue;
            f.buff[i] = new short[2];
        }
    }

    public void runBattle() {
        int i;
        engine.screenShake();
        for (i = 0; i < this.fr.length; ++i) {
            this.fr[i].move();
        }
        for (i = 0; i < this.fl.length; ++i) {
            this.fl[i].move();
        }
        if (stopBattle || Event.isBreakBattle) {
            return;
        }
        switch (curSt) {
            case 0: {
                if (++index < 10) break;
                this.setBattleST((byte)1);
                break;
            }
            case 1: {
                if (this.battleFalse() || this.battleWin()) {
                    this.setBattleST((byte)10);
                    wait = 0;
                } else {
                    if (this.checkTurnOver()) {
                        this.setAllRoleTurn();
                    }
                    this.actionIndex = this.getAcitonFighterIndex();
                    if (this.actionIndex == 0) {
                        if (MyGameCanvas.AchieveMentID[8] == 1) {
                            for (i = 0; i < this.fr.length; ++i) {
                                this.fr[i].mp = (short)(this.fr[i].mp + this.fr[i].mp_max * 5 / 100);
                                this.fr[i].mp = (short)Math.min(this.fr[i].mp, this.fr[i].mp_max);
                            }
                        }
                        if (MyGameCanvas.AchieveMentID[9] == 1) {
                            for (i = 0; i < this.fr.length; ++i) {
                                this.fr[i].hp += this.fr[i].hp_max * 5 / 100;
                                this.fr[i].hp = Math.min(this.fr[i].hp, this.fr[i].hp_max);
                            }
                        }
                    }
                    this.setBattleST((byte)5);
                    wait = 0;
                }
                wait = 0;
                break;
            }
            case 5: {
                this.runActionReady(this.actionIndex < 10 ? this.fr[this.actionIndex] : this.fl[this.actionIndex - 10]);
                break;
            }
            case 3: {
                this.runFlAction();
                break;
            }
            case 6: {
                this.runAction(this.actionIndex < 10 ? this.fr[this.actionIndex] : this.fl[this.actionIndex - 10]);
                break;
            }
            case 2: {
                if (!autoRun) break;
                this.runAutoAttack();
                break;
            }
            case 8: {
                this.runUseItem(this.fr[this.actionIndex]);
            }
        }
    }

    private void drawBattleBG() {
        Tools.addImage(244, GameMap.setOffX, GameMap.setOffY, 20, (byte)0, 20);
        Tools.addImage(244, GameMap.setOffX + 240 / 2, GameMap.setOffY, 20, (byte)1, 20);
        Tools.addImage(271, GameMap.setOffX + 20, GameMap.setOffY + 7, 0, 0, 100, 20, 20, (byte)0, 20);
        Tools.addImage(271, GameMap.setOffX + 120, GameMap.setOffY + 7, 0, 0, 100, 20, 20, (byte)1, 20);
        GameEngine.drawColorScreenBG(0, 10);
        Tools.addImage(imgbattleBgImgs[GameEngine.map.battleBg], GameMap.setOffX, GameMap.setOffY + 37, 20, (byte)0, 10);
        this.drawBBG();
        if (stopBattle) {
            return;
        }
        if (autoRun && MyGameCanvas.gameTime % 6 < 3) {
            Tools.addColorString((byte)4, "\u81ea\u52a8", GameMap.setOffX + 120, GameMap.setOffY + 50, 33, 0, 0xFF0000, 9999);
        }
    }

    private void drawBBG() {
        switch (GameEngine.map.battleBg) {
            case 0: {
                this.drawBBG2(GameMap.setOffX, GameMap.setOffY, 10);
                break;
            }
            case 1: {
                this.drawBBG1(GameMap.setOffX, GameMap.setOffY, 10);
            }
        }
    }

    private void initStar() {
        for (int i = 0; i < this.starPos.length; ++i) {
            short tempZ;
            short tempY;
            short tempX;
            this.starPos[i][0] = tempX = (short)GameEngine.nextInt(5, 190);
            this.starPos[i][1] = tempY = (short)GameEngine.nextInt(0, 93);
            this.starPos[i][2] = tempZ = (short)GameEngine.nextInt(20);
        }
    }

    private void drawBBG1(int x, int y, int dl) {
        for (int i = 0; i < this.starPos.length; ++i) {
            Tools.addImage(3, x + this.starPos[i][0], y + 28 + this.starPos[i][1], (MyGameCanvas.gameTime + this.starPos[i][2]) % 12 / 4 == 0 ? 0 : 13, 0, 13, 11, 20, (byte)0, dl);
        }
    }

    private void drawBBG2(int x, int y, int dl) {
        Tools.addImage(5, x - 4, y + 34 + this.hillPos[MyGameCanvas.gameTime % 30 / 5], 20, (byte)0, dl);
        Tools.addImage(6, x + 158, y + 34 + this.hillPos[(MyGameCanvas.gameTime + 4) % 24 / 4], 20, (byte)0, dl);
    }

    private void drawHead(int x, int y) {
        if (MyGameCanvas.gameStatus == 21) {
            return;
        }
        if (curSt == 2 || curSt == 7 || curSt == 9 || curSt == 11) {
            this.drawBattleMenu(this.fr[this.actionIndex], GameMap.setOffX, GameMap.setOffY + GameMap.screenHeight - 66);
        } else {
            int sx = 16;
            int sy = 6;
            for (int i = 0; i < this.fr.length; ++i) {
            }
        }
    }

    private void drawRoleHeadBT(int x, int y, int roleType, int dl) {
        this.canvas.drawRoundrect(1, x, y, 66, 32, 0, 16488473, dl);
        int img = 0;
        byte[] headPos = null;
        switch (roleType) {
            case 0: {
                img = 107;
                headPos = new byte[]{25, 56};
                break;
            }
            case 1: {
                img = 108;
                headPos = new byte[]{27, 55};
                break;
            }
            case 3: {
                img = 109;
                headPos = new byte[]{40, 57};
                break;
            }
            case 2: {
                img = 110;
                headPos = new byte[]{13, 45};
                break;
            }
            default: {
                System.out.println("\u51fa\u9519\uff0cdrawHeadBoxV\uff08\uff09-------");
                return;
            }
        }
        System.out.println("img = " + img);
        Tools.addImage(img, x + 1, y + 1, headPos[0], headPos[1], 64, 30, 20, (byte)0, dl);
    }

    private void drawRoleBTValueAndNum(int x, int y, Fighter r, int dl) {
        Tools.addRect((byte)1, x - 1, y - 1, 66, 6, true, 20, 6693397, dl);
        Tools.addRect((byte)1, x, y, 64, 4, true, 20, 9898000, dl);
        Tools.addRect((byte)1, x - 1, y - 1 + 7, 66, 6, true, 20, 6693397, dl);
        Tools.addRect((byte)1, x, y + 7, 64, 4, true, 20, 1536127, dl);
        Tools.addRect((byte)1, x - 1, y - 1 + 14, 66, 6, true, 20, 6693397, dl);
        Tools.addRect((byte)1, x, y + 14, 64, 4, true, 20, 11499786, dl);
        this.drawRoleHpBar(x, y, r, 64, dl);
        this.drawLossHp(x, y, r, dl);
    }

    void setLossHpIndex(Fighter r, int hurtValue) {
        if (r.modleType == 1) {
            return;
        }
        r.lossHpIndex = (short)(r.lossHpIndex + hurtValue * 64 / r.hp_max);
    }

    private void drawLossHp(int x, int y, Fighter r, int dl) {
        Tools.addRect((byte)1, x + r.hp * 64 / r.hp_max, y, r.lossHpIndex, 4, true, 20, 0xFF0000, dl);
        MyGameCanvas cfr_ignored_0 = GameEngine.me.canvas;
        if (MyGameCanvas.gameTime % 3 == 0 && r.lossHpIndex > 0) {
            r.lossHpIndex = (short)(r.lossHpIndex - 1);
        }
    }

    private void drawHitNum() {
        for (int i = 0; i < this.VhitNum.size(); ++i) {
            int[] temp = (int[])this.VhitNum.elementAt(i);
            int clipW = 14;
            int clipH = 19;
            int img = 0;
            switch (temp[1]) {
                case 0: 
                case 5: {
                    img = 17;
                    clipW = 16;
                    clipH = 21;
                    temp[0] = Math.min(99999, temp[0]);
                    byte seat = (byte)Tools.getSeat(temp[0]);
                    int len = clipW * seat + (seat - 1);
                    Tools.drawnum(temp[0], img, temp[1] == 5 ? 1 : 0, temp[2] - len / 2 + this.adNum[0][temp[4]], temp[3] + this.adNum[1][temp[4]], clipW, clipH, 1, 3, temp[5] + 32);
                    break;
                }
                case 1: {
                    img = 18;
                    clipW = 20;
                    clipH = 27;
                    temp[0] = Math.min(99999, temp[0]);
                    byte seat1 = (byte)Tools.getSeat(temp[0]);
                    int len1 = clipW * seat1 + (seat1 - 1);
                    Tools.drawnum(temp[0], img, 0, temp[2] - len1 / 2 + this.adNum[0][temp[4]], temp[3] + this.adNum[1][temp[4]], clipW, clipH, 1, 3, temp[5] + 32);
                    break;
                }
                case 2: {
                    img = 13;
                    clipW = 44;
                    clipH = 23;
                    Tools.addImage(img, temp[2] - clipW / 2, temp[3] + this.adNum[1][temp[4]], 0, 0, clipW, clipH, 36, (byte)0, temp[5] + 32);
                    break;
                }
                case 3: {
                    img = 13;
                    clipW = 44;
                    clipH = 23;
                    Tools.addImage(img, temp[2] - clipW / 2, temp[3] + this.adNum[1][temp[4]], 0, 23, clipW, clipH, 36, (byte)0, temp[5] + 32);
                    break;
                }
                case 6: {
                    img = 13;
                    clipW = 44;
                    clipH = 23;
                    Tools.addImage(img, temp[2] - clipW / 2, temp[3] + this.adNum[1][temp[4]], 0, 46, clipW, clipH, 36, (byte)0, temp[5] + 32);
                }
            }
            temp[4] = temp[4] + 1;
            if (temp[4] < this.adNum[0].length) continue;
            this.VhitNum.removeElementAt(i);
            --i;
        }
    }

    private void addHitNum(int num, int type, int x, int y, int dl) {
        if (num == 0) {
            return;
        }
        this.VhitNum.addElement(new int[]{num, type, x, y, 0, dl});
    }

    public void drawBattleInfo(String info) {
        if (MyGameCanvas.gameStatus == 21) {
            return;
        }
        Tools.addString((byte)4, info, GameMap.setOffX + 240 / 2, GameMap.setOffY + 16, 33, 16711529, 9999);
    }

    private void drawReady() {
        if (stopBattle) {
            return;
        }
        this.drawBattleInfo("\u6218\u6597\u5373\u5c06\u5f00\u59cb\uff01");
    }

    private void drawFrAction() {
        if (autoRun) {
            this.runAutoAttack();
        } else {
            this.drawArrow2(this.fr[this.actionIndex].x, this.fr[this.actionIndex].y);
            this.drawBattleInfo(this.fr[this.actionIndex].name + "\u884c\u52a8\u4e2d");
        }
        this.drawHead(GameMap.setOffX, GameMap.setOffY + GameMap.screenHeight - 66);
    }

    public void drawArrow2(int x, int y) {
        int ind = MyGameCanvas.gameTime % 8 / 2;
        Object offsetDat = null;
        offsetDat = new byte[][]{{0, 24, -8}, {1, 24, -8}, {2, 24, -8}, {3, 24, -8}};
        byte curInd = offsetDat[ind][0];
        byte adx = (byte)(offsetDat[ind][1] * -1);
        byte ady = (byte)(offsetDat[ind][2] * -1);
        Tools.drawFrame((short)9, new byte[][]{{0, 0, 0, 0, 0, 2, 2, -22, 2, 0}, {0, 0, 0, 0, 0, 3, 2, -22, 2, 0}, {0, 0, 0, 0, 0, 4, 2, -22, 2, 0}, {1, 0, 0, 0, 0, 5, 2, -25, 3, 0}, {6, 0, 0, 0, 0}, {7, 0, 0, 0, 0}, {8, 0, 0, 0, 0}, {9, 0, 0, 0, 0}}, (byte[][])new byte[][]{{0, 0, 15, 26}, {15, 0, 15, 26}, {30, 0, 11, 15}, {42, 0, 11, 15}, {30, 15, 11, 13}, {41, 15, 10, 11}, {0, 28, 50, 12}, {0, 40, 48, 12}, {0, 53, 49, 13}, {0, 66, 49, 14}}, x + adx, y + ady, curInd + 4, false, 31);
    }

    private void drawBattleMenu(Fighter f, int x, int y) {
        if (curSt == 2) {
            Tools.addImage(10, GameMap.setOffX + 83, GameMap.setOffY + 72, 0, 0, 68, 157, 20, (byte)0, 2000);
            if (frIndex == 5) {
                Tools.addImage(10, GameMap.setOffX + 109, GameMap.setOffY + 123, 68, 0, 19, 19, 20, (byte)0, 2000);
            }
            byte[][][] tempAddxy = new byte[][][]{new byte[][]{{0, -6, -12, -18, -24, -31}, {0, -4, -8, -12, -16, -19}}, new byte[][]{{0, -6, -12, -18, -24, -31}, {0, 4, 8, 12, 16, 19}}, new byte[][]{{0, 3, 6, 8, 11, 13}, {0, 7, 13, 20, 27, 33}}, new byte[][]{{0, 7, 14, 22, 29, 36}, {0, 0, 0, 0, 0, 0}}, new byte[][]{{0, 3, 6, 8, 11, 13}, {0, -7, -13, -20, -27, -33}}, new byte[][]{{0, -6, -12, -18, -24, -31}, {0, -4, -8, -12, -16, -19}}};
            for (int i = 0; i < 5; ++i) {
                byte[][] addxy = new byte[][]{{0, 0}, {31, -19}, {18, -52}, {-18, -52}, {-31, -19}};
                int ax = addxy[i - frIndex1 >= 0 ? i - frIndex1 : i - frIndex1 + 5][0] + (this.wordTurn == 1 ? tempAddxy[i - frIndex1 >= 0 ? i - frIndex1 : i - frIndex1 + 5][0][this.wordIndex] : (this.wordTurn == 0 ? (byte)0 : -tempAddxy[(i - frIndex1 >= 0 ? i - frIndex1 : i - frIndex1 + 5) + 1 > 4 ? 0 : (i - frIndex1 >= 0 ? i - frIndex1 : i - frIndex1 + 5) + 1][0][this.wordIndex]));
                int ay = addxy[i - frIndex1 >= 0 ? i - frIndex1 : i - frIndex1 + 5][1] + (this.wordTurn == 1 ? tempAddxy[i - frIndex1 >= 0 ? i - frIndex1 : i - frIndex1 + 5][1][this.wordIndex] : (this.wordTurn == 0 ? (byte)0 : -tempAddxy[(i - frIndex1 >= 0 ? i - frIndex1 : i - frIndex1 + 5) + 1 > 4 ? 0 : (i - frIndex1 >= 0 ? i - frIndex1 : i - frIndex1 + 5) + 1][1][this.wordIndex]));
                Tools.addImage(16, GameMap.setOffX + 105 + ax, GameMap.setOffY + 168 + ay, 0 + i * 27, i == frIndex ? 0 : 27, 27, 27, 20, (byte)0, i == frIndex1 || i == frIndex ? 2000 : 1999);
            }
            if (this.wordTurn != 0) {
                this.wordIndex = (byte)(this.wordIndex + 1);
                if (this.wordIndex >= 6) {
                    this.wordIndex = 0;
                    this.wordTurn = 0;
                    frIndex1 = frIndex;
                }
            }
        }
        byte[][] nameDat = new byte[][]{{13, 48, 15, 48}, {0, 48, 13, 48}, {28, 48, 15, 48}};
        byte[][] nameDat1 = new byte[][]{{0, 48, 13, 48}, {28, 48, 15, 48}};
        Tools.addImage(11, GameMap.setOffX, GameMap.setOffY + 320, 0, 0, 240, 61, 36, (byte)0, 620);
        Tools.addImage(11, GameMap.setOffX + 54, GameMap.setOffY + 320 - 35, 88, 63, Fighter.ep * 125 / f.ep_max, 10, 36, (byte)0, 620);
        Tools.drawnum(Fighter.ep, 270, 0, GameMap.setOffX + 115, GameMap.setOffY + 320 - 36, 6, 7, 0, 1, 621);
        Tools.addImage(11, GameMap.setOffX + 69, GameMap.setOffY + 320 - 19, 0, 63, f.hp * 70 / f.hp_max, 5, 36, (byte)0, 620);
        Tools.drawnum(f.hp, 270, 0, GameMap.setOffX + 105, GameMap.setOffY + 320 - 23, 6, 7, 0, 1, 621);
        Tools.addImage(270, GameMap.setOffX + 111, GameMap.setOffY + 320 - 23, 60, 0, 6, 7, 36, (byte)0, 621);
        Tools.drawnum(f.hp_max, 270, 0, GameMap.setOffX + 116, GameMap.setOffY + 320 - 23, 6, 7, 0, 36, 621);
        Tools.addImage(11, GameMap.setOffX + 69, GameMap.setOffY + 320 - 5, 0, 68, f.mp * 84 / f.mp_max, 5, 36, (byte)0, 620);
        Tools.drawnum(f.mp, 270, 0, GameMap.setOffX + 115, GameMap.setOffY + 320 - 9, 6, 7, 0, 1, 621);
        Tools.addImage(270, GameMap.setOffX + 121, GameMap.setOffY + 320 - 9, 60, 0, 6, 7, 36, (byte)0, 621);
        Tools.drawnum(f.mp_max, 270, 0, GameMap.setOffX + 126, GameMap.setOffY + 320 - 9, 6, 7, 0, 36, 621);
        Tools.addImage(256, GameMap.setOffX + 216, GameMap.setOffY + 320 - 7, GameEngine.roleTeam.length == 2 ? nameDat1[this.actionIndex] : (GameEngine.roleTeam.length == 1 ? nameDat[1] : nameDat[this.actionIndex]), 36, (byte)0, 620);
        if (Fighter.ep == f.ep_max) {
            Tools.addImage(61, GameMap.setOffX + 174, GameMap.setOffY + 288, 0, 197, 23, 26, 36, (byte)0, 620);
            if (MyGameCanvas.gameTime % 42 == 0) {
                Effect.AddEffectList(GameMap.setOffX + 174, GameMap.setOffY + 288, 48, 0, 621);
            }
        } else {
            Tools.addImage(61, GameMap.setOffX + 174, GameMap.setOffY + 288, 23, 197, 23, 26, 36, (byte)0, 620);
        }
        if (!autoRun) {
            this.drawHalfHeadImg(f.type, GameMap.setOffX, GameMap.setOffY - 3, 620);
        }
    }

    private void drawRoleHpBar(int x, int y, Fighter r, int len, int dl) {
        int hpLen = r.hp * len / r.hp_max;
        if (r.hp > 0) {
            hpLen = Math.max(1, hpLen);
        }
        MyGameCanvas cfr_ignored_0 = GameEngine.me.canvas;
        if (MyGameCanvas.gameTime % 4 >= 2 && r.hp < r.hp_max / 3) {
            Tools.addRect((byte)1, x, y, hpLen, 4, true, 20, 16758159, dl);
        }
    }

    private void drawHalfHeadImg(int fType, int x, int y, int dl) {
        int headIndent = 0;
        int img = 0;
        if (fType == 0) {
            headIndent = -7;
            img = 107;
        } else if (fType == 1) {
            headIndent = 2;
            img = 108;
        } else if (fType == 2) {
            headIndent = -7;
            img = 109;
        }
        Tools.addImage(img, x + headIndent - 25, y + GameMap.screenHeight + 8, 36, (byte)0, 620);
    }

    private void drawSelect(int x, int y, int range) {
        int sx = 16;
        int sy = GameMap.screenHeight - 66 + 6;
        this.drawArrow2(this.fr[this.actionIndex].x, this.fr[this.actionIndex].y);
        switch (range) {
            case 0: {
                this.drawBattleInfo(this.fr[this.actionIndex].name);
                this.drawArrow1(this.fr[this.actionIndex].x - 30, this.fr[this.actionIndex].y - 15, true, this.fr[this.actionIndex]);
                break;
            }
            case 1: 
            case 5: {
                this.drawBattleInfo(this.fr[Battle.index].name);
                this.drawArrow1(this.fr[Battle.index].x - 30, this.fr[Battle.index].y - 15, true, this.fr[index]);
                break;
            }
            case 2: {
                this.drawBattleInfo("\u6211\u65b9\u5168\u4f53");
                for (int i = 0; i < this.fr.length; ++i) {
                    if (this.fr[i].hp <= 0) continue;
                    this.drawArrow1(this.fr[i].x - 30, this.fr[i].y - 15, true, this.fr[i]);
                }
                break;
            }
            case 10: {
                this.drawBattleInfo("\u6211\u65b9\u4e24\u76ee\u6807");
                if (this.getTotalLive(this.actionIndex < 10 ? this.fr : this.fl) != 3) {
                    for (int i = 0; i < this.fr.length; ++i) {
                        if (this.fr[i].hp <= 0) continue;
                        this.drawArrow1(this.fr[i].x + 30, this.fr[i].y - 15, false, this.fr[i]);
                    }
                    break;
                }
                if (index == 0 || index == 1) {
                    this.drawArrow1(this.fr[Battle.index + 1].x - 30, this.fr[Battle.index + 1].y - 15, true, this.fr[index + 1]);
                    Tools.addRect((byte)1, x + sx + 71 * (index + 1), y + sy, 66, 32, false, 20, 2490366, 620);
                    this.drawArrow1(this.fr[Battle.index].x - 30, this.fr[Battle.index].y - 15, true, this.fr[index + 1]);
                }
                if (index != 2) break;
                this.drawArrow1(this.fr[0].x - 30, this.fr[0].y - 15, true, this.fr[0]);
                Tools.addRect((byte)1, x + sx, y + sy, 66, 32, false, 20, 2490366, 620);
                this.drawArrow1(this.fr[2].x - 30, this.fr[2].y - 15, true, this.fr[2]);
                break;
            }
            case 3: {
                this.drawBattleInfo(this.fl[Battle.index].name + " " + (this.fl[Battle.index].level > 99 ? "??" : "" + this.fl[Battle.index].level) + "\u7ea7");
                this.drawEmyNameHpLevel(this.fl[index]);
                this.drawArrow1(this.fl[Battle.index].x + 30, this.fl[Battle.index].y - 15, false, this.fl[index]);
                break;
            }
            case 12: {
                this.drawBattleInfo("\u654c\u65b9\u4e24\u76ee\u6807");
                if (this.getTotalLive(this.actionIndex < 10 ? this.fl : this.fr) != 3) {
                    for (int i = 0; i < this.fl.length; ++i) {
                        if (this.fl[i].hp <= 0) continue;
                        this.drawEmyNameHpLevel(this.fl[i]);
                        this.drawArrow1(this.fl[i].x + 30, this.fl[i].y - 15, false, this.fl[i]);
                    }
                    break;
                }
                if (index == 0 || index == 1) {
                    this.drawEmyNameHpLevel(this.fl[index + 1]);
                    this.drawEmyNameHpLevel(this.fl[index]);
                    this.drawArrow1(this.fl[Battle.index + 1].x + 30, this.fl[Battle.index + 1].y - 15, false, this.fl[index + 1]);
                    this.drawArrow1(this.fl[Battle.index].x + 30, this.fl[Battle.index].y - 15, false, this.fl[index]);
                }
                if (index != 2) break;
                this.drawEmyNameHpLevel(this.fl[0]);
                this.drawEmyNameHpLevel(this.fl[2]);
                this.drawArrow1(this.fl[0].x + 30, this.fl[0].y - 15, false, this.fl[0]);
                this.drawArrow1(this.fl[2].x + 30, this.fl[2].y - 15, false, this.fl[2]);
                break;
            }
            case 4: {
                this.drawBattleInfo("\u654c\u65b9\u5168\u4f53");
                for (int i = 0; i < this.fl.length; ++i) {
                    if (this.fl[i].hp <= 0) continue;
                    this.drawEmyNameHpLevel(this.fl[i]);
                    this.drawArrow1(this.fl[i].x + 30, this.fl[i].y - 15, false, this.fl[i]);
                }
                break;
            }
            case 11: {
                int i;
                this.drawBattleInfo("\u5168\u90e8");
                for (i = 0; i < this.fl.length; ++i) {
                    if (this.fl[i].hp <= 0) continue;
                    this.drawArrow1(this.fl[i].x + 30, this.fl[i].y - 15, false, this.fl[i]);
                }
                for (i = 0; i < this.fr.length; ++i) {
                    if (this.fr[i].hp <= 0) continue;
                    this.drawArrow1(this.fr[i].x - 30, this.fr[i].y - 15, true, this.fr[i]);
                }
                break;
            }
        }
    }

    private void drawEmyNameHpLevel(Fighter f) {
        int sy = 0;
        switch (f.modle) {
            case 3: 
            case 5: 
            case 6: {
                sy = -20;
                break;
            }
            case 13: 
            case 20: {
                sy = -7;
                break;
            }
            case 1: 
            case 4: {
                sy = -39;
                break;
            }
            case 16: {
                sy = -13;
                break;
            }
            case 0: {
                sy = -27;
                break;
            }
            case 11: 
            case 17: {
                sy = -33;
                break;
            }
            case 2: {
                sy = -132;
                break;
            }
            case 7: {
                sy = -107;
                break;
            }
            case 15: {
                sy = -23;
            }
        }
        Tools.addColorString((byte)4, f.name, f.x, f.y - 60 - MyGameCanvas.strHeight / 2 + sy, 33, 0, 0xFFFFFF, f.y + 32);
        Tools.addRect((byte)1, f.x - 24, f.y - 60 + sy, 48, 4, true, 20, 9898000, f.y + 32);
        if (canEscape) {
            Tools.addImage(14, f.x - 24, f.y - 60 + sy, 0, 36, f.hp == 0 ? 0 : Math.max(1, f.hp * 48 / f.hp_max), 4, 20, (byte)0, f.y + 32);
        } else {
            if (f.hp < f.hp_max / 3) {
                Tools.addImage(14, f.x - 24, f.y - 60 + sy, 0, 36, f.hp <= 0 ? 0 : Math.max(1, f.hp * 48 / (f.hp_max / 3)), 4, 20, (byte)0, f.y + 32);
            }
            if (f.hp >= f.hp_max / 3 && f.hp < f.hp_max / 3 * 2) {
                Tools.addImage(14, f.x - 24, f.y - 60 + sy, 0, 36, 48, 4, 20, (byte)0, f.y + 32);
                Tools.addImage(14, f.x - 24, f.y - 60 + sy, 0, 44, (f.hp - f.hp_max / 3) * 48 / (f.hp_max / 3 * 2 - f.hp_max / 3), 4, 20, (byte)0, f.y + 32);
            }
            if (f.hp >= f.hp_max / 3 * 2) {
                Tools.addImage(14, f.x - 24, f.y - 60 + sy, 0, 44, 48, 4, 20, (byte)0, f.y + 32);
                Tools.addImage(14, f.x - 24, f.y - 60 + sy, 0, 48, (f.hp - f.hp_max / 3 * 2) * 48 / (f.hp_max - f.hp_max / 3 * 2), 4, 20, (byte)0, f.y + 32);
            }
        }
        Tools.drawnum(f.hp, 251, 0, f.x + 12, f.y - 48 + sy, 8, 7, 0, 3, f.y + 32);
    }

    public void drawArrow1(int x, int y, boolean isMir, Fighter f) {
        int sy = 0;
        switch (f.modle) {
            case 0: {
                sy = -27;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                sy = -20;
                break;
            }
            case 13: 
            case 20: {
                sy = -7;
                break;
            }
            case 1: 
            case 4: {
                sy = -39;
                break;
            }
            case 17: {
                sy = -36;
                break;
            }
            case 16: {
                sy = -13;
                break;
            }
            case 11: {
                sy = -33;
                break;
            }
            case 2: {
                sy = -132;
                break;
            }
            case 7: {
                sy = -107;
                break;
            }
            case 15: {
                sy = -20;
            }
        }
        byte[] motion = new byte[]{0, 1, 2, 1};
        int curInd = MyGameCanvas.gameTime % 8 / 2;
        Tools.drawFrame((short)9, new byte[][]{{0, 0, 0, 0, 0, 2, 2, -22, 2, 0}, {0, 0, 0, 0, 0, 3, 2, -22, 2, 0}, {0, 0, 0, 0, 0, 4, 2, -22, 2, 0}, {1, 0, 0, 0, 0, 5, 2, -25, 3, 0}, {6, 0, 0, 0, 0}, {7, 0, 0, 0, 0}, {8, 0, 0, 0, 0}, {9, 0, 0, 0, 0}}, (byte[][])new byte[][]{{0, 0, 15, 26}, {15, 0, 15, 26}, {30, 0, 11, 15}, {42, 0, 11, 15}, {30, 15, 11, 13}, {41, 15, 10, 11}, {0, 28, 50, 12}, {0, 40, 48, 12}, {0, 53, 49, 13}, {0, 66, 49, 14}}, x - 12 + (isMir ? 32 : -27), y + motion[curInd] - (isMir ? 42 : 61) + (f.isEnemy ? sy : 0), curInd, isMir, y + 2000);
    }

    /*
     * Unable to fully structure code
     */
    private void drawItemBT(Fighter f, int x, int y, int dl) {
        this.drawHead(x, y + GameMap.screenHeight - 66);
        Battle.drawBTFrame(x + 64, y + 64, 125, 159, dl);
        this.canvas.drawBlueBG(x + 64 + 6, y + 64 + 5, 115, 79, dl);
        this.canvas.drawBlueBG(x + 64 + 6, y + 64 + 87, 115, 47, dl);
        for (i = this.btFrameIndex; i < Math.min(this.btFrameIndex + 12, this.bagMax); ++i) {
            Tools.addImage(233, x + 73 + (i - this.btFrameIndex) % 4 * 25, y + 72 + (i - this.btFrameIndex) / 4 * 25, 20, (byte)0, dl);
            Tools.addImage(263, x + 64 + 109, y + 64 + 15 + this.btFrameIndex / 4 * (49 / (this.bagMax / 4 - 3)) + (this.btFrameIndex == 16 ? 49 % (this.bagMax / 4 - 3) : 0), 119, 78, 6, 9, 20, (byte)0, dl + 2);
        }
        i = this.btFrameIndex;
        while (true) {
            Battle.engine.canvas;
            if (i >= Math.min(this.btFrameIndex + 12, MyGameCanvas.itemDat.length)) break;
            Battle.engine.canvas;
            if (MyGameCanvas.itemDat[i] != null) {
                Battle.engine.canvas;
                Tools.addImage(174, x + 75 + (i - this.btFrameIndex) % 4 * 25, y + 74 + (i - this.btFrameIndex) / 4 * 25, MyGameCanvas.itemDat[i][1] * 18, 0, 18, 18, 20, (byte)0, dl + 2);
                Battle.engine.canvas;
                Tools.drawnum(MyGameCanvas.itemDat[i][0], 269, 0, x + 74 + (i - this.btFrameIndex) % 4 * 25 + 18, y + 74 + 19 + (i - this.btFrameIndex) / 4 * 25, 3, 5, 0, 1, dl + 2);
            }
            ++i;
        }
        Battle.engine.canvas;
        if (this.btFrameIndex + this.btFrameIndex1 >= MyGameCanvas.itemDat.length) ** GOTO lbl-1000
        Battle.engine.canvas;
        if (MyGameCanvas.itemDat[this.btFrameIndex + this.btFrameIndex1] != null) {
            Battle.engine.canvas;
            Battle.engine.canvas;
            Battle.engine.canvas.allMInfo = MyGameCanvas.changeString(GameEngine.getItemInfo(GameEngine.item[MyGameCanvas.itemDat[this.btFrameIndex + this.btFrameIndex1][1]]), 5);
        } else lbl-1000:
        // 2 sources

        {
            Tools.addString((byte)4, "\u7a7a", x + 72, y + 153, 20, 0xFFFFC6, dl + 2);
        }
        Tools.addImage(234, x + 64 + 9 + this.btFrameIndex1 % 4 * 25, y + 64 + 8 + this.btFrameIndex1 / 4 * 25, 0, 15, 22, 22, 20, (byte)0, dl);
        Tools.addImage(263, x + 64 + 108, y + 64 + 7, 118, 0, 9, 37, 20, (byte)0, dl);
        Tools.addImage(263, x + 64 + 108, y + 64 + 7 + 37, 118, 0, 9, 37, 20, (byte)2, dl);
        this.canvas.drawMoneyFrame(x + 64 + 15, y + 64 + 154, dl);
    }

    public void drawItemNamePriceNum(int x, int y, int w, int space, int dl) {
        if (this.itemDataBTV == null) {
            return;
        }
        int startInd = this.btFrameIndex + this.btFrameIndex1 - this.canvas.rowIndex;
        int endInd = Math.min(startInd + 5, this.itemDataBTV.size());
        for (int i = startInd; i < endInd; ++i) {
            byte[] temp = (byte[])this.itemDataBTV.elementAt(i);
            byte num = temp[0];
            Item ite = GameEngine.item[temp[1]];
            short pri = (short)(ite.price * MyGameCanvas.pricePro / 100);
            this.canvas.drawOneItemNPN(x, y + (i - startInd) * space, w, ite.name, pri, num, i == this.btFrameIndex + this.btFrameIndex1, dl);
        }
    }

    private void drawSkill(Fighter f, int x, int y, int dl) {
        this.skillMax = f.skillData != null ? (byte)f.skillData.length : (byte)0;
        this.drawHead(x, y + GameMap.screenHeight - 66);
        Battle.drawBTFrame(x + 66, y + 73, 121, 150, dl);
        this.canvas.drawBlueBG(x + 66 + 5, y + 73 + 5, 111, 91, dl);
        this.canvas.drawBlueBG(x + 66 + 5, y + 73 + 98, 111, 47, dl);
        if (this.skillMax != 0) {
            for (int i = this.skillFrameIndex; i < Math.min(this.skillFrameIndex + 3, this.skillMax); ++i) {
                Tools.addImage(263, x + 66 + 9, y + 73 + 9 + (i - this.skillFrameIndex) * 28, 0, 126, 90, 26, 20, (byte)0, dl);
                if (this.skillMax > 3) {
                    Tools.addImage(263, x + 66 + 104, Math.min(y + 73 + 17 + this.skillFrameIndex * (56 / (this.skillMax - 3)) + (this.skillFrameIndex == this.skillMax - 3 ? 3 : 0), y + 73 + 17 + 57), 119, 78, 6, 9, 20, (byte)0, dl + 2);
                }
                boolean isChange = false;
                if (Fighter.ep < GameEngine.sk[f.skillData[i]].lossEP) {
                    isChange = true;
                }
                if (f.mp < GameEngine.sk[f.skillData[i]].lossMP) {
                    isChange = true;
                }
                this.drawSkillName(x + 66 + 19, y + 71 + 16 + (i - this.skillFrameIndex) * 28, GameEngine.sk[f.skillData[i]].name, isChange, dl);
            }
            MyGameCanvas cfr_ignored_0 = Battle.engine.canvas;
            Battle.engine.canvas.allMInfo = MyGameCanvas.changeString(GameEngine.getSkillInfo(GameEngine.sk[f.skillData[this.skillFrameIndex + this.skillFrameIndex1]]), 5);
        }
        if (this.skillMax > 0) {
            Tools.addImage(263, x + 66 + 9, y + 73 + 9 + this.skillFrameIndex1 * 28, 0, 100, 45, 26, 20, (byte)0, dl);
            Tools.addImage(263, x + 66 + 9 + 45, y + 73 + 9 + this.skillFrameIndex1 * 28, 0, 100, 45, 26, 20, (byte)1, dl);
        }
        Tools.addImage(263, x + 66 + 103, y + 73 + 9, 118, 0, 9, 41, 20, (byte)0, dl);
        Tools.addImage(263, x + 66 + 103, y + 73 + 9 + 41, 118, 0, 9, 41, 20, (byte)2, dl);
    }

    void drawSkillDetails(Fighter f, int x, int y, int dl) {
        int w = 240 - 29;
        this.drawSkillArea(f, x, y, 6, w, dl);
        this.drawSkillInfo(x + 7, y + 162, f, dl);
    }

    void drawSkillArea(Fighter f, int x, int y, int row, int w, int dl) {
        for (int i = 0; i < row; ++i) {
            this.canvas.drawUINameBG(x, y + 25 * i, w, 22, dl);
        }
        if (f.skillData != null) {
            this.canvas.drawFocusRect(x, y + this.canvas.rowIndex * 25, w, 24, dl);
        }
        this.drawSkillIconBT(x, y, f, w, this.canvas.rowIndex, dl);
        this.canvas.drawScroll(x + w + 7, y, this.skillFrameIndex + this.skillFrameIndex1, f.skillData == null ? 0 : f.skillData.length, 6, row * 25 - 1, dl);
    }

    private void drawSkillIconBT(int x, int y, Fighter r, int w, int rowInd, int dl) {
        if (r.skillData == null) {
            return;
        }
        int startInd = this.skillFrameIndex + this.skillFrameIndex1 - this.canvas.rowIndex;
        int endInd = Math.min(startInd + 6, r.skillData.length);
        for (int i = startInd; i < endInd; ++i) {
            this.drawSkillName(x + 23 + (w - 23 - 4 * MyGameCanvas.strHeight) / 2, y + 2 + (20 - MyGameCanvas.strHeight) / 2 + 25 * (i - startInd), GameEngine.sk[r.skillData[i]].name, i - startInd == rowInd, dl);
        }
    }

    void drawSkillName(int x, int y, String name, boolean isChange, int dl) {
        Tools.addString((byte)4, name, x, y, 20, isChange ? 8221294 : 0xFFFFFF, dl);
    }

    private void drawSkillInfo(int x, int y, Fighter r, int dl) {
        if (r.skillData == null) {
            return;
        }
        byte skillId = r.skillData[this.skillFrameIndex + this.skillFrameIndex1];
        String[] info = MyGameCanvas.changeString(GameEngine.getSkillInfo(GameEngine.sk[skillId]), 11);
        for (int i = 0; i < info.length; ++i) {
            Tools.addString((byte)4, info[i], x, y + 12 + MyGameCanvas.strHeight / 2 + i * 24, 36, 0xFFFFFF, dl);
        }
    }

    private void drawShop(Fighter f, int x, int y, int dl) {
        this.drawHead(x, y + GameMap.screenHeight - 66);
        this.canvas.drawMoneyFrame(x + 55 + 24, y + 53 + 165, dl + 2);
        Battle.drawBTFrame(x + 55, y + 53, 143, 170, dl);
        this.canvas.drawBlueBG(x + 55 + 6, y + 53 + 5, 133, 91, dl);
        this.canvas.drawBlueBG(x + 55 + 6, y + 53 + 98, 133, 47, dl);
        for (int i = this.shopIndex; i < Math.min(this.shopIndex + 3, this.shopMax); ++i) {
            Tools.addImage(263, x + 55 + 8, y + 53 + 9 + (i - this.shopIndex) * 28, 0, 0, 30, 26, 20, (byte)0, dl);
            Tools.addImage(263, x + 55 + 30 + 8, y + 53 + 9 + (i - this.shopIndex) * 28, 15, 0, 84, 26, 20, (byte)0, dl);
            Tools.addImage(233, x + 55 + 10, y + 53 + 11 + (i - this.shopIndex) * 28, 20, (byte)0, dl);
            Tools.addString((byte)4, GameEngine.item[i].name, x + 55 + 40, y + 53 + 32 + (i - this.shopIndex) * 28, 36, 0xFFFFC6, dl);
            Tools.addImage(174, x + 55 + 12, y + 53 + 13 + (i - this.shopIndex) * 28, i * 18, 0, 18, 18, 20, (byte)0, dl);
            Tools.addImage(263, x + 55 + 127, y + 53 + 17 + this.shopIndex * (56 / (this.shopMax - 3)) + (this.shopIndex == this.shopMax - 3 ? 1 : 0), 119, 78, 6, 9, 20, (byte)0, dl + 2);
        }
        Tools.addImage(263, x + 55 + 8, y + 53 + 9 + this.shopIndex1 * 28, 0, 100, 57, 26, 20, (byte)0, dl);
        Tools.addImage(263, x + 55 + 8 + 57, y + 53 + 9 + this.shopIndex1 * 28, 0, 100, 57, 26, 20, (byte)1, dl);
        Tools.addImage(263, x + 55 + 126, y + 53 + 9, 118, 0, 9, 41, 20, (byte)0, dl);
        Tools.addImage(263, x + 55 + 126, y + 53 + 9 + 41, 118, 0, 9, 41, 20, (byte)2, dl);
        MyGameCanvas cfr_ignored_0 = Battle.engine.canvas;
        Battle.engine.canvas.allMInfo = MyGameCanvas.changeString(GameEngine.getItemInfo(GameEngine.item[this.shopIndex + this.shopIndex1]), 6);
    }

    private void drawBattleOver() {
        int i;
        for (i = 0; i < this.fl.length; ++i) {
            this.newBuff(this.fl[i]);
        }
        for (i = 0; i < this.fr.length; ++i) {
            this.newBuff(this.fr[i]);
        }
        System.out.println("ppppp=" + this.battleFalse());
        if (this.battleFalse()) {
            this.drawBattleInfo("\u6218\u6597\u5931\u8d25\uff01");
            if (++index >= 10) {
                index = 0;
                battleResult = this.checkBattleFalse() ? 0 : 2;
                this.battleOverClear();
                MyGameCanvas.setST((byte)14);
            }
        } else {
            this.drawBattleInfo("\u6218\u6597\u80dc\u5229\uff01");
            if (index == 0) {
                this.getExpAndMoney();
            } else if (index >= 1 && index < 50) {
                this.levelUp();
            } else if (index == 51) {
                this.checkGiveTalPoint();
            }
        }
        if (index >= 52) {
            wait = 0;
            battleResult = 1;
            this.battleOverClear();
            curSt = 0;
            MyGameCanvas.setST((byte)14);
        }
    }

    public void battleOverClear() {
        GameSprite.snakeAppID = 0;
        Tools.removeAllSinleImage(new int[]{232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273});
    }

    void newBuff(Fighter f) {
        f.buff = new short[8][2];
    }

    boolean checkBattleFalse() {
        for (int i = 0; i < this.fr.length; ++i) {
            if (this.fr[i].hp <= 0) continue;
            return false;
        }
        return true;
    }

    private void getExpAndMoney() {
        MyMessage cfr_ignored_0 = MyGameCanvas.me.msg;
        this.e = (byte)(!MyMessage.canSendAgian(1) ? 2 : 1);
        if (wait == 0) {
            GameEngine.money += this.getEmyMoney() * this.m * (100 + addMoney) / 100;
            for (int i = 0; i < this.fr.length; ++i) {
                if (this.fr[i].hp <= 0) continue;
                this.fr[i].exp += this.getEmyExp() * this.e * (100 + addExp) / 100;
            }
            this.battleOverInfo = new String[]{"\u6218\u6597\u80dc\u5229", "\u83b7\u5f97\u7ecf\u9a8c" + this.getEmyExp() * this.e + "\u70b9", "\u83b7\u5f97\u91d1\u94b1" + this.getEmyMoney() * this.m + "\u4e24"};
        } else {
            this.drawBattleOverInfoBar();
        }
        ++wait;
    }

    private short getEmyExp() {
        short a = 0;
        for (int i = 0; i < this.fl.length; ++i) {
            a = (short)(a + this.fl[i].exp);
        }
        return a;
    }

    private short getEmyMoney() {
        short a = 0;
        for (int i = 0; i < this.fl.length; ++i) {
            a = (short)(a + this.fl[i].getMoney);
        }
        return a;
    }

    private void levelUp() {
        if (wait == 0) {
            this.battleOverInfo = null;
            for (int i = 0; i < this.fr.length; ++i) {
                if (this.fr[i].exp < this.fr[i].exp_max || this.fr[i].level >= Fighter.levelMax) continue;
                this.setLeveling();
                this.fr[i].exp -= this.fr[i].exp_max;
                this.fr[i].level = (byte)(this.fr[i].level + 1);
                this.fr[i].setLevel(this.fr[i].level);
                boolean isGet = false;
                int num = 0;
                switch (this.fr[i].level) {
                    case 5: {
                        isGet = true;
                        num = 4;
                        break;
                    }
                    case 10: {
                        isGet = true;
                        num = 4;
                        break;
                    }
                    case 15: {
                        isGet = true;
                        num = 5;
                        break;
                    }
                    case 19: {
                        isGet = true;
                        num = 4;
                        break;
                    }
                    case 24: {
                        isGet = true;
                        num = 6;
                        break;
                    }
                    case 29: {
                        isGet = true;
                        num = 4;
                        break;
                    }
                    case 34: {
                        isGet = true;
                        num = 6;
                        break;
                    }
                    case 39: {
                        isGet = true;
                        num = 6;
                        break;
                    }
                    case 43: {
                        isGet = true;
                        num = 5;
                    }
                }
                if (isGet) {
                    this.battleOverInfo = new String[2];
                    this.battleOverInfo[0] = this.fr[i].name + "\u5347\u5230" + this.fr[i].level + "\u7ea7";
                    this.battleOverInfo[1] = "\u83b7\u5f97" + num + "\u6280\u80fd\u70b9";
                    this.fr[i].setTotalIndex(num);
                    num = 0;
                    isGet = false;
                } else {
                    this.battleOverInfo = new String[]{this.fr[i].name + "\u5347\u5230" + this.fr[i].level + "\u7ea7"};
                }
                break;
            }
        } else if (this.battleOverInfo != null) {
            this.drawBattleOverInfoBar();
        } else {
            index = 52;
            if (this.isLevelUp) {
                index = 51;
            }
            wait = 0;
            return;
        }
        ++wait;
    }

    void setLeveling() {
        if (!this.isLevelUp) {
            this.isLevelUp = true;
            for (int i = 0; i < this.fr.length; ++i) {
                this.curLv[i] = this.fr[i].level;
            }
        }
    }

    void checkGiveTalPoint() {
        index = 52;
    }

    private void drawBattleOverInfoBar() {
        if (this.battleOverInfo == null) {
            return;
        }
        int len = this.battleOverInfo.length;
        int h = 7 + (1 + MyGameCanvas.strHeight) * len;
        short sx = (short)((GameMap.screenWidth - 168) / 2);
        short sy = (short)((GameMap.screenHeight - h) / 2);
        int[] addX = new int[]{(GameMap.screenWidth - sx) / 2, (GameMap.screenWidth - sx) / 4, (GameMap.screenWidth - sx) / 8, 0};
        this.canvas.drawBar((short)237, this.canvas.barData, GameMap.setOffX + sx + addX[Math.min(wait, 3)], GameMap.setOffY + sy, 168, h, 16762219, 9999, false);
        for (int i = 0; i < len; ++i) {
            Tools.addString((byte)4, this.battleOverInfo[i], GameMap.setOffX + sx + 84 + addX[Math.min(wait, 3)], GameMap.setOffY + sy + 13 + i * (1 + MyGameCanvas.strHeight), 33, i == 1 && len == 2 ? 65280 : 16711529, 9999);
        }
        if (++this.infoIndex >= addX.length) {
            this.infoIndex = addX.length - 1;
        }
    }

    public void drawBattle() {
        int i;
        this.drawBattleBG();
        this.drawHitNum();
        for (i = 0; i < this.fl.length; ++i) {
            this.fl[i].paint();
        }
        for (i = 0; i < this.fr.length; ++i) {
            this.fr[i].paint();
        }
        if (stopBattle) {
            GameEngine.drawColorScreenBG(0, 1);
        }
        Effect.drawEffect();
        this.drawBottonBox();
        block0 : switch (curSt) {
            case 0: {
                this.drawReady();
                break;
            }
            case 2: {
                this.drawFrAction();
                break;
            }
            case 4: {
                switch (this.lastSt) {
                    case 2: 
                    case 7: 
                    case 9: {
                        this.drawSelect(GameMap.setOffX, GameMap.setOffY, this.range);
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                this.drawItemBT(this.fr[this.actionIndex], GameMap.setOffX, GameMap.setOffY, 800);
                break;
            }
            case 9: {
                this.drawSkill(this.fr[this.actionIndex], GameMap.setOffX, GameMap.setOffY, 800);
                break;
            }
            case 10: {
                this.drawBattleOver();
                break;
            }
            case 11: {
                this.drawShop(this.fr[this.actionIndex], GameMap.setOffX, GameMap.setOffY, 800);
                break;
            }
        }
    }

    private void drawBottonBox() {
        Tools.addImage(15, GameMap.setOffX, GameMap.setOffY + GameMap.screenHeight, 36, (byte)0, 620);
        for (int i = 0; i < this.fr.length; ++i) {
            Tools.addImage(246, GameMap.setOffX + 4 + i * 77, GameMap.setOffY + GameMap.screenHeight - 2, 0, 0, 48, 43, 36, (byte)0, 620);
            Tools.addImage(248, GameMap.setOffX + 47 + i * 77, GameMap.setOffY + GameMap.screenHeight - 18, MyGameCanvas.hpmparray[7], 36, (byte)0, 620);
            Tools.addImage(248, GameMap.setOffX + 38 + i * 77, GameMap.setOffY + GameMap.screenHeight - 5, MyGameCanvas.hpmparray[8], 36, (byte)0, 620);
            Tools.addImage(248, GameMap.setOffX + 47 + i * 77, GameMap.setOffY + GameMap.screenHeight - 19, 0, 29, this.fr[i].hp * 29 / this.fr[i].hp_max, 4, 36, (byte)0, 620);
            Tools.drawnum(this.fr[i].hp, 270, 0, GameMap.setOffX + 66 + i * 77, GameMap.setOffY + GameMap.screenHeight - 22, 6, 7, 0, 1, 620);
            Tools.addImage(248, GameMap.setOffX + 38 + i * 77, GameMap.setOffY + GameMap.screenHeight - 6, 1, 33, this.fr[i].mp * 44 / this.fr[i].mp_max, 4, 36, (byte)0, 620);
            Tools.drawnum(this.fr[i].mp, 270, 0, GameMap.setOffX + 70 + i * 77, GameMap.setOffY + GameMap.screenHeight - 9, 6, 7, 0, 1, 620);
            Tools.addImage(268, GameMap.setOffX + 10 + i * 77, GameMap.setOffY + GameMap.screenHeight - 5, (GameEngine.roleTeam[i] == 1 ? 1 : (GameEngine.roleTeam[i] == 0 ? 0 : 2)) * 38, 0, 38, 38, 36, (byte)0, 620);
        }
    }

    private int getInitIndex() {
        switch (this.range) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 11: {
                return this.actionIndex;
            }
            case 3: 
            case 4: {
                return this.getLive(true, 0);
            }
            case 10: 
            case 12: {
                return this.getTwoAimIndex(this.getLive(true, 0), this.getLive(true, this.getLive(true, 0) + 1));
            }
        }
        return 0;
    }

    private byte getLive(boolean leftTeam, int startInd) {
        if (leftTeam) {
            for (int i = startInd; i < this.fl.length; ++i) {
                if (this.fl[i].hp <= 0) continue;
                return (byte)i;
            }
        } else {
            for (int i = startInd; i < this.fr.length; ++i) {
                if (this.fr[i].hp <= 0) continue;
                return (byte)i;
            }
        }
        return this.getLive(true, 0);
    }

    private byte getTwoAimIndex(byte find, byte sind) {
        if (find == 0 && sind == 1) {
            return 0;
        }
        if (find == 1 && sind == 2) {
            return 1;
        }
        if (find == 0 && sind == 2) {
            return 2;
        }
        return 3;
    }

    void createItemDataV() {
        this.itemDataBTV = new Vector();
        this.itemIndexBTV = new Vector();
        if (GameEngine.itemBag.isEmpty()) {
            return;
        }
        for (int i = 0; i < GameEngine.itemBag.size(); ++i) {
            byte[] tmp = (byte[])GameEngine.itemBag.elementAt(i);
            this.itemDataBTV.addElement(tmp);
            this.itemIndexBTV.addElement(new Integer(i));
        }
    }

    private boolean canSelect(byte range, int nextIndex) {
        switch (range) {
            case 0: 
            case 2: 
            case 4: 
            case 11: {
                return false;
            }
            case 1: 
            case 10: {
                if (nextIndex < 0 || nextIndex > this.fr.length - 1) {
                    return false;
                }
                return this.fr[nextIndex].hp > 0;
            }
            case 3: 
            case 12: {
                if (nextIndex < 0 || nextIndex > this.fl.length - 1) {
                    return false;
                }
                return this.fl[nextIndex].hp > 0;
            }
            case 5: {
                return nextIndex >= 0 && nextIndex <= this.fr.length - 1;
            }
        }
        return false;
    }

    private boolean canPress(byte range, int aim) {
        switch (range) {
            case 0: 
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
            case 1: {
                if (aim < 0 || aim > this.fr.length - 1) {
                    return false;
                }
                return this.fr[aim].hp > 0;
            }
            case 3: {
                if (aim < 0 || aim > this.fl.length - 1) {
                    return false;
                }
                return this.fl[aim].hp > 0;
            }
            case 5: {
                if (aim < 0 || aim > this.fr.length - 1) {
                    return false;
                }
                return this.fr[aim].hp <= 0;
            }
        }
        return false;
    }

    private boolean needItem(byte range, int aim) {
        byte[] tmp = (byte[])this.itemDataBTV.elementAt(this.btFrameIndex + this.btFrameIndex1);
        Item ite = GameEngine.item[tmp[1]];
        return !(range == 1 ? !engine.checkOneNeedItem((byte)aim, ite) : range == 2 && !engine.checkAllNeedItem(ite));
    }

    private void useItemBT() {
        byte[] tmp = (byte[])this.itemDataBTV.elementAt(this.btFrameIndex + this.btFrameIndex1);
        short itemInd = ((Integer)this.itemIndexBTV.elementAt(this.btFrameIndex + this.btFrameIndex1)).shortValue();
        if (tmp[0] > 1) {
            engine.removeItemByIndex(1, (byte)1, itemInd);
        } else if (tmp[0] == 1) {
            engine.removeSelectItem(itemInd, (byte)1);
        }
    }

    public void initItem(byte id) {
        this.item = null;
        this.item = new Item(engine);
        this.item = GameEngine.item[id];
        this.range = this.item.range;
    }

    private short getLossValue(int base, int reduceVal) {
        if (reduceVal == 0) {
            return (short)base;
        }
        return (short)Math.max(1, base * (100 - reduceVal) / 100);
    }

    public void ctrlBattle(int keyCode) {
        block90: {
            if (keyCode == 48) {
                autoRun = false;
            }
            block0 : switch (curSt) {
                case 10: {
                    if (wait < 3) break;
                    ++index;
                    wait = 0;
                    this.infoIndex = 0;
                    break;
                }
                case 2: {
                    switch (keyCode) {
                        case 48: {
                            autoRun = !autoRun;
                            break;
                        }
                        case -3: 
                        case 52: {
                            if (frIndex == 5 || this.wordTurn != 0) {
                                return;
                            }
                            this.wordTurn = (byte)-1;
                            frIndex = frIndex == 0 ? 4 : frIndex - 1;
                            break;
                        }
                        case -4: 
                        case 54: {
                            if (frIndex == 5 || this.wordTurn != 0) {
                                return;
                            }
                            this.wordTurn = 1;
                            frIndex = frIndex == 4 ? 0 : frIndex + 1;
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 53: {
                            if (this.wordTurn != 0) {
                                return;
                            }
                            switch (frIndex) {
                                case 0: {
                                    this.initSkill(this.getRoleNormalAttackIndex(this.fr[this.actionIndex]));
                                    this.skill.effectType = (byte)30;
                                    this.setBattleST((byte)4);
                                    index = this.getInitIndex();
                                    break;
                                }
                                case 1: {
                                    if (this.fr[this.actionIndex].skillData == null) {
                                        MyGameCanvas.setInfo(new String[]{"\u8fd8\u672a\u5b66\u4f1a\u4efb\u4f55\u6280\u80fd"});
                                        break;
                                    }
                                    this.skillFrameIndex = 0;
                                    this.skillFrameIndex1 = 0;
                                    this.canvas.rowIndex = 0;
                                    this.canvas.subTitleNum = 0;
                                    this.setBattleST((byte)9);
                                    break;
                                }
                                case 2: {
                                    this.createItemDataV();
                                    this.btFrameIndex1 = 0;
                                    this.btFrameIndex = 0;
                                    this.canvas.rowIndex = 0;
                                    this.canvas.subTitleNum = 0;
                                    MyGameCanvas.pricePro = 100;
                                    this.setBattleST((byte)7);
                                    engine.divideBag();
                                    break;
                                }
                                case 3: {
                                    this.canvas.initItemBuyData(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13});
                                    MyGameCanvas.pricePro = 150;
                                    this.setBattleST((byte)11);
                                    break;
                                }
                                case 4: {
                                    if (canEscape) {
                                        this.initSkill(34);
                                        this.setBattleST((byte)6);
                                        wait = 0;
                                        isEscape = false;
                                        break;
                                    }
                                    MyGameCanvas.setInfo(new String[]{"\u4e0d\u80fd\u9003\u8dd1\uff01"});
                                    break;
                                }
                                case 5: {
                                    if (Script.scriptVar[222] != 2) {
                                        MyGameCanvas.setInfo(new String[]{"\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\uff01"});
                                        break;
                                    }
                                    if (canLose) {
                                        MyGameCanvas.setInfo(new String[]{"\u5fc5\u8d25\u6218\u6597\u907f\u514d\u6d6a\u8d39\uff01"});
                                        break;
                                    }
                                    MyGameCanvas.me.msg.toSendState(6);
                                }
                            }
                            break;
                        }
                        case -7: {
                            frIndex = 0;
                            frIndex1 = 0;
                        }
                    }
                    break;
                }
                case 4: {
                    block24 : switch (keyCode) {
                        case -11: 
                        case -7: {
                            this.setBattleST(this.lastSt);
                            break;
                        }
                        case -1: 
                        case 50: {
                            if (this.canSelect(this.range, index - 1)) {
                                --index;
                                break;
                            }
                            if (!this.canSelect(this.range, index - 2)) break;
                            index -= 2;
                            break;
                        }
                        case -2: 
                        case 56: {
                            if (this.canSelect(this.range, index + 1)) {
                                ++index;
                                break;
                            }
                            if (!this.canSelect(this.range, index + 2)) break;
                            index += 2;
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 53: {
                            switch (this.lastSt) {
                                case 2: 
                                case 9: {
                                    if (this.canPress(this.range, index)) {
                                        this.aimIndex = (byte)index;
                                        this.createAimTeam(this.range);
                                        this.initActionVaule(this.fr[this.actionIndex]);
                                        this.setBattleST((byte)6);
                                        wait = 0;
                                        engine.skillReduce(this.fr[this.actionIndex], this.skill);
                                        break block24;
                                    }
                                    MyGameCanvas.setInfo(new String[]{"\u76ee\u6807\u4e0d\u7b26\u5408"});
                                    break block24;
                                }
                                case 7: {
                                    if (!this.needItem(this.range, index)) {
                                        return;
                                    }
                                    if (this.canPress(this.range, index)) {
                                        this.aimIndex = (byte)index;
                                        this.createAimTeam(this.range);
                                        wait = 0;
                                        this.useItemBT();
                                        this.setBattleST((byte)8);
                                        break block24;
                                    }
                                    MyGameCanvas.setInfo(new String[]{"\u76ee\u6807\u4e0d\u7b26\u5408"});
                                    break block24;
                                }
                            }
                        }
                    }
                    break;
                }
                case 7: {
                    switch (keyCode) {
                        case -3: 
                        case 52: {
                            this.btFrameIndex1 = this.btFrameIndex1 % 4 == 0 ? (byte)(this.btFrameIndex1 + 3) : (byte)(this.btFrameIndex1 - 1);
                            break;
                        }
                        case -4: 
                        case 54: {
                            this.btFrameIndex1 = this.btFrameIndex1 % 4 == 3 ? (byte)(this.btFrameIndex1 - 3) : (byte)(this.btFrameIndex1 + 1);
                            break;
                        }
                        case -1: 
                        case 50: {
                            if (this.btFrameIndex1 / 4 == 0) {
                                this.btFrameIndex = (byte)(this.btFrameIndex / 4 == 0 ? this.btFrameIndex : this.btFrameIndex - 4);
                            }
                            this.btFrameIndex1 = (byte)(this.btFrameIndex1 / 4 == 0 ? this.btFrameIndex1 : this.btFrameIndex1 - 4);
                            break;
                        }
                        case -2: 
                        case 56: {
                            if (this.btFrameIndex1 / 4 == 2) {
                                this.btFrameIndex = (byte)(this.btFrameIndex / 4 == this.bagMax / 4 - 3 ? this.btFrameIndex : this.btFrameIndex + 4);
                            }
                            this.btFrameIndex1 = (byte)(this.btFrameIndex1 / 4 == 2 ? this.btFrameIndex1 : this.btFrameIndex1 + 4);
                            break;
                        }
                        case -11: 
                        case -7: {
                            if (curSt == 11) {
                                this.canvas.itemBuyData = null;
                            }
                            this.btFrameIndex = 0;
                            this.btFrameIndex1 = 0;
                            this.setBattleST((byte)2);
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 53: {
                            MyGameCanvas cfr_ignored_0 = Battle.engine.canvas;
                            if (this.btFrameIndex + this.btFrameIndex1 < MyGameCanvas.itemDat.length) {
                                MyGameCanvas cfr_ignored_1 = Battle.engine.canvas;
                                if (MyGameCanvas.itemDat[this.btFrameIndex + this.btFrameIndex1] != null) {
                                    MyGameCanvas cfr_ignored_2 = Battle.engine.canvas;
                                    if (MyGameCanvas.itemDat[this.btFrameIndex + this.btFrameIndex1][1] == 17) {
                                        MyGameCanvas.setInfo(new String[]{"\u4efb\u52a1\u7269\u54c1\u4e0d\u53ef\u4f7f\u7528\uff01"});
                                        break;
                                    }
                                    MyGameCanvas cfr_ignored_3 = Battle.engine.canvas;
                                    this.initItem(MyGameCanvas.itemDat[this.btFrameIndex + this.btFrameIndex1][1]);
                                    this.setBattleST((byte)4);
                                    break;
                                }
                            }
                            MyGameCanvas.setInfo(new String[]{"\u7269\u54c1\u4e3a\u7a7a\uff01"});
                        }
                    }
                    break;
                }
                case 11: {
                    switch (keyCode) {
                        case -1: 
                        case 50: {
                            if (this.shopIndex1 == 0) {
                                this.shopIndex = (byte)(this.shopIndex == 0 ? this.shopIndex : this.shopIndex - 1);
                            }
                            this.shopIndex1 = (byte)(this.shopIndex1 == 0 ? this.shopIndex1 : this.shopIndex1 - 1);
                            break;
                        }
                        case -2: 
                        case 56: {
                            if (this.shopIndex1 == 2) {
                                this.shopIndex = (byte)(this.shopIndex == this.shopMax - 3 ? this.shopIndex : this.shopIndex + 1);
                            }
                            this.shopIndex1 = (byte)(this.shopIndex1 == 2 ? this.shopIndex1 : this.shopIndex1 + 1);
                            break;
                        }
                        case -11: 
                        case -7: {
                            this.shopIndex = 0;
                            this.shopIndex1 = 0;
                            this.setBattleST((byte)2);
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 53: {
                            if (MyGameCanvas.isInfo2) break;
                            if (GameEngine.money >= GameEngine.item[this.shopIndex + this.shopIndex1].price * 2) {
                                GameEngine.money -= GameEngine.item[this.shopIndex + this.shopIndex1].price * 2;
                                GameEngine.addItem(1, (byte)(this.shopIndex + this.shopIndex1), (byte)1);
                                String[] stringArray = new String[1];
                                stringArray[0] = "\u5f97\u5230" + GameEngine.item[this.shopIndex + this.shopIndex1].name + "X1";
                                MyGameCanvas.setInfo2(stringArray);
                                break;
                            }
                            MyGameCanvas.setInfo(new String[]{"\u91d1\u94b1\u4e0d\u591f\uff01"});
                            if (Script.scriptVar[222] != 2) break;
                            Battle.engine.canvas.msg.toSendState(2);
                        }
                    }
                    break;
                }
                case 9: {
                    switch (keyCode) {
                        case -1: 
                        case 50: {
                            if (this.skillFrameIndex1 == 0) {
                                this.skillFrameIndex = (byte)(this.skillFrameIndex == 0 ? this.skillFrameIndex : this.skillFrameIndex - 1);
                            }
                            this.skillFrameIndex1 = (byte)(this.skillFrameIndex1 == 0 ? this.skillFrameIndex1 : this.skillFrameIndex1 - 1);
                            break;
                        }
                        case -2: 
                        case 56: {
                            if (this.skillFrameIndex1 == 2) {
                                this.skillFrameIndex = (byte)(this.skillFrameIndex == this.skillMax - 3 ? this.skillFrameIndex : this.skillFrameIndex + 1);
                            }
                            if (this.skillMax != 0) {
                                this.skillFrameIndex1 = (byte)(this.skillFrameIndex1 == Math.min(2, this.skillMax - 1) ? this.skillFrameIndex1 : this.skillFrameIndex1 + 1);
                                break;
                            }
                            break block90;
                        }
                        case -11: 
                        case -7: {
                            this.skillFrameIndex = 0;
                            this.skillFrameIndex1 = 0;
                            this.setBattleST((byte)2);
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 53: {
                            if (this.fr[this.actionIndex].skillData != null) {
                                Fighter r = this.fr[this.actionIndex];
                                this.canvas.canPress = engine.canUseSkill(r, GameEngine.sk[r.skillData[this.skillFrameIndex + this.skillFrameIndex1]], true);
                                if (this.canvas.canPress) {
                                    this.initSkill(this.fr[this.actionIndex].skillData[this.skillFrameIndex + this.skillFrameIndex1]);
                                    this.setBattleST((byte)4);
                                    index = this.getInitIndex();
                                    break;
                                }
                                Fighter cfr_ignored_4 = this.fr[this.actionIndex];
                                if (Fighter.ep < this.getLossValue(GameEngine.sk[r.skillData[this.skillFrameIndex + this.skillFrameIndex1]].lossEP, this.fr[this.actionIndex].epLossReduce)) {
                                    MyGameCanvas.setInfo(new String[]{"\u6012\u6c14\u4e0d\u591f"});
                                    break;
                                }
                                if (this.fr[this.actionIndex].mp >= this.getLossValue(GameEngine.sk[r.skillData[this.skillFrameIndex + this.skillFrameIndex1]].lossMP, this.fr[this.actionIndex].mpLossReduce)) break block0;
                                MyGameCanvas.setInfo(new String[]{"\u5185\u529b\u4e0d\u591f"});
                                break;
                            }
                            MyGameCanvas.setInfo(new String[]{"\u8fd8\u672a\u5b66\u4f1a\u4efb\u4f55\u6280\u80fd"});
                        }
                    }
                    break;
                }
                case 12: {
                    switch (keyCode) {
                        case -2: 
                        case 56: {
                            this.canvas.buyNum = (byte)Math.max(1, this.canvas.buyNum - 10);
                            break block0;
                        }
                        case -1: 
                        case 50: {
                            this.canvas.buyNum = (byte)Math.min(99, this.canvas.buyNum + 10);
                            break block0;
                        }
                        case -3: 
                        case 52: {
                            this.canvas.buyNum = (byte)Math.max(1, this.canvas.buyNum - 1);
                            break block0;
                        }
                        case -4: 
                        case 54: {
                            this.canvas.buyNum = (byte)Math.min(99, this.canvas.buyNum + 1);
                            break block0;
                        }
                        case -6: 
                        case -5: 
                        case 53: {
                            this.canvas.isPress = true;
                            break block0;
                        }
                        case -7: {
                            this.setBattleST((byte)11);
                        }
                    }
                }
            }
        }
    }

    public void sender(Event event, short pathIndex) {
        this.event = event;
        this.pathIndex = pathIndex;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.pathIndex);
            this.event = null;
        }
    }

    public boolean checkBattleEvent(int t, int fInd) {
        boolean isOk = false;
        isOk = fInd >= 10 ? turn == t : turn == t;
        return isOk;
    }

    public static void drawBTFrame(int x, int y, int w, int h, int drawLevel) {
        int i;
        Tools.addRect((byte)1, x + 3, y + 3, w - 6, h - 6, true, 20, 277338, drawLevel);
        Tools.addImage(12, x + 1, y + 1, 1, 1, 2, 2, 20, (byte)0, drawLevel);
        for (i = 0; i < (w - 6) / 27; ++i) {
            Tools.addImage(12, x + 3 + i * 27, y, 3, 0, 27, 3, 20, (byte)0, drawLevel);
        }
        Tools.addImage(12, x + 3 + (w - 6) / 27 * 27, y, 3, 0, (w - 6) % 27, 3, 20, (byte)0, drawLevel);
        Tools.addImage(12, x + w - 3, y + 1, 1, 1, 3, 3, 20, (byte)1, drawLevel);
        for (i = 0; i < (w - 6) / 27; ++i) {
            Tools.addImage(12, x + 3 + i * 27, y + h - 3, 0, 30, 27, 3, 20, (byte)0, drawLevel);
        }
        Tools.addImage(12, x + 3 + (w - 6) / 27 * 27, y + h - 3, 0, 30, (w - 6) % 27, 3, 20, (byte)0, drawLevel);
        Tools.addImage(12, x + w - 3, y + h - 3, 27, 30, 2, 2, 20, (byte)0, drawLevel);
        for (i = 0; i < (h - 6) / 27; ++i) {
            Tools.addImage(12, x, y + 3 + i * 27, 0, 3, 3, 27, 20, (byte)0, drawLevel);
        }
        Tools.addImage(12, x, y + 3 + (h - 6) / 27 * 27, 0, 3, 3, (h - 6) % 27, 20, (byte)0, drawLevel);
        for (i = 0; i < (h - 6) / 27; ++i) {
            Tools.addImage(12, x + w - 3, y + 3 + i * 27, 0, 3, 3, 27, 20, (byte)0, drawLevel);
        }
        Tools.addImage(12, x + w - 3, y + 3 + (h - 6) / 27 * 27, 0, 3, 3, (h - 6) % 27, 20, (byte)0, drawLevel);
        Tools.addImage(249, x - 2, y + h + 2, 36, (byte)0, drawLevel);
    }

    static {
        index = 0;
        wait = 0;
        curSt = 0;
        canEscape = true;
        canLose = false;
        isEscape = false;
        curBattleEvent = (byte)-1;
        imgbattleBgImgs = new short[]{4, 2};
    }
}

