/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameMap {
    static int screenWidth;
    static int screenHeight;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    static int setOffX;
    static int setOffY;
    static GameEngine engine;
    public static final short L_TILE = 20;
    public static final short L_ROLESD = 30;
    public static final short L_LEV = 31;
    public static final short L_HIGH = 2000;
    public static final short L_TALK = 5000;
    public static final short L_MAX = 9000;
    public static final short L_BBG = 10;
    public static final short L_OVERBBG = 20;
    public static final short L_BFLASH = 350;
    public static final short L_EFF = 40;
    public static final short L_LOOK = 3000;
    byte mapID;
    String mapName;
    String fileName;
    String decDat;
    byte weather;
    byte BGM;
    static int curMusic;
    short[] enemys;
    String[] enemyName;
    byte enemyLevel;
    short battleBg;
    static byte[][] mData;
    static short[][] mProperties;
    static String[][] mName;
    static int layer;
    static boolean blackBG;
    byte[][] arraySun = new byte[][]{{0, 0, 59, 61}, {59, 0, 67, 73}, {126, 0, 76, 87}};
    static byte indexSun0;
    static byte indexSun1;
    static byte indexSun2;
    static byte indexSun3;
    static byte indexSun4;
    static byte indexSun5;
    static boolean isSun0;
    static boolean isSun1;
    static boolean isSun2;
    static boolean isSun3;
    static boolean isSun4;
    static boolean isSun5;
    static int infoX;
    static int infoY;
    static int infoMapId;
    public static boolean isShowCG;
    public static byte CGId;
    static byte index;
    static short indexTime;
    boolean isStart;
    public static final byte ITEM_TYPE = 0;
    public static final byte ITEM_X = 1;
    public static final byte ITEM_Y = 2;
    public static final byte ITEM_TR = 3;
    public static final byte OBJ_ID = 0;
    public static final byte OBJ_IMG = 1;
    public static final byte OBJ_ADDX = 2;
    public static final byte OBJ_ADDY = 3;
    public static final byte OBJ_W = 4;
    public static final byte OBJ_H = 5;
    public static final byte OBJ_DL = 6;
    short[][] objData = new short[][]{{0, 118, -9, 8, 64, 32}, {1, 119, 0, 0, 0, 0}, {2, 120, 1, 0, 16, 16}, {3, 133, 0, 0, 0, 0}, {4, 135, -3, 3, 16, 16}, {5, 144, -2, 1, 16, 16}, {6, 147, -2, 5, 48, 32}, {7, 161, 0, 0, 0, 0}, {8, 134, -29, 4, 32, 16}, {9, 145, -22, 3, 32, 16}, {10, 126, -14, 12, 80, 48}, {11, 142, 0, 0, 0, 0}, {12, 141, 0, 0, 38, 48}, {16, 138, 0, 0, 0, 0}, {17, 162, 1, 0, 16, 16}, {18, 146, 1, 0, 16, 16}, {19, 149, 0, 0, 16, 16}, {20, 151, 0, 0, 0, 0}, {21, 121, 0, 0, 0, 0}, {22, 122, 0, 0, 0, 0}, {23, 127, 0, 0, 0, 0}, {24, 130, 0, 0, 0, 0}, {25, 131, 0, 0, 0, 0}, {26, 132, 0, 0, 64, 48}, {27, 137, 0, 0, 0, 0}, {28, 139, 0, 0, 80, 48}, {29, 143, 0, 0, 0, 0}, {30, 152, 5, 5, 48, 16}, {31, 154, 0, 0, 0, 0}, {32, 155, 0, 0, 0, 0}, {34, 163, -3, 1, 16, 32}, {35, 164, 2, 5, 32, 16}, {36, 168, 0, 0, 0, 0}, {37, 117, 0, 0, 0, 0}, {38, 123, 0, 7, 64, 32}, {39, 124, -6, 3, 16, 16}, {40, 125, -10, 3, 32, 16}, {41, 128, 0, 0, 0, 0}, {42, 129, 0, 0, 0, 0}, {43, 136, -2, 3, 16, 16}, {44, 140, -4, 4, 48, 32}, {45, 148, 2, 3, 32, 16}, {46, 156, 0, 0, 0, 0}, {47, 157, 0, 0, 0, 0}, {48, 158, -2, 6, 16, 16}, {49, 160, 0, 0, 0, 0}, {50, 172, 0, 0, 0, 0}, {51, 173, 0, 0, 0, 0}, {52, 169, 0, 2, 16, 16}, {53, 170, -1, 3, 16, 16}, {54, 115, 0, 0, 0, 0}, {55, 153, 0, 0, 0, 0}, {56, 159, 1, 5, 64, 32}, {57, 165, -17, 2, 16, 16}, {58, 166, 0, 0, 0, 0}, {59, 167, 0, 0, 0, 0}, {60, 171, 0, 0, 0, 0}, {61, 116, 0, 0, 0, 0}, {62, 150, 0, 0, 16, 16}};
    static short[][] decData;
    static byte[][] dec_FuShiClipData;
    static byte[][] dec_FuShiFrameData;
    static byte[][] dec_HuoClipData;
    static byte[][] dec_HuoFrameData;
    static byte[][] dec_JianClipData;
    static byte[][] dec_JianFrameData;
    static byte decIndex;
    short[][] fogDat = new short[4][3];
    static boolean isDrawFZ1;
    static short[] fzXY1;
    static byte fzType1;
    static boolean isDrawFZ2;
    static short[] fzXY2;
    static byte fzType2;
    public static byte SCEEN_MOVE;
    int adjustX;
    int adjustY;
    static boolean isMoveScreen;
    Event event;
    short pathIndex;
    Image mapBuff;
    int buffWidth;
    int buffHeight;
    boolean isBuffNull;
    int lastStartX;
    int lastStartY;
    int lastEndX;
    int lastEndY;
    Graphics g1;
    byte[][] sinkerClip = new byte[][]{{0, 0, 24, 25}, {24, 0, 27, 23}, {37, 24, 1, 1}, {40, 24, 1, 1}, {42, 23, 3, 3}, {46, 23, 5, 4}};
    byte[][] sinkerFrame = new byte[][]{{0, 0, 0, 0, 0}, {1, 12, -3, 0, 0, 5, 24, -3, 10, 0, 5, 11, 0, 23, 0, 4, 9, -13, 27, 0, 5, 5, -8, 29, 0, 3, 0, -5, 38, 0}, {1, 18, 0, 0, 0, 5, 32, -9, 8, 0, 4, 17, -5, 25, 0, 4, 35, -17, 7, 0, 2, 38, -3, 6, 0, 3, 10, -14, 34, 0, 4, 0, -15, 42, 0, 2, 13, -21, 31, 0}, {1, 0, 0, 0, 0}};
    byte[][] sinkerMotion = new byte[][]{{0, 0, 1, 12, 12, 5, -30}, {0, 0, 1, 12, 12, 5, -30}, {0, 0, 1, 12, 12, 5, -30}, {1, 0, 1, 27, 12, -8, -18}, {1, 0, 1, 27, 12, -8, -18}, {1, 0, 1, 27, 12, -8, -18}, {2, 0, 1, 33, 12, -6, -17}, {2, 0, 1, 33, 12, -6, -17}, {2, 0, 1, 33, 12, -6, -17}, {3, 0, 1, 15, 12, -5, -18}, {3, 0, 1, 15, 12, -5, -18}, {3, 0, 1, 15, 12, -5, -18}};
    byte sinkerIndex;
    short[][] mapposRed26 = new short[][]{{336, 208, 0}, {352, 400, 0}, {80, 176, 0}};
    short[][] mapposBlue26 = new short[][]{{256, 320, 0}, {240, 96, 0}};
    short[][] mapposRed25 = new short[][]{{144, 96, 0}, {192, 256, 0}, {368, 192, 0}, {528, 304, 0}, {608, 480, 0}, {432, 512, 0}, {366, 368, 0}, {214, 512, 0}};
    short[][] mapposBlue25 = new short[][]{{112, 176, 0}, {288, 272, 0}, {480, 224, 0}, {560, 384, 0}, {512, 528, 0}, {320, 448, 0}, {128, 512, 0}};
    short[][] mapposRed24 = new short[][]{{80, 352, 0}, {176, 496, 0}, {384, 464, 0}, {288, 368, 0}, {288, 224, 0}, {464, 176, 0}, {512, 256, 0}, {576, 400, 0}};
    short[][] mapposBlue24 = new short[][]{{112, 448, 0}, {304, 512, 0}, {384, 368, 0}, {240, 288, 0}, {368, 144, 0}, {496, 96, 0}, {576, 336, 0}};
    short[][] mapposRed23 = new short[][]{{416, 256, 0}, {384, 144, 0}, {112, 224, 0}, {320, 320, 0}, {112, 384, 0}, {80, 448, 0}};
    short[][] mapposBlue23 = new short[][]{{432, 320, 0}, {432, 176, 0}, {320, 112, 0}, {96, 128, 0}, {224, 224, 0}, {240, 384, 0}};
    static boolean isRunGame;
    boolean isBlue;
    int gameIndex;
    byte roleLife = (byte)5;
    boolean dead;

    public GameMap(GameEngine en, int sw, int sh) {
        screenWidth = sw;
        screenHeight = sh;
        GameMap.setOff(0, 0);
        engine = en;
    }

    public void free() {
        mData = null;
        mProperties = null;
        mName = null;
        System.gc();
    }

    public void init(short[] dat) {
        this.mapID = (byte)Event.getInt(dat[0]);
        this.mapName = Event.getString(dat[1]);
        this.fileName = Event.getString(dat[2]);
        this.decDat = Event.getString(dat[3]);
        this.weather = (byte)Event.getInt(dat[4]);
        this.battleBg = (short)Event.getInt(dat[5]);
        this.BGM = (byte)Event.getInt(dat[6]);
        curMusic = this.BGM;
        this.enemyLevel = (byte)Event.getInt(dat[7]);
        this.enemyName = Event.getString(dat[8]).equals("null") ? null : Event.splitString(Event.getString(dat[8]), ",");
        this.enemys = Event.getArray(dat[9]);
    }

    public void initMap() {
        this.free();
        this.initMapBuff();
        decData = null;
        this.adjustX = screenWidth / 2;
        this.adjustY = screenHeight / 2 + 20;
        this.loadMapDat();
        this.loadDecorationDat(this.decDat);
        this.initDecorationData();
        this.initWeather();
    }

    void loadDecorationDat(String fName) {
        decData = null;
        decData = engine.readItemData2(fName);
    }

    void initDecorationData() {
        dec_FuShiClipData = null;
        dec_FuShiFrameData = null;
        dec_HuoClipData = null;
        dec_HuoFrameData = null;
        dec_JianClipData = null;
        dec_JianFrameData = null;
        dec_FuShiClipData = engine.readClipData("/data/i_fushi_c.bin");
        dec_FuShiFrameData = engine.readFrameData("/data/i_fushi_f.bin");
        dec_HuoClipData = engine.readClipData("/data/i_hb_c.bin");
        dec_HuoFrameData = engine.readFrameData("/data/i_hb_f.bin");
        dec_JianClipData = engine.readClipData("/data/i_jian_c.bin");
        dec_JianFrameData = engine.readFrameData("/data/i_jian_f.bin");
    }

    void loadMapDat() {
        this.loadMap(this.fileName);
        for (int i = 0; i < layer; ++i) {
            Tools.createImage(mName[i], i + 1);
        }
    }

    public void loadMap(String file) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(Tools.getMapData(file)));
        try {
            layer = GameMap.bToi(in.readByte());
            mData = new byte[layer][];
            mProperties = new short[layer][];
            mName = new String[layer][];
            for (int i = 0; i < layer; ++i) {
                GameMap.mapSize[0] = GameMap.bToi(in.readByte());
                GameMap.mapSize[1] = GameMap.bToi(in.readByte());
                tileWidth = in.readByte();
                tileHight = in.readByte();
                int size = mapSize[0] * mapSize[1];
                GameMap.mData[i] = new byte[size];
                in.read(mData[i]);
                int len = in.readShort();
                GameMap.mName[i] = new String[len];
                GameMap.mProperties[i] = new short[len];
                for (int j = 0; j < len; ++j) {
                    byte nameLen = in.readByte();
                    byte[] names = new byte[nameLen];
                    in.read(names);
                    GameMap.mName[i][j] = new String(names);
                    GameMap.mProperties[i][j] = in.readShort();
                }
            }
            in.close();
        }
        catch (IOException ex) {
            System.out.println("************* Read Map Error !!! ******************");
        }
    }

    public void setMap(Graphics g) {
        if (mData != null) {
            if (isShowCG) {
                this.drawCG();
            } else {
                g.setColor(0);
                g.fillRect(0, 0, screenWidth, screenHeight);
                this.drawMap(g, setOffX, setOffY);
                this.setTile(g);
                this.drawMapFG();
                this.drawTaskInfo();
                this.drawWeather();
            }
            if (blackBG) {
                GameEngine.drawColorScreenBG(0, 20);
            }
            if (isDrawFZ1) {
                this.drawFZ1(20);
            }
            if (isDrawFZ2) {
                this.drawFZ2(20);
            }
            if (isRunGame) {
                this.runSmallGame();
            }
        }
    }

    private void drawWeather() {
        switch (this.weather) {
            case 0: {
                Tools.addImage(230, setOffX - 3, setOffY - 20 + indexSun0, this.arraySun[1], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY - 12 + indexSun1, this.arraySun[1], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY - 2 + indexSun2, this.arraySun[2], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY + 8 + indexSun3, this.arraySun[1], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY + 20 + indexSun4, this.arraySun[2], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY + 34 + indexSun5, this.arraySun[1], 20, (byte)0, 9000);
                if (MyGameCanvas.gameTime % 3 != 0) break;
                GameMap.moveSun(isSun0, indexSun0, (byte)1, (byte)-4, (byte)0);
                GameMap.moveSun(isSun1, indexSun1, (byte)3, (byte)-4, (byte)1);
                GameMap.moveSun(isSun2, indexSun2, (byte)4, (byte)-2, (byte)2);
                GameMap.moveSun(isSun3, indexSun3, (byte)3, (byte)-1, (byte)3);
                GameMap.moveSun(isSun4, indexSun4, (byte)4, (byte)-3, (byte)4);
                GameMap.moveSun(isSun5, indexSun5, (byte)2, (byte)-4, (byte)5);
                break;
            }
            case 2: {
                Tools.addImage(230, setOffX - 3, setOffY - 20 + indexSun0, this.arraySun[1], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY - 12 + indexSun1, this.arraySun[1], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY - 2 + indexSun2, this.arraySun[2], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY + 8 + indexSun3, this.arraySun[1], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY + 20 + indexSun4, this.arraySun[2], 20, (byte)0, 9000);
                Tools.addImage(230, setOffX - 3, setOffY + 34 + indexSun5, this.arraySun[1], 20, (byte)0, 9000);
                if (MyGameCanvas.gameTime % 3 == 0) {
                    GameMap.moveSun(isSun0, indexSun0, (byte)1, (byte)-4, (byte)0);
                    GameMap.moveSun(isSun1, indexSun1, (byte)3, (byte)-4, (byte)1);
                    GameMap.moveSun(isSun2, indexSun2, (byte)4, (byte)-2, (byte)2);
                    GameMap.moveSun(isSun3, indexSun3, (byte)3, (byte)-1, (byte)3);
                    GameMap.moveSun(isSun4, indexSun4, (byte)4, (byte)-3, (byte)4);
                    GameMap.moveSun(isSun5, indexSun5, (byte)2, (byte)-4, (byte)5);
                }
            }
            case 1: {
                for (int i = 0; i < this.fogDat.length; ++i) {
                    short[] sArray = this.fogDat[i];
                    sArray[0] = (short)(sArray[0] - this.fogDat[i][2]);
                    if (this.fogDat[i][0] < setOffX - 199) {
                        this.initFog(i);
                    }
                    Tools.addImage(25, this.fogDat[i][0], this.fogDat[i][1], 36, (byte)0, 4999);
                }
                break;
            }
        }
    }

    public static void moveSun(boolean b, byte i, byte m, byte n, byte type) {
        if (i > m) {
            b = false;
        } else if (i < n) {
            b = true;
        }
        i = b ? (byte)(i + 1) : (byte)(i - 1);
        switch (type) {
            case 0: {
                isSun0 = b;
                indexSun0 = i;
                break;
            }
            case 1: {
                isSun1 = b;
                indexSun1 = i;
                break;
            }
            case 2: {
                isSun2 = b;
                indexSun2 = i;
                break;
            }
            case 3: {
                isSun3 = b;
                indexSun3 = i;
                break;
            }
            case 4: {
                isSun4 = b;
                indexSun4 = i;
                break;
            }
            case 5: {
                isSun5 = b;
                indexSun5 = i;
            }
        }
    }

    private void drawTaskInfo() {
        if (infoMapId == -1 || this.mapID != infoMapId) {
            return;
        }
    }

    void drawCG() {
        short CGImgIndex = -1;
        int addCGx = 0;
        int addCGy = 0;
        switch (CGId) {
            case 0: {
                addCGx = 0;
                addCGy = 30;
                CGImgIndex = 20;
                break;
            }
            case 1: {
                addCGx = 0;
                addCGy = 24;
                CGImgIndex = 21;
                break;
            }
            case 2: {
                addCGx = 0;
                addCGy = 50;
                CGImgIndex = 22;
                break;
            }
            case 3: {
                CGImgIndex = 23;
                addCGx = 0;
                addCGy = 0;
                break;
            }
            default: {
                addCGx = 0;
                addCGy = 0;
            }
        }
        GameEngine.drawColorScreenBG(0, 2000);
        if (CGId != -1 && CGId != 3) {
            Tools.addImage(CGImgIndex, setOffX + addCGx, setOffY + addCGy, 20, (byte)0, 2000);
        } else if (CGId == 3) {
            short[][] cg3Frame = new short[][]{{3, 0, 0, 0, 0, 15, 0, -16, 1, 1, 6, 6, -32, 6, 0, 6, 6, -35, 6, 0, 7, 2, -39, 10, 0, 7, 9, -44, 3, 0}, {9, 0, 0, 0, 0, 15, 4, -13, 4, 0, 6, 9, -29, 10, 0, 6, 9, -33, 10, 0, 7, 12, -31, 7, 0, 7, 5, -40, 14, 0}, {10, 0, 0, 19, 0, 10, 19, 0, 0, 1, 13, 6, -9, 6, 0}, {10, 21, -11, 38, 0, 10, 40, -11, 19, 1, 12, 21, -37, 39, 0, 11, 21, 0, 39, 0, 14, 0, -3, 58, 0, 11, 39, 0, 21, 1, 12, 39, -37, 21, 1, 14, 58, -3, 0, 1, 4, 30, -34, 46, 0, 4, 18, -44, 58, 0, 7, 26, -45, 52, 0, 8, 18, -30, 59, 0, 7, 13, -29, 65, 0, 5, 54, -33, 23, 0, 8, 61, -39, 16, 0, 6, 43, -48, 35, 0, 7, 53, -50, 25, 0, 5, 66, -46, 11, 0, 7, 63, -30, 15, 0}, {12, 41, -50, 59, 0, 11, 41, -13, 59, 0, 14, 20, -16, 78, 0, 11, 59, -13, 41, 1, 12, 59, -50, 41, 1, 14, 78, -16, 20, 1, 20, 18, -51, 59, 0, 19, 18, 0, 59, 0, 20, 59, -51, 18, 1, 19, 59, 0, 18, 1, 16, 101, -9, 0, 1, 16, 0, -9, 101, 0}, {20, 38, -63, 79, 0, 19, 38, -12, 79, 0, 20, 79, -63, 38, 1, 19, 79, -12, 38, 1, 16, 121, -21, 20, 1, 16, 20, -21, 121, 0, 25, 13, 0, 79, 0, 17, 0, -19, 146, 0, 24, 60, -78, 83, 0, 23, 17, -64, 101, 0, 24, 83, -78, 60, 1, 23, 101, -64, 17, 1, 25, 79, 0, 13, 1, 17, 146, -19, 0, 1}, {25, 35, -13, 101, 0, 17, 22, -32, 168, 0, 24, 82, -91, 105, 0, 23, 39, -77, 123, 0, 24, 105, -91, 82, 1, 23, 123, -77, 39, 1, 25, 101, -13, 35, 1, 17, 168, -32, 22, 1, 21, 28, -83, 115, 0, 22, 30, 0, 115, 0, 18, 0, -27, 188, 0, 18, 188, -27, 0, 1, 22, 115, 0, 30, 1, 21, 115, -83, 28, 1}, {21, 28, -83, 115, 0, 22, 30, 0, 115, 0, 18, 0, -27, 188, 0, 18, 188, -27, 0, 1, 22, 115, 0, 30, 1, 21, 115, -83, 28, 1}, {1, 0, 0, 0, 0}, {2, 0, 0, 0, 0}, {0, 0, 0, 0, 0}};
            short[][] cg3Clip = new short[][]{{0, 0, 47, 26}, {0, 26, 45, 23}, {0, 49, 45, 23}, {47, 0, 13, 16}, {49, 17, 3, 3}, {49, 21, 2, 2}, {54, 20, 1, 1}, {57, 17, 1, 1}, {56, 22, 2, 2}, {45, 26, 20, 13}, {45, 40, 20, 20}, {46, 60, 19, 3}, {46, 65, 19, 3}, {60, 0, 27, 22}, {66, 22, 21, 34}, {70, 56, 12, 16}, {87, 0, 18, 42}, {105, 0, 13, 42}, {118, 0, 15, 49}, {87, 49, 42, 9}, {87, 59, 42, 9}, {0, 72, 60, 17}, {2, 89, 58, 16}, {68, 72, 41, 14}, {111, 70, 16, 2}, {66, 86, 67, 19}};
            short[][] cg3motion = new short[][]{{1, 0, 1, 9, 11, 0, -41}, {1, 0, 1, 9, 11, 0, -41}, {1, 0, 1, 9, 11, 0, -41}, {2, 0, 1, 19, 20, -7, -24}, {2, 0, 1, 19, 20, -7, -24}, {2, 0, 1, 19, 20, -7, -24}, {3, 0, 1, 40, 39, -18, -33}, {3, 0, 1, 40, 39, -18, -33}, {3, 0, 1, 40, 39, -18, -33}, {4, 0, 1, 60, 59, -31, -29}, {4, 0, 1, 60, 59, -31, -29}, {4, 0, 1, 60, 59, -31, -29}, {5, 0, 1, 80, 79, -43, -37}, {5, 0, 1, 80, 79, -43, -37}, {5, 0, 1, 80, 79, -43, -37}, {6, 0, 1, 102, 101, -56, -44}, {6, 0, 1, 102, 101, -56, -44}, {6, 0, 1, 102, 101, -56, -44}, {7, 0, 1, 102, 101, -56, -44}, {7, 0, 1, 102, 101, -56, -44}, {7, 0, 1, 102, 101, -56, -44}, {7, 0, 1, 102, 101, -56, -44}, {7, 0, 1, 102, 101, -56, -44}, {7, 0, 1, 102, 101, -56, -44}, {7, 0, 1, 102, 101, -56, -44}, {7, 0, 1, 102, 101, -56, -44}, {8, 0, 1, 22, 23, -3, -20}, {8, 0, 1, 22, 23, -3, -20}, {8, 0, 1, 22, 23, -3, -20}, {9, 0, 1, 22, 23, -3, -20}, {9, 0, 1, 22, 23, -3, -20}, {9, 0, 1, 22, 23, -3, -20}, {10, 0, 1, 23, 24, -6, -20}, {10, 0, 1, 23, 24, -6, -20}, {10, 0, 1, 23, 24, -6, -20}, {10, 0, 1, 23, 24, -6, -20}};
            if (index < 10) {
                Tools.drawFrame(CGImgIndex, (short[][])cg3Frame, cg3Clip, setOffX + 120 - 8, setOffY + index / 2 * 35, 0, false, 2000);
            } else {
                short cgaddx = cg3motion[index - 10][3];
                short cgaddy = cg3motion[index - 10][5];
                Tools.drawFrame(CGImgIndex, (short[][])cg3Frame, cg3Clip, setOffX + 120 - cgaddx, setOffY + 212 - cgaddy, (int)cg3motion[index - 10][0], false, 2000);
            }
            index = (byte)(index + 1);
            if (index >= cg3motion.length + 10) {
                index = (byte)(cg3motion.length - 1 + 10);
            }
        }
    }

    public void drawMapBG(Graphics g) {
        g.setColor(0);
        g.fillRect(setOffX, setOffY, 240, 320);
    }

    public void drawMapFG() {
        this.drawDecorations();
        int w = mapSize[0] * tileWidth;
        int h = mapSize[1] * tileHight;
        int tempw = (screenWidth - w) / 2;
        int temph = (screenHeight - h) / 2;
        if (tempw > 0) {
            Tools.addRect((byte)1, setOffX, setOffY, tempw, screenHeight, true, 20, 0, 1111);
            Tools.addRect((byte)1, setOffX + w + tempw, setOffY, tempw, screenHeight, true, 20, 0, 1111);
        }
        if (temph > 0) {
            Tools.addRect((byte)1, setOffX, setOffY, screenWidth, temph, true, 20, 0, 1111);
            Tools.addRect((byte)1, setOffX, setOffY + h + temph, screenWidth, temph, true, 20, 0, 1111);
        }
        if (this.mapID == 71) {
            this.drawSinker();
        }
        if (this.mapID == 83) {
            Tools.addImage(7, setOffX, setOffY, 20, (byte)0, 27);
        }
    }

    public void drawDecorations() {
        if (blackBG) {
            return;
        }
        if (decData == null) {
            return;
        }
        block20: for (int i = 0; i < decData.length; ++i) {
            short type = decData[i][0];
            short x = decData[i][1];
            short y = decData[i][2];
            byte trans = (byte)decData[i][3];
            int id = this.getObjIndex(type);
            if (id == -1) continue;
            short addx = this.objData[id][2];
            short addy = this.objData[id][3];
            short img = this.objData[id][1];
            int drawLevel = y + 30 - 8;
            switch (type) {
                case 11: 
                case 12: 
                case 26: 
                case 27: 
                case 28: 
                case 41: 
                case 42: 
                case 46: 
                case 50: 
                case 51: 
                case 54: 
                case 55: 
                case 58: 
                case 59: {
                    drawLevel = 20;
                    break;
                }
                case 21: 
                case 22: {
                    drawLevel = (short)(y + 30 + 4);
                    break;
                }
                case 61: {
                    drawLevel = (short)(y + 30 - 16 > 20 ? y + 30 - 16 : 20);
                }
            }
            switch (type) {
                case 3: {
                    byte[][] decClipData_butterfly = new byte[][]{{0, 0, 8, 11}, {9, 2, 11, 8}, {21, 1, 7, 10}};
                    byte[][] decAddData_butterfly = new byte[][]{{0, 0}, {4, -6}, {8, -12}, {12, -6}, {16, 0}, {12, 6}, {8, 12}, {4, 6}, {0, 0}, {-4, -6}, {-8, -12}, {-12, -6}, {-16, 0}, {-12, 6}, {-8, 12}, {-4, 6}};
                    decIndex = (byte)(MyGameCanvas.gameTime % 16);
                    Tools.addImage((int)img, x + addx + decAddData_butterfly[decIndex][0], y + decAddData_butterfly[decIndex][1], decClipData_butterfly[MyGameCanvas.gameTime % 12 / 4], 36, decIndex > 4 && decIndex < 13 ? (byte)1 : 0, drawLevel + 8);
                    continue block20;
                }
                case 4: {
                    Tools.addImage(img, (MyGameCanvas.gameTime % 8 / 4 == 0 ? 0 : -1) + x + addx, y + addy, MyGameCanvas.gameTime % 8 / 4 == 0 ? 0 : 23, 0, 23, 23, 36, (byte)0, drawLevel);
                    continue block20;
                }
                case 7: {
                    byte[][] decClipData_water = new byte[][]{{0, 0, 29, 13}, {0, 13, 29, 13}, {0, 26, 29, 13}};
                    Tools.addImage((int)img, x + addx, y + addy, decClipData_water[MyGameCanvas.gameTime % 9 / 3], 36, (byte)0, drawLevel);
                    continue block20;
                }
                case 16: {
                    Tools.drawFrame(img, dec_JianFrameData, dec_JianClipData, x + addx, y + addy, MyGameCanvas.gameTime % 9 / 3, false, drawLevel);
                    continue block20;
                }
                case 37: {
                    byte[] decAddYData_fushi = new byte[]{0, 1, 2, 1};
                    Tools.drawFrame(img, dec_FuShiFrameData, dec_FuShiClipData, x + addx, y + addy + decAddYData_fushi[MyGameCanvas.gameTime % 12 / 3], MyGameCanvas.gameTime % 12 / 3, false, drawLevel);
                    continue block20;
                }
                case 43: {
                    Tools.drawFrame(img, dec_HuoFrameData, dec_HuoClipData, x + addx, y + addy, MyGameCanvas.gameTime % 12 / 3, false, drawLevel);
                    continue block20;
                }
                case 27: {
                    Tools.addImage(img, x + addx, y + addy, 36, trans, drawLevel);
                    Tools.addImage(img, x + addx + 72, y + addy, 36, (byte)(trans != 1 ? 1 : 0), drawLevel);
                    continue block20;
                }
                case 41: {
                    byte[][] decClipDat_fuyin1 = new byte[][]{{0, 0, 18, 11}, {0, 11, 18, 11}, {0, 22, 18, 11}};
                    Tools.addImage((int)img, x + addx, y + addy, decClipDat_fuyin1[MyGameCanvas.gameTime % 9 / 3], 36, trans, drawLevel);
                    continue block20;
                }
                case 42: {
                    byte[][] decClipDat_fuyin2 = new byte[][]{{0, 0, 15, 15}, {15, 0, 15, 15}, {30, 0, 15, 15}};
                    Tools.addImage((int)img, x + addx, y + addy, decClipDat_fuyin2[MyGameCanvas.gameTime % 9 / 3], 36, trans, drawLevel);
                    continue block20;
                }
                case 49: {
                    byte[] addtempY = new byte[]{0, 1, 2, 1};
                    Tools.addImage(img, x + addx, y + addy + addtempY[MyGameCanvas.gameTime % 12 / 3], 36, trans, drawLevel);
                    continue block20;
                }
                case 61: {
                    Tools.addImage(img, x + addx, y + addy, MyGameCanvas.gameTime % 12 / 3 * 15, 0, 15, 29, 36, trans, drawLevel);
                    continue block20;
                }
                case 0: {
                    Tools.addImage(img, x + addx, y + addy, 36, trans, drawLevel - 10);
                    continue block20;
                }
                case 1: {
                    Tools.addImage(img, x + addx, y + addy, 36, trans, drawLevel - 20);
                    continue block20;
                }
                default: {
                    Tools.addImage(img, x + addx, y + addy, 36, trans, drawLevel);
                }
            }
        }
    }

    void initWeather() {
        GameMap.engine.weatherIndex = 0;
        switch (this.weather) {
            case 0: {
                System.out.println(" \u9633\u5149 ");
                break;
            }
            case 1: 
            case 2: {
                for (int i = 0; i < this.fogDat.length; ++i) {
                    this.initFog(i);
                }
                System.out.println("\u96fe");
                break;
            }
            default: {
                System.out.println("\u521d\u59cb\u5316\u5929\u6c14\u51fa\u9519!");
            }
        }
    }

    void initFog(int id) {
        this.fogDat[id][0] = (short)(setOffX + screenWidth + GameEngine.nextInt(80));
        this.fogDat[id][1] = (short)(setOffY + GameEngine.nextInt(50, screenHeight));
        this.fogDat[id][2] = (short)GameEngine.nextInt(1, 4);
    }

    public void drawFZ1(int drawLevel) {
    }

    public void drawFZ2(int drawLevel) {
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public int getSetOffX(int x) {
        short dx = (short)(x - this.adjustX);
        dx = (short)Math.max(dx, 0);
        dx = (short)Math.min(dx, mapSize[0] * tileWidth - screenWidth);
        return dx;
    }

    public int getSetOffY(int y) {
        short dy = (short)(y - this.adjustY);
        dy = (short)Math.max(dy, 0);
        dy = (short)Math.min(dy, mapSize[1] * tileHight - screenHeight);
        return dy;
    }

    public void AdjustSrceen(int x, int y) {
        setOffX = Math.abs(x - setOffX - this.adjustX) > SCEEN_MOVE ? (x - setOffX - this.adjustX >= SCEEN_MOVE ? (setOffX += SCEEN_MOVE) : (setOffX -= SCEEN_MOVE)) : (int)((short)(x - this.adjustX));
        setOffX = (short)Math.max(setOffX, 0);
        int w = mapSize[0] * tileWidth;
        setOffX = w >= screenWidth ? (int)((short)Math.min(setOffX, w - screenWidth)) : (w - screenWidth) / 2;
        setOffY = Math.abs(y - setOffY - this.adjustY) > SCEEN_MOVE ? (y - setOffY - this.adjustY >= SCEEN_MOVE ? (setOffY += SCEEN_MOVE) : (setOffY -= SCEEN_MOVE)) : (int)((short)(y - this.adjustY));
        setOffY = (short)Math.max(setOffY, 0);
        int h = mapSize[1] * tileHight;
        setOffY = h >= screenHeight ? (int)((short)Math.min(setOffY, h - screenHeight)) : (h - screenHeight) / 2;
        if (isMoveScreen && this.checkMoveScreen(x, y)) {
            isMoveScreen = false;
            this.finish();
        }
    }

    public boolean checkMoveScreen(int x, int y) {
        short tempx = (short)(x - this.adjustX);
        tempx = (short)Math.max(tempx, 0);
        tempx = (short)Math.min(tempx, mapSize[0] * tileWidth - screenWidth);
        short tempy = (short)(y - this.adjustY);
        tempy = (short)Math.max(tempy, 0);
        tempy = (short)Math.min(tempy, mapSize[1] * tileHight - screenHeight);
        return setOffX == tempx && setOffY == tempy;
    }

    public void sender(Event event, short pathIndex) {
        this.event = event;
        this.pathIndex = pathIndex;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.pathIndex);
            this.event = null;
        }
    }

    public boolean canRun(int x, int y) {
        if (x < 0 || x > mapSize[0] * tileHight - tileHight || y < tileHight - 1 || y > mapSize[1] * tileHight) {
            return false;
        }
        for (int i = layer - 1; i >= 0; --i) {
            if (!(GameMap.inMapData(x, y, i) == -1 ? i == 0 : !this.canRun(x, y, i))) continue;
            return false;
        }
        return true;
    }

    public boolean canRun(int x, int y, int lay) {
        if (GameMap.inMapData(x, y, lay) == -1) {
            return false;
        }
        return Tools.getProperties(mProperties[lay][GameMap.getLow(GameMap.inMapData(x, y, lay))], (byte)15);
    }

    public int repaint(int data) {
        if (data == -1) {
            return 0;
        }
        return 0;
    }

    public int repaint(int data, int layer) {
        if (data == -1) {
            return -1;
        }
        if (Tools.getProperties(mProperties[layer][GameMap.getLow(data)], (byte)0)) {
            return 1;
        }
        if (Tools.getProperties(mProperties[layer][GameMap.getLow(data)], (byte)1)) {
            return 2;
        }
        return 0;
    }

    public static byte inMapData(int x, int y, int index) {
        int n = x / tileWidth * mapSize[1] + y / tileHight;
        if (n < 0 || n >= mData[index].length) {
            return -1;
        }
        return mData[index][n];
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public void initBattleMap() {
        switch (Battle.imgbattleBgImgs[this.battleBg]) {
            case 2: {
                Tools.getImage(2);
                break;
            }
            case 4: {
                Tools.getImage(4);
            }
        }
    }

    public static void drawFullScreenBG(int imgIndex, int height, int speed, int level) {
        int imgW = Tools.getImage(imgIndex).getWidth();
        int imgH = Tools.getImage(imgIndex).getHeight();
        int times = screenWidth / imgW + 2;
        int startPos = setOffX * speed * 10 / 1000;
        while (setOffX - startPos >= imgW) {
            startPos += imgW;
        }
        for (int i = 0; i < times; ++i) {
            Tools.addImage(imgIndex, startPos + i * imgW, height, 0, 0, imgW, imgH, 20, (byte)0, level);
        }
    }

    int getObjIndex(int id) {
        for (int i = 0; i < this.objData.length; ++i) {
            if (this.objData[i][0] != id) continue;
            return i;
        }
        return -1;
    }

    public int hitDecorations(int x, int y) {
        if (decData == null) {
            return -1;
        }
        for (int i = 0; i < decData.length; ++i) {
            short id = decData[i][0];
            int objIndex = this.getObjIndex(id);
            if (objIndex == -1) continue;
            short w = this.objData[objIndex][4];
            short h = this.objData[objIndex][5];
            if (w == 0 || h == 0 || x < decData[i][1] || x >= decData[i][1] + w || y >= decData[i][2] || y <= decData[i][2] - h) continue;
            return i;
        }
        return -1;
    }

    public static int getIndex(int v) {
        return v & 0x3F;
    }

    public int getIndex(int x, int y, int index) {
        return GameMap.getIndex(GameMap.inMapData(x, y, index));
    }

    public void setTile(Graphics g) {
        if (blackBG) {
            return;
        }
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = screenWidth / tileWidth + 2;
        int nh = screenHeight / tileHight + 2;
        for (int j = 0; j < nw; ++j) {
            int s;
            for (int i = s = n + j * mapSize[1]; i < s + nh; ++i) {
                if (i >= mData[0].length || i < 0) continue;
                int x = i / mapSize[1] * tileHight;
                int y = i % mapSize[1] * tileWidth;
                for (int k = 1; k < layer; ++k) {
                    int dataTemp = GameMap.getLow(mData[k][i]);
                    int temp = this.repaint(mData[k][i], k);
                    if (temp == -1) continue;
                    int lev = 0;
                    if (k != 0) {
                        switch (temp) {
                            case 1: {
                                lev = y + 30 + 32;
                                break;
                            }
                            case 2: {
                                lev = y + 2000;
                            }
                        }
                    }
                    Tools.addImage(300 * (k + 1) + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, (byte)GameMap.getTrans(mData[k][i]), lev);
                }
            }
        }
    }

    void initMapBuff() {
        this.isBuffNull = true;
        if (this.mapBuff == null) {
            tileWidth = (byte)16;
            tileHight = (byte)16;
            this.buffWidth = screenWidth - screenWidth % tileWidth + tileWidth * 2;
            this.buffHeight = screenHeight - screenHeight % tileHight + tileHight * 2;
            this.mapBuff = Image.createImage((int)this.buffWidth, (int)this.buffHeight);
            this.g1 = this.mapBuff.getGraphics();
        }
    }

    void drawBuff(Graphics g, int clipX, int clipY, int clipW, int clipH, int x, int y) {
        g.setClip(x, y, clipW, clipH);
        g.drawImage(this.mapBuff, x - clipX, y - clipY, 20);
        g.setClip(0, 0, screenWidth, screenHeight);
    }

    void drawMap(Graphics g, int setOffX, int setOffY) {
        int startX = setOffX / tileWidth;
        int endX = startX + screenWidth / tileWidth + 1;
        int startY = setOffY / tileHight;
        int endY = startY + screenHeight / tileHight + 1;
        if (this.isBuffNull) {
            this.isBuffNull = false;
            this.updateBuff(this.g1, startX, startY, endX, endY);
            this.lastStartX = startX;
            this.lastStartY = startY;
            this.lastEndX = endX;
            this.lastEndY = endY;
        }
        if (this.lastStartX != startX) {
            int tmp2;
            int tmp1;
            if (this.lastStartX < startX) {
                tmp1 = this.lastEndX + 1;
                tmp2 = endX;
            } else {
                tmp1 = startX;
                tmp2 = this.lastStartX - 1;
            }
            this.updateBuff(this.g1, tmp1, startY, tmp2, endY);
            this.lastStartX = startX;
            this.lastEndX = endX;
        }
        if (this.lastStartY != startY) {
            int tmp4;
            int tmp3;
            if (this.lastStartY < startY) {
                tmp3 = this.lastEndY + 1;
                tmp4 = endY;
            } else {
                tmp3 = startY;
                tmp4 = this.lastStartY - 1;
            }
            this.updateBuff(this.g1, startX, tmp3, endX, tmp4);
            this.lastStartY = startY;
            this.lastEndY = endY;
        }
        int t1 = setOffX % this.buffWidth;
        int t2 = setOffY % this.buffHeight;
        int t3 = (setOffX + screenWidth) % this.buffWidth;
        int t4 = (setOffY + screenHeight) % this.buffHeight;
        if (t3 > t1) {
            if (t4 > t2) {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight, 0, 0);
            } else {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight - t4, 0, 0);
                this.drawBuff(g, t1, 0, screenWidth, t4, 0, screenHeight - t4);
            }
        } else if (t4 > t2) {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight, 0, 0);
            this.drawBuff(g, 0, t2, t3, screenHeight, screenWidth - t3, 0);
        } else {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight - t4, 0, 0);
            this.drawBuff(g, t1, 0, screenWidth - t3, t4, 0, screenHeight - t4);
            this.drawBuff(g, 0, t2, t3, screenHeight - t4, screenWidth - t3, 0);
            this.drawBuff(g, 0, 0, t3, t4, screenWidth - t3, screenHeight - t4);
        }
    }

    void drawSinker() {
        Tools.drawFrame((short)225, this.sinkerFrame, this.sinkerClip, 55 - this.sinkerMotion[this.sinkerIndex][3], 155 - this.sinkerMotion[this.sinkerIndex][5], (int)this.sinkerMotion[this.sinkerIndex][0], false, 2000);
        this.sinkerIndex = (byte)(this.sinkerIndex + 1);
        if (this.sinkerIndex >= this.sinkerMotion.length) {
            this.sinkerIndex = 0;
        }
    }

    void updateBuff(Graphics g, int startX, int startY, int endX, int endY) {
        int y = startY * tileHight % this.buffHeight;
        for (int i = startY; i <= endY; ++i) {
            int x = startX * tileWidth % this.buffWidth;
            for (int j = startX; j <= endX; ++j) {
                for (int k = 0; k < layer; ++k) {
                    byte mapIndex = GameMap.inMapData(j * tileWidth, i * tileHight, k);
                    int dataTemp = GameMap.getIndex(mapIndex);
                    int transData = GameMap.getTrans(mapIndex);
                    if ((byte)mapIndex != -1) {
                        g.setClip(x, y, (int)tileWidth, (int)tileHight);
                        Tools.drawClipImage(g, 300 * (k + 1) + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, transData);
                        g.setClip(0, 0, this.buffWidth, this.buffHeight);
                        continue;
                    }
                    if (k != 0) continue;
                    g.setClip(x, y, (int)tileWidth, (int)tileHight);
                    g.setColor(0);
                    g.fillRect(x, y, (int)tileWidth, (int)tileHight);
                    g.setClip(0, 0, this.buffWidth, this.buffHeight);
                }
                if ((x += tileWidth) < this.buffWidth) continue;
                x -= this.buffWidth;
            }
            if ((y += tileHight) < this.buffHeight) continue;
            y -= this.buffHeight;
        }
    }

    void runSmallGame() {
        GameEngine.stopBomb = true;
        if (this.roleLife <= 0) {
            this.dead = true;
            GameEngine.shakeTime = 0;
            MyGameCanvas.setST((byte)14);
        }
        ++this.gameIndex;
        switch (this.mapID) {
            case 26: {
                int i;
                if (this.gameIndex % 40 == 1 && this.isBlue) {
                    for (i = 0; i < this.mapposRed26.length; ++i) {
                        Effect.AddEffectList(this.mapposRed26[i][0], this.mapposRed26[i][1], 45, 0, this.mapposRed26[i][1]);
                    }
                }
                if (this.gameIndex % 40 == 0) {
                    boolean bl = this.isBlue = !this.isBlue;
                }
                if (this.gameIndex % 40 == 1 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue26.length; ++i) {
                        Effect.AddEffectList(this.mapposBlue26[i][0], this.mapposBlue26[i][1], 45, 0, this.mapposBlue26[i][1]);
                    }
                }
                if (this.gameIndex % 40 == 20 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue26.length; ++i) {
                        this.mapposBlue26[i][2] = 1;
                    }
                }
                if (this.gameIndex % 40 == 27 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue26.length; ++i) {
                        this.mapposBlue26[i][2] = 0;
                    }
                }
                if (this.gameIndex % 40 == 20 && this.isBlue) {
                    for (i = 0; i < this.mapposRed26.length; ++i) {
                        this.mapposRed26[i][2] = 1;
                    }
                }
                if (this.gameIndex % 40 == 27 && this.isBlue) {
                    for (i = 0; i < this.mapposRed26.length; ++i) {
                        this.mapposRed26[i][2] = 0;
                    }
                }
                for (i = 0; i < this.mapposRed26.length; ++i) {
                    if (this.mapposRed26[i][2] != 1) continue;
                    if (!Tools.hit(this.mapposRed26[i][0] - 16, this.mapposRed26[i][1], 32, 32, GameEngine.sprite[0].x, GameEngine.sprite[0].y, 16, 16)) continue;
                    this.mapposRed26[i][2] = 0;
                    this.roleLife = (byte)(this.roleLife - 1);
                    Effect.AddEffectList(this.mapposRed26[i][0], this.mapposRed26[i][1], 32, 0, this.mapposRed26[i][1]);
                }
                for (i = 0; i < this.mapposBlue26.length; ++i) {
                    if (this.mapposBlue26[i][2] != 1) continue;
                    if (!Tools.hit(this.mapposBlue26[i][0] - 16, this.mapposBlue26[i][1], 32, 32, GameEngine.sprite[0].x, GameEngine.sprite[0].y, 16, 16)) continue;
                    this.mapposBlue26[i][2] = 0;
                    this.roleLife = (byte)(this.roleLife - 1);
                    Effect.AddEffectList(this.mapposRed26[i][0], this.mapposRed26[i][1], 32, 0, this.mapposRed26[i][1]);
                }
                break;
            }
            case 25: {
                int i;
                if (this.gameIndex % 40 == 1 && this.isBlue) {
                    for (i = 0; i < this.mapposRed25.length; ++i) {
                        Effect.AddEffectList(this.mapposRed25[i][0], this.mapposRed25[i][1], 45, 0, this.mapposRed25[i][1]);
                    }
                }
                if (this.gameIndex % 40 == 0) {
                    boolean bl = this.isBlue = !this.isBlue;
                }
                if (this.gameIndex % 40 == 1 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue25.length; ++i) {
                        Effect.AddEffectList(this.mapposBlue25[i][0], this.mapposBlue25[i][1], 45, 0, this.mapposBlue25[i][1]);
                    }
                }
                if (this.gameIndex % 40 == 20 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue25.length; ++i) {
                        this.mapposBlue25[i][2] = 1;
                    }
                }
                if (this.gameIndex % 40 == 27 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue25.length; ++i) {
                        this.mapposBlue25[i][2] = 0;
                    }
                }
                if (this.gameIndex % 40 == 20 && this.isBlue) {
                    for (i = 0; i < this.mapposRed25.length; ++i) {
                        this.mapposRed25[i][2] = 1;
                    }
                }
                if (this.gameIndex % 40 == 27 && this.isBlue) {
                    for (i = 0; i < this.mapposRed25.length; ++i) {
                        this.mapposRed25[i][2] = 0;
                    }
                }
                for (i = 0; i < this.mapposRed25.length; ++i) {
                    if (this.mapposRed25[i][2] != 1) continue;
                    if (!Tools.hit(this.mapposRed25[i][0] - 16, this.mapposRed25[i][1], 32, 32, GameEngine.sprite[0].x, GameEngine.sprite[0].y, 16, 16)) continue;
                    this.mapposRed25[i][2] = 0;
                    this.roleLife = (byte)(this.roleLife - 1);
                    Effect.AddEffectList(this.mapposRed25[i][0], this.mapposRed25[i][1], 32, 0, this.mapposRed25[i][1]);
                }
                for (i = 0; i < this.mapposBlue25.length; ++i) {
                    if (this.mapposBlue25[i][2] != 1) continue;
                    if (!Tools.hit(this.mapposBlue25[i][0] - 16, this.mapposBlue25[i][1], 32, 32, GameEngine.sprite[0].x, GameEngine.sprite[0].y, 16, 16)) continue;
                    this.mapposBlue25[i][2] = 0;
                    this.roleLife = (byte)(this.roleLife - 1);
                    Effect.AddEffectList(this.mapposRed25[i][0], this.mapposRed25[i][1], 32, 0, this.mapposRed25[i][1]);
                }
                break;
            }
            case 24: {
                int i;
                if (this.gameIndex % 40 == 1 && this.isBlue) {
                    for (i = 0; i < this.mapposRed24.length; ++i) {
                        Effect.AddEffectList(this.mapposRed24[i][0], this.mapposRed24[i][1], 45, 0, this.mapposRed24[i][1]);
                    }
                }
                if (this.gameIndex % 40 == 0) {
                    boolean bl = this.isBlue = !this.isBlue;
                }
                if (this.gameIndex % 40 == 1 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue24.length; ++i) {
                        Effect.AddEffectList(this.mapposBlue24[i][0], this.mapposBlue24[i][1], 45, 0, this.mapposBlue24[i][1]);
                    }
                }
                if (this.gameIndex % 40 == 20 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue24.length; ++i) {
                        this.mapposBlue24[i][2] = 1;
                    }
                }
                if (this.gameIndex % 40 == 27 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue24.length; ++i) {
                        this.mapposBlue24[i][2] = 0;
                    }
                }
                if (this.gameIndex % 40 == 20 && this.isBlue) {
                    for (i = 0; i < this.mapposRed24.length; ++i) {
                        this.mapposRed24[i][2] = 1;
                    }
                }
                if (this.gameIndex % 40 == 27 && this.isBlue) {
                    for (i = 0; i < this.mapposRed24.length; ++i) {
                        this.mapposRed24[i][2] = 0;
                    }
                }
                for (i = 0; i < this.mapposRed24.length; ++i) {
                    if (this.mapposRed24[i][2] != 1) continue;
                    if (!Tools.hit(this.mapposRed24[i][0] - 16, this.mapposRed24[i][1], 32, 32, GameEngine.sprite[0].x, GameEngine.sprite[0].y, 16, 16)) continue;
                    this.mapposRed24[i][2] = 0;
                    this.roleLife = (byte)(this.roleLife - 1);
                    Effect.AddEffectList(this.mapposRed24[i][0], this.mapposRed24[i][1], 32, 0, this.mapposRed24[i][1]);
                }
                for (i = 0; i < this.mapposBlue24.length; ++i) {
                    if (this.mapposBlue24[i][2] != 1) continue;
                    if (!Tools.hit(this.mapposBlue24[i][0] - 16, this.mapposBlue24[i][1], 32, 32, GameEngine.sprite[0].x, GameEngine.sprite[0].y, 16, 16)) continue;
                    this.mapposBlue24[i][2] = 0;
                    this.roleLife = (byte)(this.roleLife - 1);
                    Effect.AddEffectList(this.mapposRed24[i][0], this.mapposRed24[i][1], 32, 0, this.mapposRed24[i][1]);
                }
                break;
            }
            case 23: {
                int i;
                if (this.gameIndex % 40 == 1 && this.isBlue) {
                    for (i = 0; i < this.mapposRed23.length; ++i) {
                        Effect.AddEffectList(this.mapposRed23[i][0], this.mapposRed23[i][1], 45, 0, this.mapposRed23[i][1]);
                    }
                }
                if (this.gameIndex % 40 == 0) {
                    boolean bl = this.isBlue = !this.isBlue;
                }
                if (this.gameIndex % 40 == 1 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue23.length; ++i) {
                        Effect.AddEffectList(this.mapposBlue23[i][0], this.mapposBlue23[i][1], 45, 0, this.mapposBlue23[i][1]);
                    }
                }
                if (this.gameIndex % 40 == 20 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue23.length; ++i) {
                        this.mapposBlue23[i][2] = 1;
                    }
                }
                if (this.gameIndex % 40 == 27 && !this.isBlue) {
                    for (i = 0; i < this.mapposBlue23.length; ++i) {
                        this.mapposBlue23[i][2] = 0;
                    }
                }
                if (this.gameIndex % 40 == 20 && this.isBlue) {
                    for (i = 0; i < this.mapposRed23.length; ++i) {
                        this.mapposRed23[i][2] = 1;
                    }
                }
                if (this.gameIndex % 40 == 27 && this.isBlue) {
                    for (i = 0; i < this.mapposRed23.length; ++i) {
                        this.mapposRed23[i][2] = 0;
                    }
                }
                for (i = 0; i < this.mapposRed23.length; ++i) {
                    if (this.mapposRed23[i][2] != 1) continue;
                    if (!Tools.hit(this.mapposRed23[i][0] - 16, this.mapposRed23[i][1], 32, 32, GameEngine.sprite[0].x, GameEngine.sprite[0].y, 16, 16)) continue;
                    this.mapposRed23[i][2] = 0;
                    this.roleLife = (byte)(this.roleLife - 1);
                    Effect.AddEffectList(this.mapposRed23[i][0], this.mapposRed23[i][1], 32, 0, this.mapposRed23[i][1]);
                }
                for (i = 0; i < this.mapposBlue23.length; ++i) {
                    if (this.mapposBlue23[i][2] != 1) continue;
                    if (!Tools.hit(this.mapposBlue23[i][0] - 16, this.mapposBlue23[i][1], 32, 32, GameEngine.sprite[0].x, GameEngine.sprite[0].y, 16, 16)) continue;
                    this.mapposBlue23[i][2] = 0;
                    this.roleLife = (byte)(this.roleLife - 1);
                    Effect.AddEffectList(this.mapposRed23[i][0], this.mapposRed23[i][1], 32, 0, this.mapposRed23[i][1]);
                }
                break;
            }
        }
    }

    boolean runCheckHit(short[][] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i][2] != 1) continue;
            if (!Tools.hit(array[i][0], array[i][1] - 32, 32, 32, GameEngine.sprite[0].x, GameEngine.sprite[0].y - 16, 16, 16)) continue;
            return true;
        }
        return false;
    }

    static {
        mapSize = new int[2];
        indexSun0 = (byte)-2;
        indexSun1 = (byte)2;
        indexSun2 = (byte)-3;
        indexSun3 = (byte)4;
        indexSun4 = (byte)-2;
        indexSun5 = (byte)-3;
        infoMapId = -1;
        isShowCG = false;
        index = 0;
        indexTime = 0;
        fzXY1 = null;
        fzXY2 = null;
        SCEEN_MOVE = (byte)10;
    }
}

