/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class WordWrap {
    public static final boolean log_errors = false;
    public static String error = "ok\n";
    public static String[] errorMsg = null;
    private static int error_offset = 0;

    public static void drawError(Graphics g, int width, int height) {
        int clipOldX = g.getClipX();
        int clipOldY = g.getClipY();
        int clipOldDX = g.getClipWidth();
        int clipOldDY = g.getClipHeight();
        Font f = g.getFont();
        int yoffset = 0;
        int yspacing = f.getHeight();
        int line = 0;
        if (errorMsg == null) {
            errorMsg = WordWrap.WrapString(width, error, f);
        }
        g.setColor(0);
        g.setClip(0, yoffset, width, yoffset + yspacing * errorMsg.length);
        g.fillRect(0, yoffset, width, yoffset + yspacing * errorMsg.length);
        g.setColor(0xFF6600);
        int lines_viewable = Math.min(yspacing * errorMsg.length, height);
        for (int i = 0; i < lines_viewable && i - error_offset < errorMsg.length; ++i) {
            g.drawString("" + errorMsg[i - error_offset], 0, yoffset + yspacing * line++, 20);
        }
        g.setClip(clipOldX, clipOldY, clipOldDX, clipOldDY);
    }

    public static void setError(String str) {
    }

    public static void appendError(String str) {
    }

    public static void error_scroll(int lines) {
        int newoffset = error_offset + lines;
        if (newoffset > 0) {
            newoffset = 0;
        }
        if (newoffset < -errorMsg.length) {
            newoffset = -errorMsg.length;
        }
        error_offset = newoffset;
    }

    private static Vector Tokenize(String InputString) {
        InputString = InputString.trim();
        Vector<String> Output = new Vector<String>();
        int CurrentWordStart = 0;
        for (int i = 0; i < InputString.length(); ++i) {
            if (InputString.charAt(i) != ' ' && InputString.charAt(i) != '\n') continue;
            Output.addElement(InputString.substring(CurrentWordStart, i + 1));
            CurrentWordStart = i + 1;
        }
        Output.addElement(InputString.substring(CurrentWordStart, InputString.length()));
        return Output;
    }

    private static Vector WrapWord(int WrapWidth, String InputString, DashFont font) {
        Vector<String> Output = new Vector<String>();
        int CurrentWordStart = 0;
        for (int i = 0; i <= InputString.length(); ++i) {
            String StrToCheck = InputString.substring(CurrentWordStart, i);
            int StrToCheckWidth = font.stringWidth(StrToCheck);
            if (StrToCheckWidth <= WrapWidth) continue;
            int periodCheck = InputString.lastIndexOf(46, i - 1);
            int atSymbolCheck = InputString.lastIndexOf(64, i - 1);
            if (atSymbolCheck != -1) {
                Output.addElement(InputString.substring(CurrentWordStart, atSymbolCheck + 1));
                CurrentWordStart = atSymbolCheck + 1;
                continue;
            }
            if (periodCheck != -1) {
                Output.addElement(InputString.substring(CurrentWordStart, periodCheck + 1));
                CurrentWordStart = periodCheck + 1;
                continue;
            }
            Output.addElement(InputString.substring(CurrentWordStart, i - 1));
            CurrentWordStart = i - 1;
        }
        Output.addElement(InputString.substring(CurrentWordStart, InputString.length()));
        return Output;
    }

    public static String[] WrapString(int WrapWidth, String InputString, DashFont font) {
        int i;
        Vector TStringVector = WordWrap.Tokenize(InputString);
        Vector<String> Output = new Vector<String>();
        int CurWord = 0;
        boolean CurLineStart = false;
        String LineToCheck = "";
        String wordToAdd = "";
        int NumOfWordsInCurrentLine = 0;
        for (CurWord = 0; CurWord < TStringVector.size(); ++CurWord) {
            wordToAdd = (String)TStringVector.elementAt(CurWord);
            int LineToCheckWidth = font.stringWidth(LineToCheck + wordToAdd);
            if (LineToCheckWidth > WrapWidth) {
                if (NumOfWordsInCurrentLine == 0) {
                    Vector WordWrapOut = WordWrap.WrapWord(WrapWidth, LineToCheck + wordToAdd, font);
                    for (i = 0; i < WordWrapOut.size() - 1; ++i) {
                        Output.addElement(((String)WordWrapOut.elementAt(i)).trim());
                    }
                    LineToCheck = (String)WordWrapOut.elementAt(WordWrapOut.size() - 1);
                    NumOfWordsInCurrentLine = 1;
                    continue;
                }
                LineToCheck.trim();
                Output.addElement(LineToCheck.trim());
                LineToCheck = "";
                NumOfWordsInCurrentLine = 0;
                --CurWord;
                continue;
            }
            LineToCheck = LineToCheck + wordToAdd;
            ++NumOfWordsInCurrentLine;
            if (wordToAdd.length() <= 0 || wordToAdd.charAt(wordToAdd.length() - 1) != '\n') continue;
            Output.addElement(LineToCheck.substring(0, LineToCheck.length() - 1).trim());
            LineToCheck = "";
            NumOfWordsInCurrentLine = 0;
        }
        Output.addElement(LineToCheck.trim());
        String[] OutputStringArray = new String[Output.size()];
        for (i = 0; i < Output.size(); ++i) {
            OutputStringArray[i] = (String)Output.elementAt(i);
        }
        return OutputStringArray;
    }

    public static String[] WrapString(int WrapWidth, String InputString, Font font) {
        int i;
        Vector TStringVector = WordWrap.Tokenize(InputString);
        Vector<String> Output = new Vector<String>();
        int CurWord = 0;
        boolean CurLineStart = false;
        String LineToCheck = "";
        String wordToAdd = "";
        int NumOfWordsInCurrentLine = 0;
        for (CurWord = 0; CurWord < TStringVector.size(); ++CurWord) {
            wordToAdd = (String)TStringVector.elementAt(CurWord);
            int LineToCheckWidth = font.stringWidth(LineToCheck + wordToAdd);
            if (LineToCheckWidth > WrapWidth) {
                if (NumOfWordsInCurrentLine == 0) {
                    Vector WordWrapOut = WordWrap.WrapWord(WrapWidth, LineToCheck + wordToAdd, font);
                    for (i = 0; i < WordWrapOut.size() - 1; ++i) {
                        Output.addElement(((String)WordWrapOut.elementAt(i)).trim());
                    }
                    LineToCheck = (String)WordWrapOut.elementAt(WordWrapOut.size() - 1);
                    NumOfWordsInCurrentLine = 1;
                    continue;
                }
                LineToCheck.trim();
                Output.addElement(LineToCheck.trim());
                LineToCheck = "";
                NumOfWordsInCurrentLine = 0;
                --CurWord;
                continue;
            }
            LineToCheck = LineToCheck + wordToAdd;
            ++NumOfWordsInCurrentLine;
            if (wordToAdd.charAt(wordToAdd.length() - 1) != '\n') continue;
            Output.addElement(LineToCheck.substring(0, LineToCheck.length() - 1).trim());
            LineToCheck = "";
            NumOfWordsInCurrentLine = 0;
        }
        Output.addElement(LineToCheck.trim());
        String[] OutputStringArray = new String[Output.size()];
        for (i = 0; i < Output.size(); ++i) {
            OutputStringArray[i] = (String)Output.elementAt(i);
        }
        return OutputStringArray;
    }

    private static Vector WrapWord(int WrapWidth, String InputString, Font font) {
        Vector<String> Output = new Vector<String>();
        int CurrentWordStart = 0;
        for (int i = 0; i < InputString.length(); ++i) {
            String StrToCheck = InputString.substring(CurrentWordStart, i);
            int StrToCheckWidth = font.stringWidth(StrToCheck);
            if (StrToCheckWidth <= WrapWidth) continue;
            Output.addElement(InputString.substring(CurrentWordStart, i - 1));
            CurrentWordStart = i - 1;
        }
        Output.addElement(InputString.substring(CurrentWordStart, InputString.length()));
        return Output;
    }

    private WordWrap() {
    }
}

