/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class DashScrollableText {
    public static final int SCROLLBAR_WIDTH = 6;
    public int scroll_jump;
    String[] m_text;
    DashFont m_font;
    int dx;
    int dy;
    private AEERect m_subWindow;
    private int m_fillColor;
    private int m_borderColor;
    private int scrollPosition;
    private int m_viewableLines;
    private boolean m_allLinesRead;
    private boolean m_drawCellOutline;
    private int m_align;
    private int m_alignOff;
    private boolean m_vAlignCenter;
    private int m_scrollCursor = 0;

    private void init(String text, int width, DashFont font) {
        this.m_vAlignCenter = false;
        this.setAlign(20);
        this.m_font = font;
        this.scroll_jump = this.m_font.getHeight() + 2;
        this.dx = width;
        if (text != null) {
            this.setText(text);
        } else {
            this.m_text = null;
            this.dy = 0;
        }
    }

    public DashScrollableText(String text, int width, DashFont font) {
        this.init(text, width, font);
    }

    public DashScrollableText(AEERect area, int borderColor, int fillColor, DashFont font) {
        this.m_subWindow = new AEERect(area);
        this.init(null, area.dx - 6 - 4, font);
        this.m_viewableLines = this.m_subWindow.dy / (this.m_font.getHeight() + 2);
        this.m_fillColor = fillColor;
        this.m_borderColor = borderColor;
        this.m_allLinesRead = true;
        this.m_drawCellOutline = true;
    }

    public void setText(String text) {
        if (this.m_text != null) {
            this.clearText();
        }
        this.m_text = this.m_font.wrap(text, this.dx);
        if (this.m_text == null) {
            return;
        }
        this.dy = this.m_text.length * (this.m_font.getHeight() + 2);
        this.m_allLinesRead = this.scrollPosition + this.m_viewableLines >= this.m_text.length;
    }

    public void addText(String text) {
        String[] newText = this.m_font.wrap(text, this.dx);
        if (this.m_text == null) {
            this.m_text = newText;
        } else {
            String[] completeText = new String[this.m_text.length + newText.length];
            for (int i = 0; i < this.m_text.length; ++i) {
                completeText[i] = this.m_text[i];
            }
            for (int j = 0; j < newText.length; ++j) {
                completeText[i++] = newText[j];
            }
            this.m_text = completeText;
        }
        this.dy = this.m_text.length * (this.m_font.getHeight() + 2);
    }

    public void draw(Graphics g, int xoff, int yoff, int align) {
        if (this.m_text == null) {
            System.out.println("drawing a scrollable text without any text, bailing.");
            return;
        }
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        int clip_xoff = xoff;
        int clip_yoff = yoff;
        if ((align & 1) != 0) {
            clip_xoff -= this.dx / 2;
        } else if ((align & 8) != 0) {
            clip_xoff -= this.dx;
        }
        if ((align & 2) != 0) {
            clip_yoff -= this.dy / 2;
        } else if ((align & 0x20) != 0) {
            clip_yoff -= this.dy;
        }
        g.clipRect(clip_xoff, clip_yoff, this.dx, this.dy);
        int yspacing = this.m_font.getHeight() + 2;
        int line = (clipy - yoff) / yspacing;
        int lastLine = line + cliph / yspacing + 1;
        yoff -= this.m_scrollCursor;
        if (line < 0) {
            line = 0;
        }
        if (lastLine > this.m_text.length) {
            lastLine = this.m_text.length;
        }
        while (line < lastLine) {
            this.m_font.drawString(g, this.m_text[line], xoff, yoff + yspacing * line, align);
            ++line;
        }
        g.setClip(clipx, clipy, clipw, cliph);
    }

    private void draw_faster(Graphics g, int xoff, int yoff) {
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        int yspacing = this.m_font.getHeight() + 2;
        int firstLine = (clipy - yoff) / yspacing;
        int lastLine = firstLine + cliph / yspacing;
        yoff -= this.m_scrollCursor;
        if (firstLine < 0) {
            firstLine = 0;
        }
        if (lastLine > this.m_text.length) {
            lastLine = this.m_text.length;
        }
        for (int line = firstLine; line < lastLine; ++line) {
            if (line == firstLine || line == lastLine - 1) {
                g.setClip(clipx, clipy, clipw, cliph);
                this.m_font.drawString(g, this.m_text[line], xoff, yoff + yspacing * line, 20);
            }
            this.m_font.drawString_faster(g, this.m_text[line], xoff, yoff + yspacing * line);
        }
        g.setClip(clipx, clipy, clipw, cliph);
    }

    public void Draw(Graphics g) {
        if (this.m_subWindow == null) {
            return;
        }
        int oldColor = g.getColor();
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        int vOffset = 0;
        g.clipRect(this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx, this.m_subWindow.dy + vOffset);
        if (this.m_fillColor != 0xFF00FF) {
            g.setColor(this.m_fillColor);
            g.fillRect(this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx, this.m_subWindow.dy + vOffset);
        }
        if (this.m_vAlignCenter) {
            vOffset = (this.m_viewableLines - this.m_text.length) / 2 * (this.m_font.getHeight() + 2);
        }
        this.draw(g, this.m_subWindow.x + 2 + this.m_alignOff, this.m_subWindow.y - this.scrollPosition + vOffset, this.m_align);
        if (this.m_borderColor != 0xFF00FF) {
            if (this.m_drawCellOutline) {
                g.setColor(this.m_borderColor);
                g.drawRect(this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx - 1, this.m_subWindow.dy - 1 + vOffset);
            }
            if (this.m_subWindow.dy < this.dy) {
                g.setColor(this.m_borderColor);
                g.drawRect(this.m_subWindow.x + this.m_subWindow.dx - 6 - 1, this.m_subWindow.y, 6, this.m_subWindow.dy + vOffset - 1);
                int dyFill = this.m_subWindow.dy * this.m_subWindow.dy / this.dy + vOffset;
                int startY = this.scrollPosition * this.m_subWindow.dy / this.dy + this.m_subWindow.y;
                g.fillRect(this.m_subWindow.x + this.m_subWindow.dx - 6 - 1, startY, 6, dyFill);
            }
        }
        g.setColor(oldColor);
        g.setClip(clipx, clipy, clipw, cliph);
    }

    int getHeight() {
        return this.dy;
    }

    public void HandleAction(int key) {
        if (this.m_subWindow != null) {
            if ((key & 0x1000) != 0) {
                this.scrollPosition -= this.scroll_jump;
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                }
            }
            if ((key & 0x8000) != 0) {
                this.scrollPosition += this.scroll_jump;
                if (this.scrollPosition >= this.dy - this.m_subWindow.dy) {
                    this.scrollPosition = this.dy - this.m_subWindow.dy;
                }
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                }
            }
        }
    }

    public AEERect getTextArea() {
        AEERect area = new AEERect(0, 0, this.dx, this.dy);
        return area;
    }

    public DashFont getFont() {
        return this.m_font;
    }

    public int getNumViewableLines() {
        return this.m_viewableLines;
    }

    public boolean isTextSet() {
        return this.m_text != null;
    }

    public void clearText() {
        this.m_allLinesRead = false;
        this.scrollPosition = 0;
        if (this.m_text != null) {
            this.m_text = null;
        }
    }

    public void setDrawCellOutline(boolean on) {
        this.m_drawCellOutline = on;
    }

    public void setPos(int x, int y) {
        this.m_subWindow.x = x;
        this.m_subWindow.y = y;
    }

    public void resetScrollbar() {
        this.scrollPosition = 0;
    }

    public void setAlign(int align) {
        this.m_vAlignCenter = false;
        if ((align & 4) != 0) {
            this.m_alignOff = 0;
        } else if ((align & 8) != 0) {
            this.m_alignOff = this.m_subWindow.dx;
        } else if ((align & 1) != 0) {
            this.m_vAlignCenter = true;
            this.m_alignOff = this.m_subWindow.dx / 2 - 3 - 2;
        }
        this.m_align = align;
    }
}

