/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class DmgcpuColor
implements ICpu {
    private final int F_ZERO;
    private final int F_SUBTRACT;
    private final int F_HALFCARRY;
    private final int F_CARRY;
    protected int INSTRS_PER_HBLANK = 60;
    protected int INSTRS_IN_MODE_0 = 30;
    protected int INSTRS_IN_MODE_0_2 = 40;
    protected int INSTRS_PER_DIV = 33;
    protected final int BASE_INSTRS_PER_HBLANK;
    protected final int BASE_INSTRS_IN_MODE_0;
    protected final int BASE_INSTRS_IN_MODE_0_2;
    protected final int BASE_INSTRS_PER_DIV;
    public final int INT_VBLANK;
    public final int INT_LCDC;
    public final int INT_TIMA;
    public final int INT_SER;
    public final int INT_P10;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int sp;
    private int hl;
    private byte[] decoderMemory;
    private int localPC;
    private int globalPC;
    private int decoderMaxCruise;
    private int instrCount;
    private int nextHBlank;
    private int nextTimaOverflow;
    private int nextInterruptEnable;
    private int nextTimedInterrupt;
    public boolean interruptsEnabled = false;
    public boolean interruptsArmed = false;
    public boolean timaEnabled = false;
    public boolean interruptEnableEnabled = false;
    protected boolean p10Requested;
    protected int gbcRamBank;
    protected boolean hdmaRunning;
    public byte[][] memory = new byte[8][];
    private byte[] mainRam;
    public byte[] oam = new byte[256];
    public byte[] registers = new byte[256];
    private int divReset;
    private int instrsPerTima = 131;
    private int buttonState;
    public GraphicsChipColor graphicsChip;
    public GBCanvas screen;
    public boolean terminate;
    private String cartName;
    private int cartType;
    private byte[][] rom;
    public byte[][] cartRam;
    private int currentRomBank = 1;
    int loadedRomBanks;
    private int[] romBankQueue;
    private int currentRamBank;
    private boolean mbc1LargeRamMode;
    private boolean cartRamEnabled;
    public byte[] rtcReg = new byte[5];
    private int lastRtcUpdate;
    private int[] incflags = new int[256];
    private int[] decflags = new int[256];
    private int[] romTouch;

    public DmgcpuColor(String string, GBCanvas gBCanvas) {
        this.F_ZERO = 128;
        this.F_SUBTRACT = 64;
        this.F_HALFCARRY = 32;
        this.F_CARRY = 16;
        this.BASE_INSTRS_PER_HBLANK = 60;
        this.BASE_INSTRS_IN_MODE_0 = 30;
        this.BASE_INSTRS_IN_MODE_0_2 = 40;
        this.BASE_INSTRS_PER_DIV = 33;
        this.INT_VBLANK = 1;
        this.INT_LCDC = 2;
        this.INT_TIMA = 4;
        this.INT_SER = 8;
        this.INT_P10 = 16;
        this.cartName = string;
        this.initCartridge();
        this.screen = gBCanvas;
        this.graphicsChip = new GraphicsChipColor(this);
        this.memory[6] = this.mainRam;
        this.memory[7] = this.mainRam;
        this.interruptsEnabled = false;
        this.a = 17;
        this.b = 0;
        this.c = 19;
        this.d = 0;
        this.e = 216;
        this.f = 176;
        this.hl = 333;
        this.setPC(256);
        this.sp = 65534;
        this.nextHBlank = this.INSTRS_PER_HBLANK;
        this.nextTimaOverflow = Integer.MAX_VALUE;
        this.timaEnabled = false;
        this.nextInterruptEnable = Integer.MAX_VALUE;
        this.interruptEnableEnabled = false;
        this.nextTimedInterrupt = this.INSTRS_PER_HBLANK;
        this.initIncDecFlags();
        this.ioHandlerReset();
    }

    public DmgcpuColor(String string, GBCanvas gBCanvas, byte[] byArray, int n) {
        this.F_ZERO = 128;
        this.F_SUBTRACT = 64;
        this.F_HALFCARRY = 32;
        this.F_CARRY = 16;
        this.BASE_INSTRS_PER_HBLANK = 60;
        this.BASE_INSTRS_IN_MODE_0 = 30;
        this.BASE_INSTRS_IN_MODE_0_2 = 40;
        this.BASE_INSTRS_PER_DIV = 33;
        this.INT_VBLANK = 1;
        this.INT_LCDC = 2;
        this.INT_TIMA = 4;
        this.INT_SER = 8;
        this.INT_P10 = 16;
        this.cartName = string;
        this.initCartridge();
        this.screen = gBCanvas;
        this.graphicsChip = new GraphicsChipColor(this);
        this.memory[6] = this.mainRam;
        this.memory[7] = this.mainRam;
        this.unflatten(byArray, n);
        this.initIncDecFlags();
    }

    private void initIncDecFlags() {
        int n;
        this.incflags[0] = 160;
        for (n = 16; n < 256; n += 16) {
            this.incflags[n] = 32;
        }
        this.decflags[0] = 192;
        for (n = 1; n < 256; ++n) {
            this.decflags[n] = 64 + ((n & 0xF) == 15 ? 32 : 0);
        }
    }

    private void unflatten(byte[] byArray, int n) {
        int n2;
        this.a = byArray[n++] & 0xFF;
        this.b = byArray[n++] & 0xFF;
        this.c = byArray[n++] & 0xFF;
        this.d = byArray[n++] & 0xFF;
        this.e = byArray[n++] & 0xFF;
        this.f = byArray[n++] & 0xFF;
        this.sp = byArray[n++] & 0xFF;
        this.sp = (this.sp << 8) + (byArray[n++] & 0xFF);
        this.hl = byArray[n++] & 0xFF;
        this.hl = (this.hl << 8) + (byArray[n++] & 0xFF);
        int n3 = byArray[n++] & 0xFF;
        n3 = (n3 << 8) + (byArray[n++] & 0xFF);
        this.instrCount = GBCanvas.getInt(byArray, n);
        this.nextHBlank = GBCanvas.getInt(byArray, n += 4);
        this.nextTimaOverflow = GBCanvas.getInt(byArray, n += 4);
        this.timaEnabled = this.nextTimaOverflow == Integer.MAX_VALUE;
        this.nextInterruptEnable = GBCanvas.getInt(byArray, n += 4);
        this.interruptEnableEnabled = this.nextInterruptEnable == Integer.MAX_VALUE;
        this.nextTimedInterrupt = GBCanvas.getInt(byArray, n += 4);
        n += 4;
        if ((n2 = byArray[n++] & 0xFF) <= 1) {
            this.interruptsEnabled = n2 != 0;
            throw new RuntimeException("Incompatible saved game (GB/GBC mismatch)");
        }
        if (n2 >= 2) {
            if (n2 == 3) {
                throw new RuntimeException("Incompatible saved game (GB/GBC mismatch)");
            }
            this.interruptsEnabled = byArray[n++] != 0;
        }
        this.interruptsArmed = byArray[n++] != 0;
        System.arraycopy(byArray, n, this.mainRam, 0, this.mainRam.length);
        System.arraycopy(byArray, n += this.mainRam.length, this.oam, 0, 256);
        System.arraycopy(byArray, n += 256, this.registers, 0, 256);
        this.divReset = GBCanvas.getInt(byArray, n += 256);
        this.instrsPerTima = GBCanvas.getInt(byArray, n += 4);
        this.cartType = GBCanvas.getInt(byArray, n += 4);
        n += 4;
        for (int i = 0; i < this.cartRam.length; ++i) {
            System.arraycopy(byArray, n, this.cartRam[i], 0, 8192);
            n += 8192;
        }
        this.currentRomBank = GBCanvas.getInt(byArray, n);
        this.mapRom(this.currentRomBank);
        this.currentRamBank = GBCanvas.getInt(byArray, n += 4);
        n += 4;
        if (this.currentRamBank != 0) {
            this.mapRam(this.currentRamBank);
        }
        this.mbc1LargeRamMode = byArray[n++] != 0;
        boolean bl = this.cartRamEnabled = byArray[n++] != 0;
        if (n2 >= 2) {
            System.arraycopy(byArray, n, this.rtcReg, 0, this.rtcReg.length);
            n += this.rtcReg.length;
        }
        n = this.graphicsChip.unflatten(byArray, n);
        this.gbcRamBank = byArray[n++] & 0xFF;
        this.hdmaRunning = byArray[n++] != 0;
        this.setPC(n3);
        if (n != byArray.length) {
            throw new RuntimeException("unflatten offset error:" + n + ", " + byArray.length);
        }
    }

    public byte[] flatten() {
        int n;
        int n2 = this.cartName.length() + 1 + 35 + this.mainRam.length + 512 + 12 + 8192 * this.cartRam.length + 10 + 8192 + 48 + 6 + this.rtcReg.length;
        byte[] byArray = new byte[n2 += 8324];
        for (n = 0; n < this.cartName.length(); ++n) {
            byArray[n] = (byte)this.cartName.charAt(n);
        }
        byArray[n++] = 0;
        byArray[n++] = (byte)this.a;
        byArray[n++] = (byte)this.b;
        byArray[n++] = (byte)this.c;
        byArray[n++] = (byte)this.d;
        byArray[n++] = (byte)this.e;
        byArray[n++] = (byte)this.f;
        byArray[n++] = (byte)(this.sp >> 8);
        byArray[n++] = (byte)this.sp;
        byArray[n++] = (byte)(this.hl >> 8);
        byArray[n++] = (byte)this.hl;
        int n3 = this.localPC + this.globalPC;
        byArray[n++] = (byte)(n3 >> 8);
        byArray[n++] = (byte)n3;
        GBCanvas.setInt(byArray, n, this.instrCount);
        GBCanvas.setInt(byArray, n += 4, this.nextHBlank);
        GBCanvas.setInt(byArray, n += 4, this.timaEnabled ? this.nextTimaOverflow : Integer.MAX_VALUE);
        GBCanvas.setInt(byArray, n += 4, this.interruptEnableEnabled ? this.nextInterruptEnable : Integer.MAX_VALUE);
        GBCanvas.setInt(byArray, n += 4, this.nextTimedInterrupt);
        n += 4;
        byArray[n++] = 2;
        byArray[n++] = (byte)(this.interruptsEnabled ? 1 : 0);
        byArray[n++] = (byte)(this.interruptsArmed ? 1 : 0);
        System.arraycopy(this.mainRam, 0, byArray, n, this.mainRam.length);
        System.arraycopy(this.oam, 0, byArray, n += this.mainRam.length, 256);
        System.arraycopy(this.registers, 0, byArray, n += 256, 256);
        GBCanvas.setInt(byArray, n += 256, this.divReset);
        GBCanvas.setInt(byArray, n += 4, this.instrsPerTima);
        GBCanvas.setInt(byArray, n += 4, this.cartType);
        n += 4;
        for (int i = 0; i < this.cartRam.length; ++i) {
            System.arraycopy(this.cartRam[i], 0, byArray, n, 8192);
            n += 8192;
        }
        GBCanvas.setInt(byArray, n, this.currentRomBank);
        GBCanvas.setInt(byArray, n += 4, this.currentRamBank);
        n += 4;
        byArray[n++] = (byte)(this.mbc1LargeRamMode ? 1 : 0);
        byArray[n++] = (byte)(this.cartRamEnabled ? 1 : 0);
        System.arraycopy(this.rtcReg, 0, byArray, n, this.rtcReg.length);
        n += this.rtcReg.length;
        n = this.graphicsChip.flatten(byArray, n);
        byArray[n++] = (byte)this.gbcRamBank;
        byArray[n++] = (byte)(this.hdmaRunning ? 1 : 0);
        if (n != byArray.length) {
            throw new RuntimeException("flatten offset error:" + Integer.toString(n, 16) + ", " + Integer.toString(byArray.length, 16));
        }
        return byArray;
    }

    public final int addressRead(int n) {
        if (n < 40960) {
            return this.memory[n >> 13][n & 0x1FFF];
        }
        if (n < 49152) {
            if (this.currentRamBank >= 8) {
                this.rtcSync();
                return this.rtcReg[this.currentRamBank - 8];
            }
            return this.memory[n >> 13][n & 0x1FFF];
        }
        if ((n & 0x1000) == 0) {
            return this.mainRam[n & 0xFFF];
        }
        if (n < 65024) {
            return this.mainRam[(n & 0xFFF) + this.gbcRamBank * 4096];
        }
        if (n < 65280) {
            return this.oam[n - 65024] & 0xFF;
        }
        return this.ioRead(n - 65280);
    }

    public final void addressWrite(int n, int n2) {
        int n3 = n >> 12;
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.cartridgeWrite(n, n2);
                break;
            }
            case 8: 
            case 9: {
                this.graphicsChip.addressWrite(n - 32768, (byte)n2);
                break;
            }
            case 10: 
            case 11: {
                this.cartridgeWrite(n, n2);
                break;
            }
            case 12: {
                this.mainRam[n - 49152] = (byte)n2;
                break;
            }
            case 13: {
                this.mainRam[n - 53248 + this.gbcRamBank * 4096] = (byte)n2;
                break;
            }
            case 14: {
                this.mainRam[n - 57344] = (byte)n2;
                break;
            }
            case 15: {
                if (n < 65024) {
                    this.mainRam[n - 61440 + this.gbcRamBank * 4096] = (byte)n2;
                    break;
                }
                if (n < 65280) {
                    this.oam[n - 65024] = (byte)n2;
                    break;
                }
                this.ioWrite(n - 65280, n2);
            }
        }
    }

    private final void pushPC() {
        int n = this.globalPC + this.localPC;
        if (this.sp >> 13 == 6) {
            this.mainRam[--this.sp - 49152] = (byte)(n >> 8);
            this.mainRam[--this.sp - 49152] = (byte)n;
        } else {
            this.addressWrite(--this.sp, n >> 8);
            this.addressWrite(--this.sp, n & 0xFF);
        }
    }

    private final void popPC() {
        if (this.sp >> 13 == 6) {
            this.setPC((this.mainRam[this.sp++ - 49152] & 0xFF) + ((this.mainRam[this.sp++ - 49152] & 0xFF) << 8));
        } else {
            this.setPC((this.addressRead(this.sp++) & 0xFF) + ((this.addressRead(this.sp++) & 0xFF) << 8));
        }
    }

    private final int registerRead(int n) {
        switch (n) {
            case 0: {
                return this.b;
            }
            case 1: {
                return this.c;
            }
            case 2: {
                return this.d;
            }
            case 3: {
                return this.e;
            }
            case 4: {
                return this.hl >> 8;
            }
            case 5: {
                return this.hl & 0xFF;
            }
            case 6: {
                return this.addressRead(this.hl) & 0xFF;
            }
            case 7: {
                return this.a;
            }
        }
        return -1;
    }

    private final void registerWrite(int n, int n2) {
        switch (n) {
            case 0: {
                this.b = n2;
                return;
            }
            case 1: {
                this.c = n2;
                return;
            }
            case 2: {
                this.d = n2;
                return;
            }
            case 3: {
                this.e = n2;
                return;
            }
            case 4: {
                this.hl = this.hl & 0xFF | n2 << 8;
                return;
            }
            case 5: {
                this.hl = this.hl & 0xFF00 | n2;
                return;
            }
            case 6: {
                this.addressWrite(this.hl, n2);
                return;
            }
            case 7: {
                this.a = n2;
                return;
            }
        }
    }

    private void performHdma() {
        int n = ((this.registers[81] & 0xFF) << 8) + (this.registers[82] & 0xFF & 0xF0);
        int n2 = ((this.registers[83] & 0x1F) << 8) + (this.registers[84] & 0xF0) + 32768;
        for (int i = 0; i < 16; ++i) {
            this.addressWrite(n2 + i, this.addressRead(n + i));
        }
        this.registers[81] = (byte)(((n += 16) & 0xFF00) >> 8);
        this.registers[82] = (byte)(n & 0xF0);
        this.registers[83] = (byte)(((n2 += 16) & 0x1F00) >> 8);
        this.registers[84] = (byte)(n2 & 0xF0);
        if (this.registers[85] == 0) {
            this.hdmaRunning = false;
        }
        this.registers[85] = (byte)(this.registers[85] - 1);
    }

    private final void checkInterrupts() {
        this.pushPC();
        int n = this.registers[255] & this.registers[15];
        if ((n & 1) != 0) {
            this.setPC(64);
            this.registers[15] = (byte)(this.registers[15] - 1);
        } else if ((n & 2) != 0) {
            this.setPC(72);
            this.registers[15] = (byte)(this.registers[15] - 2);
        } else if ((n & 4) != 0) {
            this.setPC(80);
            this.registers[15] = (byte)(this.registers[15] - 4);
        } else if ((n & 8) != 0) {
            this.setPC(88);
            this.registers[15] = (byte)(this.registers[15] - 8);
        } else if ((n & 0x10) != 0) {
            this.setPC(96);
            this.registers[15] = (byte)(this.registers[15] - 16);
        } else {
            throw new RuntimeException("concurrent modification exception: " + n + " " + this.registers[255] + " " + this.registers[15]);
        }
        this.interruptsEnabled = false;
        this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
    }

    private final void initiateInterrupts() {
        if (this.instrCount - this.nextHBlank >= 0) {
            int n;
            this.nextHBlank += this.INSTRS_PER_HBLANK;
            this.registers[68] = (byte)(this.registers[68] + 1);
            if (this.hdmaRunning) {
                this.performHdma();
            }
            if ((n = this.registers[68] & 0xFF) == 153) {
                this.registers[68] = 0;
                n = 0;
            }
            if (n < 144) {
                this.graphicsChip.notifyScanline(n);
                if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 2) != 0) {
                    if ((this.registers[65] & 0x40) != 0 && (this.registers[69] & 0xFF) == n) {
                        this.interruptsArmed = true;
                        this.registers[15] = (byte)(this.registers[15] | 2);
                    } else if ((this.registers[65] & 8) != 0) {
                        this.interruptsArmed = true;
                        this.registers[15] = (byte)(this.registers[15] | 2);
                    }
                }
            } else if (n == 144) {
                this.graphicsChip.vBlank();
                if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 1) != 0) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 1);
                    if ((this.registers[65] & 0x10) != 0 && (this.registers[255] & 2) != 0) {
                        this.registers[15] = (byte)(this.registers[15] | 2);
                    }
                }
            }
            if (!this.interruptsArmed && this.p10Requested) {
                this.p10Requested = false;
                if ((this.registers[255] & 0x10) != 0) {
                    this.registers[15] = (byte)(this.registers[15] | 0x10);
                }
                this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
            }
        } else if (this.timaEnabled && this.instrCount - this.nextTimaOverflow >= 0) {
            this.nextTimaOverflow += this.instrsPerTima * (256 - this.registers[6]);
            if ((this.registers[255] & 4) != 0) {
                this.interruptsArmed = true;
                this.registers[15] = (byte)(this.registers[15] | 4);
            }
        }
        if (this.interruptEnableEnabled && this.instrCount - this.nextInterruptEnable >= 0) {
            this.interruptsEnabled = true;
            this.interruptEnableEnabled = false;
        }
        this.nextTimedInterrupt = this.timaEnabled ? (this.nextHBlank - this.nextTimaOverflow < 0 ? this.nextHBlank : this.nextTimaOverflow) : this.nextHBlank;
    }

    public final void setPC(int n) {
        if (n < 65280) {
            this.decoderMemory = this.memory[n >> 13];
            this.localPC = n & 0x1FFF;
            this.globalPC = n & 0xE000;
            int n2 = this.decoderMaxCruise = n < 57344 ? 8189 : 7677;
            if (this.gbcRamBank > 1 && n >= 49152) {
                this.decoderMaxCruise &= 0xFFF;
            }
        } else {
            this.decoderMemory = this.registers;
            this.localPC = n & 0xFF;
            this.globalPC = 65280;
            this.decoderMaxCruise = 253;
        }
    }

    private final void executeShift(int n) {
        int n2 = n & 7;
        int n3 = this.registerRead(n2);
        if ((n & 0xC0) == 0) {
            switch (n & 0xF8) {
                case 0: {
                    this.f = 0;
                    if (n3 >= 128) {
                        this.f = 16;
                    }
                    n3 = n3 << 1 & 0xFF;
                    if ((this.f & 0x10) == 0) break;
                    n3 |= 1;
                    break;
                }
                case 8: {
                    this.f = 0;
                    if ((n3 & 1) != 0) {
                        this.f = 16;
                    }
                    n3 >>= 1;
                    if ((this.f & 0x10) == 0) break;
                    n3 |= 0x80;
                    break;
                }
                case 16: {
                    int n4 = n3 >= 128 ? 16 : 0;
                    n3 = n3 << 1 & 0xFF;
                    if ((this.f & 0x10) != 0) {
                        n3 |= 1;
                    }
                    this.f = n4;
                    break;
                }
                case 24: {
                    int n5 = (n3 & 1) != 0 ? 16 : 0;
                    n3 >>= 1;
                    if ((this.f & 0x10) != 0) {
                        n3 |= 0x80;
                    }
                    this.f = n5;
                    break;
                }
                case 32: {
                    this.f = 0;
                    if ((n3 & 0x80) != 0) {
                        this.f = 16;
                    }
                    n3 = n3 << 1 & 0xFF;
                    break;
                }
                case 40: {
                    this.f = 0;
                    if ((n3 & 1) != 0) {
                        this.f = 16;
                    }
                    n3 = (n3 & 0x80) + (n3 >> 1);
                    break;
                }
                case 48: {
                    n3 = (n3 & 0xF) << 4 | n3 >> 4;
                    this.f = 0;
                    break;
                }
                case 56: {
                    this.f = 0;
                    if ((n3 & 1) != 0) {
                        this.f = 16;
                    }
                    n3 >>= 1;
                }
            }
            if (n3 == 0) {
                this.f |= 0x80;
            }
            this.registerWrite(n2, n3);
        } else {
            int n6 = 1 << ((n & 0x38) >> 3);
            if ((n & 0xC0) == 64) {
                this.f = this.f & 0x10 | 0x20;
                if ((n3 & n6) == 0) {
                    this.f |= 0x80;
                }
            } else if ((n & 0xC0) == 128) {
                this.registerWrite(n2, n3 & 255 - n6);
            } else if ((n & 0xC0) == 192) {
                this.registerWrite(n2, n3 | n6);
            }
        }
    }

    private final void executeDAA() {
        int n = this.a >> 4 & 0xF;
        int n2 = this.a & 0xF;
        int n3 = this.f & 0x50;
        if ((this.f & 0x40) == 0) {
            if ((this.f & 0x10) == 0) {
                if (n <= 8 && n2 >= 10 && (this.f & 0x20) == 0) {
                    this.a += 6;
                }
                if (n <= 9 && n2 <= 3 && (this.f & 0x20) != 0) {
                    this.a += 6;
                }
                if (n >= 10 && n2 <= 9 && (this.f & 0x20) == 0) {
                    this.a += 96;
                    n3 |= 0x10;
                }
                if (n >= 9 && n2 >= 10 && (this.f & 0x20) == 0) {
                    this.a += 102;
                    n3 |= 0x10;
                }
                if (n >= 10 && n2 <= 3 && (this.f & 0x20) != 0) {
                    this.a += 102;
                    n3 |= 0x10;
                }
            } else {
                if (n <= 2 && n2 <= 9 && (this.f & 0x20) == 0) {
                    this.a += 96;
                }
                if (n <= 2 && n2 >= 10 && (this.f & 0x20) == 0) {
                    this.a += 102;
                }
                if (n <= 3 && n2 <= 3 && (this.f & 0x20) != 0) {
                    this.a += 102;
                }
            }
        } else if ((this.f & 0x10) == 0) {
            if (n <= 8 && n2 >= 6 && (this.f & 0x20) != 0) {
                this.a += 250;
            }
        } else {
            if (n >= 7 && n2 <= 9 && (this.f & 0x20) == 0) {
                this.a += 160;
            }
            if (n >= 6 && n2 >= 6 && (this.f & 0x20) != 0) {
                this.a += 154;
            }
        }
        this.a &= 0xFF;
        if (this.a == 0) {
            n3 |= 0x80;
        }
        this.f = n3;
    }

    private final void executeALU(int n) {
        int n2 = this.registerRead(n & 7);
        switch ((n & 0x38) >> 3) {
            case 1: {
                if ((this.f & 0x10) != 0) {
                    ++n2;
                }
            }
            case 0: {
                this.f = (this.a & 0xF) + (n2 & 0xF) >= 16 ? 32 : 0;
                this.a += n2;
                if (this.a > 255) {
                    this.f |= 0x10;
                    this.a &= 0xFF;
                }
                if (this.a != 0) break;
                this.f |= 0x80;
                break;
            }
            case 3: {
                if ((this.f & 0x10) != 0) {
                    ++n2;
                }
            }
            case 2: {
                this.f = 64;
                if ((this.a & 0xF) < (n2 & 0xF)) {
                    this.f |= 0x20;
                }
                this.a -= n2;
                if (this.a < 0) {
                    this.f |= 0x10;
                    this.a &= 0xFF;
                }
                if (this.a != 0) break;
                this.f |= 0x80;
                break;
            }
            case 4: {
                this.a &= n2;
                if (this.a == 0) {
                    this.f = 160;
                    break;
                }
                this.f = 32;
                break;
            }
            case 5: {
                this.a ^= n2;
                this.f = this.a == 0 ? 128 : 0;
                break;
            }
            case 6: {
                this.a |= n2;
                this.f = this.a == 0 ? 128 : 0;
                break;
            }
            case 7: {
                this.f = 64;
                if (this.a == n2) {
                    this.f |= 0x80;
                } else if (this.a < n2) {
                    this.f |= 0x10;
                }
                if ((this.a & 0xF) >= (n2 & 0xF)) break;
                this.f |= 0x20;
            }
        }
    }

    public final void run() {
        int n;
        this.terminate = false;
        int n2 = 0;
        System.gc();
        this.graphicsChip.timer = n = (int)System.currentTimeMillis();
        while (!this.terminate) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            ++this.instrCount;
            if (this.localPC <= this.decoderMaxCruise) {
                n7 = this.decoderMemory[this.localPC++] & 0xFF;
                n6 = this.decoderMemory[this.localPC];
                n5 = n6 & 0xFF;
                n4 = this.decoderMemory[this.localPC + 1];
            } else {
                n3 = this.localPC + this.globalPC;
                n7 = this.addressRead(n3++) & 0xFF;
                n6 = this.addressRead(n3);
                n5 = n6 & 0xFF;
                n4 = this.addressRead(n3 + 1);
                this.setPC(n3);
            }
            switch (n7) {
                case 0: {
                    break;
                }
                case 1: {
                    this.localPC += 2;
                    this.b = n4 & 0xFF;
                    this.c = n5;
                    break;
                }
                case 2: {
                    this.addressWrite(this.b << 8 | this.c, this.a);
                    break;
                }
                case 3: {
                    ++this.c;
                    if (this.c != 256) break;
                    this.c = 0;
                    this.b = this.b + 1 & 0xFF;
                    break;
                }
                case 4: {
                    this.b = this.b + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.b];
                    break;
                }
                case 5: {
                    this.b = this.b - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.b];
                    break;
                }
                case 6: {
                    ++this.localPC;
                    this.b = n5;
                    break;
                }
                case 7: {
                    if (this.a >= 128) {
                        this.f = 16;
                        this.a = (this.a << 1) + 1 & 0xFF;
                        break;
                    }
                    if (this.a == 0) {
                        this.f = 128;
                        break;
                    }
                    this.a <<= 1;
                    this.f = 0;
                    break;
                }
                case 8: {
                    this.localPC += 2;
                    n2 = ((n4 & 0xFF) << 8) + n5;
                    this.addressWrite(n2, this.sp);
                    this.addressWrite(n2 + 1, this.sp >> 8);
                    break;
                }
                case 9: {
                    this.hl += (this.b << 8) + this.c;
                    if ((this.hl & 0xFFFF0000) != 0) {
                        this.f = this.f & 0x80 | 0x10;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    this.f &= 0x80;
                    break;
                }
                case 10: {
                    this.a = this.addressRead((this.b << 8) + this.c) & 0xFF;
                    break;
                }
                case 11: {
                    --this.c;
                    if (this.c >= 0) break;
                    this.c = 255;
                    this.b = this.b - 1 & 0xFF;
                    break;
                }
                case 12: {
                    this.c = this.c + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.c];
                    break;
                }
                case 13: {
                    this.c = this.c - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.c];
                    break;
                }
                case 14: {
                    ++this.localPC;
                    this.c = n5;
                    break;
                }
                case 15: {
                    this.f = (this.a & 1) == 1 ? 16 : 0;
                    this.a >>= 1;
                    if ((this.f & 0x10) != 0) {
                        this.a |= 0x80;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 16: {
                    ++this.localPC;
                    if ((this.registers[77] & 1) == 0) break;
                    n3 = this.registers[77] & 0xFE;
                    int n8 = 1;
                    if ((n3 & 0x80) != 0) {
                        n3 &= 0x7F;
                    } else {
                        n8 = 2;
                        n3 |= 0x80;
                    }
                    this.INSTRS_PER_HBLANK = 60 * n8;
                    this.INSTRS_PER_DIV = 33 * n8;
                    this.INSTRS_IN_MODE_0 = 30 * n8;
                    this.INSTRS_IN_MODE_0_2 = 40 * n8;
                    this.registers[77] = (byte)n3;
                    break;
                }
                case 17: {
                    this.localPC += 2;
                    this.d = n4 & 0xFF;
                    this.e = n5;
                    break;
                }
                case 18: {
                    this.addressWrite((this.d << 8) + this.e, this.a);
                    break;
                }
                case 19: {
                    ++this.e;
                    if (this.e != 256) break;
                    this.e = 0;
                    this.d = this.d + 1 & 0xFF;
                    break;
                }
                case 20: {
                    this.d = this.d + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.d];
                    break;
                }
                case 21: {
                    this.d = this.d - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.d];
                    break;
                }
                case 22: {
                    ++this.localPC;
                    this.d = n5;
                    break;
                }
                case 23: {
                    n2 = (this.a & 0x80) != 0 ? 16 : 0;
                    this.a <<= 1;
                    if ((this.f & 0x10) != 0) {
                        this.a |= 1;
                    }
                    this.a &= 0xFF;
                    if (this.a == 0) {
                        n2 |= 0x80;
                    }
                    this.f = n2;
                    break;
                }
                case 24: {
                    this.localPC += 1 + n6;
                    if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                    this.setPC(this.localPC + this.globalPC);
                    break;
                }
                case 25: {
                    this.hl += (this.d << 8) + this.e;
                    if ((this.hl & 0xFFFF0000) != 0) {
                        this.f = this.f & 0x80 | 0x10;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    this.f &= 0x80;
                    break;
                }
                case 26: {
                    this.a = this.addressRead((this.d << 8) + this.e) & 0xFF;
                    break;
                }
                case 27: {
                    --this.e;
                    if (this.e >= 0) break;
                    this.e = 255;
                    this.d = this.d - 1 & 0xFF;
                    break;
                }
                case 28: {
                    this.e = this.e + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.e];
                    break;
                }
                case 29: {
                    this.e = this.e - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.e];
                    break;
                }
                case 30: {
                    ++this.localPC;
                    this.e = n5;
                    break;
                }
                case 31: {
                    n2 = (this.a & 1) != 0 ? 16 : 0;
                    this.a >>= 1;
                    if ((this.f & 0x10) != 0) {
                        this.a |= 0x80;
                    }
                    if (this.a == 0) {
                        n2 |= 0x80;
                    }
                    this.f = n2;
                    break;
                }
                case 32: {
                    if (this.f < 128) {
                        this.localPC += 1 + n6;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    ++this.localPC;
                    break;
                }
                case 33: {
                    this.localPC += 2;
                    this.hl = ((n4 & 0xFF) << 8) + n5;
                    break;
                }
                case 34: {
                    this.addressWrite(this.hl++, this.a);
                    break;
                }
                case 35: {
                    this.hl = this.hl + 1 & 0xFFFF;
                    break;
                }
                case 36: {
                    n5 = (this.hl >> 8) + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[n5];
                    this.hl = (this.hl & 0xFF) + (n5 << 8);
                    break;
                }
                case 37: {
                    n5 = (this.hl >> 8) - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[n5];
                    this.hl = (this.hl & 0xFF) + (n5 << 8);
                    break;
                }
                case 38: {
                    ++this.localPC;
                    this.hl = this.hl & 0xFF | n5 << 8;
                    break;
                }
                case 39: {
                    this.executeDAA();
                    break;
                }
                case 40: {
                    if (this.f >= 128) {
                        this.localPC += 1 + n6;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    ++this.localPC;
                    break;
                }
                case 41: {
                    this.hl *= 2;
                    if ((this.hl & 0xFFFF0000) != 0) {
                        this.f = this.f & 0x80 | 0x10;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    this.f &= 0x80;
                    break;
                }
                case 42: {
                    this.a = this.addressRead(this.hl++) & 0xFF;
                    break;
                }
                case 43: {
                    this.hl = this.hl - 1 & 0xFFFF;
                    break;
                }
                case 44: {
                    n5 = this.hl + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[n5];
                    this.hl = (this.hl & 0xFF00) + n5;
                    break;
                }
                case 45: {
                    n5 = this.hl - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[n5];
                    this.hl = (this.hl & 0xFF00) + n5;
                    break;
                }
                case 46: {
                    ++this.localPC;
                    this.hl = this.hl & 0xFF00 | n5;
                    break;
                }
                case 47: {
                    this.a = ~this.a & 0xFF;
                    this.f |= 0x60;
                    break;
                }
                case 48: {
                    if ((this.f & 0x10) == 0) {
                        this.localPC += 1 + n6;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    ++this.localPC;
                    break;
                }
                case 49: {
                    this.localPC += 2;
                    this.sp = ((n4 & 0xFF) << 8) + n5;
                    break;
                }
                case 50: {
                    this.addressWrite(this.hl--, this.a);
                    break;
                }
                case 51: {
                    this.sp = this.sp + 1 & 0xFFFF;
                    break;
                }
                case 52: {
                    n5 = this.addressRead(this.hl) + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[n5];
                    this.addressWrite(this.hl, n5);
                    break;
                }
                case 53: {
                    n5 = this.addressRead(this.hl) - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[n5];
                    this.addressWrite(this.hl, n5);
                    break;
                }
                case 54: {
                    ++this.localPC;
                    this.addressWrite(this.hl, n5);
                    break;
                }
                case 55: {
                    this.f = this.f & 0x80 | 0x10;
                    break;
                }
                case 56: {
                    if ((this.f & 0x10) != 0) {
                        this.localPC += 1 + n6;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    ++this.localPC;
                    break;
                }
                case 57: {
                    this.hl += this.sp;
                    if (this.hl > 65535) {
                        this.f = this.f & 0x80 | 0x10;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    this.f &= 0x80;
                    break;
                }
                case 58: {
                    this.a = this.addressRead(this.hl--) & 0xFF;
                    break;
                }
                case 59: {
                    this.sp = this.sp - 1 & 0xFFFF;
                    break;
                }
                case 60: {
                    this.a = this.a + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.a];
                    break;
                }
                case 61: {
                    this.a = this.a - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.a];
                    break;
                }
                case 62: {
                    ++this.localPC;
                    this.a = n5;
                    break;
                }
                case 63: {
                    this.f = this.f & 0x90 ^ 0x10;
                    break;
                }
                case 64: {
                    break;
                }
                case 65: {
                    this.b = this.c;
                    break;
                }
                case 66: {
                    this.b = this.d;
                    break;
                }
                case 67: {
                    this.b = this.e;
                    break;
                }
                case 68: {
                    this.b = this.hl >> 8;
                    break;
                }
                case 69: {
                    this.b = this.hl & 0xFF;
                    break;
                }
                case 70: {
                    this.b = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 71: {
                    this.b = this.a;
                    break;
                }
                case 72: {
                    this.c = this.b;
                    break;
                }
                case 73: {
                    break;
                }
                case 74: {
                    this.c = this.d;
                    break;
                }
                case 75: {
                    this.c = this.e;
                    break;
                }
                case 76: {
                    this.c = this.hl >> 8;
                    break;
                }
                case 77: {
                    this.c = this.hl & 0xFF;
                    break;
                }
                case 78: {
                    this.c = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 79: {
                    this.c = this.a;
                    break;
                }
                case 80: {
                    this.d = this.b;
                    break;
                }
                case 81: {
                    this.d = this.c;
                    break;
                }
                case 82: {
                    break;
                }
                case 83: {
                    this.d = this.e;
                    break;
                }
                case 84: {
                    this.d = this.hl >> 8;
                    break;
                }
                case 85: {
                    this.d = this.hl & 0xFF;
                    break;
                }
                case 86: {
                    this.d = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 87: {
                    this.d = this.a;
                    break;
                }
                case 88: {
                    this.e = this.b;
                    break;
                }
                case 89: {
                    this.e = this.c;
                    break;
                }
                case 90: {
                    this.e = this.d;
                    break;
                }
                case 91: {
                    break;
                }
                case 92: {
                    this.e = this.hl >> 8;
                    break;
                }
                case 93: {
                    this.e = this.hl & 0xFF;
                    break;
                }
                case 94: {
                    this.e = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 95: {
                    this.e = this.a;
                    break;
                }
                case 96: {
                    this.hl = this.hl & 0xFF | this.b << 8;
                    break;
                }
                case 97: {
                    this.hl = this.hl & 0xFF | this.c << 8;
                    break;
                }
                case 98: {
                    this.hl = this.hl & 0xFF | this.d << 8;
                    break;
                }
                case 99: {
                    this.hl = this.hl & 0xFF | this.e << 8;
                    break;
                }
                case 100: {
                    break;
                }
                case 101: {
                    this.hl = (this.hl & 0xFF) * 257;
                    break;
                }
                case 102: {
                    this.hl = this.hl & 0xFF | (this.addressRead(this.hl) & 0xFF) << 8;
                    break;
                }
                case 103: {
                    this.hl = this.hl & 0xFF | this.a << 8;
                    break;
                }
                case 104: {
                    this.hl = this.hl & 0xFF00 | this.b;
                    break;
                }
                case 105: {
                    this.hl = this.hl & 0xFF00 | this.c;
                    break;
                }
                case 106: {
                    this.hl = this.hl & 0xFF00 | this.d;
                    break;
                }
                case 107: {
                    this.hl = this.hl & 0xFF00 | this.e;
                    break;
                }
                case 108: {
                    this.hl = (this.hl >> 8) * 257;
                    break;
                }
                case 109: {
                    break;
                }
                case 110: {
                    this.hl = this.hl & 0xFF00 | this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 111: {
                    this.hl = this.hl & 0xFF00 | this.a;
                    break;
                }
                case 112: {
                    this.addressWrite(this.hl, this.b);
                    break;
                }
                case 113: {
                    this.addressWrite(this.hl, this.c);
                    break;
                }
                case 114: {
                    this.addressWrite(this.hl, this.d);
                    break;
                }
                case 115: {
                    this.addressWrite(this.hl, this.e);
                    break;
                }
                case 116: {
                    this.addressWrite(this.hl, this.hl >> 8);
                    break;
                }
                case 117: {
                    this.addressWrite(this.hl, this.hl);
                    break;
                }
                case 118: {
                    this.interruptsEnabled = true;
                    while (!this.interruptsArmed) {
                        this.instrCount = this.nextTimedInterrupt;
                        this.initiateInterrupts();
                    }
                    break;
                }
                case 119: {
                    this.addressWrite(this.hl, this.a);
                    break;
                }
                case 120: {
                    this.a = this.b;
                    break;
                }
                case 121: {
                    this.a = this.c;
                    break;
                }
                case 122: {
                    this.a = this.d;
                    break;
                }
                case 123: {
                    this.a = this.e;
                    break;
                }
                case 124: {
                    this.a = this.hl >> 8;
                    break;
                }
                case 125: {
                    this.a = this.hl & 0xFF;
                    break;
                }
                case 126: {
                    this.a = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 127: {
                    break;
                }
                case 167: {
                    if (this.a == 0) {
                        this.f = 160;
                        break;
                    }
                    this.f = 32;
                    break;
                }
                case 175: {
                    this.a = 0;
                    this.f = 128;
                    break;
                }
                case 192: {
                    if (this.f >= 128) break;
                    this.popPC();
                    break;
                }
                case 193: {
                    this.c = this.addressRead(this.sp++) & 0xFF;
                    this.b = this.addressRead(this.sp++) & 0xFF;
                    break;
                }
                case 194: {
                    if (this.f < 128) {
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    this.localPC += 2;
                    break;
                }
                case 195: {
                    this.setPC(((n4 & 0xFF) << 8) + n5);
                    break;
                }
                case 196: {
                    this.localPC += 2;
                    if (this.f >= 128) break;
                    this.pushPC();
                    this.setPC(((n4 & 0xFF) << 8) + n5);
                    break;
                }
                case 197: {
                    this.addressWrite(--this.sp, this.b);
                    this.addressWrite(--this.sp, this.c);
                    break;
                }
                case 198: {
                    ++this.localPC;
                    this.f = (this.a & 0xF) + (n5 & 0xF) >= 16 ? 32 : 0;
                    this.a += n5;
                    if (this.a > 255) {
                        this.f |= 0x10;
                        this.a &= 0xFF;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 199: {
                    this.pushPC();
                    this.setPC(0);
                    break;
                }
                case 200: {
                    if (this.f < 128) break;
                    this.popPC();
                    break;
                }
                case 201: {
                    this.popPC();
                    break;
                }
                case 202: {
                    if (this.f >= 128) {
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    this.localPC += 2;
                    break;
                }
                case 203: {
                    ++this.localPC;
                    this.executeShift(n5);
                    break;
                }
                case 204: {
                    this.localPC += 2;
                    if (this.f < 128) break;
                    this.pushPC();
                    this.setPC(((n4 & 0xFF) << 8) + n5);
                    break;
                }
                case 205: {
                    this.localPC += 2;
                    this.pushPC();
                    this.setPC(((n4 & 0xFF) << 8) + n5);
                    break;
                }
                case 206: {
                    ++this.localPC;
                    if ((this.f & 0x10) != 0) {
                        ++n5;
                    }
                    this.f = (this.a & 0xF) + (n5 & 0xF) >= 16 ? 32 : 0;
                    this.a += n5;
                    if (this.a > 255) {
                        this.f |= 0x10;
                        this.a &= 0xFF;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 207: {
                    this.pushPC();
                    this.setPC(8);
                    break;
                }
                case 208: {
                    if ((this.f & 0x10) != 0) break;
                    this.popPC();
                    break;
                }
                case 209: {
                    this.e = this.addressRead(this.sp++) & 0xFF;
                    this.d = this.addressRead(this.sp++) & 0xFF;
                    break;
                }
                case 210: {
                    if ((this.f & 0x10) == 0) {
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    this.localPC += 2;
                    break;
                }
                case 212: {
                    this.localPC += 2;
                    if ((this.f & 0x10) != 0) break;
                    this.pushPC();
                    this.setPC(((n4 & 0xFF) << 8) + n5);
                    break;
                }
                case 213: {
                    this.addressWrite(--this.sp, this.d);
                    this.addressWrite(--this.sp, this.e);
                    break;
                }
                case 214: {
                    ++this.localPC;
                    this.f = 64;
                    if ((this.a & 0xF) < (n5 & 0xF)) {
                        this.f |= 0x20;
                    }
                    this.a -= n5;
                    if (this.a < 0) {
                        this.f |= 0x10;
                        this.a &= 0xFF;
                        break;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 215: {
                    this.pushPC();
                    this.setPC(16);
                    break;
                }
                case 216: {
                    if ((this.f & 0x10) == 0) break;
                    this.popPC();
                    break;
                }
                case 217: {
                    this.interruptsEnabled = true;
                    this.popPC();
                    break;
                }
                case 218: {
                    if ((this.f & 0x10) != 0) {
                        this.setPC(((n4 & 0xFF) << 8) + n5);
                        break;
                    }
                    this.localPC += 2;
                    break;
                }
                case 220: {
                    this.localPC += 2;
                    if ((this.f & 0x10) == 0) break;
                    this.pushPC();
                    this.setPC(((n4 & 0xFF) << 8) + n5);
                    break;
                }
                case 222: {
                    ++this.localPC;
                    if ((this.f & 0x10) != 0) {
                        ++n5;
                    }
                    this.f = 64;
                    if ((this.a & 0xF) < (n5 & 0xF)) {
                        this.f |= 0x20;
                    }
                    this.a -= n5;
                    if (this.a < 0) {
                        this.f |= 0x10;
                        this.a &= 0xFF;
                        break;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 223: {
                    this.pushPC();
                    this.setPC(24);
                    break;
                }
                case 224: {
                    ++this.localPC;
                    this.ioWrite(n5, this.a);
                    break;
                }
                case 225: {
                    this.hl = ((this.addressRead(this.sp + 1) & 0xFF) << 8) + (this.addressRead(this.sp) & 0xFF);
                    this.sp += 2;
                    break;
                }
                case 226: {
                    this.ioWrite(this.c, this.a);
                    break;
                }
                case 229: {
                    this.addressWrite(--this.sp, this.hl >> 8);
                    this.addressWrite(--this.sp, this.hl);
                    break;
                }
                case 230: {
                    ++this.localPC;
                    this.a &= n5;
                    if (this.a == 0) {
                        this.f = 128;
                        break;
                    }
                    this.f = 0;
                    break;
                }
                case 231: {
                    this.pushPC();
                    this.setPC(32);
                    break;
                }
                case 232: {
                    ++this.localPC;
                    this.sp += n6;
                    this.f = 0;
                    if (this.sp <= 65535 && this.sp >= 0) break;
                    this.sp &= 0xFFFF;
                    this.f = 16;
                    break;
                }
                case 233: {
                    this.setPC(this.hl);
                    break;
                }
                case 234: {
                    this.localPC += 2;
                    this.addressWrite(((n4 & 0xFF) << 8) + n5, this.a);
                    break;
                }
                case 238: {
                    ++this.localPC;
                    this.a ^= n5;
                    this.f = 0;
                    if (this.a != 0) break;
                    this.f = 128;
                    break;
                }
                case 239: {
                    this.pushPC();
                    this.setPC(40);
                    break;
                }
                case 240: {
                    ++this.localPC;
                    if (n5 > 65) {
                        this.a = this.registers[n5] & 0xFF;
                        break;
                    }
                    this.a = this.ioRead(n5) & 0xFF;
                    break;
                }
                case 241: {
                    this.f = this.addressRead(this.sp++) & 0xF0;
                    this.a = this.addressRead(this.sp++) & 0xFF;
                    break;
                }
                case 242: {
                    this.a = this.ioRead(this.c) & 0xFF;
                    break;
                }
                case 243: {
                    this.interruptsEnabled = false;
                    break;
                }
                case 245: {
                    this.addressWrite(--this.sp, this.a);
                    this.addressWrite(--this.sp, this.f);
                    break;
                }
                case 246: {
                    ++this.localPC;
                    this.a |= n5;
                    this.f = 0;
                    if (this.a != 0) break;
                    this.f = 128;
                    break;
                }
                case 247: {
                    this.pushPC();
                    this.setPC(48);
                    break;
                }
                case 248: {
                    ++this.localPC;
                    this.hl = this.sp + n6;
                    this.f = 0;
                    if ((this.hl & 0xFFFF0000) == 0) break;
                    this.f = 16;
                    this.hl &= 0xFFFF;
                    break;
                }
                case 249: {
                    this.sp = this.hl;
                    break;
                }
                case 250: {
                    this.localPC += 2;
                    this.a = this.addressRead(((n4 & 0xFF) << 8) + n5) & 0xFF;
                    break;
                }
                case 251: {
                    this.nextTimedInterrupt = this.nextInterruptEnable = this.instrCount;
                    this.interruptEnableEnabled = true;
                    break;
                }
                case 254: {
                    ++this.localPC;
                    int n9 = this.f = (this.a & 0xF) < (n5 & 0xF) ? 96 : 64;
                    if (this.a == n5) {
                        this.f |= 0x80;
                        break;
                    }
                    if (this.a >= n5) break;
                    this.f |= 0x10;
                    break;
                }
                case 255: {
                    this.pushPC();
                    this.setPC(56);
                    break;
                }
                default: {
                    if ((n7 & 0xC0) == 128) {
                        this.executeALU(n7);
                        break;
                    }
                    MeBoy.log("Unrecognized opcode (" + Integer.toHexString(n7) + ")");
                    this.terminate = true;
                    MeBoy.showLog();
                }
            }
            if (this.interruptsArmed && this.interruptsEnabled) {
                this.checkInterrupts();
            }
            if (this.instrCount - this.nextTimedInterrupt < 0) continue;
            this.initiateInterrupts();
        }
    }

    private final void ioHandlerReset() {
        this.ioWrite(15, 1);
        this.ioWrite(38, 241);
        this.ioWrite(64, 145);
        this.ioWrite(71, 252);
        this.ioWrite(72, 255);
        this.ioWrite(73, 255);
        this.registers[85] = -128;
        this.hdmaRunning = false;
    }

    private final int ioRead(int n) {
        if (n == 65) {
            int n2 = this.registers[65];
            if (this.registers[68] == this.registers[69]) {
                n2 |= 4;
            }
            if ((this.registers[68] & 0xFF) >= 144) {
                n2 |= 1;
            } else {
                int n3 = this.instrCount - this.nextHBlank + this.INSTRS_PER_HBLANK;
                if (n3 != this.INSTRS_PER_HBLANK) {
                    if (n3 > this.INSTRS_IN_MODE_0_2) {
                        n2 |= 3;
                    } else if (n3 > this.INSTRS_IN_MODE_0) {
                        n2 |= 2;
                    }
                }
            }
            return n2;
        }
        if (n == 4) {
            return (byte)((this.instrCount - this.divReset - 1) / this.INSTRS_PER_DIV);
        }
        if (n == 5) {
            if (!this.timaEnabled) {
                return 0;
            }
            return (this.instrCount + this.instrsPerTima * 256 - this.nextTimaOverflow) / this.instrsPerTima;
        }
        return this.registers[n];
    }

    public void ioWrite(int n, int n2) {
        switch (n) {
            case 0: {
                int n3 = 0;
                if ((n2 & 0x10) == 0) {
                    n3 |= this.buttonState & 0xF;
                }
                if ((n2 & 0x20) == 0) {
                    n3 |= this.buttonState >> 4;
                }
                this.registers[0] = (byte)(0xF0 | ~n3 & 0xF);
                break;
            }
            case 2: {
                this.registers[2] = (byte)n2;
                if ((this.registers[2] & 1) != 1) break;
                this.registers[1] = -1;
                if ((this.registers[255] & 8) != 0) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 8);
                }
                this.registers[2] = (byte)(this.registers[2] & 0x7F);
                break;
            }
            case 4: {
                this.divReset = this.instrCount;
                break;
            }
            case 5: {
                if (!this.timaEnabled) break;
                this.nextTimaOverflow = this.instrCount + this.instrsPerTima * (256 - (n2 & 0xFF));
                break;
            }
            case 7: {
                if ((n2 & 4) != 0) {
                    int n4 = this.INSTRS_PER_HBLANK * 154 * 60;
                    int n5 = n2 & 3;
                    switch (n5) {
                        case 0: {
                            this.instrsPerTima = n4 / 4096;
                            break;
                        }
                        case 1: {
                            this.instrsPerTima = n4 / 262144;
                            break;
                        }
                        case 2: {
                            this.instrsPerTima = n4 / 65536;
                            break;
                        }
                        case 3: {
                            this.instrsPerTima = n4 / 16384;
                        }
                    }
                    this.nextTimaOverflow = this.instrCount + this.instrsPerTima * (256 - this.registers[6]);
                    this.timaEnabled = true;
                    break;
                }
                this.timaEnabled = false;
                break;
            }
            case 15: {
                this.registers[15] = (byte)n2;
                this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                break;
            }
            case 26: {
                this.registers[n] = (byte)n2;
                if ((n2 & 0x80) != 0) break;
                this.registers[38] = (byte)(this.registers[38] & 0xFB);
                break;
            }
            case 64: {
                this.graphicsChip.bgEnabled = true;
                this.graphicsChip.lcdEnabled = (n2 & 0x80) != 0;
                this.graphicsChip.hiWinTileMapAddress = (n2 & 0x40) != 0;
                this.graphicsChip.winEnabled = (n2 & 0x20) != 0;
                this.graphicsChip.bgWindowDataSelect = (n2 & 0x10) != 0;
                this.graphicsChip.hiBgTileMapAddress = (n2 & 8) != 0;
                boolean bl = this.graphicsChip.doubledSprites = (n2 & 4) != 0;
                if ((n2 & 2) != 0) {
                    this.graphicsChip.spritesEnabled = true;
                    this.graphicsChip.spritesEnabledThisFrame = true;
                } else {
                    this.graphicsChip.spritesEnabled = false;
                }
                if ((n2 & 1) == 0) {
                    this.graphicsChip.spritePriorityEnabled = false;
                }
                this.registers[64] = (byte)n2;
                break;
            }
            case 65: {
                this.registers[65] = (byte)(n2 & 0xF8);
                break;
            }
            case 70: {
                System.arraycopy(this.memory[n2 >> 5], n2 << 8 & 0x1F00, this.oam, 0, 160);
                break;
            }
            case 71: {
                this.graphicsChip.decodePalette(0, n2);
                if (this.registers[71] == (byte)n2) break;
                this.registers[71] = (byte)n2;
                this.graphicsChip.invalidateAll(0);
                break;
            }
            case 72: {
                this.graphicsChip.decodePalette(4, n2);
                if (this.registers[72] == (byte)n2) break;
                this.registers[72] = (byte)n2;
                this.graphicsChip.invalidateAll(1);
                break;
            }
            case 73: {
                this.graphicsChip.decodePalette(8, n2);
                if (this.registers[73] == (byte)n2) break;
                this.registers[73] = (byte)n2;
                this.graphicsChip.invalidateAll(2);
                break;
            }
            case 74: {
                if ((n2 & 0xFF) >= 144) {
                    this.graphicsChip.stopWindowFromLine();
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 75: {
                if ((n2 & 0xFF) >= 167) {
                    this.graphicsChip.stopWindowFromLine();
                }
                this.registers[n] = (byte)n2;
                break;
            }
            case 79: {
                this.graphicsChip.setVRamBank(n2 & 1);
                this.registers[79] = (byte)n2;
                break;
            }
            case 85: {
                if (!this.hdmaRunning && (n2 & 0x80) == 0) {
                    int n6 = ((this.registers[81] & 0xFF) << 8) + (this.registers[82] & 0xF0);
                    int n7 = ((this.registers[83] & 0x1F) << 8) + (this.registers[84] & 0xF0);
                    int n8 = (n2 & 0x7F) * 16 + 16;
                    for (int i = 0; i < n8; ++i) {
                        this.graphicsChip.addressWrite(n7 + i, (byte)this.addressRead(n6 + i));
                    }
                    this.registers[85] = -1;
                    break;
                }
                if ((n2 & 0x80) != 0) {
                    this.hdmaRunning = true;
                    this.registers[85] = (byte)(n2 & 0x7F);
                    break;
                }
                this.hdmaRunning = false;
                this.registers[85] = (byte)(this.registers[85] | 0x80);
                break;
            }
            case 104: {
                this.registers[105] = (byte)this.graphicsChip.getGBCPalette(n2 & 0x3F);
                this.registers[104] = (byte)n2;
                break;
            }
            case 105: {
                this.graphicsChip.setGBCPalette(this.registers[104] & 0x3F, n2 & 0xFF);
                if (this.registers[104] >= 0) break;
                int n9 = this.registers[104] + 1 & 0x3F;
                this.registers[104] = (byte)(n9 + 128);
                this.registers[105] = (byte)this.graphicsChip.getGBCPalette(n9);
                break;
            }
            case 106: {
                this.registers[107] = (byte)this.graphicsChip.getGBCPalette((n2 & 0x3F) + 64);
                this.registers[106] = (byte)n2;
                break;
            }
            case 107: {
                this.graphicsChip.setGBCPalette((this.registers[106] & 0x3F) + 64, n2 & 0xFF);
                if (this.registers[106] >= 0) break;
                int n10 = this.registers[106] + 1 & 0x3F;
                this.registers[106] = (byte)(n10 + 128);
                this.registers[107] = (byte)this.graphicsChip.getGBCPalette(n10 + 64);
                break;
            }
            case 112: {
                this.gbcRamBank = (n2 & 7) < 2 ? 1 : n2 & 7;
                if (this.globalPC >= 49152) {
                    this.setPC(this.globalPC + this.localPC);
                }
                this.registers[112] = (byte)n2;
                break;
            }
            case 255: {
                this.registers[255] = (byte)n2;
                this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                break;
            }
            default: {
                this.registers[n] = (byte)n2;
            }
        }
    }

    private final void initCartridge() {
        InputStream inputStream = this.getClass().getResourceAsStream(this.cartName + '0');
        if (inputStream == null) {
            MeBoy.log("ERROR: The cart \"" + this.cartName + "\" does not exist.");
            throw new RuntimeException();
        }
        try {
            int n;
            byte[] byArray = new byte[8192];
            int n2 = 8192;
            while ((n2 -= inputStream.read(byArray, 8192 - n2, n2)) > 0) {
            }
            this.cartType = byArray[327] & 0xFF;
            int n3 = this.lookUpCartSize(byArray[328]);
            this.mainRam = new byte[32768];
            this.gbcRamBank = 1;
            if (n3 <= MeBoy.lazyLoadingThreshold) {
                this.rom = new byte[n3 * 2][8192];
                this.rom[0] = byArray;
                for (n = 1; n < n3 * 2; ++n) {
                    if ((n & 0xF) == 0) {
                        inputStream.close();
                        inputStream = this.getClass().getResourceAsStream(this.cartName + (n >> 4));
                    }
                    n2 = 8192;
                    while ((n2 -= inputStream.read(this.rom[n], 8192 - n2, n2)) > 0) {
                    }
                }
            } else {
                this.rom = new byte[n3 * 2][];
                this.rom[0] = byArray;
                this.rom[1] = new byte[8192];
                MeBoy.log("Partial loading active.");
                n2 = 8192;
                while ((n2 -= inputStream.read(this.rom[1], 8192 - n2, n2)) > 0) {
                }
                this.loadedRomBanks = 1;
                this.romBankQueue = new int[MeBoy.lazyLoadingThreshold];
            }
            inputStream.close();
            this.memory[0] = this.rom[0];
            this.memory[1] = this.rom[1];
            this.romTouch = new int[this.rom.length / 2];
            this.mapRom(1);
            n = this.getNumRAMBanks();
            MeBoy.log("Loaded '" + this.cartName + "'. " + n3 + " banks = " + n3 * 16 + " kB, " + n + " RAM banks.");
            MeBoy.log("Type: " + this.cartType + " (color)");
            if (this.cartType == 6 && n == 0) {
                n = 1;
            }
            this.cartRam = new byte[n][8192];
            if (n > 0) {
                this.memory[5] = this.cartRam[0];
            }
            this.lastRtcUpdate = (int)System.currentTimeMillis();
        }
        catch (Exception exception) {
            MeBoy.log("ERROR: Loading the cart \"" + this.cartName + "\" failed.");
            MeBoy.log(exception.toString());
            throw new RuntimeException();
        }
    }

    private final void mapRom(int n) {
        this.currentRomBank = n;
        this.romTouch[n] = this.instrCount;
        if (this.rom[n * 2] == null) {
            try {
                int n2;
                int n3;
                int n4;
                int n5;
                byte[][] byArrayArray = new byte[2][];
                if (this.loadedRomBanks >= MeBoy.lazyLoadingThreshold) {
                    n5 = 0;
                    n4 = Integer.MIN_VALUE;
                    int n6 = this.rom.length >> 1;
                    for (n3 = 1; n3 < n6; ++n3) {
                        if (this.rom[n3 * 2] == null || (n2 = this.instrCount - this.romTouch[n3]) <= n4) continue;
                        n4 = n2;
                        n5 = n3;
                    }
                    byArrayArray[0] = this.rom[n5 * 2];
                    byArrayArray[1] = this.rom[n5 * 2 + 1];
                    this.rom[n5 * 2] = null;
                    this.rom[n5 * 2 + 1] = null;
                } else {
                    byArrayArray[0] = new byte[8192];
                    byArrayArray[1] = new byte[8192];
                    this.romBankQueue[this.loadedRomBanks] = n;
                    ++this.loadedRomBanks;
                }
                n5 = n >> 3;
                n4 = (n & 7) * 16384;
                InputStream inputStream = this.getClass().getResourceAsStream(this.cartName + n5);
                if (inputStream.skip(n4) != (long)n4) {
                    throw new RuntimeException("failed skipping to " + n);
                }
                for (n3 = n * 2; n3 < n * 2 + 2; ++n3) {
                    n2 = 8192;
                    this.rom[n3] = byArrayArray[n3 & 1];
                    while ((n2 -= inputStream.read(this.rom[n3], 8192 - n2, n2)) > 0) {
                    }
                }
                inputStream.close();
            }
            catch (Exception exception) {
                MeBoy.log("ERROR: Lazy loading the cart \"" + this.cartName + "\" failed.");
                MeBoy.log(exception.toString());
                throw new RuntimeException();
            }
        }
        this.memory[2] = this.rom[n * 2];
        this.memory[3] = this.rom[n * 2 + 1];
        if ((this.globalPC & 0xC000) == 16384) {
            this.setPC(this.localPC + this.globalPC);
        }
    }

    private final void mapRam(int n) {
        this.currentRamBank = n;
        if (this.currentRamBank <= this.cartRam.length) {
            this.memory[5] = this.cartRam[n];
        }
    }

    private final void cartridgeWrite(int n, int n2) {
        int n3 = n >> 13;
        int n4 = n & 0x1FFF;
        switch (this.cartType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (n3 == 0) {
                    this.cartRamEnabled = (n2 & 0xF) == 10;
                    break;
                }
                if (n3 == 1) {
                    int n5 = n2 & 0x1F;
                    if (n5 == 0) {
                        n5 = 1;
                    }
                    this.mapRom(this.currentRomBank & 0x60 | n5);
                    break;
                }
                if (n3 == 2) {
                    if (this.mbc1LargeRamMode) {
                        this.mapRam(n2 & 3);
                        break;
                    }
                    this.mapRom(this.currentRomBank & 0x1F | (n2 & 3) << 5);
                    break;
                }
                if (n3 == 3) {
                    this.mbc1LargeRamMode = (n2 & 1) == 1;
                    break;
                }
                if (n3 != 5 || !this.cartRamEnabled) break;
                this.memory[n3][n4] = (byte)n2;
                break;
            }
            case 5: 
            case 6: {
                if (n3 == 1) {
                    if ((n & 0x100) != 0) {
                        int n6 = n2 & 0xF;
                        if (n6 == 0) {
                            n6 = 1;
                        }
                        this.mapRom(n6);
                        break;
                    }
                    this.cartRamEnabled = (n2 & 0xF) == 10;
                    break;
                }
                if (n3 != 5 || !this.cartRamEnabled) break;
                this.memory[n3][n4] = (byte)n2;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (n3 == 1) {
                    int n7 = n2 & 0x7F;
                    if (n7 == 0) {
                        n7 = 1;
                    }
                    this.mapRom(n7);
                    break;
                }
                if (n3 == 2) {
                    if (this.cartRam.length <= 0) break;
                    this.mapRam(n2);
                    break;
                }
                if (n3 != 5) break;
                if (this.currentRamBank >= 8) {
                    this.rtcSync();
                    this.rtcReg[this.currentRamBank - 8] = (byte)n2;
                    break;
                }
                this.memory[n3][n4] = (byte)n2;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                if (n >> 12 == 2) {
                    int n8 = this.currentRomBank & 0xFF00 | n2;
                    this.mapRom(n8);
                    break;
                }
                if (n >> 12 == 3) {
                    int n9 = this.currentRomBank & 0xFF | (n2 & 1) << 8;
                    this.mapRom(n9);
                    break;
                }
                if (n3 == 2) {
                    if (this.cartRam.length <= 0) break;
                    this.mapRam(n2 & 7);
                    break;
                }
                if (n3 != 5 || this.memory[5] == null) break;
                this.memory[n3][n4] = (byte)n2;
            }
        }
    }

    protected final void rtcSync() {
        if ((this.rtcReg[4] & 0x40) == 0) {
            int n = (int)System.currentTimeMillis();
            while (n - this.lastRtcUpdate > 1000) {
                this.lastRtcUpdate += 1000;
                this.rtcReg[0] = (byte)(this.rtcReg[0] + 1);
                if (this.rtcReg[0] != 60) continue;
                this.rtcReg[0] = 0;
                this.rtcReg[1] = (byte)(this.rtcReg[1] + 1);
                if (this.rtcReg[1] != 60) continue;
                this.rtcReg[1] = 0;
                this.rtcReg[2] = (byte)(this.rtcReg[2] + 1);
                if (this.rtcReg[2] != 24) continue;
                this.rtcReg[2] = 0;
                this.rtcReg[3] = (byte)(this.rtcReg[3] + 1);
                if (this.rtcReg[3] != 0) continue;
                this.rtcReg[4] = (byte)((this.rtcReg[4] | this.rtcReg[4] << 7) ^ 1);
            }
        }
    }

    public final void rtcSkip(int n) {
        int n2 = n + this.rtcReg[0];
        this.rtcReg[0] = (byte)(n2 % 60);
        if ((n2 /= 60) == 0) {
            return;
        }
        this.rtcReg[1] = (byte)((n2 += this.rtcReg[1]) % 60);
        if ((n2 /= 60) == 0) {
            return;
        }
        this.rtcReg[2] = (byte)((n2 += this.rtcReg[2]) % 24);
        if ((n2 /= 24) == 0) {
            return;
        }
        n2 = n2 + (this.rtcReg[3] & 0xFF) + ((this.rtcReg[4] & 1) << 8);
        this.rtcReg[3] = (byte)n2;
        if (n2 > 511) {
            this.rtcReg[4] = (byte)(this.rtcReg[4] | 0x80);
        }
        this.rtcReg[4] = (byte)((this.rtcReg[4] & 0xFE) + (n2 >> 8 & 1));
    }

    private final int getNumRAMBanks() {
        switch (this.rom[0][329]) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: 
            case 5: 
            case 6: {
                return 16;
            }
        }
        return 0;
    }

    private final int lookUpCartSize(int n) {
        if (n < 8) {
            return 2 << n;
        }
        if (n == 82) {
            return 72;
        }
        if (n == 83) {
            return 80;
        }
        if (n == 84) {
            return 96;
        }
        return -1;
    }

    public final boolean hasBattery() {
        return this.cartType == 3 || this.cartType == 9 || this.cartType == 27 || this.cartType == 30 || this.cartType == 6 || this.cartType == 16 || this.cartType == 19;
    }

    public void buttonDown(int n) {
        this.buttonState |= 1 << n;
        this.p10Requested = true;
    }

    public void buttonUp(int n) {
        this.buttonState &= 255 - (1 << n);
        this.p10Requested = true;
    }

    public void setScale(int n, int n2) {
        this.graphicsChip.setScale(n, n2);
    }

    public int getTileWidth() {
        return this.graphicsChip.tileWidth;
    }

    public int getTileHeight() {
        return this.graphicsChip.tileHeight;
    }

    public void setTranslation(int n, int n2) {
        this.graphicsChip.left = n;
        this.graphicsChip.top = n2;
    }

    public int getLastSkipCount() {
        return this.graphicsChip.lastSkipCount;
    }

    public void draw(Graphics graphics) {
        this.graphicsChip.draw(graphics);
    }

    public void terminate() {
        this.terminate = true;
    }

    public boolean isTerminated() {
        return this.terminate;
    }

    public byte[] getRtcReg() {
        return this.rtcReg;
    }

    public byte[][] getCartRam() {
        return this.cartRam;
    }

    public void releaseReferences() {
        this.incflags = null;
        this.decflags = null;
        this.rtcReg = null;
        this.romBankQueue = null;
        this.cartRam = null;
        this.rom = null;
        this.romTouch = null;
        this.cartName = null;
        this.graphicsChip = null;
        this.mainRam = null;
        this.screen = null;
        this.memory = null;
        this.decoderMemory = null;
        System.gc();
    }
}

