/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Enemy
extends Sprite {
    int speed;
    Trap[] fire;

    Enemy(int objectId, int x, int y, int w, int h, int hp, int eye_range, int speed) {
        super(objectId, x, y, hp * 3 / 2, eye_range);
        this.w = w;
        this.h = h;
        this.speed = speed;
        this.fire = new Trap[3];
    }

    void paint(Graphics g) {
        super.paint(g);
        this.drawFire(g);
    }

    void logic() {
        Object var1_1 = null;
        if (Engine._a1()) {
            return;
        }
        super.logic();
        switch (this.objectIndex) {
            case 2: {
                Enemy.AI_02(Game.getEngine().role, this);
                return;
            }
            case 3: {
                Enemy.AI_BOSS_01(Game.getEngine().role, this);
                return;
            }
            case 10: {
                Sprite.AI(Game.getEngine().role, this);
                break;
            }
            case 12: {
                Enemy.AI_12(Game.getEngine().role, this);
                return;
            }
            case 4: 
            case 11: {
                Sprite.AI_FLY(Game.getEngine().role, this);
                break;
            }
            case 9: {
                return;
            }
            case 5: {
                Enemy.AI_BOSS_02(Game.getEngine().role, this);
                return;
            }
            case 13: {
                Enemy.AI_13(Game.getEngine().role, this);
                return;
            }
            case 14: {
                Enemy.AI_14(Game.getEngine().role, this);
                return;
            }
            case 15: {
                Enemy.AI_15(Game.getEngine().role, this);
                return;
            }
            case 16: {
                Enemy.AI_BOSS_03(Game.getEngine().role, this);
                return;
            }
            case 17: {
                Enemy.AI_BOSS_04(Game.getEngine().role, this);
                if (Game.getEngine().bossIsDead) {
                    this.isDead = true;
                }
                return;
            }
            case 18: {
                Enemy.AI_BOSS_05(Game.getEngine().role, this);
                return;
            }
        }
        switch (this.curStatus) {
            case 0: {
                this.move(0, 2);
                break;
            }
            case 1: 
            case 8: {
                this.changeFrame(true);
                if (this.isFlyingEnemy() && this.curStatus == 8) {
                    this.y += this.isUp ? -this.speed : this.speed;
                }
                this.x += this.isLeft ? -this.speed : this.speed;
                break;
            }
            case 4: {
                if (!this.changeFrame(true)) break;
                this.setStatus(0);
                break;
            }
            case 6: {
                if (!this.changeFrame(false)) break;
                this.setStatus(0);
                break;
            }
            case 5: {
                if (this.actionIndex == -1) {
                    this.isDead = true;
                    break;
                }
                if (!this.changeFrame(false)) break;
                this.isDead = true;
                break;
            }
            case 9: {
                this.move(0, 10);
            }
        }
        this.fireLogic();
    }

    void enterStatus() {
        switch (this.curStatus) {
            case 6: {
                this.hp -= 30 / Engine.gameDifficulty;
            }
        }
    }

    void move(int stepX, int stepY) {
        Game.getEngine().getClass();
        int cellWidth = 16;
        Game.getEngine().getClass();
        int cellHeight = 16;
        if (stepY > 0) {
            if (this.canClimb(this.x, this.y + stepY)) {
                this.x = this.x / cellWidth * cellWidth + (cellWidth >> 1);
                if (this.curStatus == 7) {
                    this.y += stepY;
                } else {
                    this.setStatus(7);
                }
                return;
            }
            if (!this.canFall(this.x - (this.w >> 1), this.y + stepY) || !this.canFall(this.x + (this.w >> 1), this.y + stepY)) {
                this.y = (short)((this.y + stepY) / cellHeight * cellHeight);
                this.toStopStatus();
            } else {
                this.y += stepY;
                if (this.curStatus != 3) {
                    this.setStatus(9);
                }
            }
        } else if (stepY < 0) {
            if (this.canClimb(this.x, this.y + stepY - this.h)) {
                this.x = this.x / cellWidth * cellWidth + (cellWidth >> 1);
                if (this.curStatus == 7) {
                    this.y += stepY;
                } else {
                    this.setStatus(7);
                }
                return;
            }
            if (this.curStatus != 7) {
                this.y = !this.canUp(this.x - (this.w >> 1), this.y + stepY - this.h) || !this.canUp(this.x + (this.w >> 1), this.y + stepY - this.h) ? (int)((short)((this.y + stepY - this.h) / cellHeight * cellHeight + cellHeight + this.h)) : (this.y += stepY);
            }
        }
        if (stepX != 0) {
            if (this.isLeft) {
                if (!this.canRun(this.x - (this.w >> 1) - stepX, this.y - 2) || !this.canRun(this.x - (this.w >> 1) - stepX, this.y - this.h)) {
                    this.x = (short)((this.x - (this.w >> 1) - stepX) / cellWidth * cellWidth + cellWidth + (this.w >> 1));
                    this.toStopStatus();
                } else if (this.canFall(this.x - (this.w >> 1) - stepX, this.y + (this.h >> 1))) {
                    this.isLeft = this.x - this.startX > 0;
                } else {
                    this.x -= stepX;
                }
            } else if (!this.canRun(this.x + (this.w >> 1) + stepX, this.y - 2) || !this.canRun(this.x + (this.w >> 1) + stepX, this.y - this.h)) {
                this.x = (short)((this.x + (this.w >> 1) + stepX) / cellWidth * cellWidth - (this.w >> 1));
                this.toStopStatus();
            } else if (this.canFall(this.x + (this.w >> 1) + stepX, this.y + (this.h >> 1))) {
                this.isLeft = this.x - this.startX > 0;
            } else {
                this.x += stepX;
            }
        }
    }

    private static final void AI_ARCHER(Role role, Enemy enemy) {
        switch (enemy.curStatus) {
            case 4: {
                boolean bl = enemy.isLeft = enemy.x > role.x;
                if (enemy.frameIndex == 5) {
                    enemy.createFire(enemy.x, enemy.y, enemy.isLeft);
                    enemy.iCount = 0;
                }
                if (role.x <= enemy.startX + enemy.eye_range && role.x >= enemy.startX - enemy.eye_range && Math.abs(role.y - enemy.y) <= 10) break;
                enemy.setStatus(0);
                break;
            }
            case 6: {
                break;
            }
            default: {
                ++enemy.iCount;
                if (role.x >= enemy.startX + enemy.eye_range || role.x <= enemy.startX - enemy.eye_range || Math.abs(role.y - enemy.y) >= 10 || enemy.iCount <= 5) break;
                enemy.isLeft = enemy.x > role.x;
                enemy.iCount = 0;
                enemy.setStatus(4);
            }
        }
    }

    private final void createFire(int x, int y, boolean isLeft) {
        for (int i = 0; i < this.fire.length; ++i) {
            if (this.fire[i] != null) continue;
            this.fire[i] = new Trap(5, x, y, 8, isLeft);
            return;
        }
    }

    private final void fireLogic() {
        int length = this.fire.length;
        for (int i = 0; i < length; ++i) {
            if (this.fire[i] == null) continue;
            this.fire[i].logic();
            if (!this.fire[i].isDead) continue;
            this.fire[i] = null;
        }
    }

    private final void drawFire(Graphics g) {
        int length = this.fire.length;
        for (int i = 0; i < length; ++i) {
            if (this.fire[i] == null) continue;
            this.fire[i].paint(g);
        }
    }

    private final boolean isFlyingEnemy() {
        return this.objectIndex == 4 || this.objectIndex == 11;
    }

    private final boolean isMoveEnemy() {
        return this.objectIndex == 10;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void AI_02(Role role, Enemy enemy) {
        enemy.isLeft = enemy.x > role.x;
        switch (enemy.curStatus) {
            case 0: {
                enemy.changeFrame(true);
                if (!Sprite.inEyeRange(role, enemy, false)) return;
                enemy.setStatus(1);
                return;
            }
            case 1: {
                if (!enemy.changeFrame(false)) return;
                enemy.setStatus(13);
                return;
            }
            case 13: {
                enemy.changeFrame(true);
                if (!Sprite.inEyeRange(role, enemy, false)) {
                    enemy.setStatus(0);
                    return;
                }
                if (role.x <= enemy.startX + enemy.chase_range && role.x >= enemy.startX - enemy.chase_range) {
                    int n = Math.abs(role.y - enemy.y);
                    Game.getEngine().getClass();
                    if (n >= 16 + 2) {
                        if (Math.abs(role.x - enemy.x) >= 20) return;
                        if (role.y <= enemy.y - 50) return;
                        if (role.y >= enemy.y) return;
                        enemy.setStatus(11);
                        return;
                    }
                }
                enemy.setStatus(4);
                return;
            }
            case 8: {
                return;
            }
            case 4: {
                if (!enemy.changeFrame(false)) return;
                if (++enemy.attackIndex <= 10) return;
                enemy.attackIndex = 0;
                Engine engine = Game.getEngine();
                int n = enemy.x;
                int n2 = enemy.y;
                Game.getEngine().getClass();
                engine.createFire(35, n, n2 - 16 / 2, 6, enemy.isLeft);
                enemy.setStatus(13);
                return;
            }
            case 11: {
                if (!enemy.changeFrame(false)) return;
                Engine engine = Game.getEngine();
                int n = enemy.x;
                int n3 = enemy.y;
                Game.getEngine().getClass();
                engine.createFire(36, n, n3 - 16 / 2, -6, enemy.isLeft);
                enemy.setStatus(13);
                return;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    return;
                }
                if (!enemy.changeFrame(false)) return;
                enemy.setStatus(13);
                return;
            }
            case 5: {
                if (!enemy.changeFrame(false)) return;
                enemy.isDead = true;
                return;
            }
        }
    }

    public static final void AI_BOSS_01(Role role, Enemy enemy) {
        switch (enemy.curStatus) {
            case 0: {
                enemy.setStatus(1);
                break;
            }
            case 1: {
                enemy.changeFrame(true);
                if (Sprite.inEyeRange(role, enemy, true)) {
                    enemy.isLeft = enemy.x > role.x;
                    enemy.setStatus(8);
                } else if (enemy.x < enemy.startX - enemy.eye_range || enemy.x > enemy.startX + enemy.eye_range) {
                    enemy.isLeft = enemy.x > enemy.startX;
                }
                enemy.move(enemy.speed, 2);
                break;
            }
            case 8: {
                boolean bl = enemy.isLeft = enemy.x > role.x;
                if (!Sprite.inChaseRange(role, enemy)) {
                    enemy.setStatus(1);
                } else {
                    int distance = Math.abs(role.x - enemy.x);
                    Game.getEngine().getClass();
                    if (distance < 5 * 16) {
                        int n = role.w + enemy.w >> 1;
                        Game.getEngine().getClass();
                        if (distance > n + 16) {
                            if (++enemy.attackIndex > Text.attackSpeedBoss_0) {
                                enemy.setStatus(11);
                                return;
                            }
                        } else if (++enemy.attackIndex > Text.attackSpeedBoss_0 / 2) {
                            enemy.setStatus(4);
                            return;
                        }
                    }
                }
                int tempX = enemy.x;
                enemy.move(enemy.speed, 2);
                if (enemy.x != tempX) break;
                enemy.setStatus(1);
                break;
            }
            case 4: {
                boolean bl = enemy.isLeft = enemy.x > role.x;
                if (!enemy.changeFrame(false)) break;
                enemy.attackIndex = 0;
                if (Sprite.hit(enemy, role)) {
                    role.setStatus(6);
                }
                enemy.setStatus(8);
                break;
            }
            case 11: {
                boolean bl = enemy.isLeft = enemy.x > role.x;
                if (!enemy.changeFrame(false)) break;
                enemy.attackIndex = 0;
                Engine engine = Game.getEngine();
                int n = enemy.x;
                int n2 = enemy.y;
                Game.getEngine().getClass();
                engine.createFire(6, n, n2 - 16, 6, enemy.isLeft);
                enemy.setStatus(8);
                break;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    break;
                }
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(1);
                break;
            }
            case 5: {
                if (!enemy.changeFrame(false)) break;
                enemy.isDead = true;
            }
        }
    }

    public static final void AI_BOSS_02(Role role, Enemy enemy) {
        enemy.isLeft = enemy.x > role.x;
        switch (enemy.curStatus) {
            case 0: {
                if (!Sprite.inEyeRange(role, enemy, true) || ++enemy.attackIndex <= Text.attackSpeedBoss_1) break;
                int id = Math.abs(Engine.random.nextInt() % 3000);
                if (id < 1000) {
                    enemy.setStatus(11);
                    break;
                }
                if (id < 2000) {
                    enemy.setStatus(11);
                    break;
                }
                enemy.setStatus(12);
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                if (!enemy.changeFrame(false)) break;
                enemy.attackIndex = 0;
                enemy.getAttackSize();
                Game.getEngine().createFire(11, enemy.x, enemy.py, 6, enemy.isLeft);
                enemy.setStatus(0);
                break;
            }
            case 11: {
                if (!enemy.changeFrame(false)) break;
                enemy.getAttackSize();
                enemy.attackIndex = 0;
                Game.getEngine().createFire(7, enemy.x, enemy.py + enemy.ph, 6, enemy.isLeft);
                enemy.setStatus(0);
                break;
            }
            case 12: {
                if (!enemy.changeFrame(false)) break;
                enemy.attackIndex = 0;
                Game.getEngine().createFire(8, enemy.x, enemy.y - 90, 6, enemy.isLeft);
                enemy.setStatus(0);
                break;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    break;
                }
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(0);
                break;
            }
            case 5: {
                if (!enemy.changeFrame(false)) break;
                enemy.isDead = true;
                for (int i = 0; i < Game.getEngine().smallEnemy.length; ++i) {
                    Game.getEngine().smallEnemy[i] = null;
                }
                break;
            }
            default: {
                enemy.setStatus(0);
            }
        }
    }

    public static final void AI_BOSS_03(Role role, Enemy enemy) {
        enemy.isLeft = enemy.x > role.x;
        switch (enemy.curStatus) {
            case 0: {
                if (!Sprite.inEyeRange(role, enemy, false) || ++enemy.attackIndex <= Text.attackSpeedBoss_2) break;
                enemy.setStatus(4);
                break;
            }
            case 8: {
                break;
            }
            case 4: 
            case 12: 
            case 13: {
                if (!enemy.changeFrame(false)) break;
                enemy.attackIndex = 0;
                if (Sprite.hit(enemy, role)) {
                    role.setStatus(6);
                }
                enemy.setStatus(0);
                break;
            }
            case 11: {
                int n;
                if (!enemy.changeFrame(false)) break;
                enemy.getAttackSize();
                enemy.attackIndex = 0;
                Engine engine = Game.getEngine();
                int n2 = enemy.x;
                if (enemy.isLeft) {
                    MainCanvas.getGame();
                    n = MainCanvas.width;
                } else {
                    MainCanvas.getGame();
                    n = -MainCanvas.width;
                }
                engine.createFire(10, n2 + n, enemy.py + enemy.ph, 6, enemy.isLeft);
                enemy.setStatus(0);
                break;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    break;
                }
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(0);
                break;
            }
            case 5: {
                if (!enemy.changeFrame(false)) break;
                enemy.isDead = true;
                for (int i = 0; i < Game.getEngine().smallEnemy.length; ++i) {
                    Game.getEngine().smallEnemy[i] = null;
                }
                break;
            }
            default: {
                enemy.setStatus(0);
            }
        }
    }

    public static final void AI_BOSS_04(Role role, Enemy enemy) {
        switch (enemy.curStatus) {
            case 1: {
                if (enemy.x < enemy.startX - enemy.eye_range || enemy.x > enemy.startX + enemy.eye_range) {
                    enemy.isLeft = enemy.x > enemy.startX;
                }
                enemy.x = enemy.x + (enemy.isLeft ? -enemy.speed : enemy.speed);
                if (enemy.attackIndex++ <= Text.attackSpeedBoss_3) break;
                enemy.attackIndex = 0;
                if (!Engine.isPossible(50)) break;
                enemy.setStatus(4);
                break;
            }
            case 4: {
                if (!enemy.changeFrame(false)) break;
                Game.getEngine().createFire(19, enemy.x, enemy.y, 6, enemy.isLeft);
                enemy.attackIndex = 0;
                enemy.setStatus(0);
                break;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    break;
                }
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(0);
                break;
            }
            case 5: {
                if (!enemy.changeFrame(false)) break;
                enemy.isDead = true;
                for (int i = 0; i < Game.getEngine().smallEnemy.length; ++i) {
                    Game.getEngine().smallEnemy[i] = null;
                }
                break;
            }
            default: {
                enemy.setStatus(1);
            }
        }
    }

    public static final void AI_BOSS_05(Role role, Enemy enemy) {
        enemy.isLeft = enemy.x > role.x;
        switch (enemy.curStatus) {
            case 0: {
                if (!Sprite.inEyeRange(role, enemy, true) || ++enemy.attackIndex <= Text.attackSpeedBoss_4) break;
                enemy.setStatus(12);
                break;
            }
            case 4: {
                if (!enemy.changeFrame(false)) break;
                enemy.getAttackSize();
                enemy.attackIndex = 0;
                Game.getEngine().createFire(23, enemy.x + (enemy.isLeft ? -enemy.w / 2 : enemy.w / 2), enemy.py + enemy.ph, 6, enemy.isLeft);
                enemy.setStatus(0);
                break;
            }
            case 12: {
                if (!enemy.changeFrame(false)) break;
                enemy.getAttackSize();
                enemy.attackIndex = 0;
                Game.getEngine().createFire(21, enemy.x + (enemy.isLeft ? -enemy.w / 2 : enemy.w / 2), enemy.py + enemy.ph, 6, enemy.isLeft);
                enemy.setStatus(0);
                break;
            }
            case 11: {
                if (!enemy.changeFrame(false)) break;
                enemy.getAttackSize();
                enemy.attackIndex = 0;
                Game.getEngine().createFire(20, enemy.x + (enemy.isLeft ? enemy.w / 2 : -enemy.w / 2), enemy.py + enemy.ph, 6, enemy.isLeft);
                enemy.setStatus(0);
                break;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    break;
                }
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(0);
                break;
            }
            case 5: {
                if (!enemy.changeFrame(false)) break;
                enemy.isDead = true;
                for (int i = 0; i < Game.getEngine().smallEnemy.length; ++i) {
                    Game.getEngine().smallEnemy[i] = null;
                }
                break;
            }
            default: {
                enemy.setStatus(0);
            }
        }
    }

    public static final void AI_13(Role role, Enemy enemy) {
        enemy.isLeft = enemy.x > role.x;
        switch (enemy.curStatus) {
            case 0: {
                if (!Sprite.inEyeRange(role, enemy, true) || ++enemy.attackIndex <= 10 || !Engine.isPossible(60)) break;
                enemy.setStatus(4);
                break;
            }
            case 4: {
                if (!enemy.changeFrame(false)) break;
                enemy.getAttackSize();
                enemy.attackIndex = 0;
                Game.getEngine().createFire(23, enemy.x + (enemy.isLeft ? -enemy.w / 2 : enemy.w / 2), enemy.py + enemy.ph / 2 + 10, 6, enemy.isLeft);
                enemy.setStatus(0);
                break;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    break;
                }
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(0);
                break;
            }
            case 5: {
                if (!enemy.changeFrame(false)) break;
                enemy.isDead = true;
                for (int i = 0; i < Game.getEngine().smallEnemy.length; ++i) {
                    Game.getEngine().smallEnemy[i] = null;
                }
                break;
            }
            default: {
                enemy.setStatus(0);
            }
        }
    }

    public static final void AI_12(Role role, Enemy enemy) {
        enemy.isLeft = enemy.x > role.x;
        switch (enemy.curStatus) {
            case 0: {
                if (!Sprite.allAttackHit(enemy, role) || ++enemy.attackIndex <= 10 || !Engine.isPossible(60)) break;
                enemy.setStatus(4);
                break;
            }
            case 4: {
                if (!enemy.changeFrame(false)) break;
                role.setStatus(6);
                enemy.setStatus(0);
                break;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    break;
                }
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(0);
                break;
            }
            case 5: {
                if (!enemy.changeFrame(false)) break;
                enemy.isDead = true;
                for (int i = 0; i < Game.getEngine().smallEnemy.length; ++i) {
                    Game.getEngine().smallEnemy[i] = null;
                }
                break;
            }
            default: {
                enemy.setStatus(0);
            }
        }
    }

    public static final void AI_14(Role role, Enemy enemy) {
        switch (enemy.curStatus) {
            case 1: {
                if (Sprite.inEyeRange(role, enemy, false)) {
                    enemy.isLeft = enemy.x > role.x;
                    enemy.getAttackSize();
                    enemy.setStatus(8);
                } else {
                    enemy.checkFront();
                }
                enemy.x = enemy.isLeft ? (enemy.x -= enemy.speed) : (enemy.x += enemy.speed);
                enemy.changeFrame(true);
                break;
            }
            case 8: {
                enemy.isLeft = enemy.x > role.x;
                boolean bl = enemy.isUp = enemy.y > role.y;
                if (enemy.y - (enemy.h >> 1) < role.y && enemy.y - (enemy.h >> 1) > role.y - role.h || Sprite.hit(enemy, role)) {
                    enemy.setStatus(4);
                } else {
                    enemy.x = enemy.x + (enemy.isLeft ? -enemy.speed : enemy.speed);
                    enemy.y = enemy.y + (enemy.isUp ? -enemy.speed : enemy.speed);
                }
                enemy.changeFrame(true);
                break;
            }
            case 4: {
                if (!enemy.changeFrame(false)) break;
                enemy.getAttackSize();
                enemy.attackIndex = 0;
                Game.getEngine().createFire(23, enemy.x + (enemy.isLeft ? -enemy.w / 2 : enemy.w / 2), enemy.py + enemy.ph - 5, 6, enemy.isLeft);
                enemy.setStatus(0);
                if (!Sprite.hit(enemy, role)) break;
                role.setStatus(6);
                break;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    break;
                }
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(0);
                break;
            }
            case 5: {
                if (!enemy.changeFrame(false)) break;
                enemy.isDead = true;
                for (int i = 0; i < Game.getEngine().smallEnemy.length; ++i) {
                    Game.getEngine().smallEnemy[i] = null;
                }
                break;
            }
            default: {
                enemy.setStatus(1);
            }
        }
    }

    private final void checkFront() {
        if (this.x > this.startX + this.eye_range || this.x < this.startX - this.eye_range) {
            boolean bl = this.isLeft = this.x > this.startX;
        }
        if (this.x > this.startY + this.eye_range || this.y < this.startY - this.eye_range) {
            this.isUp = this.y > this.startY;
        }
    }

    public static final void AI_15(Role role, Enemy enemy) {
        switch (enemy.curStatus) {
            case 1: {
                if (Sprite.inEyeRange(role, enemy, true)) {
                    enemy.setStatus(8);
                } else {
                    enemy.checkFront();
                    enemy.move(enemy.speed, 2);
                }
                enemy.changeFrame(true);
                break;
            }
            case 8: {
                boolean bl = enemy.isLeft = enemy.x > role.x;
                if (Sprite.hit(enemy, role)) {
                    enemy.setStatus(4);
                } else {
                    enemy.move(enemy.speed, 2);
                }
                enemy.changeFrame(true);
                break;
            }
            case 4: {
                boolean bl = enemy.isLeft = enemy.x > role.x;
                if (!enemy.changeFrame(false)) break;
                role.setStatus(6);
                enemy.setStatus(0);
                break;
            }
            case 12: {
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(11);
                break;
            }
            case 11: {
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(0);
                break;
            }
            case 6: {
                if (enemy.hp <= 0) {
                    enemy.setStatus(5);
                    break;
                }
                if (!enemy.changeFrame(false)) break;
                enemy.setStatus(0);
                break;
            }
            case 5: {
                if (!enemy.changeFrame(false)) break;
                enemy.isDead = true;
                for (int i = 0; i < Game.getEngine().smallEnemy.length; ++i) {
                    Game.getEngine().smallEnemy[i] = null;
                }
                break;
            }
            default: {
                enemy.setStatus(1);
            }
        }
    }
}

