/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Sprite {
    boolean isUnDead;
    int x;
    int y;
    int w;
    int h;
    boolean isLeft;
    boolean isUp;
    boolean isDead;
    int hp;
    int objectIndex;
    public int onBoard;
    public static int SPEED_X = 4;
    public static final int FLY_SPEED_X = 8;
    public static final int[] SPEED_UP = new int[]{12, 12, 10, 8, 6, 4, 2};
    int attackIndex = 0;
    public int curStatus;
    public static final int ST_STAND = 0;
    public static final int ST_RUN = 1;
    public static final int ST_UP = 2;
    public static final int ST_DOWN = 3;
    public static final int ST_ATTACK = 4;
    public static final int ST_DEAD = 5;
    public static final int ST_INJURE = 6;
    public static final int ST_CLIMB = 7;
    public static final int ST_CHASE = 8;
    public static final int ST_DECLINE = 9;
    public static final int ST_SQUAT = 10;
    public static final int ST_ATTACK_SKILL = 11;
    public static final int ST_ATTACK_JUMP = 12;
    public static final int ST_TEMP = 13;
    public static final int ST_ATTACK_SPECIAL = 14;
    int frameIndex;
    int actionIndex;
    int startX;
    int startY;
    int eye_range;
    int chase_range;
    int px;
    int py;
    int pw;
    int ph;
    private int cellWidth;
    private int cellHeight;
    int iCount;
    private static final int JUMP_UP = 0;
    private static final int JUMP_DOWN = 1;
    private static final int RUN = 2;
    private static final int CLIMB = 3;
    private static final int DEAD = 4;
    private Trap stone;
    private Trap atStone;

    Sprite(int objectId, int x, int y, int hp, int eye_range) {
        Game.getEngine().getClass();
        this.cellWidth = 16;
        Game.getEngine().getClass();
        this.cellHeight = 16;
        this.objectIndex = objectId;
        this.x = x;
        this.y = y;
        this.hp = hp;
        this.eye_range = eye_range;
        this.chase_range = eye_range << 1;
        this.startX = x;
        this.startY = y;
        this.isLeft = false;
        this.isDead = false;
        this.setStatus(0);
        this.getSize();
        this.onBoard = -1;
        this.isUnDead = false;
    }

    void logic() {
        if (this.curStatus == 10) {
            this.setStatus(0);
        }
    }

    void getSize() {
    }

    void enterStatus() {
    }

    void paint(Graphics g) {
        Game.clip(g);
        if (this.actionIndex >= 0) {
            Tools.drawNpcItem(g, this.objectIndex, this.actionIndex, this.frameIndex, this.x, this.y, this.isLeft);
        }
        g.setColor(0xFF0000);
    }

    void setStatus(int status) {
        if (this.curStatus == status) {
            return;
        }
        switch (status) {
            case 6: {
                if (this.curStatus == 5 || this.isUnDead) {
                    return;
                }
                if (this != Game.getEngine().role || Game.getEngine().role.injureDelayIndex >= Role.INJURE_DELAY_FRAME) break;
                return;
            }
        }
        this.curStatus = status;
        this.getActionIndex(this.curStatus);
        this.enterStatus();
        this.iCount = 0;
    }

    boolean changeFrame(boolean isCycle) {
        if (++this.frameIndex >= Data.npcFrameLength[this.objectIndex][this.actionIndex]) {
            this.frameIndex = isCycle ? 0 : Data.npcFrameLength[this.objectIndex][this.actionIndex] - 1;
            return true;
        }
        return false;
    }

    void move(int stepX, int stepY) {
        Object var3_3 = null;
        if (Engine._a1()) {
            return;
        }
        if (stepX >= 8) {
            int cur = this.curStatus;
            int step = stepX >> 1;
            this.moveBase(step, stepY);
            if (cur == this.curStatus) {
                this.moveBase(stepX - step, stepY);
            }
        } else {
            this.moveBase(stepX, stepY);
        }
    }

    private void moveBase(int stepX, int stepY) {
        this.atStone = null;
        if (stepY > 0) {
            if (this.canClimb(this.x, this.y + stepY)) {
                this.x = this.x / this.cellWidth * this.cellWidth + (this.cellWidth >> 1);
                if (this.curStatus == 7) {
                    this.y += stepY;
                } else {
                    this.y = (short)((this.y + stepY) / this.cellHeight * this.cellHeight + this.h);
                    this.setStatus(7);
                }
                return;
            }
            if (this.onBoard < 0) {
                if (this.haveStone(this.x - (this.w >> 1) + 1, this.y + stepY) || this.haveStone(this.x + (this.w >> 1) - 1, this.y + stepY)) {
                    this.toStopStatus();
                } else if (!this.canFall(this.x - (this.w >> 1) + 1, this.y + stepY) || !this.canFall(this.x + (this.w >> 1) - 1, this.y + stepY)) {
                    this.y = (short)((this.y + stepY) / this.cellHeight * this.cellHeight);
                    this.toStopStatus();
                } else {
                    this.y += stepY;
                    if (this.curStatus != 3) {
                        this.setStatus(9);
                    }
                }
            }
        } else if (stepY < 0) {
            if (this.canClimb(this.x, this.y + stepY - this.h)) {
                this.x = this.x / this.cellWidth * this.cellWidth + (this.cellWidth >> 1);
                if (this.curStatus == 7) {
                    this.y += stepY;
                } else {
                    this.setStatus(7);
                }
                return;
            }
            if (this.curStatus != 7) {
                if (!this.canUp(this.x - (this.w >> 1) + 1, this.y + stepY - this.h) || !this.canUp(this.x + (this.w >> 1) - 1, this.y + stepY - this.h)) {
                    this.y = (short)((this.y + stepY - this.h) / this.cellHeight * this.cellHeight + this.cellHeight + this.h);
                    this.setStatus(9);
                } else {
                    this.y += stepY;
                }
            }
        }
        if (stepX != 0) {
            if (this.isLeft) {
                if (!this.canRun(this.x - (this.w >> 1) - stepX, this.y - 2) || !this.canRun(this.x - (this.w >> 1) - stepX, this.y - this.h)) {
                    this.x = (short)((this.x - (this.w >> 1) - stepX) / this.cellWidth * this.cellWidth + this.cellWidth + (this.w >> 1) + 1);
                } else if (this.atStone == null && (this.haveStone(this.x - (this.w >> 1) + 1 - stepX, this.y - 2) || this.haveStone(this.x - (this.w >> 1) - 1 - stepX, this.y - this.h))) {
                    if (this.stone != null) {
                        this.stone.getAttackSize();
                        int tempX = this.stone.px + this.stone.pw + (this.w >> 1);
                        if (this.canRun(tempX, this.y - 2) && this.canRun(tempX, this.y - this.h)) {
                            this.x = tempX;
                        }
                    }
                } else {
                    this.x -= stepX;
                }
            } else if (!this.canRun(this.x + (this.w >> 1) + stepX, this.y - 2) || !this.canRun(this.x + (this.w >> 1) + stepX, this.y - this.h)) {
                this.x = (short)((this.x + (this.w >> 1) + stepX) / this.cellWidth * this.cellWidth - (this.w >> 1) - 1);
            } else if (this.atStone == null && (this.haveStone(this.x + (this.w >> 1) + 1 + stepX, this.y - 2) || this.haveStone(this.x + (this.w >> 1) - 1 + stepX, this.y - this.h))) {
                if (this.stone != null) {
                    this.stone.getAttackSize();
                    int tempX = this.stone.px - (this.w >> 1);
                    if (this.canRun(tempX, this.y - 2) && this.canRun(tempX, this.y - this.h)) {
                        this.x = tempX;
                    }
                }
            } else {
                this.x += stepX;
            }
        }
    }

    private void getActionIndex(int status) {
        this.frameIndex = 0;
        this.actionIndex = Data.SPRITE_ACTION[this.objectIndex][status];
    }

    public static final void AI(Sprite role, Sprite enemy) {
        switch (enemy.curStatus) {
            case 0: {
                enemy.setStatus(1);
                break;
            }
            case 1: {
                if (enemy.x > enemy.startX + enemy.eye_range || enemy.x < enemy.startX - enemy.eye_range) {
                    enemy.isLeft = enemy.x > enemy.startX;
                    break;
                }
                if (role.x >= enemy.startX + enemy.eye_range || role.x <= enemy.startX - enemy.eye_range || Math.abs(role.y - enemy.y) >= 20) break;
                enemy.isLeft = enemy.x > role.x;
                enemy.setStatus(8);
                break;
            }
            case 8: {
                if (role.x > enemy.startX + enemy.eye_range || role.x < enemy.startX - enemy.eye_range || Math.abs(role.y - enemy.y) > 10) {
                    enemy.setStatus(1);
                    break;
                }
                boolean bl = enemy.isLeft = enemy.x - role.x > 0;
                if (!Sprite.hit(enemy, role)) break;
                enemy.setStatus(4);
                break;
            }
            case 4: {
                if (++enemy.attackIndex < 3 || !Sprite.hit(enemy, role) || enemy.frameIndex != 1) break;
                enemy.attackIndex = 0;
                role.setStatus(6);
                break;
            }
            case 6: {
                if (enemy.hp > 0) break;
                enemy.setStatus(5);
                break;
            }
        }
    }

    public static final void AI_A(Sprite role, Sprite enemy) {
        switch (enemy.curStatus) {
            case 0: {
                enemy.setStatus(1);
                break;
            }
            case 1: {
                if (enemy.x > enemy.startX + enemy.eye_range || enemy.x < enemy.startX - enemy.eye_range) {
                    enemy.isLeft = enemy.x > enemy.startX;
                    break;
                }
                if (role.x >= enemy.startX + enemy.eye_range || role.x <= enemy.startX - enemy.eye_range || Math.abs(role.y - enemy.y) >= 10) break;
                enemy.isLeft = enemy.x > role.x;
                enemy.setStatus(8);
                break;
            }
            case 8: {
                if (role.x > enemy.startX + enemy.chase_range || role.x < enemy.startX - enemy.chase_range || Math.abs(role.y - enemy.y) > 10) {
                    enemy.setStatus(1);
                    break;
                }
                boolean bl = enemy.isLeft = enemy.x - role.x > 0;
                if (!Sprite.hit(enemy, role)) break;
                enemy.setStatus(4);
                break;
            }
            case 4: {
                if (++enemy.attackIndex < 3 || !Sprite.hit(enemy, role) || enemy.frameIndex != 1) break;
                enemy.attackIndex = 0;
                role.setStatus(6);
                break;
            }
            case 6: {
                if (enemy.hp > 0) break;
                enemy.setStatus(5);
                break;
            }
        }
    }

    public static final void AI_FLY(Sprite role, Sprite enemy) {
        Game.getEngine().getClass();
        int offsetY = 16 - enemy.h / 2;
        switch (enemy.curStatus) {
            case 0: {
                enemy.isLeft = enemy.x - role.x > 0;
                boolean bl = enemy.isUp = enemy.y > role.y;
                if (Sprite.hit(enemy, role)) {
                    enemy.setStatus(4);
                    break;
                }
                enemy.setStatus(1);
                break;
            }
            case 1: {
                if (enemy.y > enemy.startY + enemy.eye_range || enemy.y < enemy.startY - enemy.eye_range) {
                    boolean bl = enemy.isUp = enemy.y > enemy.startY;
                }
                if (enemy.x > enemy.startX + enemy.eye_range || enemy.x < enemy.startX - enemy.eye_range) {
                    enemy.isLeft = enemy.x > enemy.startX;
                    break;
                }
                if (!Sprite.inEyeRange(role, enemy, false)) break;
                enemy.isLeft = enemy.x > role.x;
                enemy.isUp = enemy.y > role.y;
                enemy.setStatus(8);
                break;
            }
            case 8: {
                if (!Sprite.inEyeRange(role, enemy, false)) {
                    enemy.setStatus(1);
                    break;
                }
                enemy.isLeft = enemy.x - role.x > 0;
                boolean bl = enemy.isUp = enemy.y > role.y - offsetY;
                if (!Sprite.hit(enemy, role) || Math.abs(enemy.y - role.y + offsetY) >= 10) break;
                enemy.setStatus(4);
                break;
            }
            case 4: {
                if (++enemy.attackIndex < 10 || !Sprite.hit(enemy, role) || enemy.frameIndex != 1) break;
                enemy.attackIndex = 0;
                role.setStatus(6);
                break;
            }
            case 6: {
                if (enemy.hp > 0) break;
                enemy.setStatus(5);
                break;
            }
        }
    }

    public static final boolean hit(Sprite s1, Sprite s2) {
        s1.getAttackSize();
        s2.getSize();
        return Tools.hit(s1.px, s1.py, s1.pw, s1.ph, s2.x - (s2.w >> 1), s2.y - s2.h, s2.w, s2.h);
    }

    public static final boolean allAttackHit(Sprite s1, Sprite s2) {
        s1.getAttackSize();
        s2.getAttackSize();
        return Tools.hit(s1.px, s1.py, s1.pw, s1.ph, s2.px, s2.py, s2.pw, s2.ph);
    }

    protected boolean canRun(int x, int y) {
        try {
            MainCanvas.getGame();
            short[][] sArray = Game.getEngine().mapData;
            Game.getEngine().getClass();
            short[] sArray2 = sArray[y / 16];
            Game.getEngine().getClass();
            short id = sArray2[x / 16];
            if (id == -1 || Data.info[id] == -1) {
                return true;
            }
            byte value = Data.info[id];
            int temp = value >> 2 & 1;
            if (temp == 1) {
                return true;
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    protected boolean canFall(int x, int y) {
        try {
            MainCanvas.getGame();
            short[][] sArray = Game.getEngine().mapData;
            Game.getEngine().getClass();
            short[] sArray2 = sArray[y / 16];
            Game.getEngine().getClass();
            short id = sArray2[x / 16];
            if (id == -1 || Data.info[id] == -1) {
                return true;
            }
            byte value = Data.info[id];
            int temp = value >> 1 & 1;
            if (temp == 1) {
                return true;
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    protected boolean canUp(int x, int y) {
        try {
            MainCanvas.getGame();
            short[][] sArray = Game.getEngine().mapData;
            Game.getEngine().getClass();
            short[] sArray2 = sArray[y / 16];
            Game.getEngine().getClass();
            short id = sArray2[x / 16];
            if (id == -1 || Data.info[id] == -1) {
                return true;
            }
            byte value = Data.info[id];
            int temp = value >> 0 & 1;
            if (temp == 1) {
                return true;
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    protected boolean canClimb(int x, int y) {
        try {
            MainCanvas.getGame();
            short[][] sArray = Game.getEngine().mapData;
            Game.getEngine().getClass();
            short[] sArray2 = sArray[y / 16];
            Game.getEngine().getClass();
            short id = sArray2[x / 16];
            if (id == -1 || Data.info[id] == -1) {
                return false;
            }
            byte value = Data.info[id];
            int temp = value >> 3 & 1;
            if (temp == 1) {
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    protected boolean canDead(int x, int y) {
        try {
            MainCanvas.getGame();
            short[][] sArray = Game.getEngine().mapData;
            Game.getEngine().getClass();
            short[] sArray2 = sArray[y / 16];
            Game.getEngine().getClass();
            short id = sArray2[x / 16];
            if (id == -1 || Data.info[id] == -1) {
                return false;
            }
            byte value = Data.info[id];
            int temp = value >> 4 & 1;
            if (temp == 1) {
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    void toStopStatus() {
        if (this.curStatus == 3 || this.curStatus == 9) {
            this.setStatus(10);
        }
    }

    void getAttackSize() {
        this.pw = Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 2];
        this.ph = Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 3];
        if (Tools.isRight(this.objectIndex)) {
            if (!this.isLeft) {
                this.px = (short)(this.x + Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 0]);
                this.py = (short)(this.y + Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 1]);
            } else {
                this.px = (short)(this.x - Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 0] - this.pw);
                this.py = (short)(this.y + Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 1]);
            }
        } else if (this.isLeft) {
            this.px = (short)(this.x + Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 0]);
            this.py = (short)(this.y + Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 1]);
        } else {
            this.px = (short)(this.x - Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 0] - this.pw);
            this.py = (short)(this.y + Data.npcItemSize0[this.objectIndex][this.actionIndex][this.frameIndex * 4 + 1]);
        }
        Game.getEngine().getClass();
        this.py -= 16 >> 1;
    }

    protected static final void attackLogic(Sprite role, Sprite enemy) {
        if (role.frameIndex == 1 && enemy != null && Sprite.hit(role, enemy)) {
            enemy.setStatus(6);
        }
    }

    protected static final boolean isCancel(Sprite enemy) {
        block5: {
            block4: {
                if (enemy == null) {
                    return true;
                }
                int n = enemy.startX - enemy.eye_range;
                short s = Game.getEngine().leftTopX;
                MainCanvas.getGame();
                if (n > s + MainCanvas.width || enemy.startX + enemy.eye_range < Game.getEngine().leftTopX) break block4;
                int n2 = enemy.startY - enemy.eye_range;
                short s2 = Game.getEngine().leftTopY;
                MainCanvas.getGame();
                if (n2 <= s2 + MainCanvas.height && enemy.startY + enemy.eye_range >= Game.getEngine().leftTopY) break block5;
            }
            return true;
        }
        return false;
    }

    private final boolean haveStone(int x, int y) {
        this.stone = null;
        for (int i = 0; i < Game.getEngine().allItem.length; ++i) {
            Trap trap;
            if (Game.getEngine().allItem[i] == null || !Tools.isStand(Game.getEngine().allItem[i].objectIndex) || !this.haveStone(x, y, trap = Game.getEngine().allItem[i])) continue;
            return true;
        }
        Trap[] fire = Game.getEngine().fire;
        int length = fire.length;
        for (int i = 0; i < length; ++i) {
            if (fire[i] == null || !Tools.isStand(fire[i].objectIndex) || !this.haveStone(x, y, fire[i])) continue;
            return true;
        }
        return false;
    }

    private final boolean haveStone(int x, int y, Trap trap) {
        trap.getAttackSize();
        if (trap.objectIndex == 37 && (x > trap.px + trap.pw || x < trap.px || y > trap.py + trap.ph || y < trap.py)) {
            return false;
        }
        if (x > trap.px + trap.pw || x < trap.px || y - this.h > trap.py + trap.ph || y < trap.py) {
            return false;
        }
        if (this.y < trap.py) {
            this.y = trap.py;
            if (trap.objectIndex == 25) {
                int n = trap.py;
                Game.getEngine().getClass();
                this.y = n + 16;
            } else if (trap.objectIndex == 37) {
                this.y = trap.py + 6;
            }
        }
        if (trap.objectIndex != 25 && trap.objectIndex != 37) {
            this.stone = trap;
        }
        this.atStone = trap;
        return true;
    }

    public static final boolean inEyeRange(Sprite role, Sprite enemy, boolean verticalEqual) {
        boolean vertical;
        if (verticalEqual) {
            vertical = Math.abs(role.y - enemy.y) < 20;
        } else {
            boolean bl = vertical = role.y - enemy.y > -50 && role.y - enemy.y < 100;
        }
        return role.x < enemy.startX + enemy.eye_range && role.x > enemy.startX - enemy.eye_range && vertical;
    }

    public static final boolean inChaseRange(Role role, Enemy enemy) {
        return role.x < enemy.startX + enemy.chase_range && role.x > enemy.startX - enemy.chase_range && role.y - enemy.y > -50 && role.y - enemy.y < 100;
    }

    protected final boolean isInjuredReady() {
        return this.curStatus != 5 && !this.isDead && !this.isUnDead;
    }
}

