/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Tools {
    public static final boolean DEBUG = false;
    public static final boolean OPEN_SKIP_LEVEL = false;
    public static final int[][] word = new int[][]{{9, 8}, {5, 10}};
    static int clipX;
    static int clipY;
    static int clipW;
    static int clipH;
    static int curClipX;
    static int curClipY;
    static int curClipW;
    static int curClipH;
    public static final int MIRRO = -1;
    public static final int VERTICAL = -2;
    public static final int TRANS_180 = -3;
    public static final int IMG_GAME_UI = 16;
    public static final int IMG_NEW_GAME = 18;
    public static final int IMG_CONTINUE_GAME = 9;
    public static final int IMG_QUIT_GAME = 15;
    public static final int IMG_OPTION = 21;
    public static final int IMG_MORE_GAMES = 22;
    public static final int IMG_BACK_MAINMENU = 23;
    public static final int IMG_ABOUT = 5;
    public static final int IMG_HELP = 0;
    public static final int IMG_MENU_ITEM_BG = 3;
    public static final int IMG_BUTTON_LEFT = 19;
    public static final int IMG_BUTTON_RIGHT = 20;
    public static final int IMG_OPTION_SOUND = 14;
    public static final int IMG_OPTION_SOUND_ON = 12;
    public static final int IMG_OPTION_SOUND_OFF = 4;
    public static final int IMG_GOLD = 6;
    public static final int IMG_BUTTON_OK = 24;
    public static final int IMG_BUTTON_BACK = 25;
    public static final int IMG_BACKGROUND_FRAME = 26;
    public static Image[] otherImg;
    public static final int[] ID_IMG_MAIN_MENU;
    public static final int[] ID_IMG_PAUSE_MENU;
    public static final String[] fileName;

    public static boolean hit(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 + w1 > x2 && x1 < x2 + w2 && y1 < y2 + h2 && y1 + h1 > y2;
    }

    protected static final void drawColorStr(Graphics g, String menuText, int posx, int posy, int anchor, int color1, int color2) {
        g.setFont(MainCanvas.defaultFont);
        g.setColor(color2);
        g.drawString(menuText, posx, posy - 1, anchor);
        g.drawString(menuText, posx - 1, posy, anchor);
        g.drawString(menuText, posx, posy + 1, anchor);
        g.drawString(menuText, posx + 1, posy, anchor);
        g.setColor(color1);
        g.drawString(menuText, posx, posy, anchor);
    }

    public static final String[] get(String str, int width) {
        Font defaultFont = MainCanvas.defaultFont;
        StringBuffer buffer = new StringBuffer();
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                vec.addElement(buffer.toString());
                buffer.delete(0, buffer.length());
                continue;
            }
            buffer.append(ch);
            if (i != str.length() - 1) continue;
            vec.addElement(buffer.toString());
            buffer.delete(0, buffer.length());
        }
        int nowWidth = 0;
        Vector<String> result = new Vector<String>();
        int spaceW = defaultFont.charWidth(' ');
        for (int i = 0; i < vec.size(); ++i) {
            String s = (String)vec.elementAt(i);
            int w = defaultFont.stringWidth(s) + spaceW;
            if ((nowWidth += w) > width) {
                result.addElement(buffer.toString());
                nowWidth = w;
                buffer.delete(0, buffer.length());
            }
            buffer.append(s + " ");
            if (i != vec.size() - 1) continue;
            result.addElement(buffer.toString());
        }
        String[] back = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            back[i] = (String)result.elementAt(i);
        }
        return back;
    }

    public static final void drawCell(Graphics g, Image img, int index, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        short width = Data.nDrawPos[index][3];
        short height = Data.nDrawPos[index][4];
        short offsetX = Data.nDrawPos[index][1];
        short offsetY = Data.nDrawPos[index][2];
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public static final boolean inScreen(int x, int y) {
        short s = Game.getEngine().leftTopX;
        MainCanvas.getGame();
        if (x < s + MainCanvas.width && x > Game.getEngine().leftTopX) {
            short s2 = Game.getEngine().leftTopY;
            MainCanvas.getGame();
            if (y < s2 + MainCanvas.height && y > Game.getEngine().leftTopY) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isLogic(int x, int y) {
        short s = Game.getEngine().leftTopX;
        MainCanvas.getGame();
        int n = s + MainCanvas.width;
        MainCanvas.getGame();
        if (x < n + (MainCanvas.width >> 1)) {
            short s2 = Game.getEngine().leftTopX;
            MainCanvas.getGame();
            if (x > s2 - (MainCanvas.width >> 1)) {
                short s3 = Game.getEngine().leftTopY;
                MainCanvas.getGame();
                int n2 = s3 + MainCanvas.height;
                MainCanvas.getGame();
                if (y < n2 + (MainCanvas.height >> 1)) {
                    short s4 = Game.getEngine().leftTopY;
                    MainCanvas.getGame();
                    if (y > s4 - (MainCanvas.height >> 1)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static final boolean isRight(int objectId) {
        return objectId == 1 || objectId == 29 || objectId == 33 || objectId == 6 || objectId == 37 || objectId == 74;
    }

    public static final boolean isStand(int objectId) {
        return objectId == 0 || objectId == 24 || objectId == 37;
    }

    public static String[] readText(String fileName) {
        Vector<String> result = new Vector<String>();
        InputStream is = "".getClass().getResourceAsStream(fileName);
        String s = null;
        do {
            try {
                s = Tools.readLineUTF(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (s == null) continue;
            s.trim();
            if (s.length() <= 0) continue;
            result.addElement(s);
        } while (s != null);
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        is = null;
        String[] str = new String[result.size()];
        for (int i = 0; i < str.length; ++i) {
            str[i] = (String)result.elementAt(i);
        }
        return str;
    }

    public static String readLineUTF(InputStream is) throws IOException {
        try {
            int b = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = is.read()) != -1 && b != 10) {
                if (b == 13) continue;
                baos.write(b);
            }
            baos.close();
            byte[] data = baos.toByteArray();
            String str = data.length > 0 ? Tools.convertFromUTF8(data) : (b != -1 ? "" : null);
            baos = null;
            return str;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String convertFromUTF8(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            int len = data.length;
            byte[] newdata = new byte[len + 2];
            newdata[0] = (byte)(len >>> 8);
            newdata[1] = (byte)len;
            System.arraycopy(data, 0, newdata, 2, len);
            ByteArrayInputStream bis = new ByteArrayInputStream(newdata);
            DataInputStream dis = new DataInputStream(bis);
            return dis.readUTF();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void drawImage(Graphics g, Image image, int sX, int sY, int width, int height, int showX, int showY, int anchor, int type) {
        clipX = g.getClipX();
        clipY = g.getClipY();
        clipW = g.getClipWidth();
        clipH = g.getClipHeight();
        if (showX > clipX + clipW - 1 || showY > clipY + clipH - 1 || showX + width < clipX || showY + height < clipY) {
            return;
        }
        curClipX = Math.max(clipX, showX);
        curClipY = Math.max(clipY, showY);
        curClipW = Math.min(clipX + clipW - curClipX, showX + width - curClipX);
        curClipH = Math.min(clipY + clipH - curClipY, showY + height - curClipY);
        g.setClip(curClipX, curClipY, curClipW, curClipH);
        if (type == 0) {
            g.drawImage(image, showX - sX, showY - sY, anchor);
        } else if (type == 1) {
            g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), 6, showX - sY, showY - (image.getWidth() - sX - width), 0);
        } else if (type == 2) {
            g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), 3, showX - (image.getWidth() - sX - width), showY - (image.getHeight() - sY - height), 0);
        } else if (type == 3) {
            g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), 5, showX - (image.getHeight() - sY - height), showY - sX, 0);
        } else if (type == 4) {
            g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), 2, showX - (image.getWidth() - sX - width), showY - sY, 0);
        } else if (type == 5) {
            g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), 1, showX - sX, showY - (image.getHeight() - sY - height), 0);
        }
        g.setClip(clipX, clipY, clipW, clipH);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    static void showObj(Graphics g, Image[] drawImg, int x, int y, int i, int f, int j, short[][][][] obj, int type) {
        short[][] nDrawPos = Data.nDrawPos;
        int t = obj[i][f][j].length;
        int flag = 0;
        for (int k = 0; k < t; k += 3) {
            short xOff = obj[i][f][j][k + 1];
            short yOff = obj[i][f][j][k + 2];
            short no = obj[i][f][j][k];
            flag = nDrawPos[no].length < 6 ? 0 : nDrawPos[no][5];
            if (type != 0) {
                xOff = -xOff;
                if (flag == 0) {
                    flag = 4;
                } else if (flag == 4) {
                    flag = 0;
                }
            }
            if (drawImg[nDrawPos[no][0]] == null) {
                System.out.println("null:" + nDrawPos[no][0]);
                continue;
            }
            Tools.drawImage(g, drawImg[nDrawPos[no][0]], nDrawPos[no][1], nDrawPos[no][2], nDrawPos[no][3], nDrawPos[no][4], x + xOff - (nDrawPos[no][3] >> 1), y + yOff - (nDrawPos[no][4] >> 1), 0, flag);
        }
    }

    protected static final void drawNpcItem(Graphics g, int objectId, int actionId, int frameIndex, int posX, int posY, boolean isLeft) {
        if (objectId == 25) {
            isLeft = true;
        }
        if (Engine.gameLevel < 4) {
            Game.getEngine().getClass();
            posY -= 16 >> 1;
        }
        if (Tools.isRight(objectId)) {
            boolean bl = isLeft = !isLeft;
        }
        if (isLeft) {
            boolean type = false;
        } else {
            boolean type = true;
        }
        Tools.drawImageSplit(g, objectId, actionId, frameIndex, posX, posY, isLeft);
    }

    protected static final void drawObject(Graphics g, int objectId, int actionId, int frameIndex, int posX, int posY, boolean isLeft) {
        if (isLeft) {
            boolean type = false;
        } else {
            boolean type = true;
        }
        Tools.drawImageSplitObject(g, objectId, actionId, frameIndex, posX, posY, isLeft);
    }

    protected static final void drawImageSplit(Graphics g, int objectId, int actionId, int frameIndex, int posX, int posY, boolean isLeft) {
        try {
            int length = Data.npcItem[objectId][actionId][frameIndex].length / 3;
            for (int i = 0; i < length; ++i) {
                int tempY;
                int tempX;
                short ID = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 0];
                if (Data.allImage[ID] == null) continue;
                int offsetX = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 1];
                int offsetY = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 2];
                short tempW = Data.nDrawPos[ID][3];
                short tempH = Data.nDrawPos[ID][4];
                if (isLeft) {
                    if (Data.nDrawPos[ID].length == 6 && (Data.nDrawPos[ID][5] == 1 || Data.nDrawPos[ID][5] == 3)) {
                        tempX = posX + offsetX - (Data.nDrawPos[ID][4] >> 1);
                        tempY = posY + offsetY - (Data.nDrawPos[ID][3] >> 1);
                    } else {
                        tempX = posX + offsetX - (Data.nDrawPos[ID][3] >> 1);
                        tempY = posY + offsetY - (Data.nDrawPos[ID][4] >> 1);
                    }
                    g.drawImage(Data.allImage[ID], tempX - Game.getEngine().leftTopX, tempY - Game.getEngine().leftTopY, 0);
                    continue;
                }
                if (Data.nDrawPos[ID].length == 6 && (Data.nDrawPos[ID][5] == 1 || Data.nDrawPos[ID][5] == 3)) {
                    tempW = Data.nDrawPos[ID][4];
                    tempH = Data.nDrawPos[ID][3];
                    offsetX = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 1] - (Data.nDrawPos[ID][3] >> 1) + (Data.nDrawPos[ID][4] >> 1);
                    offsetY = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 2] + (Data.nDrawPos[ID][3] >> 1) - (Data.nDrawPos[ID][4] >> 1);
                    tempX = posX - offsetX - (Data.nDrawPos[ID][4] >> 1);
                    tempY = posY + offsetY - (Data.nDrawPos[ID][3] >> 1);
                } else {
                    tempX = posX - offsetX - (Data.nDrawPos[ID][3] >> 1);
                    tempY = posY + offsetY - (Data.nDrawPos[ID][4] >> 1);
                }
                try {
                    g.drawRegion(Data.allImage[ID], 0, 0, (int)tempW, (int)tempH, 2, tempX - Game.getEngine().leftTopX, tempY - Game.getEngine().leftTopY, 0);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
        }
    }

    protected static final void drawImageSplitObject(Graphics g, int objectId, int actionId, int frameIndex, int posX, int posY, boolean isLeft) {
        try {
            int length = Data.npcItem[objectId][actionId][frameIndex].length / 3;
            for (int i = 0; i < length; ++i) {
                int tempY;
                int tempX;
                short ID = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 0];
                if (Data.allImage[ID] == null) continue;
                int offsetX = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 1];
                int offsetY = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 2];
                short tempW = Data.nDrawPos[ID][3];
                short tempH = Data.nDrawPos[ID][4];
                if (isLeft) {
                    if (Data.nDrawPos[ID].length == 6 && (Data.nDrawPos[ID][5] == 1 || Data.nDrawPos[ID][5] == 3)) {
                        tempX = posX + offsetX - (Data.nDrawPos[ID][4] >> 1);
                        tempY = posY + offsetY - (Data.nDrawPos[ID][3] >> 1);
                    } else {
                        tempX = posX + offsetX - (Data.nDrawPos[ID][3] >> 1);
                        tempY = posY + offsetY - (Data.nDrawPos[ID][4] >> 1);
                    }
                    g.drawImage(Data.allImage[ID], tempX, tempY, 0);
                    continue;
                }
                if (Data.nDrawPos[ID].length == 6 && (Data.nDrawPos[ID][5] == 1 || Data.nDrawPos[ID][5] == 3)) {
                    tempW = Data.nDrawPos[ID][4];
                    tempH = Data.nDrawPos[ID][3];
                    offsetX = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 1] - (Data.nDrawPos[ID][3] >> 1) + (Data.nDrawPos[ID][4] >> 1);
                    offsetY = Data.npcItem[objectId][actionId][frameIndex][i * 3 + 2] + (Data.nDrawPos[ID][3] >> 1) - (Data.nDrawPos[ID][4] >> 1);
                    tempX = posX - offsetX - (Data.nDrawPos[ID][4] >> 1);
                    tempY = posY + offsetY - (Data.nDrawPos[ID][3] >> 1);
                } else {
                    tempX = posX - offsetX - (Data.nDrawPos[ID][3] >> 1);
                    tempY = posY + offsetY - (Data.nDrawPos[ID][4] >> 1);
                }
                try {
                    g.drawRegion(Data.allImage[ID], 0, 0, (int)tempW, (int)tempH, 2, tempX, tempY, 0);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void drawImage(Graphics g, Image img, int x, int y, int trans) {
        if (trans == -1) {
            trans = 2;
            g.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), trans, x, y, 0);
        } else if (trans == -2) {
            trans = 1;
            g.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), trans, x, y, 0);
        } else if (trans == -3) {
            trans = 3;
            g.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), trans, x, y, 0);
        }
    }

    public static final Image createImage(String str) {
        Image img = null;
        try {
            img = Image.createImage((String)str);
        }
        catch (IOException ex) {
            System.out.println("Load image error : " + str);
        }
        return img;
    }

    public static void loadOtherImage() {
        otherImg = new Image[fileName.length];
        for (int i = 0; i < fileName.length; ++i) {
            Tools.otherImg[i] = Tools.createImage("/ui/" + fileName[i].trim());
        }
    }

    public static void drawOther(Graphics g, int id, int x, int y) {
        g.drawImage(otherImg[id], x, y, 0);
    }

    public static void drawOtherCenter(Graphics g, int id, int x, int y) {
        g.drawImage(otherImg[id], x - (otherImg[id].getWidth() >> 1), y, 0);
    }

    public static final void fillMenuBg(Graphics g, int y) {
        Image img = otherImg[3];
        int cellW = img.getWidth();
        MainCanvas.getGame();
        int nums = MainCanvas.width / cellW + 1;
        for (int i = 0; i < nums; ++i) {
            g.drawImage(img, i * cellW, y, 0);
        }
    }

    static {
        ID_IMG_MAIN_MENU = new int[]{18, 9, 21, 22, 0, 5, 15};
        ID_IMG_PAUSE_MENU = new int[]{9, 21, 0, 23};
        fileName = new String[]{"bz.png", "di-1.png", "di-2.png", "di.png", "  guan.png", " gy.png", " jb-1.png", "         jb-2.png", "        jb-3.png", "       jxyx.png", "      jy.png", "     jz.png", "    kai.png", "   shou.png", "  shy.png", " tcyx.png", "ui.png", "         x.png", "        xyx.png", "       y-1.png", "      y-2.png", "     yxsz.png", "gd.png", "zcd.png", "ok.png", "back.png", "bian.png"};
    }
}

