/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.UTFDataFormatException;

public class DataSet {
    private int index;
    private byte[] bytes;

    public DataSet(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte readByte() {
        return this.bytes[this.index++];
    }

    public short readShort() {
        short value = this.bytes[this.index++];
        for (int i = 0; i < 1; ++i) {
            value = (short)(value << 8);
            value = (short)(value | this.bytes[this.index++] & 0xFF);
        }
        return value;
    }

    public int readInt() {
        int value = this.bytes[this.index++];
        for (int i = 0; i < 3; ++i) {
            value <<= 8;
            value |= this.bytes[this.index++] & 0xFF;
        }
        return value;
    }

    public String readString() throws IOException {
        int utflen = this.bytes[this.index++] & 0xFF;
        char[] str = new char[utflen];
        byte[] bytearr = new byte[utflen];
        int count = 0;
        int strlen = 0;
        System.arraycopy(this.bytes, this.index, bytearr, 0, utflen);
        this.index += utflen;
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str, 0, strlen);
    }

    public boolean readBoolean() {
        return this.bytes[this.index++] != 0;
    }

    public void skip(int len) {
        this.index += len;
    }

    public void writeByte(int value) {
        this.bytes[this.index++] = (byte)value;
    }

    public void writeInt(int value) {
        for (int i = 24; i >= 0; i -= 8) {
            this.bytes[this.index++] = (byte)(value >> i & 0xFF);
        }
    }

    public void writeString(String str) {
        byte[] strBytes = str.getBytes();
        int len = strBytes.length;
        this.bytes[this.index++] = (byte)len;
        System.arraycopy(strBytes, 0, this.bytes, this.index, len);
        this.index += len;
    }

    public void clear() {
        this.index = 0;
    }

    public void writeBoolean(boolean value) {
        this.bytes[this.index++] = (byte)(value ? 1 : 0);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int size() {
        return this.index;
    }

    public boolean ready() {
        return this.index < this.bytes.length;
    }
}

