/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris;

import de._3DTetris.EfgSort;
import de._3DTetris.GPunkt;
import de._3DTetris.GQuadrat;
import de._3DTetris.GWuerfel;
import de._3DTetris.GitterElement;
import de._3DTetris.Punkt3D;
import de._3DTetris.Vergleich;
import de._3DTetris.graphic.IColor;
import de._3DTetris.util._3DTetrisClassFactory;

public abstract class TetrisBlock
implements GitterElement {
    private GWuerfel[] m_Wuerfel;
    static /* synthetic */ Class class$de$_3DTetris$GQuadrat;

    protected void setKoerper(GPunkt[] indezes, IColor farbe) {
        this.m_Wuerfel = new GWuerfel[indezes.length];
        for (int i = 0; i < indezes.length; ++i) {
            this.m_Wuerfel[i] = new GWuerfel(indezes[i].ermBIndex(), indezes[i].ermLIndex(), indezes[i].ermHIndex(), farbe);
        }
    }

    public GQuadrat[] ermFlaechen() {
        Vergleich[] q = new GQuadrat[]{};
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            q = (GQuadrat[])EfgSort.sortieren(q, this.m_Wuerfel[i].ermFlaechen(), false, class$de$_3DTetris$GQuadrat == null ? TetrisBlock.class$("de._3DTetris.GQuadrat") : class$de$_3DTetris$GQuadrat);
        }
        return q;
    }

    public void ebenen(int anzahl) {
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            this.m_Wuerfel[i].ebenen(anzahl);
        }
    }

    public void zeilen(int anzahl) {
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            this.m_Wuerfel[i].zeilen(anzahl);
        }
    }

    public void spalten(int anzahl) {
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            this.m_Wuerfel[i].spalten(anzahl);
        }
    }

    public void zurueck() {
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            this.m_Wuerfel[i].zurueck();
        }
    }

    public void rotZ(Punkt3D mPunkt) {
        mPunkt = this.ermPunkt(3);
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            this.m_Wuerfel[i].rotZ(mPunkt);
        }
    }

    public void rotY(Punkt3D mPunkt) {
        mPunkt = this.ermPunkt(2);
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            this.m_Wuerfel[i].rotY(mPunkt);
        }
    }

    public void rotX(Punkt3D mPunkt) {
        mPunkt = this.ermPunkt(1);
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            this.m_Wuerfel[i].rotX(mPunkt);
        }
    }

    private Punkt3D ermPunkt(int status) {
        Punkt3D sPkt = this.berechneSchwerpunkt();
        switch (status) {
            case 1: {
                double[] koor = this.berechneNPunkt(sPkt.ermY(), sPkt.ermZ());
                sPkt.setPkt(sPkt.ermX(), koor[0], koor[1]);
                break;
            }
            case 2: {
                double[] koor = this.berechneNPunkt(sPkt.ermX(), sPkt.ermZ());
                sPkt.setPkt(koor[0], sPkt.ermY(), koor[1]);
                break;
            }
            case 3: {
                double[] koor = this.berechneNPunkt(sPkt.ermX(), sPkt.ermY());
                sPkt.setPkt(koor[0], koor[1], sPkt.ermZ());
                break;
            }
            default: {
                return null;
            }
        }
        return sPkt;
    }

    private Punkt3D berechneSchwerpunkt() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            x += (double)this.m_Wuerfel[i].ermBIndex();
            y += (double)this.m_Wuerfel[i].ermHIndex();
            z += (double)this.m_Wuerfel[i].ermLIndex();
        }
        return new Punkt3D(x / (double)this.m_Wuerfel.length, y / (double)this.m_Wuerfel.length, z / (double)this.m_Wuerfel.length);
    }

    private double[] berechneNPunkt(double koor1, double koor2) {
        double ganzZahl1 = koor1 - (double)((int)koor1) < 0.5 ? (double)((int)koor1) : (double)((int)koor1) + 1.0;
        double gebrZahl1 = (double)((int)koor1) + 0.5;
        double ganzZahl2 = koor2 - (double)((int)koor2) < 0.5 ? (double)((int)koor2) : (double)((int)koor2) + 1.0;
        double gebrZahl2 = (double)((int)koor2) + 0.5;
        double referenz = Math.sqrt(koor1 * koor1 + koor2 * koor2);
        double wertGanz = Math.sqrt(ganzZahl1 * ganzZahl1 + ganzZahl2 * ganzZahl2);
        double wertGebr = Math.sqrt(gebrZahl1 * gebrZahl1 + gebrZahl2 * gebrZahl2);
        double[] ret = new double[2];
        if (Math.abs(referenz - wertGanz) > Math.abs(referenz - wertGebr)) {
            ret[0] = gebrZahl1;
            ret[1] = gebrZahl2;
        } else {
            ret[0] = ganzZahl1;
            ret[1] = ganzZahl2;
        }
        return ret;
    }

    public GWuerfel[] ermWuerfel() {
        return this.m_Wuerfel;
    }

    public TetrisBlock copyBlock() {
        TetrisBlock tBlock;
        try {
            tBlock = (TetrisBlock)this.getClass().newInstance();
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
        tBlock.m_Wuerfel = new GWuerfel[this.m_Wuerfel.length];
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            tBlock.m_Wuerfel[i] = this.m_Wuerfel[i].copyWuerfel();
        }
        return tBlock;
    }

    public int[] ermEDim() {
        int[] minMax = new int[]{0, 0};
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            if (i == 0) {
                minMax[0] = minMax[1] = this.m_Wuerfel[i].ermHIndex();
            }
            if (minMax[0] > this.m_Wuerfel[i].ermHIndex()) {
                minMax[0] = this.m_Wuerfel[i].ermHIndex();
                continue;
            }
            if (minMax[1] >= this.m_Wuerfel[i].ermHIndex()) continue;
            minMax[1] = this.m_Wuerfel[i].ermHIndex();
        }
        return minMax;
    }

    public int[] ermZDim() {
        int[] minMax = new int[]{0, 0};
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            if (i == 0) {
                minMax[0] = minMax[1] = this.m_Wuerfel[i].ermLIndex();
            }
            if (minMax[0] > this.m_Wuerfel[i].ermLIndex()) {
                minMax[0] = this.m_Wuerfel[i].ermLIndex();
                continue;
            }
            if (minMax[1] >= this.m_Wuerfel[i].ermLIndex()) continue;
            minMax[1] = this.m_Wuerfel[i].ermLIndex();
        }
        return minMax;
    }

    public int[] ermSDim() {
        int[] minMax = new int[]{0, 0};
        for (int i = 0; i < this.m_Wuerfel.length; ++i) {
            if (i == 0) {
                minMax[0] = minMax[1] = this.m_Wuerfel[i].ermBIndex();
            }
            if (minMax[0] > this.m_Wuerfel[i].ermBIndex()) {
                minMax[0] = this.m_Wuerfel[i].ermBIndex();
                continue;
            }
            if (minMax[1] >= this.m_Wuerfel[i].ermBIndex()) continue;
            minMax[1] = this.m_Wuerfel[i].ermBIndex();
        }
        return minMax;
    }

    public GPunkt[] ermPunkte() {
        return null;
    }

    public IColor ermFarbe() {
        IColor black = _3DTetrisClassFactory.instanceColorClass();
        black.setRed(0);
        black.setGreen(0);
        black.setBlue(0);
        return black;
    }

    public int[] ermDim() {
        int[] dim = new int[]{0, 0, 0};
        return dim;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

