/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris;

import de._3DTetris.Beleuchtungsmodell;
import de._3DTetris.Bildpunkt;
import de._3DTetris.EfgSort;
import de._3DTetris.GLinie;
import de._3DTetris.GPunkt;
import de._3DTetris.GQuadrat;
import de._3DTetris.Gitter3D;
import de._3DTetris.GitterElement;
import de._3DTetris.Punkt3D;
import de._3DTetris.TetrisBlock;
import de._3DTetris.Vergleich;
import de._3DTetris.graphic.IGraphics;
import de._3DTetris.graphic.IPolygon;
import de._3DTetris.util._3DTetrisClassFactory;
import java.util.Vector;

public class TetrisSzene {
    private Gitter3D m_Gitter = null;
    private SzeneObjekt[] m_BgrL;
    private SzeneObjekt[] m_Flaechen;
    private SzeneObjekt[] m_ABlock;
    private GQuadrat[] m_BlockQuad = null;
    private SzeneObjekt[] m_SortObjekte;
    private SzeneObjekt[] m_All;
    private Beleuchtungsmodell m_BModell = new Beleuchtungsmodell();
    static /* synthetic */ Class class$de$_3DTetris$TetrisSzene$SzeneObjekt;

    public TetrisSzene() {
        this.m_BgrL = new SzeneObjekt[0];
        this.m_Flaechen = this.m_BgrL;
        this.m_ABlock = this.m_BgrL;
        this.m_SortObjekte = this.m_BgrL;
        this.m_All = this.m_BgrL;
    }

    public TetrisSzene(Gitter3D g) {
        this();
        this.m_Gitter = g;
    }

    public void setGitter(Gitter3D g) {
        this.m_Gitter = g;
    }

    public void nurBgrLinien() {
        this.m_All = this.m_BgrL;
    }

    public void setBgrL(Vector bgrL) {
        this.m_BgrL = new SzeneObjekt[bgrL.size()];
        for (int i = 0; i < bgrL.size(); ++i) {
            this.m_BgrL[i] = new SzeneLinie((GLinie)bgrL.elementAt(i));
            this.m_BgrL[i].berechnen();
        }
        this.m_BgrL = (SzeneObjekt[])EfgSort.sortieren(null, this.m_BgrL, true, class$de$_3DTetris$TetrisSzene$SzeneObjekt == null ? (class$de$_3DTetris$TetrisSzene$SzeneObjekt = TetrisSzene.class$("de._3DTetris.TetrisSzene$SzeneObjekt")) : class$de$_3DTetris$TetrisSzene$SzeneObjekt);
        this.m_SortObjekte = this.m_BgrL;
        this.m_All = this.m_BgrL;
    }

    public void setABlock(TetrisBlock block) {
        if (block == null) {
            return;
        }
        this.m_BlockQuad = block.ermFlaechen();
        this.m_ABlock = new SzeneObjekt[this.m_BlockQuad.length];
        for (int j = 0; j < this.m_BlockQuad.length; ++j) {
            this.m_ABlock[j] = new SzeneQuadrat(this.m_BlockQuad[j]);
            this.m_ABlock[j].berechnen();
        }
        this.m_All = (SzeneObjekt[])EfgSort.sortieren(this.m_SortObjekte, this.m_ABlock, true, class$de$_3DTetris$TetrisSzene$SzeneObjekt == null ? (class$de$_3DTetris$TetrisSzene$SzeneObjekt = TetrisSzene.class$("de._3DTetris.TetrisSzene$SzeneObjekt")) : class$de$_3DTetris$TetrisSzene$SzeneObjekt);
    }

    public void setFlaechen(GQuadrat[] q) {
        this.m_Flaechen = new SzeneObjekt[q.length];
        for (int j = 0; j < q.length; ++j) {
            this.m_Flaechen[j] = new SzeneQuadrat(q[j]);
            this.m_Flaechen[j].berechnen();
        }
        this.m_SortObjekte = (SzeneObjekt[])EfgSort.sortieren(this.m_BgrL, this.m_Flaechen, true, class$de$_3DTetris$TetrisSzene$SzeneObjekt == null ? (class$de$_3DTetris$TetrisSzene$SzeneObjekt = TetrisSzene.class$("de._3DTetris.TetrisSzene$SzeneObjekt")) : class$de$_3DTetris$TetrisSzene$SzeneObjekt);
        this.m_All = this.m_SortObjekte;
    }

    public void darstellen(IGraphics g) {
        for (int i = 0; i < this.m_All.length; ++i) {
            this.m_All[i].zeichnen(g);
        }
    }

    public final void neu() {
        int i;
        for (i = 0; i < this.m_BgrL.length; ++i) {
            this.m_BgrL[i].berechnen();
        }
        for (i = 0; i < this.m_Flaechen.length; ++i) {
            this.m_Flaechen[i].berechnen();
        }
        for (i = 0; i < this.m_ABlock.length; ++i) {
            this.m_ABlock[i].berechnen();
        }
        this.m_BgrL = (SzeneObjekt[])EfgSort.sortieren(null, this.m_BgrL, true, class$de$_3DTetris$TetrisSzene$SzeneObjekt == null ? (class$de$_3DTetris$TetrisSzene$SzeneObjekt = TetrisSzene.class$("de._3DTetris.TetrisSzene$SzeneObjekt")) : class$de$_3DTetris$TetrisSzene$SzeneObjekt);
        this.m_SortObjekte = (SzeneObjekt[])EfgSort.sortieren(this.m_BgrL, this.m_Flaechen, true, class$de$_3DTetris$TetrisSzene$SzeneObjekt == null ? (class$de$_3DTetris$TetrisSzene$SzeneObjekt = TetrisSzene.class$("de._3DTetris.TetrisSzene$SzeneObjekt")) : class$de$_3DTetris$TetrisSzene$SzeneObjekt);
        this.m_All = (SzeneObjekt[])EfgSort.sortieren(this.m_SortObjekte, this.m_ABlock, true, class$de$_3DTetris$TetrisSzene$SzeneObjekt == null ? (class$de$_3DTetris$TetrisSzene$SzeneObjekt = TetrisSzene.class$("de._3DTetris.TetrisSzene$SzeneObjekt")) : class$de$_3DTetris$TetrisSzene$SzeneObjekt);
    }

    public void blockSortieren() {
        for (int i = 0; i < this.m_ABlock.length; ++i) {
            this.m_ABlock[i].berechnen();
        }
        this.m_All = (SzeneObjekt[])EfgSort.sortieren(this.m_SortObjekte, this.m_ABlock, true, class$de$_3DTetris$TetrisSzene$SzeneObjekt == null ? (class$de$_3DTetris$TetrisSzene$SzeneObjekt = TetrisSzene.class$("de._3DTetris.TetrisSzene$SzeneObjekt")) : class$de$_3DTetris$TetrisSzene$SzeneObjekt);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SzeneQuadrat
    extends SzeneObjekt {
        Punkt3D m_Normale = new Punkt3D();

        public SzeneQuadrat(GQuadrat quadrat) {
            super(quadrat, TetrisSzene.this);
        }

        public void zeichnen(IGraphics g) {
            GPunkt[] gPkte = this.m_Elm.ermPunkte();
            Bildpunkt p1 = TetrisSzene.this.m_Gitter.ermPBild(gPkte[0]);
            Bildpunkt p2 = TetrisSzene.this.m_Gitter.ermPBild(gPkte[1]);
            Bildpunkt p3 = TetrisSzene.this.m_Gitter.ermPBild(gPkte[2]);
            Bildpunkt p4 = TetrisSzene.this.m_Gitter.ermPBild(gPkte[3]);
            int[] xPoints = new int[]{p1.ermX(), p2.ermX(), p3.ermX(), p4.ermX()};
            int[] yPoints = new int[]{p1.ermY(), p2.ermY(), p3.ermY(), p4.ermY()};
            IPolygon poly = _3DTetrisClassFactory.instancePolygonClass();
            poly.setXPoints(xPoints);
            poly.setYPoints(yPoints);
            poly.setCount(4);
            if (TetrisSzene.this.m_BModell.isRenderable()) {
                g.setColor(TetrisSzene.this.m_BModell.getOFFarbe(this.m_Elm.ermFarbe(), this.m_Normale));
                g.fillPolygon(poly);
            } else {
                g.setColor(this.m_Elm.ermFarbe());
                g.fillPolygon(poly);
                g.setBlockEdgeColor();
                g.drawPolygon(poly);
            }
        }

        public void berechnen() {
            super.berechnen();
            GPunkt[] pkt = this.m_Elm.ermPunkte();
            Punkt3D p1 = TetrisSzene.this.m_Gitter.ermP3D(pkt[0]);
            Punkt3D p2 = TetrisSzene.this.m_Gitter.ermP3D(pkt[1]);
            Punkt3D p3 = TetrisSzene.this.m_Gitter.ermP3D(pkt[2]);
            double x1 = p2.ermX() - p1.ermX();
            double y1 = p2.ermY() - p1.ermY();
            double z1 = p2.ermZ() - p1.ermZ();
            double x2 = p3.ermX() - p1.ermX();
            double y2 = p3.ermY() - p1.ermY();
            double z2 = p3.ermZ() - p1.ermZ();
            this.m_Normale.setPkt(y1 * z2 - z1 * y2, z1 * x2 - x1 * z2, x1 * y2 - y1 * x2);
        }
    }

    class SzeneLinie
    extends SzeneObjekt {
        public SzeneLinie(GLinie linie) {
            super(linie, TetrisSzene.this);
        }

        public void zeichnen(IGraphics g) {
            GPunkt[] pkte = this.m_Elm.ermPunkte();
            Bildpunkt p1 = TetrisSzene.this.m_Gitter.ermPBild(pkte[0]);
            Bildpunkt p2 = TetrisSzene.this.m_Gitter.ermPBild(pkte[1]);
            g.setGridLineColor();
            g.drawLine(p1.ermX(), p1.ermY(), p2.ermX(), p2.ermY());
        }
    }

    static class SzeneObjekt
    implements Vergleich {
        GitterElement m_Elm;
        Punkt3D m_PMittel = null;
        TetrisSzene m_TetrisSzene = null;

        public SzeneObjekt() {
        }

        public SzeneObjekt(GitterElement g, TetrisSzene tz) {
            this.m_Elm = g;
            this.m_TetrisSzene = tz;
        }

        public void berechnen() {
            int i;
            GPunkt[] pkte = this.m_Elm.ermPunkte();
            this.m_PMittel = this.m_TetrisSzene.m_Gitter.ermP3D(pkte[0]);
            if (pkte.length < 2) {
                return;
            }
            this.m_PMittel = Punkt3D.plus(this.m_PMittel, this.m_TetrisSzene.m_Gitter.ermP3D(pkte[1]));
            for (i = 2; i < pkte.length; ++i) {
                this.m_PMittel.plus(this.m_TetrisSzene.m_Gitter.ermP3D(pkte[i]));
            }
            this.m_PMittel.div(i);
        }

        public void zeichnen(IGraphics g) {
        }

        public short vergleichen(Vergleich element) {
            SzeneObjekt e2 = (SzeneObjekt)element;
            if (this.m_PMittel == null || e2.m_PMittel == null) {
                return -1;
            }
            if (this.m_PMittel.ermZ() == e2.m_PMittel.ermZ()) {
                return 0;
            }
            if (this.m_PMittel.ermZ() > e2.m_PMittel.ermZ()) {
                return 1;
            }
            if (this.m_PMittel.ermZ() < e2.m_PMittel.ermZ()) {
                return 2;
            }
            return -1;
        }

        public Vergleich[] createArray(int length) {
            return new SzeneObjekt[length];
        }
    }
}

