/*
 * Decompiled with CFR 0.152.
 */
public final class Item {
    public static final int TYPE_MENU = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_CHANGE_GFORM = 3;
    public static final int TYPE_IMAGE = 4;
    public static final int TYPE_SPRITE = 6;
    public static final int TYPE_ITEMS = 9;
    public static final int TYPE_SEPARATOR = 10;
    public static final int DATA_NONE = 0;
    public static final int DATA_ITEM = 1;
    public static final int DATA_IMAGE = 2;
    public static final int DATA_NUMBER = 3;
    public static final int DATA_STRING = 4;
    public static final int DATA_ARRAY_ITEM = 5;
    public static final int DATA_ARRAY_NUMBER = 6;
    public static final int DATA_ARRAY_STRING = 7;
    String[] messageTable = GMain.strings;
    short drawX;
    short drawY;
    short drawWidth;
    short drawHeight;
    final byte type;
    boolean active = true;
    boolean blockBackCmd;
    byte inputConstrain;
    short index;
    short offsetY = (short)3;
    short offsetX = 0;
    short label;
    Object data;
    int dataNumber;
    byte font;
    byte fontNormal = (byte)3;
    byte fontSelected = (byte)2;
    byte fontLabel = (byte)4;
    byte flags;
    byte dataType;
    public boolean multiLineMenuItem = false;
    public String[] multilineString;

    public Item(int n, int n2) {
        this.type = (byte)n;
        this.dataNumber = n2;
        this.dataType = (byte)3;
        this.label = (short)-1;
        this.setType(n);
    }

    public Item(int n, String string) {
        this.type = (byte)n;
        this.data = string;
        this.dataType = (byte)4;
        this.label = (short)-1;
        this.setType(n);
    }

    public Item(int n, PlatformImage platformImage) {
        this.type = (byte)n;
        this.data = platformImage;
        this.dataType = (byte)2;
        this.label = (short)-1;
        this.setType(n);
    }

    public Item(int n, int[] nArray) {
        this.type = (byte)n;
        this.data = nArray;
        this.dataType = (byte)6;
        this.label = (short)-1;
        this.setType(n);
    }

    public Item(int n, String[] stringArray) {
        this.type = (byte)n;
        this.data = stringArray;
        this.dataType = (byte)7;
        this.label = (short)-1;
        this.setType(n);
    }

    private void setType(int n) {
        switch (n) {
            case 0: 
            case 3: {
                this.font = (byte)3;
                break;
            }
            case 6: {
                this.font = (byte)4;
                break;
            }
            default: {
                this.font = (byte)4;
            }
        }
    }

    public void paint(PlatformGraphics platformGraphics, int n) {
        int n2 = 0;
        if (this.label != -1) {
            byte by = this.fontLabel;
            n2 = Fonts.getFontHeight(by) + 3;
            Fonts.drawGraphicString(by, this.messageTable[this.label], this.offsetX, this.offsetY, n);
            platformGraphics.translate(0, n2);
        }
        switch (this.type) {
            case 1: {
                String string = this.dataType == 4 ? (String)this.data : this.messageTable[this.dataNumber];
                Fonts.drawGraphicString(this.font, string, this.offsetX, this.offsetY, n);
                break;
            }
            case 0: 
            case 3: {
                if (this.dataType == 4) {
                    if (this.multiLineMenuItem) {
                        for (int i = 0; i < this.multilineString.length; ++i) {
                            Fonts.drawGraphicString(this.font, this.multilineString[i], this.offsetX, this.offsetY + i * Fonts.getFontHeight(this.font), n);
                        }
                        break;
                    }
                    Fonts.drawGraphicString(this.font, (String)this.data, this.offsetX, this.offsetY, n);
                    break;
                }
                if (this.dataType == 3) {
                    Fonts.drawGraphicString(this.font, this.messageTable[this.dataNumber], this.offsetX, this.offsetY, n);
                    break;
                }
                if (this.dataType == 1) {
                    ((Item)this.data).paint(platformGraphics, n);
                    break;
                }
                if (this.dataType == 2) {
                    platformGraphics.drawImage((PlatformImage)this.data, this.offsetX, this.offsetY, n);
                    break;
                }
                if (this.dataType == 7) {
                    String[] stringArray = (String[])this.data;
                    Fonts.drawGraphicString(this.font, stringArray[this.index], this.offsetX, this.offsetY, n);
                    break;
                }
                if (this.dataType == 5) {
                    Item[] itemArray = (Item[])this.data;
                    itemArray[this.index].paint(platformGraphics, n);
                    break;
                }
                if (this.dataType != 6) break;
                int[] nArray = (int[])this.data;
                Fonts.drawGraphicString(this.font, this.messageTable[nArray[this.index]], this.offsetX, this.offsetY, n);
                break;
            }
            case 4: {
                if (this.dataType != 2) break;
                PlatformImage platformImage = (PlatformImage)this.data;
                platformGraphics.drawImage(platformImage, this.offsetX, this.offsetY, n);
                break;
            }
            case 6: {
                Sprite sprite = (Sprite)this.data;
                int n3 = platformGraphics.getTranslateX();
                int n4 = platformGraphics.getTranslateY();
                platformGraphics.translate(-n3, -n4);
                sprite.paint(n3 + this.offsetX, n4 + this.offsetY - sprite.getSizeY());
                platformGraphics.translate(n3, n4);
                break;
            }
            case 9: {
                Item[] itemArray = (Item[])this.data;
                int n5 = platformGraphics.getTranslateX();
                for (int i = 0; i < itemArray.length; ++i) {
                    Item item = itemArray[i];
                    item.paint(platformGraphics, n);
                    platformGraphics.translate(item.getWidth(), 0);
                }
                platformGraphics.translate(n5 - platformGraphics.getTranslateX(), 0);
                break;
            }
            case 10: {
                int[] nArray = (int[])this.data;
                platformGraphics.setColor(nArray[1]);
                int n6 = 0;
                int n7 = nArray[0];
                if ((n & 8) != 0) {
                    n6 -= n7;
                } else if ((n & 1) != 0) {
                    n6 -= n7 >> 1;
                }
                platformGraphics.drawLine(n6, 0, n6 + n7, 0);
            }
        }
        if (this.type == 0 && (this.dataType == 1 || this.dataType == 5)) {
            return;
        }
        platformGraphics.translate(0, -n2);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = (short)n;
    }

    public boolean isActive() {
        return this.active && (this.type == 3 || this.type == 0 || this.type == 9);
    }

    public int getHeight() {
        int n = 0;
        if (this.label != -1) {
            n = Fonts.getFontHeight(this.font) + 3;
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 3: {
                if (this.dataType == 1) {
                    Item item = (Item)this.data;
                    return n + item.getHeight();
                }
                if (this.dataType == 5) {
                    Item[] itemArray = (Item[])this.data;
                    return n + itemArray[this.index].getHeight();
                }
                if (this.dataType == 2) {
                    PlatformImage platformImage = (PlatformImage)this.data;
                    return platformImage.getHeight();
                }
                if (this.multiLineMenuItem) {
                    return n + this.multilineString.length * Fonts.getFontHeight(this.font);
                }
                return n + Fonts.getFontHeight(this.font);
            }
            case 4: {
                if (this.dataType == 2) {
                    PlatformImage platformImage = (PlatformImage)this.data;
                    return platformImage.getHeight();
                }
            }
            case 6: {
                Sprite sprite = (Sprite)this.data;
                int n2 = sprite.getSizeY2() - sprite.getSizeY();
                return n + n2;
            }
            case 9: {
                int n3 = 0;
                Item[] itemArray = (Item[])this.data;
                for (int i = 0; i < itemArray.length; ++i) {
                    int n4 = itemArray[i].getHeight();
                    if (n4 <= n3) continue;
                    n3 = n4;
                }
                return n + n3;
            }
            case 10: {
                return 1;
            }
        }
        return n;
    }

    public int getWidth() {
        int n = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 3: {
                if (this.dataType == 4) {
                    n = Fonts.getStringWidth(this.font, (String)this.data);
                    break;
                }
                if (this.dataType == 7) {
                    String[] stringArray = (String[])this.data;
                    n = Fonts.getStringWidth(this.font, stringArray[this.index]);
                    break;
                }
                if (this.dataType == 1) {
                    Item item = (Item)this.data;
                    n = item.getWidth();
                    break;
                }
                if (this.dataType == 5) {
                    Item[] itemArray = (Item[])this.data;
                    n = itemArray[this.index].getWidth();
                    break;
                }
                if (this.dataType != 3) break;
                n = Fonts.getStringWidth(this.font, this.messageTable[this.dataNumber]);
                break;
            }
            case 4: {
                if (this.dataType != 2) break;
                PlatformImage platformImage = (PlatformImage)this.data;
                n += platformImage.getWidth();
                break;
            }
            case 9: {
                Item[] itemArray = (Item[])this.data;
                for (int i = 0; i < itemArray.length; ++i) {
                    n += itemArray[i].getWidth();
                }
                break;
            }
            case 10: {
                int[] nArray = (int[])this.data;
                n = nArray[0];
            }
        }
        if (this.label != -1) {
            n = Math.max(n, Fonts.getStringWidth(4, this.messageTable[this.label]));
        }
        return n;
    }
}

