/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class CNG_25D {
    private static final int HEAD_LENGTH = 12;
    private static final byte[] head = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 8, 3, 0, 0, 0};
    private static final byte[] tail = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private int bufType;
    private int plteLength;
    private byte[] cngFile;
    private Image[] bufferImage;
    private int screenWidth;
    private int screenHeight;
    public static CNG_25D cng;

    public CNG_25D(int n, InputStream inputStream, int n2, int n3) throws IOException {
        this.bufType = n;
        this.screenWidth = n2;
        this.screenHeight = n3;
        this.cngFile = CNG_25D.readData(inputStream);
        if (this.cngFile[0] > 0) {
            this.plteLength = this.cngFile[12 * this.cngFile[0] + 1] << 8 | this.cngFile[12 * this.cngFile[0] + 2] & 0xFF;
            if (n == 0) {
                this.bufferImage = new Image[this.cngFile[0]];
            }
        }
        cng = this;
    }

    public int getPngCount() {
        return this.cngFile[0];
    }

    public int getWidth(int n) {
        if (this.bufferImage[n] == null) {
            return this.cngFile[12 * n + 1];
        }
        return this.bufferImage[n].getWidth();
    }

    public int getHeight(int n) {
        if (this.bufferImage[n] == null) {
            return this.cngFile[12 * n + 2];
        }
        return this.bufferImage[n].getHeight();
    }

    public void removeImage(int n) {
        if (this.bufType == 0) {
            this.bufferImage[n] = null;
        }
    }

    public void addImage(int n) {
        if (this.bufType == 0) {
            this.bufferImage[n] = this.createPNG(n);
        }
    }

    public Image createPNG(int n) {
        int n2 = 12 * n + 1;
        int n3 = 0;
        int n4 = this.cngFile[n2 + 4] << 8 | this.cngFile[n2 + 5] & 0xFF;
        byte[] byArray = new byte[head.length + 4 + this.plteLength + n4 + tail.length];
        System.arraycopy(head, 0, byArray, n3, head.length);
        n3 = head.length;
        System.arraycopy(this.cngFile, n2 + 8, byArray, n3, 4);
        System.arraycopy(this.cngFile, 12 * this.cngFile[0] + 3, byArray, n3 += 4, this.plteLength);
        System.arraycopy(this.cngFile, this.cngFile[n2 + 2] << 8 | this.cngFile[n2 + 3] & 0xFF, byArray, n3 += this.plteLength, n4);
        System.arraycopy(tail, 0, byArray, n3 += n4, tail.length);
        byArray[19] = this.cngFile[n2];
        byArray[23] = this.cngFile[n2 + 1];
        return Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
    }

    public boolean partInRegion(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n >= this.cngFile[0]) {
            return false;
        }
        int n8 = 12 * n;
        byte by = this.cngFile[n8 + 7];
        byte by2 = this.cngFile[n8 + 8];
        return n2 + by <= n6 && n3 + by2 <= n7 && n2 + by + (this.cngFile[n8 + 1] & 0xFF) > n4 && n3 + by2 + (this.cngFile[n8 + 2] & 0xFF) > n5;
    }

    public boolean allInRegion(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 12 * n;
        byte by = this.cngFile[n8 + 7];
        byte by2 = this.cngFile[n8 + 8];
        return n2 + by > n4 && n3 + by2 > n5 && n2 + by + (this.cngFile[n8 + 1] & 0xFF) <= n6 && n3 + by2 + (this.cngFile[n8 + 2] & 0xFF) <= n7;
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl && !this.partInRegion(n, n2, n3, 0, 0, this.screenWidth, this.screenHeight)) {
            return;
        }
        Image image = this.bufType == 0 && this.bufferImage[n] != null ? this.bufferImage[n] : this.createPNG(n);
        if (bl) {
            int n5 = 12 * n;
            graphics.drawImage(image, n2 + this.cngFile[n5 + 7], n3 + this.cngFile[n5 + 8], n4);
        } else {
            graphics.drawImage(image, n2, n3, n4);
        }
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3) {
        try {
            this.drawImage(graphics, n, n2, n3, 20, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int memoryUse(byte by) {
        return (this.cngFile[12 * by + 1] & 0xFF) * (this.cngFile[12 * by + 2] & 0xFF) << 1;
    }

    private static byte[] readData(InputStream inputStream) throws IOException {
        byte[] byArray;
        int n = 4096;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2 + 1];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray2, n3, byArray2.length - n3)) != -1) {
            if ((n3 += n2) != byArray2.length) continue;
            byArray = new byte[byArray2.length + n];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
            byArray2 = byArray;
        }
        byArray = new byte[n3];
        System.arraycopy(byArray2, 0, byArray, 0, n3);
        return byArray;
    }
}

