/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class Pack {
    public static final byte[] F_PACK_MAGIC = new byte[]{10, 11, 12, 33};
    public static final byte[] F_NOPACK_MAGIC = new byte[]{10, 11, 12, 46};
    private byte[][] fileNameByte;
    private short[] fileSize;
    public int[] offStart;
    public byte[] data;
    private int infoBytes;
    private int fileCount;
    private int size;
    public boolean isHave;
    private static final int HEAD_SIZE = 12;

    public Pack(String string) {
        try {
            InputStream inputStream = "o".getClass().getResourceAsStream(string);
            this.loadPack(inputStream);
            inputStream.close();
            inputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadPack(InputStream inputStream) {
        if (inputStream != null) {
            try {
                byte[] byArray = new byte[4];
                inputStream.read(byArray);
                this.size = Game.byteToInt(byArray);
                inputStream.read(byArray);
                this.infoBytes = Game.byteToInt(byArray);
                inputStream.read(byArray);
                this.fileCount = Game.byteToInt(byArray);
                byte[] byArray2 = new byte[this.infoBytes];
                inputStream.read(byArray2);
                this.getPackInfo(byArray2);
                this.data = new byte[this.size - this.infoBytes - 12];
                inputStream.read(this.data);
                this.isHave = true;
            }
            catch (IOException iOException) {
                this.isHave = false;
                System.out.println("readData Error!");
            }
        }
    }

    public void free() {
        this.fileNameByte = null;
        this.fileSize = null;
        this.offStart = null;
        this.data = null;
        System.gc();
    }

    public Image loadImage(String string) {
        Image image = null;
        int n = this.getIndex(string);
        if (n == -1) {
            return null;
        }
        try {
            image = Image.createImage((byte[])this.data, (int)this.offStart[n], (int)this.fileSize[n]);
            return image;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String loadString(String string) {
        int n = this.getIndex(string);
        if (n == -1) {
            return null;
        }
        return Pack.toUTF(this.data, this.offStart[n], this.fileSize[n]);
    }

    public InputStream getInputStream(String string) {
        try {
            return new ByteArrayInputStream(this.getBytes(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] getBytes(String string) {
        int n = this.getIndex(string);
        byte[] byArray = new byte[this.fileSize[n]];
        System.arraycopy(this.data, this.offStart[n], byArray, 0, byArray.length);
        int n2 = 0;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray2 = new byte[4];
            byteArrayInputStream.read(byArray2);
            int n3 = 2;
            while (n3 >= 0) {
                if (byArray2[n3] != F_PACK_MAGIC[n3]) {
                    n2 = 1;
                }
                --n3;
            }
            if (n2 == 0 && byArray2[3] != F_PACK_MAGIC[3]) {
                n2 = byArray2[3] == F_NOPACK_MAGIC[3] ? 2 : 1;
            }
            if (n2 == 0) {
                this.undate(byteArrayInputStream, byteArrayOutputStream, 0, 1);
                byArray = byteArrayOutputStream.toByteArray();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public final int undate(ByteArrayInputStream byteArrayInputStream, ByteArrayOutputStream byteArrayOutputStream, int n, int n2) {
        int n3 = 4096;
        int n4 = 18;
        int n5 = 2;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        byte[] byArray = new byte[n3 + n4 - 1];
        int n13 = 0;
        if (n6 == 0) {
            n9 = n3 - n4;
            n7 = 0;
        }
        while (true) {
            if (n6 == 2 && n10 <= n11) {
                n8 = byArray[n12 + n10 & n3 - 1];
                byArray[n9++] = (byte)n8;
                byteArrayOutputStream.write((byte)n8);
                ++n;
                n9 &= n3 - 1;
                ++n10;
                ++n13;
                continue;
            }
            if (((n7 >>>= 1) & 0x100) == 0) {
                n8 = byteArrayInputStream.read();
                if (n8 == -1) break;
                n7 = n8 | 0xFF00;
            }
            if ((n7 & 1) == 1) {
                n8 = byteArrayInputStream.read();
                if (n8 == -1) break;
                byArray[n9++] = (byte)n8;
                n9 &= n3 - 1;
                byteArrayOutputStream.write((byte)n8);
                ++n;
                ++n13;
                n6 = 1;
                continue;
            }
            n12 = byteArrayInputStream.read();
            if (n12 == -1 || (n11 = byteArrayInputStream.read()) == -1) break;
            n12 |= (n11 & 0xF0) << 4;
            n11 = (n11 & 0xF) + n5;
            n10 = 0;
            n6 = 2;
        }
        if (n13 == 0) {
            return -1;
        }
        return n13;
    }

    public int getIndex(String string) {
        byte[] byArray = string.trim().getBytes();
        int n = 0;
        while (n < this.offStart.length) {
            if (this.compareFileName(n, byArray)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean compareFileName(int n, byte[] byArray) {
        if (byArray.length - 1 != this.fileNameByte[n].length) {
            return false;
        }
        int n2 = 1;
        while (n2 < byArray.length) {
            if (byArray[n2] != this.fileNameByte[n][n2 - 1]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void getPackInfo(byte[] byArray) {
        this.fileNameByte = new byte[this.fileCount][];
        this.offStart = new int[this.fileCount];
        this.fileSize = new short[this.fileCount];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < byArray.length) {
            if ((byArray[n5] == 13 || n5 == byArray.length - 1) && n5 - n - 4 > 0) {
                this.fileSize[n2] = (short)(byArray[n] << 24 | byArray[n + 1] << 16 | byArray[n + 2] << 8 | byArray[n + 3] & 0xFF);
                this.offStart[n2] = n3;
                n3 += this.fileSize[n2];
                n4 = n5 - n - 4;
                this.fileNameByte[n2] = new byte[n4];
                int n6 = 0;
                while (n6 < n4) {
                    this.fileNameByte[n2][n6] = byArray[n + 4 + n6];
                    ++n6;
                }
                n = n5 + 1;
                ++n2;
            }
            ++n5;
        }
    }

    public static String toUTF(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            try {
                char c;
                if ((byArray[n3 + n] & 0x80) != 0) {
                    if ((byArray[n3 + n] & 0x20) != 0) {
                        c = (char)((byArray[n3 + n] & 0xF) << 12);
                        c = (char)(c + ((char)(byArray[n3 + 1 + n] & 0x3F) << 6));
                        c = (char)(c + (byArray[n3 + 2 + n] & 0x3F));
                        n3 += 3;
                    } else {
                        c = (char)((byArray[n3 + n] & 0x1F) << 6);
                        c = (char)(c + (byArray[n3 + 1 + n] & 0x3F));
                        n3 += 2;
                    }
                } else {
                    c = (char)byArray[n3 + n];
                    ++n3;
                }
                cArray[n4++] = c;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new String(cArray, 1, n4);
    }
}

