/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteX {
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_ROT90 = 5;
    public static final byte TRANS_ROT180 = 3;
    public static final byte TRANS_ROT270 = 6;
    public static final byte TRANS_MIRROR = 2;
    public static final byte TRANS_MIRROR_ROT90 = 7;
    public static final byte TRANS_MIRROR_ROT180 = 1;
    public static final byte TRANS_MIRROR_ROT270 = 4;
    public static final byte ANTICLOCKWISE_90 = 0;
    public static final byte DEASIL_90 = 1;
    public static final byte HORIZONTAL = 2;
    public static final byte VERTICAL = 3;
    public static final byte DIRECTION_NONE = 0;
    public static final byte DIRECTION_UP = 1;
    public static final byte DIRECTION_DOWN = 2;
    public static final byte DIRECTION_LEFT = 3;
    public static final byte DIRECTION_RIGHT = 4;
    public static final byte FRAME_HEADER_SIZE = 8;
    public static final byte FRAME_TILE_COUNT_BIT = 1;
    public static final byte FRAME_COLLISION_COUNT_BIT = 2;
    public static final byte FRAME_REFERENCE_POINT_COUNT_BIT = 3;
    public static final byte FRAME_TOP_POS_BIT = 4;
    public static final byte FRAME_BOTTOM_POS_BIT = 5;
    public static final byte FRAME_LEFT_POS_BIT = 6;
    public static final byte FRAME_RIGHT_POS_BIT = 7;
    public static final byte ACTION_HEADER_SIZE = 4;
    public static final byte ACTION_SEQUENCE_LENGTH_BIT = 1;
    public static final byte ACTION_SEQUENCE_DELAY_BIT = 2;
    public static final byte ACTION_TRANSFORM_BIT = 3;
    public static final byte COLLISION_INTERSECT = 1;
    public static final byte COLLISION_INCLUSION = 2;
    public static final byte INVERTED_AXES = 4;
    public static final byte[][] TRANSFORM_TABLE;
    public static final byte[][] ROTATE_TABLE;
    short[][] actionData;
    byte actionCount;
    short[][] frameData;
    byte frameCount;
    short[][] tileData;
    short tileCount;
    byte actionIndex;
    byte sequenceIndex;
    Image image;
    Image[] tiles;
    boolean tileMode;
    int x;
    int y;
    boolean visible;
    long lastTime;
    boolean firstUpdate;
    boolean disableUpdate;
    int originOffsetX;
    int originOffsetY;

    static {
        byte[][] byArrayArray = new byte[8][];
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 1;
        byArray2[2] = 3;
        byArray2[3] = 2;
        byArray2[4] = 5;
        byArray2[5] = 4;
        byArray2[6] = 7;
        byArray2[7] = 6;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[0] = 2;
        byArray3[1] = 3;
        byArray3[3] = 1;
        byArray3[4] = 6;
        byArray3[5] = 7;
        byArray3[6] = 4;
        byArray3[7] = 5;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = 3;
        byArray4[1] = 2;
        byArray4[2] = 1;
        byArray4[4] = 7;
        byArray4[5] = 6;
        byArray4[6] = 5;
        byArray4[7] = 4;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[0] = 4;
        byArray5[1] = 6;
        byArray5[2] = 5;
        byArray5[3] = 7;
        byArray5[5] = 2;
        byArray5[6] = 1;
        byArray5[7] = 3;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[8];
        byArray6[0] = 5;
        byArray6[1] = 7;
        byArray6[2] = 4;
        byArray6[3] = 6;
        byArray6[4] = 1;
        byArray6[5] = 3;
        byArray6[7] = 2;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[8];
        byArray7[0] = 6;
        byArray7[1] = 4;
        byArray7[2] = 7;
        byArray7[3] = 5;
        byArray7[4] = 2;
        byArray7[6] = 3;
        byArray7[7] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[8];
        byArray8[0] = 7;
        byArray8[1] = 5;
        byArray8[2] = 6;
        byArray8[3] = 4;
        byArray8[4] = 3;
        byArray8[5] = 1;
        byArray8[6] = 2;
        byArrayArray[7] = byArray8;
        TRANSFORM_TABLE = byArrayArray;
        byte[][] byArrayArray2 = new byte[8][];
        byArrayArray2[0] = new byte[]{6, 5, 2, 1};
        byte[] byArray9 = new byte[4];
        byArray9[0] = 7;
        byArray9[1] = 4;
        byArray9[2] = 3;
        byArrayArray2[1] = byArray9;
        byte[] byArray10 = new byte[4];
        byArray10[0] = 4;
        byArray10[1] = 7;
        byArray10[3] = 3;
        byArrayArray2[2] = byArray10;
        byArrayArray2[3] = new byte[]{5, 6, 1, 2};
        byArrayArray2[4] = new byte[]{1, 2, 5, 6};
        byte[] byArray11 = new byte[4];
        byArray11[1] = 3;
        byArray11[2] = 4;
        byArray11[3] = 7;
        byArrayArray2[5] = byArray11;
        byte[] byArray12 = new byte[4];
        byArray12[0] = 3;
        byArray12[2] = 7;
        byArray12[3] = 4;
        byArrayArray2[6] = byArray12;
        byArrayArray2[7] = new byte[]{2, 1, 6, 5};
        ROTATE_TABLE = byArrayArray2;
    }

    public SpriteX(String spxName, Image image) {
        this.loadSpx(spxName, image);
    }

    public SpriteX(String spxName, Image[] tiles) {
        this.loadSpx(spxName, this.image);
        this.tiles = tiles;
        this.tileMode = true;
    }

    public SpriteX(String spxName, String imageName) {
        this.loadSpx(spxName, null);
        if (this.tileMode) {
            String name = null;
            String ext = null;
            int namelen = imageName.length();
            int i = namelen - 1;
            while (i >= 0) {
                char ch = imageName.charAt(i);
                if (ch == '.') {
                    ext = imageName.substring(i);
                    name = imageName.substring(0, i);
                    break;
                }
                --i;
            }
            if (ext == null) {
                name = imageName;
                ext = "";
            }
            this.tiles = new Image[this.tileCount];
            int i2 = 0;
            while (i2 < this.tileCount) {
                String fullName = String.valueOf(name) + i2 + ext;
                Image spximg = null;
                try {
                    spximg = Image.createImage((String)fullName);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.tiles[i2] = spximg;
                ++i2;
            }
            this.tiles = this.tiles;
        } else {
            Image spximg = null;
            try {
                spximg = Image.createImage((String)imageName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.loadSpx(spxName, spximg);
        }
    }

    public void loadSpx(String spxName, Image image) {
        try {
            short j;
            int offset;
            short length;
            short i;
            InputStream is = "".getClass().getResourceAsStream(spxName);
            DataInputStream data = new DataInputStream(is);
            data.readInt();
            byte version = data.readByte();
            byte byteSequence = data.readByte();
            if ((byteSequence & 2) != 0) {
                this.tileMode = true;
            }
            this.tileCount = (short)data.readInt();
            if (!this.tileMode) {
                this.tileData = new short[this.tileCount][4];
                i = 0;
                while (i < this.tileCount) {
                    this.tileData[i][0] = data.readShort();
                    this.tileData[i][1] = data.readShort();
                    this.tileData[i][2] = data.readShort();
                    this.tileData[i][3] = data.readShort();
                    i = (short)(i + 1);
                }
            }
            this.frameCount = (byte)data.readInt();
            this.frameData = new short[this.frameCount][];
            i = 0;
            while (i < this.frameCount) {
                short frameTileCount = (short)data.readInt();
                short collisionCount = (short)data.readInt();
                short referencePointCount = (short)data.readInt();
                length = (short)(8 + frameTileCount * 4 + collisionCount * 4 + referencePointCount * 2);
                this.frameData[i] = new short[length];
                this.frameData[i][0] = length;
                this.frameData[i][1] = frameTileCount;
                this.frameData[i][2] = collisionCount;
                this.frameData[i][3] = referencePointCount;
                this.frameData[i][4] = data.readShort();
                this.frameData[i][5] = data.readShort();
                this.frameData[i][6] = data.readShort();
                this.frameData[i][7] = data.readShort();
                offset = 8;
                j = 0;
                while (j < frameTileCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset = (short)(offset + 4);
                    j = (short)(j + 1);
                }
                j = 0;
                while (j < collisionCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset = (short)(offset + 4);
                    j = (short)(j + 1);
                }
                j = 0;
                while (j < referencePointCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    offset = (short)(offset + 2);
                    j = (short)(j + 1);
                }
                i = (short)(i + 1);
            }
            this.actionCount = (byte)data.readInt();
            this.actionData = new short[this.actionCount][];
            i = 0;
            while (i < this.actionCount) {
                short sequenceLength = (short)data.readInt();
                byte delay = data.readByte();
                length = delay == 1 ? (short)(4 + sequenceLength * 2) : (short)(4 + sequenceLength);
                this.actionData[i] = new short[length];
                this.actionData[i][0] = length;
                this.actionData[i][1] = sequenceLength;
                this.actionData[i][2] = delay;
                this.actionData[i][3] = (short)data.readInt();
                offset = 4;
                if (delay == 1) {
                    j = 0;
                    while (j < sequenceLength) {
                        this.actionData[i][offset] = data.readShort();
                        this.actionData[i][offset + 1] = data.readShort();
                        offset = (short)(offset + 2);
                        j = (short)(j + 1);
                    }
                } else {
                    j = 0;
                    while (j < sequenceLength) {
                        this.actionData[i][offset] = data.readShort();
                        offset = (short)(offset + 1);
                        j = (short)(j + 1);
                    }
                }
                i = (short)(i + 1);
            }
            this.setImage(image);
            this.visible = true;
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SpriteX(SpriteX spx) {
        int length;
        this.actionCount = spx.actionCount;
        this.frameCount = spx.frameCount;
        this.tileCount = spx.tileCount;
        this.actionData = new short[this.actionCount][];
        this.frameData = new short[this.frameCount][];
        this.tileData = new short[this.tileCount][];
        int i = 0;
        while (i < this.actionCount) {
            length = spx.actionData[i][0];
            this.actionData[i] = new short[length];
            System.arraycopy(spx.actionData[i], 0, this.actionData[i], 0, length);
            ++i;
        }
        i = 0;
        while (i < this.frameCount) {
            length = spx.frameData[i][0];
            this.frameData[i] = new short[length];
            System.arraycopy(spx.frameData[i], 0, this.frameData[i], 0, length);
            ++i;
        }
        i = 0;
        while (i < this.tileCount) {
            length = 4;
            this.tileData[i] = new short[length];
            System.arraycopy(spx.tileData[i], 0, this.tileData[i], 0, length);
            ++i;
        }
        this.actionIndex = spx.actionIndex;
        this.sequenceIndex = spx.sequenceIndex;
        this.image = spx.image;
        this.x = spx.x;
        this.y = spx.y;
        this.visible = spx.visible;
        this.lastTime = spx.lastTime;
        this.firstUpdate = spx.firstUpdate;
        this.disableUpdate = spx.disableUpdate;
    }

    public void enableUpdate(boolean enable) {
        if (this.disableUpdate && enable) {
            this.lastTime = System.currentTimeMillis();
        }
        this.disableUpdate = !enable;
    }

    public boolean isEnableUpdate() {
        return !this.disableUpdate;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getImage(int index) {
        return this.tiles[index];
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setAction(byte actionIndex) {
        if (actionIndex < 0 || actionIndex >= this.actionCount) {
            throw new IndexOutOfBoundsException();
        }
        this.actionIndex = actionIndex;
        this.sequenceIndex = 0;
        this.firstUpdate = false;
    }

    public int getAction() {
        return this.actionIndex;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    public void setFrame(byte sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.getSequenceLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = sequenceIndex;
        this.firstUpdate = false;
    }

    public int getFrame() {
        return this.sequenceIndex;
    }

    public void setTransform(byte transform) {
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        this.actionData[this.actionIndex][3] = transform;
    }

    public int getTransform() {
        return this.actionData[this.actionIndex][3];
    }

    public void deasilRotate90() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][1]);
    }

    void anticlockwiseRotate90() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][0]);
    }

    void horizontalMirror() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][2]);
    }

    void verticalMirror() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][3]);
    }

    public void nextFrame() {
        this.sequenceIndex = (byte)((this.sequenceIndex + 1) % this.getSequenceLength());
        this.firstUpdate = false;
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? (byte)(this.getSequenceLength() - 1) : (byte)(this.sequenceIndex - 1);
        this.firstUpdate = false;
    }

    public void update(long time) {
        if (!this.isEnableUpdate()) {
            return;
        }
        if (this.isDelay()) {
            int dms;
            if (!this.firstUpdate) {
                this.firstUpdate = true;
                this.lastTime = time;
            }
            if (time - this.lastTime >= (long)(dms = this.getDelayTime())) {
                this.nextFrame();
                this.lastTime = time;
            }
        }
    }

    public void update() {
        if (!this.isEnableUpdate()) {
            return;
        }
        this.update(System.currentTimeMillis());
    }

    public int getSequenceFrame(int sequenceIndex) {
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + sequenceIndex * 2];
        }
        return this.actionData[this.actionIndex][4 + sequenceIndex];
    }

    public int getSequenceFrame() {
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2];
        }
        return this.actionData[this.actionIndex][4 + this.sequenceIndex];
    }

    public int getSequenceLength() {
        return this.actionData[this.actionIndex][1];
    }

    public boolean isDelay() {
        return this.actionData[this.actionIndex][2] == 1;
    }

    public int getDelayTime() {
        return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2 + 1];
    }

    public int getReferencePointX(int index) {
        int frameIndex = this.getSequenceFrame();
        short frameTileCount = this.frameData[frameIndex][1];
        short frameCollisionCount = this.frameData[frameIndex][2];
        int offset = 8 + frameTileCount * 4 + frameCollisionCount * 4 + index * 2;
        short refX = this.frameData[frameIndex][offset];
        short refY = this.frameData[frameIndex][offset + 1];
        return this.getTransformedReferenceX(refX, refY, this.getTransform()) + this.x;
    }

    public int getReferencePointY(int index) {
        int frameIndex = this.getSequenceFrame();
        short frameTileCount = this.frameData[frameIndex][1];
        short frameCollisionCount = this.frameData[frameIndex][2];
        int offset = 8 + frameTileCount * 4 + frameCollisionCount * 4 + index * 2;
        short refX = this.frameData[frameIndex][offset];
        short refY = this.frameData[frameIndex][offset + 1];
        return this.getTransformedReferenceY(refX, refY, this.getTransform()) + this.y;
    }

    public int getReferencePointCount(int frameIndex) {
        if (frameIndex < 0 && frameIndex >= this.frameCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short frameReferencePointCount = this.frameData[frameIndex][3];
        return frameReferencePointCount;
    }

    public int getReferencePointCount() {
        int frameIndex = this.getSequenceFrame();
        return this.getReferencePointCount(frameIndex);
    }

    int getTransformedReferenceX(int x, int y, int transform) {
        int t_x = 0;
        switch (transform) {
            case 0: {
                t_x = x;
                break;
            }
            case 2: {
                t_x = -x;
            }
        }
        return t_x;
    }

    int getTransformedReferenceY(int x, int y, int transform) {
        int t_y = 0;
        switch (transform) {
            case 0: {
                t_y = y;
                break;
            }
            case 2: {
                t_y = y;
            }
        }
        return t_y;
    }

    public int getCollidesX(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4;
        return this.frameData[frame][offset] + this.x;
    }

    public int getCollidesY(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 1;
        return this.frameData[frame][offset] + this.y;
    }

    public int getCollidesWidth(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 2;
        return this.frameData[frame][offset];
    }

    public int getCollidesHeight(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 3;
        return this.frameData[frame][offset];
    }

    public int getCollidesX(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesX(frameIndex, index);
    }

    public int getCollidesY(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesY(frameIndex, index);
    }

    public int getCollidesWidth(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesWidth(frameIndex, index);
    }

    public int getCollidesHeight(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesHeight(frameIndex, index);
    }

    public int getCollidesCount(int index) {
        return this.frameData[index][2];
    }

    public int getCollidesCount() {
        return this.frameData[this.getSequenceFrame()][2];
    }

    public boolean collidesWith(SpriteX spx, int spxCollides, int thisCollides, int type) {
        if (!spx.visible || !this.visible) {
            return false;
        }
        int x = spx.getCollidesX(spxCollides);
        int y = spx.getCollidesY(spxCollides);
        int width = spx.getCollidesWidth(spxCollides);
        int height = spx.getCollidesHeight(spxCollides);
        return this.collidesWith(x, y, width, height, thisCollides, type);
    }

    public boolean collidesWith(Image image, int x, int y, int collides, int type) {
        return this.collidesWith(x, y, image.getWidth(), image.getHeight(), collides, type);
    }

    public boolean collidesWith(int x, int y, int width, int height, int collides, int type) {
        if (!this.visible) {
            return false;
        }
        int x1 = this.getCollidesX(collides);
        int y1 = this.getCollidesY(collides);
        int w1 = this.getCollidesWidth(collides);
        int h1 = this.getCollidesHeight(collides);
        if (type == 1) {
            return SpriteX.intersectRect(x1, y1, w1, h1, x, y, width, height);
        }
        if (type == 2) {
            return SpriteX.inclusionRect(x1, y1, w1, h1, x, y, width, height);
        }
        throw new ArithmeticException();
    }

    public boolean collidesWith(SpriteX spx) {
        if (!spx.visible || !this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0 || spx.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(spx, 0, 0, 1);
    }

    public boolean collidesWith(Image image, int x, int y) {
        if (!this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(image, x, y, 0, 1);
    }

    public boolean collidesWith(int x, int y, int width, int height) {
        if (!this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(x, y, width, height, 0, 1);
    }

    public static boolean intersectRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 + height2 >= y1 && y2 <= y1 + height1 && x2 + width2 >= x1 && x2 <= x1 + width1;
    }

    public static boolean inclusionRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 >= y1 && y2 + height2 <= y1 + height1 && x2 >= x1 && x2 + width2 <= x1 + width1;
    }

    public void originOffset(int x, int y) {
        this.originOffsetX = x;
        this.originOffsetY = y;
    }

    public int getFrameTopPos() {
        return this.frameData[this.getSequenceFrame()][4] + this.y;
    }

    public int getFrameBottomPos() {
        return this.frameData[this.getSequenceFrame()][5] + this.y;
    }

    public int getFrameLeftPos() {
        return this.frameData[this.getSequenceFrame()][6] + this.x;
    }

    public int getFrameRightPos() {
        return this.frameData[this.getSequenceFrame()][7] + this.x;
    }

    public int getFrameWidth() {
        return this.getFrameRightPos() - this.getFrameLeftPos();
    }

    public int getFrameHeight() {
        return this.getFrameBottomPos() - this.getFrameTopPos();
    }

    public void paint(Graphics g) {
        this.paint(g, this.x, this.y);
    }

    public void paint(Graphics g, int x, int y) {
        block33: {
            if (g == null) {
                throw new NullPointerException();
            }
            if (!this.visible) break block33;
            x -= this.originOffsetX;
            y -= this.originOffsetY;
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            int actionTransform = this.getTransform();
            if (actionTransform == 0) {
                int frameIndex = this.getSequenceFrame();
                int tileCount = this.frameData[frameIndex][1];
                int offset = 8;
                int i = 0;
                while (i < tileCount) {
                    int th;
                    int tw;
                    short ty;
                    short tx;
                    short transform;
                    int dy;
                    int dx;
                    short tileIndex;
                    if (this.tileMode) {
                        tileIndex = this.frameData[frameIndex][0 + offset];
                        dx = this.frameData[frameIndex][1 + offset] + x;
                        dy = this.frameData[frameIndex][2 + offset] + y;
                        transform = this.frameData[frameIndex][3 + offset];
                        tx = 0;
                        ty = 0;
                        tw = this.tiles[tileIndex].getWidth();
                        if (SpriteX.intersectRect(dx, dy, tw, th = this.tiles[tileIndex].getHeight(), clipX, clipY, clipWidth, clipHeight)) {
                            SpriteX.drawRegion(g, this.tiles[tileIndex], tx, ty, tw, th, transform, dx, dy, 20);
                        }
                    } else {
                        tileIndex = this.frameData[frameIndex][0 + offset];
                        dx = this.frameData[frameIndex][1 + offset] + x;
                        dy = this.frameData[frameIndex][2 + offset] + y;
                        transform = this.frameData[frameIndex][3 + offset];
                        tx = this.tileData[tileIndex][0];
                        ty = this.tileData[tileIndex][1];
                        tw = this.tileData[tileIndex][2];
                        th = this.tileData[tileIndex][3];
                        if (SpriteX.intersectRect(dx, dy, tw, th, clipX, clipY, clipWidth, clipHeight)) {
                            SpriteX.drawRegion(g, this.image, tx, ty, tw, th, transform, dx, dy, 20);
                        }
                    }
                    offset += 4;
                    ++i;
                }
            } else {
                int frameIndex = this.getSequenceFrame();
                int tileCount = this.frameData[frameIndex][1];
                int offset = 8;
                int i = 0;
                while (i < tileCount) {
                    int cy;
                    int cx;
                    int th;
                    int tw;
                    short ty;
                    short tx;
                    short transform;
                    int dy;
                    int dx;
                    short tileIndex;
                    if (this.tileMode) {
                        tileIndex = this.frameData[frameIndex][0 + offset];
                        dx = this.frameData[frameIndex][1 + offset] + x;
                        dy = this.frameData[frameIndex][2 + offset] + y;
                        transform = this.frameData[frameIndex][3 + offset];
                        tx = 0;
                        ty = 0;
                        tw = this.tiles[tileIndex].getWidth();
                        th = this.tiles[tileIndex].getHeight();
                        cx = x - dx;
                        cy = y - dy;
                        transform = TRANSFORM_TABLE[transform][actionTransform];
                        switch (actionTransform) {
                            case 0: {
                                break;
                            }
                            case 5: {
                                dx = x - (th - cy);
                                dy = y - cx;
                                break;
                            }
                            case 3: {
                                dx = x - (tw - cx);
                                dy = y - (th - cy);
                                break;
                            }
                            case 6: {
                                dx = x - cy;
                                dy = y - (tw - cx);
                                break;
                            }
                            case 2: {
                                dx = x - (tw - cx);
                                break;
                            }
                            case 7: {
                                dx = x - (th - cy);
                                dy = y - (tw - cx);
                                break;
                            }
                            case 1: {
                                dy = y - (th - cy);
                                break;
                            }
                            case 4: {
                                dx = x - cy;
                                dy = y - cx;
                            }
                        }
                        if (SpriteX.intersectRect(dx, dy, tw, th, clipX, clipY, clipWidth, clipHeight)) {
                            SpriteX.drawRegion(g, this.tiles[tileIndex], tx, ty, tw, th, transform, dx, dy, 20);
                        }
                        offset += 4;
                    } else {
                        tileIndex = this.frameData[frameIndex][0 + offset];
                        dx = this.frameData[frameIndex][1 + offset] + x;
                        dy = this.frameData[frameIndex][2 + offset] + y;
                        transform = this.frameData[frameIndex][3 + offset];
                        tx = this.tileData[tileIndex][0];
                        ty = this.tileData[tileIndex][1];
                        tw = this.tileData[tileIndex][2];
                        th = this.tileData[tileIndex][3];
                        cx = x - dx;
                        cy = y - dy;
                        transform = TRANSFORM_TABLE[transform][actionTransform];
                        switch (actionTransform) {
                            case 0: {
                                break;
                            }
                            case 5: {
                                dx = x - (th - cy);
                                dy = y - cx;
                                break;
                            }
                            case 3: {
                                dx = x - (tw - cx);
                                dy = y - (th - cy);
                                break;
                            }
                            case 6: {
                                dx = x - cy;
                                dy = y - (tw - cx);
                                break;
                            }
                            case 2: {
                                dx = x - (tw - cx);
                                break;
                            }
                            case 7: {
                                dx = x - (th - cy);
                                dy = y - (tw - cx);
                                break;
                            }
                            case 1: {
                                dy = y - (th - cy);
                                break;
                            }
                            case 4: {
                                dx = x - cy;
                                dy = y - cx;
                            }
                        }
                        if (SpriteX.intersectRect(dx, dy, tw, th, clipX, clipY, clipWidth, clipHeight)) {
                            SpriteX.drawRegion(g, this.image, tx, ty, tw, th, transform, dx, dy, 20);
                        }
                        offset += 4;
                    }
                    ++i;
                }
            }
        }
    }

    public static void drawRegionMIDP1(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        if (g == null || src == null) {
            throw new NullPointerException();
        }
        if (!SpriteX.checkAnchor(anchor, 64)) {
            throw new IllegalArgumentException();
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        if (width < 0 || height < 0 || x_src < 0 || y_src < 0 || x_src + width > src.getWidth() || y_src + height > src.getHeight()) {
            throw new IllegalArgumentException();
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if ((4 & transform) != 0) {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= width;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= height;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= height / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= width / 2;
                }
            }
            g.clipRect(x_dest, y_dest, height, width);
        } else {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= height;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= width;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= width / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= height / 2;
                }
            }
            g.clipRect(x_dest, y_dest, width, height);
        }
        int x_offset = 0;
        int y_offset = 0;
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        switch (transform) {
            case 0: {
                g.drawImage(src, x_dest - x_src, y_dest - y_src, 4 | 0x10);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                return;
            }
            case 5: {
                x_offset = srcHeight - (y_src + height);
                y_offset = x_src;
                break;
            }
            case 3: {
                x_offset = srcWidth - (x_src + width);
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 6: {
                x_offset = y_src;
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 2: {
                x_offset = srcWidth - (x_src + width);
                y_offset = y_src;
                break;
            }
            case 7: {
                x_offset = srcHeight - (y_src + height);
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 1: {
                x_offset = x_src;
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 4: {
                x_offset = y_src;
                y_offset = x_src;
            }
        }
        x_dest -= x_offset;
        y_dest -= y_offset;
        int clipX1 = g.getClipX();
        int clipY1 = g.getClipY();
        int clipX2 = g.getClipX() + g.getClipWidth();
        int clipY2 = g.getClipY() + g.getClipHeight();
        if ((4 & transform) != 0) {
            int temp = srcWidth;
            srcWidth = srcHeight;
            srcHeight = temp;
        }
        int src_start_x = Math.max(0, clipX1 - x_dest);
        int src_start_y = Math.max(0, clipY1 - y_dest);
        int dest_start_x = Math.max(clipX1, x_dest);
        int dest_start_y = Math.max(clipY1, y_dest);
        int dest_right = x_dest + srcWidth;
        int dest_bottom = y_dest + srcHeight;
        int copy_width = srcWidth - src_start_x;
        int copy_height = srcHeight - src_start_y;
        copy_width -= Math.max(0, dest_right - clipX2);
        copy_height -= Math.max(0, dest_bottom - clipY2);
        int px = 0;
        int py = 0;
        int i = 0;
        while (i < copy_height) {
            int j = 0;
            while (j < copy_width) {
                switch (transform) {
                    case 5: {
                        px = src_start_y + i;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 3: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 6: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = src_start_x + j;
                        break;
                    }
                    case 2: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = src_start_y + i;
                        break;
                    }
                    case 7: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 1: {
                        px = src_start_x + j;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 4: {
                        px = src_start_y + i;
                        py = src_start_x + j;
                    }
                }
                g.setClip(dest_start_x + j, dest_start_y + i, 1, 1);
                g.drawImage(src, dest_start_x + j - px, dest_start_y + i - py, 4 | 0x10);
                ++j;
            }
            ++i;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public static boolean checkAnchor(int anchor, int illegal_vpos) {
        int n;
        boolean right;
        if (anchor == 0) {
            return true;
        }
        boolean bl = right = anchor > 0 && anchor < 128 && (anchor & illegal_vpos) == 0;
        if (right) {
            n = anchor & 0x72;
            boolean bl2 = right = n != 0 && (n & n - 1) == 0;
        }
        if (right) {
            n = anchor & 0xD;
            right = n != 0 && (n & n - 1) == 0;
        }
        return right;
    }

    public static void drawRegion(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        g.drawRegion(src, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
    }

    public static boolean collide(SpriteX sp, byte i, SpriteX sp2, byte j) {
        if (sp.getTransform() == 2) {
            if (sp2.getTransform() == 2) {
                if (2 * sp.getX() - sp.getCollidesX(i) - sp.getCollidesWidth(i) + sp.getCollidesWidth(i) < 2 * sp2.getX() - sp2.getCollidesX(j) - sp2.getCollidesWidth(j)) {
                    return false;
                }
                if (2 * sp2.getX() - sp2.getCollidesX(j) - sp2.getCollidesWidth(j) + sp2.getCollidesWidth(j) < 2 * sp.getX() - sp.getCollidesX(i) - sp.getCollidesWidth(i)) {
                    return false;
                }
                if (sp.getCollidesY(i) + sp.getCollidesHeight(i) < sp2.getCollidesY(j)) {
                    return false;
                }
                return sp2.getCollidesY(j) + sp2.getCollidesHeight(j) >= sp.getCollidesY(i);
            }
            if (2 * sp.getX() - sp.getCollidesX(i) - sp.getCollidesWidth(i) + sp.getCollidesWidth(i) < sp2.getCollidesX(j)) {
                return false;
            }
            if (sp2.getCollidesX(j) + sp2.getCollidesWidth(j) < 2 * sp.getX() - sp.getCollidesX(i) - sp.getCollidesWidth(i)) {
                return false;
            }
            if (sp.getCollidesY(i) + sp.getCollidesHeight(i) < sp2.getCollidesY(j)) {
                return false;
            }
            return sp2.getCollidesY(j) + sp2.getCollidesHeight(j) >= sp.getCollidesY(i);
        }
        if (sp2.getTransform() == 2) {
            if (sp.getCollidesX(i) + sp.getCollidesWidth(i) < 2 * sp2.getX() - sp2.getCollidesX(j) - sp2.getCollidesWidth(j)) {
                return false;
            }
            if (2 * sp2.getX() - sp2.getCollidesX(j) - sp2.getCollidesWidth(j) + sp2.getCollidesWidth(j) < sp.getCollidesX(i)) {
                return false;
            }
            if (sp.getCollidesY(i) + sp.getCollidesHeight(i) < sp2.getCollidesY(j)) {
                return false;
            }
            return sp2.getCollidesY(j) + sp2.getCollidesHeight(j) >= sp.getCollidesY(i);
        }
        if (sp.getCollidesX(i) + sp.getCollidesWidth(i) < sp2.getCollidesX(j)) {
            return false;
        }
        if (sp2.getCollidesX(j) + sp2.getCollidesWidth(j) < sp.getCollidesX(i)) {
            return false;
        }
        if (sp.getCollidesY(i) + sp.getCollidesHeight(i) < sp2.getCollidesY(j)) {
            return false;
        }
        return sp2.getCollidesY(j) + sp2.getCollidesHeight(j) >= sp.getCollidesY(i);
    }
}

