/*
 * Decompiled with CFR 0.152.
 */
package SHUDU;

import java.util.Random;

public class Sodoku {
    private byte[][] matrix = null;
    private byte[][] buff = null;
    private byte[] log = null;
    private Random seed = new Random();

    private void initMatrix() {
        this.seed.setSeed(System.currentTimeMillis());
        this.matrix = new byte[9][9];
        this.buff = new byte[9][9];
        for (int n = 0; n < 9; n = (int)((byte)(n + 1))) {
            for (int n2 = 0; n2 < 9; n2 = (int)((byte)(n2 + 1))) {
                this.buff[n][n2] = n2;
            }
        }
    }

    public byte[][] getNewMatrix() {
        byte[][] byArray = new byte[9][9];
        byte[][] byArray2 = null;
        while ((byArray2 = this.generateMatrix()) == null) {
        }
        for (int n = 0; n < 9; n = (int)((byte)(n + 1))) {
            System.arraycopy(byArray2[n], 0, byArray[n], 0, 9);
        }
        byArray2 = null;
        return byArray;
    }

    private byte[][] generateMatrix() {
        this.initMatrix();
        for (byte by = 1; by <= 9; by = (byte)(by + 1)) {
            this.log = new byte[9];
            int n = 0;
            for (int n2 = 0; n2 < 9; n2 = (byte)(n2 + 1)) {
                if (this.setRandomPos((byte)n2, by)) continue;
                if ((n = (int)((byte)(n + 1))) > 50) {
                    return null;
                }
                n2 = -1;
                this.resetThisRound(by);
            }
            this.goNextRound();
        }
        this.buff = null;
        this.log = null;
        return this.matrix;
    }

    public byte[][] setMask(byte[][] byArray, int n) {
        int n2;
        byte[] byArray2 = new byte[81];
        for (n2 = 0; n2 < byArray2.length; n2 = (int)((byte)(n2 + 1))) {
            byArray2[n2] = n2;
        }
        for (n2 = 0; n2 < n; n2 = (int)((byte)(n2 + 1))) {
            byte by = (byte)this.getRandom(0, byArray2.length - 1);
            byArray[byArray2[by] % 9][byArray2[by] / 9] = 0;
            byArray2[by] = byArray2[byArray2.length - 1];
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
            byArray3 = null;
        }
        byArray2 = null;
        return byArray;
    }

    private boolean isIllegalPos(byte by, byte by2, byte by3) {
        for (int n = 0; n < 9; n = (int)((byte)(n + 1))) {
            if (this.matrix[n][by2] != by3 && this.matrix[by][n] != by3) continue;
            return false;
        }
        return true;
    }

    private void resetThisRound(byte by) {
        for (int n = 0; n < 9; n = (int)((byte)(n + 1))) {
            for (int n2 = 0; n2 < 9; n2 = (int)((byte)(n2 + 1))) {
                if (this.matrix[n][n2] != by) continue;
                this.matrix[n][n2] = 0;
            }
        }
    }

    private void goNextRound() {
        block0: for (int n = 0; n < 9; n = (int)((byte)(n + 1))) {
            for (int n2 = 0; n2 < this.buff[n].length; n2 = (int)((byte)(n2 + 1))) {
                if (this.buff[n][n2] != this.log[n]) continue;
                this.buff[n][n2] = this.buff[n][this.buff[n].length - 1];
                byte[] byArray = new byte[this.buff[n].length - 1];
                System.arraycopy(this.buff[n], 0, byArray, 0, byArray.length);
                this.buff[n] = byArray;
                byArray = null;
                continue block0;
            }
        }
    }

    private boolean setRandomPos(byte by, byte by2) {
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray = new byte[this.buff[by].length];
        System.arraycopy(this.buff[by], 0, byArray, 0, byArray.length);
        do {
            if (byArray.length == 0) {
                return false;
            }
            by3 = (byte)this.getRandom(0, byArray.length - 1);
            by4 = byArray[by3];
            byte[] byArray2 = new byte[byArray.length - 1];
            byArray[by3] = byArray[byArray.length - 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            byArray = byArray2;
            byArray2 = null;
        } while (!this.isIllegalPos((byte)(by % 3 * 3 + by4 % 3), (byte)(by / 3 * 3 + by4 / 3), by2));
        this.matrix[by % 3 * 3 + by4 % 3][by / 3 * 3 + by4 / 3] = by2;
        this.log[by] = by4;
        return true;
    }

    private int getRandom(int n, int n2) {
        Random random = new Random(this.seed.nextLong());
        int n3 = random.nextInt();
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = n + n3 % (n2 - n + 1);
        return n4;
    }

    public void outputMatrix() {
        for (int n = 0; n < 9; n = (int)((byte)(n + 1))) {
            for (int n2 = 0; n2 < 9; n2 = (int)((byte)(n2 + 1))) {
                System.out.print(this.matrix[n2][n] + " ");
            }
            System.out.println();
        }
    }

    public void outputMatrix(byte[][] byArray) {
        for (int n = 0; n < 9; n = (int)((byte)(n + 1))) {
            for (int n2 = 0; n2 < 9; n2 = (int)((byte)(n2 + 1))) {
                System.out.print(byArray[n2][n] + " ");
            }
            System.out.println();
        }
    }
}

