/*
 * Decompiled with CFR 0.152.
 */
package paoData;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import paoData.Boss;
import paoData.EnemyFish;
import paoData.GameRule;
import paoData.GameTools;
import paoData.MyFish;
import paoData.SenceMap;

public class FEFCanvas {
    Image[] fishImages = new Image[30];
    MyFish myFish;
    int count = 0;
    Image[] enemyImages = new Image[60];
    Image[] bossImages = new Image[4];
    Image[] dieImages = new Image[6];
    Boss[] boss = new Boss[3];
    int num = 30;
    public static int[] initNum = new int[]{10, 15, 20, 25, 30, 30};
    EnemyFish[] enemyFish = new EnemyFish[this.num];
    SenceMap sence;
    Image[] senceImages = new Image[5];
    GameRule rule;
    Image[] energyImage = new Image[7];
    Image testImage;
    Vector vector;
    GameTools gTool;
    private int blackHeight = 0;
    int arrowH = 70;
    int arrowFrame = 0;
    int deathHeight = 0;
    int frame = 0;
    long starttime = 0L;
    long timetaken = 0L;
    private final int TIME_PER_FRAME;
    final int WIDTH;
    final int HEIGHT;
    private boolean gameLive = true;
    static final Font lowFont = Font.getFont((int)64, (int)0, (int)8);
    short gameCount;
    short loadwidth;
    short gameState = (short)30;
    private final byte GAME_LOGO;
    private final byte GAME_MENU = (byte)10;
    final byte GAME_LOAD = (byte)20;
    private final byte GAME_RUN = (byte)30;
    private final byte GAME_ONMENU = (byte)40;
    private final byte GAME_WIN = (byte)50;
    private final byte GAME_OVER = (byte)60;
    private final byte GAME_RECORD = (byte)70;
    private final byte GAME_RECORD_SEND = (byte)80;
    final byte ZERO_KEY = (byte)48;
    final byte ONE_KEY = (byte)49;
    final byte TWO_KEY = (byte)50;
    final byte THREE_KEY = (byte)51;
    final byte FOUR_KEY = (byte)52;
    final byte FIVE_KEY = (byte)53;
    final byte SIX_KEY = (byte)54;
    final byte SEVEN_KEY = (byte)55;
    final byte EIGHT_KEY = (byte)56;
    final byte NINE_KEY = (byte)57;
    final byte UP_KEY = (byte)-1;
    final byte DOWN_KEY = (byte)-6;
    final byte LEFT_KEY = (byte)-2;
    final byte RIGHT_KEY = (byte)-5;
    final byte FIRE_KEY = (byte)-20;
    final byte LEFT_SOFT_KEY = (byte)-21;
    final byte RIGHT_SOFT_KEY = (byte)-22;

    public FEFCanvas() {
        this.TIME_PER_FRAME = 150;
        this.WIDTH = 176;
        this.HEIGHT = 204;
        this.GAME_LOGO = 0;
        this.gTool = new GameTools();
        this.gameState = (short)20;
        for (int i = 0; i < 4; ++i) {
            this.InitImg(i);
        }
    }

    public void ReleaseImg() {
        this.fishImages = null;
        this.enemyImages = null;
        this.bossImages = null;
        this.senceImages = null;
        this.energyImage = null;
        this.dieImages = null;
        System.gc();
    }

    public void InitImg(int n) {
        switch (n) {
            case 0: {
                this.gTool.createImage(this.fishImages, "/pao/myFish.c", 0, 30);
                break;
            }
            case 1: {
                this.gTool.createImage(this.enemyImages, "/pao/enemyFish.c", 0, 60);
                break;
            }
            case 2: {
                this.gTool.createImage(this.bossImages, "/pao/boss.c", 0, 4);
                break;
            }
            case 3: {
                this.gTool.createImage(this.senceImages, "/pao/sence.c", 0, 5);
                this.gTool.createImage(this.energyImage, "/pao/energy.c", 0, 7);
                this.gTool.createImage(this.dieImages, "/pao/dieImage.c", 0, 6);
            }
        }
    }

    void drawOnMenu(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, 176, 220);
        graphics.setColor(208, 112, 236);
        graphics.fillRect(0, 50, 176, 100);
        graphics.setColor(245, 202, 255);
        graphics.fillRect(0, 70, 176, 60);
        graphics.setColor(255, 255, 255);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        graphics.drawString("\u7ee7\u7eed", 88, 75, 17);
        graphics.drawString("\u8fd4\u56de\u4e3b\u83dc\u5355", 88, 100, 17);
        graphics.drawImage(this.bossImages[this.arrowFrame], 10, this.arrowH, 0);
        this.arrowFrame = this.arrowFrame == 0 ? 2 : 0;
    }

    void drawDead(Graphics graphics) {
        if (this.deathHeight < 40) {
            graphics.drawImage(this.dieImages[this.deathHeight / 2 % 3], this.myFish.posX, this.myFish.posY - this.deathHeight, 0);
            this.deathHeight += 2;
        } else if (this.frame < 6) {
            graphics.drawImage(this.dieImages[this.frame / 2 % 3 + 3], this.myFish.posX, this.myFish.posY - this.deathHeight, 0);
            ++this.frame;
        } else {
            this.gameState = (short)20;
            this.deathHeight = 0;
        }
    }

    public void paint(Graphics graphics) {
        switch (this.gameState) {
            case 20: {
                int n;
                this.sence = new SenceMap(this.senceImages, this);
                this.myFish = new MyFish(this.fishImages, this.sence);
                for (n = 0; n < 3; ++n) {
                    this.boss[n] = new Boss(this.bossImages, this.sence);
                }
                this.rule = new GameRule(this.myFish, this.enemyFish, this.boss, this.energyImage);
                for (n = 0; n < this.num; ++n) {
                    if (n < initNum[0]) {
                        this.enemyFish[n] = new EnemyFish(this.enemyImages, this.sence, 0);
                        this.enemyFish[n].isLive = true;
                        continue;
                    }
                    if (n >= initNum[0] && n < initNum[1]) {
                        this.enemyFish[n] = new EnemyFish(this.enemyImages, this.sence, 1);
                        this.enemyFish[n].isLive = true;
                        continue;
                    }
                    if (n >= initNum[1] && n < initNum[2]) {
                        this.enemyFish[n] = new EnemyFish(this.enemyImages, this.sence, 2);
                        this.enemyFish[n].isLive = false;
                        continue;
                    }
                    if (n >= initNum[2] && n < initNum[3]) {
                        this.enemyFish[n] = new EnemyFish(this.enemyImages, this.sence, 3);
                        this.enemyFish[n].isLive = false;
                        continue;
                    }
                    if (n < initNum[3] || n >= initNum[4]) continue;
                    this.enemyFish[n] = new EnemyFish(this.enemyImages, this.sence, 4);
                    this.enemyFish[n].isLive = false;
                }
                this.myFish.init();
                this.blackHeight = 0;
                this.gameState = (short)30;
                break;
            }
            case 30: {
                int n;
                this.sence.draw(graphics);
                for (n = 0; n < this.num; ++n) {
                    this.enemyFish[n].draw(graphics);
                }
                this.myFish.draw(graphics);
                for (n = 0; n < 3; ++n) {
                    this.boss[n].draw(graphics);
                }
                this.rule.draw(graphics);
                if (this.myFish.isLive) break;
                this.drawDead(graphics);
                break;
            }
            case 50: {
                break;
            }
            case 40: {
                this.drawOnMenu(graphics);
                break;
            }
            case 80: {
                break;
            }
            case 60: {
                int n;
                graphics.setClip(0, 0, 176, 208);
                graphics.setColor(0, 0, 0);
                for (n = 0; n < 11; ++n) {
                    if (n % 2 != 0) continue;
                    graphics.fillRect(n * 176 / 11, 0, 16, this.blackHeight);
                }
                for (n = 0; n < 11; ++n) {
                    if (n % 2 != 1) continue;
                    graphics.fillRect(n * 176 / 11, 208 - this.blackHeight, 16, 208);
                }
                if (this.blackHeight != 204) break;
                graphics.setColor(255, 255, 255);
                graphics.drawString("\u611f\u8c22\u652f\u6301\u706b\u8681\u6e38\u620f", 50, 68, 0);
                graphics.drawString("\u60a8\u7684\u5f97\u5206:", 50, 88, 0);
                graphics.setClip(80, 102, 7, 10);
                graphics.drawImage(this.rule.ml.scoreImg, this.rule.ml.finalScore / 600 * -7 + 77, 102, 0);
                graphics.setClip(87, 102, 7, 10);
                graphics.drawImage(this.rule.ml.scoreImg, this.rule.ml.finalScore % 600 / 60 * -7 + 83, 102, 0);
                graphics.setClip(94, 102, 3, 10);
                graphics.drawImage(this.rule.ml.scoreImg, 94, 102, 0);
                graphics.setClip(101, 102, 7, 10);
                graphics.drawImage(this.rule.ml.scoreImg, this.rule.ml.finalScore % 60 / 10 * -7 + 98, 102, 0);
                graphics.setClip(108, 102, 7, 10);
                graphics.drawImage(this.rule.ml.scoreImg, this.rule.ml.finalScore % 10 * -7 + 105, 102, 0);
            }
        }
    }

    public void run() {
        switch (this.gameState) {
            case 0: {
                break;
            }
            case 10: {
                break;
            }
            case 20: {
                break;
            }
            case 30: {
                int n;
                if (!this.myFish.isLive) break;
                this.myFish.move();
                for (n = 0; n < this.num; ++n) {
                    this.enemyFish[n].move();
                }
                this.rule.compareEnemyFish();
                this.rule.compareMyFish();
                this.rule.catchOrRun();
                for (n = 0; n < 3; ++n) {
                    this.boss[n].move();
                }
                break;
            }
            case 50: {
                break;
            }
            case 60: {
                if (this.frame < 6) break;
                this.blackHeight += 10;
                if (this.blackHeight <= 204) break;
                this.blackHeight = 204;
            }
        }
    }

    public int keyPressed(int n) {
        int n2 = 30;
        block0 : switch (this.gameState) {
            case 0: {
                switch (n) {
                    case -20: 
                    case 53: {
                        this.gameState = (short)10;
                    }
                }
                break;
            }
            case 10: {
                break;
            }
            case 30: {
                switch (n) {
                    case 48: {
                        break block0;
                    }
                    case 49: {
                        break block0;
                    }
                    case -1: 
                    case 50: {
                        this.myFish.moveUp();
                        break block0;
                    }
                    case 51: {
                        break block0;
                    }
                    case -2: 
                    case 52: {
                        this.myFish.moveLeft();
                        break block0;
                    }
                    case -20: 
                    case 53: {
                        break block0;
                    }
                    case -5: 
                    case 54: {
                        this.myFish.moveRight();
                        break block0;
                    }
                    case 55: {
                        break block0;
                    }
                    case -6: 
                    case 56: {
                        this.myFish.moveDown();
                        break block0;
                    }
                    case 57: {
                        break block0;
                    }
                    case -21: {
                        break block0;
                    }
                }
                break;
            }
            case 40: {
                switch (n) {
                    case -1: 
                    case 50: {
                        this.arrowH = 70;
                        break;
                    }
                    case -6: 
                    case 56: {
                        this.arrowH = 95;
                        break;
                    }
                    case -22: {
                        this.gameState = (short)30;
                        break;
                    }
                    case -20: 
                    case 53: {
                        int n3;
                        if (this.arrowH == 70) {
                            this.gameState = (short)30;
                        }
                        if (this.arrowH != 95) break;
                        this.myFish = null;
                        for (n3 = 0; n3 < this.enemyFish.length; ++n3) {
                            this.enemyFish[n3] = null;
                        }
                        for (n3 = 0; n3 < this.boss.length; ++n3) {
                            this.boss[n3] = null;
                        }
                        this.rule = null;
                        this.sence = null;
                        this.gameCount = 0;
                        n2 = 90;
                    }
                }
                break;
            }
            case 70: {
                break;
            }
            case 60: {
                int n4;
                if (this.blackHeight != 204) break;
                this.myFish = null;
                for (n4 = 0; n4 < this.enemyFish.length; ++n4) {
                    this.enemyFish[n4] = null;
                }
                for (n4 = 0; n4 < this.boss.length; ++n4) {
                    this.boss[n4] = null;
                }
                this.rule = null;
                this.sence = null;
                this.gameCount = 0;
                this.gameState = (short)20;
            }
        }
        return n2;
    }

    public void keyReleased(int n) {
        block0 : switch (this.gameState) {
            case 0: {
                break;
            }
            case 10: {
                switch (n) {
                    case -1: 
                    case 50: {
                        break block0;
                    }
                    case -6: 
                    case 56: {
                        break block0;
                    }
                    case -2: 
                    case 52: {
                        break block0;
                    }
                    case -5: 
                    case 54: {
                        break block0;
                    }
                    case -20: 
                    case 53: {
                        break block0;
                    }
                }
                break;
            }
            case 30: {
                switch (n) {
                    case 48: {
                        break;
                    }
                    case 49: {
                        break;
                    }
                    case -1: 
                    case 50: {
                        this.myFish.stopMove();
                        break;
                    }
                    case 51: {
                        break;
                    }
                    case -2: 
                    case 52: {
                        this.myFish.stopMove();
                        break;
                    }
                    case 53: {
                        break;
                    }
                    case -5: 
                    case 54: {
                        this.myFish.stopMove();
                        break;
                    }
                    case 55: {
                        break;
                    }
                    case -6: 
                    case 56: {
                        this.myFish.stopMove();
                        break;
                    }
                    case 57: {
                        break;
                    }
                    case -20: {
                        break;
                    }
                    case -21: {
                        break;
                    }
                    case -22: {
                        this.gameState = (short)40;
                    }
                }
                break;
            }
            case 40: {
                switch (n) {
                    case -1: 
                    case 50: {
                        break block0;
                    }
                    case -6: 
                    case 56: {
                        break block0;
                    }
                }
                break;
            }
        }
    }
}

