/*
 * Decompiled with CFR 0.152.
 */
package huoyun;

import huoyun.End;
import huoyun.MyCanvas;
import javax.microedition.lcdui.Graphics;

public class Cargo {
    MyCanvas canvas;
    int x;
    int y;
    int xNext;
    int yNext;
    int iState;
    static final int STATE_READY = 0;
    static final int STATE_MOVING = 1;
    int iColor;
    static final int COLOR_NONE = -1;
    static final int COLOR_RED = 0;
    static final int COLOR_GREEN = 1;
    static final int COLOR_PINK = 2;
    static final int COLOR_BLUE = 3;
    static final int COLOR_YELLOW = 4;
    int iMovePhase;

    public Cargo(MyCanvas canvas) {
        this.canvas = canvas;
        this.goStateReady();
    }

    public void goStateReady() {
        this.iState = 0;
        this.y = -1;
        this.x = -1;
        this.iColor = -1;
    }

    public void goStateMoving() {
        this.iState = 1;
        this.x = 0;
        this.y = 20;
        this.setCargoLocation();
    }

    public void emptyCargoLocation() {
        this.canvas.chAryCargoTreeLocation[this.y][this.x] = 32;
    }

    public void setCargoLocation() {
        if (this.iColor == 0) {
            this.canvas.chAryCargoTreeLocation[this.y][this.x] = 82;
        } else if (this.iColor == 1) {
            this.canvas.chAryCargoTreeLocation[this.y][this.x] = 71;
        } else if (this.iColor == 2) {
            this.canvas.chAryCargoTreeLocation[this.y][this.x] = 80;
        } else if (this.iColor == 3) {
            this.canvas.chAryCargoTreeLocation[this.y][this.x] = 66;
        } else if (this.iColor == 4) {
            this.canvas.chAryCargoTreeLocation[this.y][this.x] = 89;
        }
    }

    public void onMove() {
        if (this.iState == 0) {
            this.goStateMoving();
        } else if (this.iState == 1) {
            this.move();
        }
    }

    public void onStop() {
        if (this.iState == 1) {
            End end = this.getEnd(this.x, this.y);
            if (end.iState == 1) {
                if (this.iColor == end.iAryColorTable[end.iCurrentColorIndex]) {
                    if (end.iCurrentColorIndex == end.iColorTableLength - 1) {
                        end.onRunning();
                    } else {
                        end.onModifyColor();
                    }
                } else {
                    --this.canvas.iMaxDeadCargo;
                }
            } else {
                --this.canvas.iMaxDeadCargo;
            }
            this.iMovePhase = 0;
            this.emptyCargoLocation();
            this.goStateReady();
        }
    }

    public void computerCoordinateNextStep() {
        char ch = this.canvas.chAryMap[this.y][this.x];
        if (ch == '*') {
            int iForkIndex = this.getFixedForkIndex(this.x, this.y);
            if (iForkIndex != -1) {
                if (this.canvas.iAryFixedFork[iForkIndex][2] == 1) {
                    this.xNext = this.x + 1;
                    this.yNext = this.y;
                } else if (this.canvas.iAryFixedFork[iForkIndex][3] == 1) {
                    this.xNext = this.x;
                    this.yNext = this.y + 1;
                } else if (this.canvas.iAryFixedFork[iForkIndex][4] == 1) {
                    this.xNext = this.x - 1;
                    this.yNext = this.y;
                } else if (this.canvas.iAryFixedFork[iForkIndex][5] == 1) {
                    this.xNext = this.x;
                    this.yNext = this.y - 1;
                }
            } else {
                iForkIndex = this.getUnFixedForkIndex(this.x, this.y);
                if (iForkIndex != -1) {
                    if (this.canvas.iAryUnFixedFork[iForkIndex][6] == 0) {
                        this.xNext = this.x + 1;
                        this.yNext = this.y;
                    } else if (this.canvas.iAryUnFixedFork[iForkIndex][6] == 1) {
                        this.xNext = this.x;
                        this.yNext = this.y + 1;
                    } else if (this.canvas.iAryUnFixedFork[iForkIndex][6] == 2) {
                        this.xNext = this.x - 1;
                        this.yNext = this.y;
                    } else if (this.canvas.iAryUnFixedFork[iForkIndex][6] == 3) {
                        this.xNext = this.x;
                        this.yNext = this.y - 1;
                    }
                }
            }
        } else if (ch == 'E') {
            this.xNext = this.x + 1;
            this.yNext = this.y;
        } else if (ch == 'S') {
            this.xNext = this.x;
            this.yNext = this.y + 1;
        } else if (ch == 'W') {
            this.xNext = this.x - 1;
            this.yNext = this.y;
        } else if (ch == 'N') {
            this.xNext = this.x;
            this.yNext = this.y - 1;
        }
    }

    public void move() {
        this.emptyCargoLocation();
        char ch = this.canvas.chAryMap[this.y][this.x];
        if (ch == '*') {
            int iForkIndex = this.getFixedForkIndex(this.x, this.y);
            if (iForkIndex != -1) {
                if (this.canvas.iAryFixedFork[iForkIndex][2] == 1) {
                    ++this.x;
                } else if (this.canvas.iAryFixedFork[iForkIndex][3] == 1) {
                    ++this.y;
                } else if (this.canvas.iAryFixedFork[iForkIndex][4] == 1) {
                    --this.x;
                } else if (this.canvas.iAryFixedFork[iForkIndex][5] == 1) {
                    --this.y;
                }
            } else {
                iForkIndex = this.getUnFixedForkIndex(this.x, this.y);
                if (iForkIndex != -1) {
                    if (this.canvas.iAryUnFixedFork[iForkIndex][6] == 0) {
                        ++this.x;
                    } else if (this.canvas.iAryUnFixedFork[iForkIndex][6] == 1) {
                        ++this.y;
                    } else if (this.canvas.iAryUnFixedFork[iForkIndex][6] == 2) {
                        --this.x;
                    } else if (this.canvas.iAryUnFixedFork[iForkIndex][6] == 3) {
                        --this.y;
                    }
                }
            }
        } else if (ch == 'E') {
            ++this.x;
        } else if (ch == 'S') {
            ++this.y;
        } else if (ch == 'W') {
            --this.x;
        } else if (ch == 'N') {
            --this.y;
        }
        this.iMovePhase = 0;
        if (this.canvas.chAryMap[this.y][this.x] < 'a' && this.canvas.chAryMap[this.y][this.x] <= 'c') {
            this.setCargoLocation();
        } else if (this.canvas.chMusicOrSound == 'S') {
            this.canvas.playSound();
        }
    }

    public End getEnd(int x, int y) {
        End end = null;
        if (x == 20 && y == 4) {
            end = this.canvas.endAry[0];
        } else if (x == 20 && y == 8) {
            end = this.canvas.endAry[1];
        } else if (x == 20 && y == 12) {
            end = this.canvas.endAry[2];
        } else if (x == 40 && y == 36) {
            end = this.canvas.endAry[3];
        } else if (x == 36 && y == 36) {
            end = this.canvas.endAry[4];
        } else if (x == 32 && y == 36) {
            end = this.canvas.endAry[5];
        } else if (x == 16 && y == 48) {
            end = this.canvas.endAry[6];
        } else if (x == 16 && y == 44) {
            end = this.canvas.endAry[7];
        } else if (x == 16 && y == 40) {
            end = this.canvas.endAry[8];
        }
        return end;
    }

    public int getFixedForkIndex(int x, int y) {
        int iIndex = -1;
        for (int i = 0; i < this.canvas.nFixedFork; ++i) {
            if (this.canvas.iAryFixedFork[i][0] != x || this.canvas.iAryFixedFork[i][1] != y) continue;
            iIndex = i;
            break;
        }
        return iIndex;
    }

    public int getUnFixedForkIndex(int x, int y) {
        int iIndex = -1;
        for (int i = 0; i < this.canvas.nUnFixedFork; ++i) {
            if (this.canvas.iAryUnFixedFork[i][0] != x || this.canvas.iAryUnFixedFork[i][1] != y) continue;
            iIndex = i;
            break;
        }
        return iIndex;
    }

    public void drawToScreen(Graphics g) {
        if (this.iState == 1) {
            this.canvas.drawImageArea(g, this.canvas.imgCargo, this.iColor * 17, 0, 17, 18, this.canvas.xMapStart + (this.x - this.y) * 7 - 6 - this.canvas.iStepX * this.canvas.wStepX, this.canvas.yMapStart + (this.y + this.x) * 4 - 11 - this.canvas.iStepY * this.canvas.wStepY, 'A');
        }
    }

    public void run() {
        if (this.iState == 1) {
            if (this.canvas.chAryMap[this.y][this.x] >= 'a' && this.canvas.chAryMap[this.y][this.x] <= 'c') {
                this.onStop();
            } else if (this.iMovePhase == this.canvas.iMaxCargoMovePhase) {
                this.computerCoordinateNextStep();
                if (!this.canvas.hasCargo(this.xNext, this.yNext)) {
                    this.onMove();
                }
            } else {
                ++this.iMovePhase;
            }
        }
    }
}

