/*
 * Decompiled with CFR 0.152.
 */
package xqwlight;

import java.util.Random;
import xqwlight.Book;

public class Position {
    public static final int MATE_VALUE = 1000;
    public static final int WIN_VALUE = 900;
    public static final int NULL_SAFE_MARGIN = 400;
    public static final int NULL_OKAY_MARGIN = 200;
    public static final int CONTEMPT_VALUE = 20;
    public static final int ADVANCED_VALUE = 3;
    public static final int MAX_GEN_MOVES = 128;
    public static final int MAX_MOVE_NUM = 256;
    public static final int PIECE_KING = 1;
    public static final int PIECE_ADVISOR = 2;
    public static final int PIECE_BISHOP = 3;
    public static final int PIECE_KNIGHT = 4;
    public static final int PIECE_ROOK = 5;
    public static final int PIECE_CANNON = 6;
    public static final int PIECE_PAWN = 7;
    public static final byte[] IN_BOARD;
    public static final byte[] IN_FORT;
    public static final byte[] LEGAL_SPAN;
    public static final byte[] KNIGHT_PIN;
    public static final int[] KING_DELTA;
    public static final int[] ADVISOR_DELTA;
    public static final int[][] KNIGHT_DELTA;
    public static final int[][] KNIGHT_CHECK_DELTA;
    public static final int[] MVV_VALUE;
    public static final short[][] PIECE_VALUE;
    public static final int[][] BOARD_HANDICAP;
    public static int PreGen_zobristKeyPlayer;
    public static int PreGen_zobristLockPlayer;
    public static int[][] PreGen_zobristKeyTable;
    public static int[][] PreGen_zobristLockTable;
    public static Random random;
    public int sdPlayer;
    public byte[] squares = new byte[256];
    public int zobristKey;
    public int zobristLock;
    public int vlWhite;
    public int vlBlack;
    public int moveNum;
    public int distance;
    public int[] mvList = new int[256];
    public int[] pcList = new int[256];
    public int[] keyList = new int[256];
    public boolean[] chkList = new boolean[256];

    static {
        byte[] byArray = new byte[256];
        byArray[51] = 1;
        byArray[52] = 1;
        byArray[53] = 1;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[58] = 1;
        byArray[59] = 1;
        byArray[67] = 1;
        byArray[68] = 1;
        byArray[69] = 1;
        byArray[70] = 1;
        byArray[71] = 1;
        byArray[72] = 1;
        byArray[73] = 1;
        byArray[74] = 1;
        byArray[75] = 1;
        byArray[83] = 1;
        byArray[84] = 1;
        byArray[85] = 1;
        byArray[86] = 1;
        byArray[87] = 1;
        byArray[88] = 1;
        byArray[89] = 1;
        byArray[90] = 1;
        byArray[91] = 1;
        byArray[99] = 1;
        byArray[100] = 1;
        byArray[101] = 1;
        byArray[102] = 1;
        byArray[103] = 1;
        byArray[104] = 1;
        byArray[105] = 1;
        byArray[106] = 1;
        byArray[107] = 1;
        byArray[115] = 1;
        byArray[116] = 1;
        byArray[117] = 1;
        byArray[118] = 1;
        byArray[119] = 1;
        byArray[120] = 1;
        byArray[121] = 1;
        byArray[122] = 1;
        byArray[123] = 1;
        byArray[131] = 1;
        byArray[132] = 1;
        byArray[133] = 1;
        byArray[134] = 1;
        byArray[135] = 1;
        byArray[136] = 1;
        byArray[137] = 1;
        byArray[138] = 1;
        byArray[139] = 1;
        byArray[147] = 1;
        byArray[148] = 1;
        byArray[149] = 1;
        byArray[150] = 1;
        byArray[151] = 1;
        byArray[152] = 1;
        byArray[153] = 1;
        byArray[154] = 1;
        byArray[155] = 1;
        byArray[163] = 1;
        byArray[164] = 1;
        byArray[165] = 1;
        byArray[166] = 1;
        byArray[167] = 1;
        byArray[168] = 1;
        byArray[169] = 1;
        byArray[170] = 1;
        byArray[171] = 1;
        byArray[179] = 1;
        byArray[180] = 1;
        byArray[181] = 1;
        byArray[182] = 1;
        byArray[183] = 1;
        byArray[184] = 1;
        byArray[185] = 1;
        byArray[186] = 1;
        byArray[187] = 1;
        byArray[195] = 1;
        byArray[196] = 1;
        byArray[197] = 1;
        byArray[198] = 1;
        byArray[199] = 1;
        byArray[200] = 1;
        byArray[201] = 1;
        byArray[202] = 1;
        byArray[203] = 1;
        IN_BOARD = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[54] = 1;
        byArray2[55] = 1;
        byArray2[56] = 1;
        byArray2[70] = 1;
        byArray2[71] = 1;
        byArray2[72] = 1;
        byArray2[86] = 1;
        byArray2[87] = 1;
        byArray2[88] = 1;
        byArray2[166] = 1;
        byArray2[167] = 1;
        byArray2[168] = 1;
        byArray2[182] = 1;
        byArray2[183] = 1;
        byArray2[184] = 1;
        byArray2[198] = 1;
        byArray2[199] = 1;
        byArray2[200] = 1;
        IN_FORT = byArray2;
        byte[] byArray3 = new byte[512];
        byArray3[222] = 3;
        byArray3[226] = 3;
        byArray3[239] = 2;
        byArray3[240] = 1;
        byArray3[241] = 2;
        byArray3[255] = 1;
        byArray3[257] = 1;
        byArray3[271] = 2;
        byArray3[272] = 1;
        byArray3[273] = 2;
        byArray3[286] = 3;
        byArray3[290] = 3;
        LEGAL_SPAN = byArray3;
        byte[] byArray4 = new byte[512];
        byArray4[223] = -16;
        byArray4[225] = -16;
        byArray4[238] = -1;
        byArray4[242] = 1;
        byArray4[270] = -1;
        byArray4[274] = 1;
        byArray4[287] = 16;
        byArray4[289] = 16;
        KNIGHT_PIN = byArray4;
        KING_DELTA = new int[]{-16, -1, 1, 16};
        ADVISOR_DELTA = new int[]{-17, -15, 15, 17};
        KNIGHT_DELTA = new int[][]{{-33, -31}, {-18, 14}, {-14, 18}, {31, 33}};
        KNIGHT_CHECK_DELTA = new int[][]{{-33, -18}, {-31, -14}, {14, 31}, {18, 33}};
        int[] nArray = new int[8];
        nArray[1] = 50;
        nArray[2] = 10;
        nArray[3] = 10;
        nArray[4] = 30;
        nArray[5] = 40;
        nArray[6] = 30;
        nArray[7] = 20;
        MVV_VALUE = nArray;
        short[][] sArrayArray = new short[7][];
        short[] sArray = new short[256];
        sArray[51] = 9;
        sArray[52] = 9;
        sArray[53] = 9;
        sArray[54] = 11;
        sArray[55] = 13;
        sArray[56] = 11;
        sArray[57] = 9;
        sArray[58] = 9;
        sArray[59] = 9;
        sArray[67] = 19;
        sArray[68] = 24;
        sArray[69] = 34;
        sArray[70] = 42;
        sArray[71] = 44;
        sArray[72] = 42;
        sArray[73] = 34;
        sArray[74] = 24;
        sArray[75] = 19;
        sArray[83] = 19;
        sArray[84] = 24;
        sArray[85] = 32;
        sArray[86] = 37;
        sArray[87] = 37;
        sArray[88] = 37;
        sArray[89] = 32;
        sArray[90] = 24;
        sArray[91] = 19;
        sArray[99] = 19;
        sArray[100] = 23;
        sArray[101] = 27;
        sArray[102] = 29;
        sArray[103] = 30;
        sArray[104] = 29;
        sArray[105] = 27;
        sArray[106] = 23;
        sArray[107] = 19;
        sArray[115] = 14;
        sArray[116] = 18;
        sArray[117] = 20;
        sArray[118] = 27;
        sArray[119] = 29;
        sArray[120] = 27;
        sArray[121] = 20;
        sArray[122] = 18;
        sArray[123] = 14;
        sArray[131] = 7;
        sArray[133] = 13;
        sArray[135] = 16;
        sArray[137] = 13;
        sArray[139] = 7;
        sArray[147] = 7;
        sArray[149] = 7;
        sArray[151] = 15;
        sArray[153] = 7;
        sArray[155] = 7;
        sArray[166] = 1;
        sArray[167] = 1;
        sArray[168] = 1;
        sArray[182] = 2;
        sArray[183] = 2;
        sArray[184] = 2;
        sArray[198] = 11;
        sArray[199] = 15;
        sArray[200] = 11;
        sArrayArray[0] = sArray;
        short[] sArray2 = new short[256];
        sArray2[133] = 20;
        sArray2[137] = 20;
        sArray2[163] = 18;
        sArray2[166] = 20;
        sArray2[167] = 23;
        sArray2[168] = 20;
        sArray2[171] = 18;
        sArray2[183] = 23;
        sArray2[197] = 20;
        sArray2[198] = 20;
        sArray2[200] = 20;
        sArray2[201] = 20;
        sArrayArray[1] = sArray2;
        short[] sArray3 = new short[256];
        sArray3[133] = 20;
        sArray3[137] = 20;
        sArray3[163] = 18;
        sArray3[166] = 20;
        sArray3[167] = 23;
        sArray3[168] = 20;
        sArray3[171] = 18;
        sArray3[183] = 23;
        sArray3[197] = 20;
        sArray3[198] = 20;
        sArray3[200] = 20;
        sArray3[201] = 20;
        sArrayArray[2] = sArray3;
        short[] sArray4 = new short[256];
        sArray4[51] = 90;
        sArray4[52] = 90;
        sArray4[53] = 90;
        sArray4[54] = 96;
        sArray4[55] = 90;
        sArray4[56] = 96;
        sArray4[57] = 90;
        sArray4[58] = 90;
        sArray4[59] = 90;
        sArray4[67] = 90;
        sArray4[68] = 96;
        sArray4[69] = 103;
        sArray4[70] = 97;
        sArray4[71] = 94;
        sArray4[72] = 97;
        sArray4[73] = 103;
        sArray4[74] = 96;
        sArray4[75] = 90;
        sArray4[83] = 92;
        sArray4[84] = 98;
        sArray4[85] = 99;
        sArray4[86] = 103;
        sArray4[87] = 99;
        sArray4[88] = 103;
        sArray4[89] = 99;
        sArray4[90] = 98;
        sArray4[91] = 92;
        sArray4[99] = 93;
        sArray4[100] = 108;
        sArray4[101] = 100;
        sArray4[102] = 107;
        sArray4[103] = 100;
        sArray4[104] = 107;
        sArray4[105] = 100;
        sArray4[106] = 108;
        sArray4[107] = 93;
        sArray4[115] = 90;
        sArray4[116] = 100;
        sArray4[117] = 99;
        sArray4[118] = 103;
        sArray4[119] = 104;
        sArray4[120] = 103;
        sArray4[121] = 99;
        sArray4[122] = 100;
        sArray4[123] = 90;
        sArray4[131] = 90;
        sArray4[132] = 98;
        sArray4[133] = 101;
        sArray4[134] = 102;
        sArray4[135] = 103;
        sArray4[136] = 102;
        sArray4[137] = 101;
        sArray4[138] = 98;
        sArray4[139] = 90;
        sArray4[147] = 92;
        sArray4[148] = 94;
        sArray4[149] = 98;
        sArray4[150] = 95;
        sArray4[151] = 98;
        sArray4[152] = 95;
        sArray4[153] = 98;
        sArray4[154] = 94;
        sArray4[155] = 92;
        sArray4[163] = 93;
        sArray4[164] = 92;
        sArray4[165] = 94;
        sArray4[166] = 95;
        sArray4[167] = 92;
        sArray4[168] = 95;
        sArray4[169] = 94;
        sArray4[170] = 92;
        sArray4[171] = 93;
        sArray4[179] = 85;
        sArray4[180] = 90;
        sArray4[181] = 92;
        sArray4[182] = 93;
        sArray4[183] = 78;
        sArray4[184] = 93;
        sArray4[185] = 92;
        sArray4[186] = 90;
        sArray4[187] = 85;
        sArray4[195] = 88;
        sArray4[196] = 85;
        sArray4[197] = 90;
        sArray4[198] = 88;
        sArray4[199] = 90;
        sArray4[200] = 88;
        sArray4[201] = 90;
        sArray4[202] = 85;
        sArray4[203] = 88;
        sArrayArray[3] = sArray4;
        short[] sArray5 = new short[256];
        sArray5[51] = 206;
        sArray5[52] = 208;
        sArray5[53] = 207;
        sArray5[54] = 213;
        sArray5[55] = 214;
        sArray5[56] = 213;
        sArray5[57] = 207;
        sArray5[58] = 208;
        sArray5[59] = 206;
        sArray5[67] = 206;
        sArray5[68] = 212;
        sArray5[69] = 209;
        sArray5[70] = 216;
        sArray5[71] = 233;
        sArray5[72] = 216;
        sArray5[73] = 209;
        sArray5[74] = 212;
        sArray5[75] = 206;
        sArray5[83] = 206;
        sArray5[84] = 208;
        sArray5[85] = 207;
        sArray5[86] = 214;
        sArray5[87] = 216;
        sArray5[88] = 214;
        sArray5[89] = 207;
        sArray5[90] = 208;
        sArray5[91] = 206;
        sArray5[99] = 206;
        sArray5[100] = 213;
        sArray5[101] = 213;
        sArray5[102] = 216;
        sArray5[103] = 216;
        sArray5[104] = 216;
        sArray5[105] = 213;
        sArray5[106] = 213;
        sArray5[107] = 206;
        sArray5[115] = 208;
        sArray5[116] = 211;
        sArray5[117] = 211;
        sArray5[118] = 214;
        sArray5[119] = 215;
        sArray5[120] = 214;
        sArray5[121] = 211;
        sArray5[122] = 211;
        sArray5[123] = 208;
        sArray5[131] = 208;
        sArray5[132] = 212;
        sArray5[133] = 212;
        sArray5[134] = 214;
        sArray5[135] = 215;
        sArray5[136] = 214;
        sArray5[137] = 212;
        sArray5[138] = 212;
        sArray5[139] = 208;
        sArray5[147] = 204;
        sArray5[148] = 209;
        sArray5[149] = 204;
        sArray5[150] = 212;
        sArray5[151] = 214;
        sArray5[152] = 212;
        sArray5[153] = 204;
        sArray5[154] = 209;
        sArray5[155] = 204;
        sArray5[163] = 198;
        sArray5[164] = 208;
        sArray5[165] = 204;
        sArray5[166] = 212;
        sArray5[167] = 212;
        sArray5[168] = 212;
        sArray5[169] = 204;
        sArray5[170] = 208;
        sArray5[171] = 198;
        sArray5[179] = 200;
        sArray5[180] = 208;
        sArray5[181] = 206;
        sArray5[182] = 212;
        sArray5[183] = 200;
        sArray5[184] = 212;
        sArray5[185] = 206;
        sArray5[186] = 208;
        sArray5[187] = 200;
        sArray5[195] = 194;
        sArray5[196] = 206;
        sArray5[197] = 204;
        sArray5[198] = 212;
        sArray5[199] = 200;
        sArray5[200] = 212;
        sArray5[201] = 204;
        sArray5[202] = 206;
        sArray5[203] = 194;
        sArrayArray[4] = sArray5;
        short[] sArray6 = new short[256];
        sArray6[51] = 100;
        sArray6[52] = 100;
        sArray6[53] = 96;
        sArray6[54] = 91;
        sArray6[55] = 90;
        sArray6[56] = 91;
        sArray6[57] = 96;
        sArray6[58] = 100;
        sArray6[59] = 100;
        sArray6[67] = 98;
        sArray6[68] = 98;
        sArray6[69] = 96;
        sArray6[70] = 92;
        sArray6[71] = 89;
        sArray6[72] = 92;
        sArray6[73] = 96;
        sArray6[74] = 98;
        sArray6[75] = 98;
        sArray6[83] = 97;
        sArray6[84] = 97;
        sArray6[85] = 96;
        sArray6[86] = 91;
        sArray6[87] = 92;
        sArray6[88] = 91;
        sArray6[89] = 96;
        sArray6[90] = 97;
        sArray6[91] = 97;
        sArray6[99] = 96;
        sArray6[100] = 99;
        sArray6[101] = 99;
        sArray6[102] = 98;
        sArray6[103] = 100;
        sArray6[104] = 98;
        sArray6[105] = 99;
        sArray6[106] = 99;
        sArray6[107] = 96;
        sArray6[115] = 96;
        sArray6[116] = 96;
        sArray6[117] = 96;
        sArray6[118] = 96;
        sArray6[119] = 100;
        sArray6[120] = 96;
        sArray6[121] = 96;
        sArray6[122] = 96;
        sArray6[123] = 96;
        sArray6[131] = 95;
        sArray6[132] = 96;
        sArray6[133] = 99;
        sArray6[134] = 96;
        sArray6[135] = 100;
        sArray6[136] = 96;
        sArray6[137] = 99;
        sArray6[138] = 96;
        sArray6[139] = 95;
        sArray6[147] = 96;
        sArray6[148] = 96;
        sArray6[149] = 96;
        sArray6[150] = 96;
        sArray6[151] = 96;
        sArray6[152] = 96;
        sArray6[153] = 96;
        sArray6[154] = 96;
        sArray6[155] = 96;
        sArray6[163] = 97;
        sArray6[164] = 96;
        sArray6[165] = 100;
        sArray6[166] = 99;
        sArray6[167] = 101;
        sArray6[168] = 99;
        sArray6[169] = 100;
        sArray6[170] = 96;
        sArray6[171] = 97;
        sArray6[179] = 96;
        sArray6[180] = 97;
        sArray6[181] = 98;
        sArray6[182] = 98;
        sArray6[183] = 98;
        sArray6[184] = 98;
        sArray6[185] = 98;
        sArray6[186] = 97;
        sArray6[187] = 96;
        sArray6[195] = 96;
        sArray6[196] = 96;
        sArray6[197] = 97;
        sArray6[198] = 99;
        sArray6[199] = 99;
        sArray6[200] = 99;
        sArray6[201] = 97;
        sArray6[202] = 96;
        sArray6[203] = 96;
        sArrayArray[5] = sArray6;
        short[] sArray7 = new short[256];
        sArray7[51] = 9;
        sArray7[52] = 9;
        sArray7[53] = 9;
        sArray7[54] = 11;
        sArray7[55] = 13;
        sArray7[56] = 11;
        sArray7[57] = 9;
        sArray7[58] = 9;
        sArray7[59] = 9;
        sArray7[67] = 19;
        sArray7[68] = 24;
        sArray7[69] = 34;
        sArray7[70] = 42;
        sArray7[71] = 44;
        sArray7[72] = 42;
        sArray7[73] = 34;
        sArray7[74] = 24;
        sArray7[75] = 19;
        sArray7[83] = 19;
        sArray7[84] = 24;
        sArray7[85] = 32;
        sArray7[86] = 37;
        sArray7[87] = 37;
        sArray7[88] = 37;
        sArray7[89] = 32;
        sArray7[90] = 24;
        sArray7[91] = 19;
        sArray7[99] = 19;
        sArray7[100] = 23;
        sArray7[101] = 27;
        sArray7[102] = 29;
        sArray7[103] = 30;
        sArray7[104] = 29;
        sArray7[105] = 27;
        sArray7[106] = 23;
        sArray7[107] = 19;
        sArray7[115] = 14;
        sArray7[116] = 18;
        sArray7[117] = 20;
        sArray7[118] = 27;
        sArray7[119] = 29;
        sArray7[120] = 27;
        sArray7[121] = 20;
        sArray7[122] = 18;
        sArray7[123] = 14;
        sArray7[131] = 7;
        sArray7[133] = 13;
        sArray7[135] = 16;
        sArray7[137] = 13;
        sArray7[139] = 7;
        sArray7[147] = 7;
        sArray7[149] = 7;
        sArray7[151] = 15;
        sArray7[153] = 7;
        sArray7[155] = 7;
        sArray7[166] = 1;
        sArray7[167] = 1;
        sArray7[168] = 1;
        sArray7[182] = 2;
        sArray7[183] = 2;
        sArray7[184] = 2;
        sArray7[198] = 11;
        sArray7[199] = 15;
        sArray7[200] = 11;
        sArrayArray[6] = sArray7;
        PIECE_VALUE = sArrayArray;
        int[][] nArrayArray = new int[4][];
        int[] nArray2 = new int[128];
        nArray2[19] = 7;
        nArray2[21] = 7;
        nArray2[23] = 7;
        nArray2[25] = 7;
        nArray2[27] = 7;
        nArray2[36] = 6;
        nArray2[42] = 6;
        nArray2[67] = 5;
        nArray2[68] = 4;
        nArray2[69] = 3;
        nArray2[70] = 2;
        nArray2[71] = 1;
        nArray2[72] = 2;
        nArray2[73] = 3;
        nArray2[74] = 4;
        nArray2[75] = 5;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[128];
        nArray3[19] = 7;
        nArray3[21] = 7;
        nArray3[23] = 7;
        nArray3[25] = 7;
        nArray3[27] = 7;
        nArray3[36] = 6;
        nArray3[42] = 6;
        nArray3[67] = 5;
        nArray3[68] = 4;
        nArray3[69] = 3;
        nArray3[70] = 2;
        nArray3[71] = 1;
        nArray3[72] = 2;
        nArray3[73] = 3;
        nArray3[75] = 5;
        nArrayArray[1] = nArray3;
        int[] nArray4 = new int[128];
        nArray4[19] = 7;
        nArray4[21] = 7;
        nArray4[23] = 7;
        nArray4[25] = 7;
        nArray4[27] = 7;
        nArray4[36] = 6;
        nArray4[42] = 6;
        nArray4[67] = 5;
        nArray4[69] = 3;
        nArray4[70] = 2;
        nArray4[71] = 1;
        nArray4[72] = 2;
        nArray4[73] = 3;
        nArray4[75] = 5;
        nArrayArray[2] = nArray4;
        int[] nArray5 = new int[128];
        nArray5[36] = 6;
        nArray5[42] = 6;
        nArray5[67] = 5;
        nArray5[68] = 4;
        nArray5[71] = 1;
        nArray5[74] = 4;
        nArray5[75] = 5;
        nArrayArray[3] = nArray5;
        BOARD_HANDICAP = nArrayArray;
        PreGen_zobristKeyTable = new int[14][256];
        PreGen_zobristLockTable = new int[14][256];
        random = new Random();
        RC4 rc4 = new RC4(new byte[1]);
        PreGen_zobristKeyPlayer = rc4.nextLong();
        rc4.nextLong();
        PreGen_zobristLockPlayer = rc4.nextLong();
        int i = 0;
        while (i < 14) {
            int j = 0;
            while (j < 256) {
                Position.PreGen_zobristKeyTable[i][j] = rc4.nextLong();
                rc4.nextLong();
                Position.PreGen_zobristLockTable[i][j] = rc4.nextLong();
                ++j;
            }
            ++i;
        }
    }

    public static final boolean IN_BOARD(int sq) {
        return IN_BOARD[sq] != 0;
    }

    public static final boolean IN_FORT(int sq) {
        return IN_FORT[sq] != 0;
    }

    public static final int RANK_Y(int sq) {
        return sq >> 4;
    }

    public static final int FILE_X(int sq) {
        return sq & 0xF;
    }

    public static final int COORD_XY(int x, int y) {
        return x + (y << 4);
    }

    public static final int SQUARE_FLIP(int sq) {
        return 254 - sq;
    }

    public static final int FILE_FLIP(int x) {
        return 14 - x;
    }

    public static final int RANK_FLIP(int y) {
        return 15 - y;
    }

    public static final int MIRROR_SQUARE(int sq) {
        return Position.COORD_XY(Position.FILE_FLIP(Position.FILE_X(sq)), Position.RANK_Y(sq));
    }

    public static final int SQUARE_FORWARD(int sq, int sd) {
        return sq - 16 + (sd << 5);
    }

    public static final int SQUARE_BACKWARD(int sq, int sd) {
        return sq + 16 - (sd << 5);
    }

    public static final boolean KING_SPAN(int sqSrc, int sqDst) {
        return LEGAL_SPAN[sqDst - sqSrc + 256] == 1;
    }

    public static final boolean ADVISOR_SPAN(int sqSrc, int sqDst) {
        return LEGAL_SPAN[sqDst - sqSrc + 256] == 2;
    }

    public static final boolean BISHOP_SPAN(int sqSrc, int sqDst) {
        return LEGAL_SPAN[sqDst - sqSrc + 256] == 3;
    }

    public static final int BISHOP_PIN(int sqSrc, int sqDst) {
        return sqSrc + sqDst >> 1;
    }

    public static final int KNIGHT_PIN(int sqSrc, int sqDst) {
        return sqSrc + KNIGHT_PIN[sqDst - sqSrc + 256];
    }

    public static final boolean HOME_HALF(int sq, int sd) {
        return (sq & 0x80) != sd << 7;
    }

    public static final boolean AWAY_HALF(int sq, int sd) {
        return (sq & 0x80) == sd << 7;
    }

    public static final boolean SAME_HALF(int sqSrc, int sqDst) {
        return ((sqSrc ^ sqDst) & 0x80) == 0;
    }

    public static final boolean DIFF_HALF(int sqSrc, int sqDst) {
        return ((sqSrc ^ sqDst) & 0x80) != 0;
    }

    public static final boolean SAME_RANK(int sqSrc, int sqDst) {
        return ((sqSrc ^ sqDst) & 0xF0) == 0;
    }

    public static final boolean SAME_FILE(int sqSrc, int sqDst) {
        return ((sqSrc ^ sqDst) & 0xF) == 0;
    }

    public static final int SIDE_TAG(int sd) {
        return 8 + (sd << 3);
    }

    public static final int OPP_SIDE_TAG(int sd) {
        return 16 - (sd << 3);
    }

    public static final int SRC(int mv) {
        return mv & 0xFF;
    }

    public static final int DST(int mv) {
        return mv >> 8;
    }

    public static final int MOVE(int sqSrc, int sqDst) {
        return sqSrc + (sqDst << 8);
    }

    public static final int MIRROR_MOVE(int mv) {
        return Position.MOVE(Position.MIRROR_SQUARE(Position.SRC(mv)), Position.MIRROR_SQUARE(Position.DST(mv)));
    }

    public static final int MVV_LVA(int pc, int lva) {
        return MVV_VALUE[pc & 7] - lva;
    }

    public static int binarySearch(int vl, int[] vls, int from, int to) {
        int low = from;
        int high = to - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int vlLeft = vls[mid] >>> 1;
            int vlRight = vl >>> 1;
            if (vlLeft < vlRight) {
                low = mid + 1;
                continue;
            }
            if (vlLeft > vlRight) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public void clearBoard() {
        this.sdPlayer = 0;
        int sq = 0;
        while (sq < 256) {
            this.squares[sq] = 0;
            ++sq;
        }
        this.zobristLock = 0;
        this.zobristKey = 0;
        this.vlBlack = 0;
        this.vlWhite = 0;
    }

    public void setIrrev() {
        this.pcList[0] = 0;
        this.mvList[0] = 0;
        this.chkList[0] = this.checked(this.sdPlayer);
        this.moveNum = 1;
        this.distance = 0;
    }

    public void loadBoard(int handicap) {
        int pc;
        this.clearBoard();
        int sq = 0;
        while (sq < 128) {
            pc = BOARD_HANDICAP[handicap][sq];
            if (pc > 0) {
                this.addPiece(128 + sq, pc + 8);
            }
            ++sq;
        }
        sq = 0;
        while (sq < 128) {
            pc = BOARD_HANDICAP[0][sq];
            if (pc > 0) {
                this.addPiece(126 - sq, pc + 16);
            }
            ++sq;
        }
        this.setIrrev();
    }

    public void addPiece(int sq, int pc, boolean del) {
        int pcAdjust;
        this.squares[sq] = (byte)(del ? 0 : pc);
        if (pc < 16) {
            pcAdjust = pc - 9;
            this.vlWhite += del ? -PIECE_VALUE[pcAdjust][sq] : PIECE_VALUE[pcAdjust][sq];
        } else {
            pcAdjust = pc - 17;
            this.vlBlack += del ? -PIECE_VALUE[pcAdjust][Position.SQUARE_FLIP(sq)] : PIECE_VALUE[pcAdjust][Position.SQUARE_FLIP(sq)];
            pcAdjust += 7;
        }
        this.zobristKey ^= PreGen_zobristKeyTable[pcAdjust][sq];
        this.zobristLock ^= PreGen_zobristLockTable[pcAdjust][sq];
    }

    public void addPiece(int sq, int pc) {
        this.addPiece(sq, pc, false);
    }

    public void delPiece(int sq, int pc) {
        this.addPiece(sq, pc, true);
    }

    public int movePiece(int mv) {
        int sqSrc = Position.SRC(mv);
        int sqDst = Position.DST(mv);
        byte pcCaptured = this.squares[sqDst];
        if (pcCaptured > 0) {
            this.delPiece(sqDst, pcCaptured);
        }
        byte pc = this.squares[sqSrc];
        this.delPiece(sqSrc, pc);
        this.addPiece(sqDst, pc);
        return pcCaptured;
    }

    public void undoMovePiece(int mv, int pcCaptured) {
        int sqSrc = Position.SRC(mv);
        int sqDst = Position.DST(mv);
        byte pc = this.squares[sqDst];
        this.delPiece(sqDst, pc);
        this.addPiece(sqSrc, pc);
        if (pcCaptured > 0) {
            this.addPiece(sqDst, pcCaptured);
        }
    }

    public void changeSide() {
        this.sdPlayer = 1 - this.sdPlayer;
        this.zobristKey ^= PreGen_zobristKeyPlayer;
        this.zobristLock ^= PreGen_zobristLockPlayer;
    }

    public boolean makeMove(int mv) {
        this.keyList[this.moveNum] = this.zobristKey;
        int pcCaptured = this.movePiece(mv);
        if (this.checked(this.sdPlayer)) {
            this.undoMovePiece(mv, pcCaptured);
            return false;
        }
        this.changeSide();
        this.mvList[this.moveNum] = mv;
        this.pcList[this.moveNum] = pcCaptured;
        this.chkList[this.moveNum] = this.checked(this.sdPlayer);
        ++this.moveNum;
        ++this.distance;
        return true;
    }

    public void undoMakeMove() {
        --this.moveNum;
        --this.distance;
        this.changeSide();
        this.undoMovePiece(this.mvList[this.moveNum], this.pcList[this.moveNum]);
    }

    public void nullMove() {
        this.keyList[this.moveNum] = this.zobristKey;
        this.changeSide();
        this.pcList[this.moveNum] = 0;
        this.mvList[this.moveNum] = 0;
        this.chkList[this.moveNum] = false;
        ++this.moveNum;
        ++this.distance;
    }

    public void undoNullMove() {
        --this.moveNum;
        --this.distance;
        this.changeSide();
    }

    public int generateAllMoves(int[] mvs) {
        return this.generateMoves(mvs, null);
    }

    public int generateMoves(int[] mvs, int[] vls) {
        int moves = 0;
        int pcSelfSide = Position.SIDE_TAG(this.sdPlayer);
        int pcOppSide = Position.OPP_SIDE_TAG(this.sdPlayer);
        int sqSrc = 0;
        while (sqSrc < 256) {
            byte pcSrc = this.squares[sqSrc];
            if ((pcSrc & pcSelfSide) != 0) {
                switch (pcSrc - pcSelfSide) {
                    case 1: {
                        byte pcDst;
                        int sqDst;
                        int i = 0;
                        while (i < 4) {
                            sqDst = sqSrc + KING_DELTA[i];
                            if (Position.IN_FORT(sqDst)) {
                                pcDst = this.squares[sqDst];
                                if (vls == null) {
                                    if ((pcDst & pcSelfSide) == 0) {
                                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                        ++moves;
                                    }
                                } else if ((pcDst & pcOppSide) != 0) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    vls[moves] = Position.MVV_LVA(pcDst, 5);
                                    ++moves;
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case 2: {
                        byte pcDst;
                        int sqDst;
                        int i = 0;
                        while (i < 4) {
                            sqDst = sqSrc + ADVISOR_DELTA[i];
                            if (Position.IN_FORT(sqDst)) {
                                pcDst = this.squares[sqDst];
                                if (vls == null) {
                                    if ((pcDst & pcSelfSide) == 0) {
                                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                        ++moves;
                                    }
                                } else if ((pcDst & pcOppSide) != 0) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    vls[moves] = Position.MVV_LVA(pcDst, 1);
                                    ++moves;
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case 3: {
                        byte pcDst;
                        int sqDst;
                        int i = 0;
                        while (i < 4) {
                            sqDst = sqSrc + ADVISOR_DELTA[i];
                            if (Position.IN_BOARD(sqDst) && Position.HOME_HALF(sqDst, this.sdPlayer) && this.squares[sqDst] == 0) {
                                pcDst = this.squares[sqDst += ADVISOR_DELTA[i]];
                                if (vls == null) {
                                    if ((pcDst & pcSelfSide) == 0) {
                                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                        ++moves;
                                    }
                                } else if ((pcDst & pcOppSide) != 0) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    vls[moves] = Position.MVV_LVA(pcDst, 1);
                                    ++moves;
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        byte pcDst;
                        int sqDst;
                        int i = 0;
                        while (i < 4) {
                            sqDst = sqSrc + KING_DELTA[i];
                            if (this.squares[sqDst] <= 0) {
                                int j = 0;
                                while (j < 2) {
                                    sqDst = sqSrc + KNIGHT_DELTA[i][j];
                                    if (Position.IN_BOARD(sqDst)) {
                                        pcDst = this.squares[sqDst];
                                        if (vls == null) {
                                            if ((pcDst & pcSelfSide) == 0) {
                                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                                ++moves;
                                            }
                                        } else if ((pcDst & pcOppSide) != 0) {
                                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                            vls[moves] = Position.MVV_LVA(pcDst, 1);
                                            ++moves;
                                        }
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case 5: {
                        int sqDst;
                        int delta;
                        byte pcDst;
                        int i = 0;
                        while (i < 4) {
                            delta = KING_DELTA[i];
                            sqDst = sqSrc + delta;
                            while (Position.IN_BOARD(sqDst)) {
                                pcDst = this.squares[sqDst];
                                if (pcDst == 0) {
                                    if (vls == null) {
                                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                        ++moves;
                                    }
                                } else {
                                    if ((pcDst & pcOppSide) == 0) break;
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    if (vls != null) {
                                        vls[moves] = Position.MVV_LVA(pcDst, 4);
                                    }
                                    ++moves;
                                    break;
                                }
                                sqDst += delta;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 6: {
                        int sqDst;
                        int delta;
                        byte pcDst;
                        int i = 0;
                        while (i < 4) {
                            delta = KING_DELTA[i];
                            sqDst = sqSrc + delta;
                            while (Position.IN_BOARD(sqDst)) {
                                pcDst = this.squares[sqDst];
                                if (pcDst != 0) break;
                                if (vls == null) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    ++moves;
                                }
                                sqDst += delta;
                            }
                            sqDst += delta;
                            while (Position.IN_BOARD(sqDst)) {
                                pcDst = this.squares[sqDst];
                                if (pcDst > 0) {
                                    if ((pcDst & pcOppSide) == 0) break;
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    if (vls != null) {
                                        vls[moves] = Position.MVV_LVA(pcDst, 4);
                                    }
                                    ++moves;
                                    break;
                                }
                                sqDst += delta;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 7: {
                        byte pcDst;
                        int sqDst = Position.SQUARE_FORWARD(sqSrc, this.sdPlayer);
                        if (Position.IN_BOARD(sqDst)) {
                            byte pcDst2 = this.squares[sqDst];
                            if (vls == null) {
                                if ((pcDst2 & pcSelfSide) == 0) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    ++moves;
                                }
                            } else if ((pcDst2 & pcOppSide) != 0) {
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                vls[moves] = Position.MVV_LVA(pcDst2, 2);
                                ++moves;
                            }
                        }
                        if (!Position.AWAY_HALF(sqSrc, this.sdPlayer)) break;
                        int delta = -1;
                        while (delta <= 1) {
                            sqDst = sqSrc + delta;
                            if (Position.IN_BOARD(sqDst)) {
                                pcDst = this.squares[sqDst];
                                if (vls == null) {
                                    if ((pcDst & pcSelfSide) == 0) {
                                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                        ++moves;
                                    }
                                } else if ((pcDst & pcOppSide) != 0) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    vls[moves] = Position.MVV_LVA(pcDst, 2);
                                    ++moves;
                                }
                            }
                            delta += 2;
                        }
                        break;
                    }
                }
            }
            ++sqSrc;
        }
        return moves;
    }

    public boolean legalMove(int mv) {
        int pcSelfSide;
        int sqSrc = Position.SRC(mv);
        byte pcSrc = this.squares[sqSrc];
        if ((pcSrc & (pcSelfSide = Position.SIDE_TAG(this.sdPlayer))) == 0) {
            return false;
        }
        int sqDst = Position.DST(mv);
        byte pcDst = this.squares[sqDst];
        if ((pcDst & pcSelfSide) != 0) {
            return false;
        }
        switch (pcSrc - pcSelfSide) {
            case 1: {
                return Position.IN_FORT(sqDst) && Position.KING_SPAN(sqSrc, sqDst);
            }
            case 2: {
                return Position.IN_FORT(sqDst) && Position.ADVISOR_SPAN(sqSrc, sqDst);
            }
            case 3: {
                return Position.SAME_HALF(sqSrc, sqDst) && Position.BISHOP_SPAN(sqSrc, sqDst) && this.squares[Position.BISHOP_PIN(sqSrc, sqDst)] == 0;
            }
            case 4: {
                int sqPin = Position.KNIGHT_PIN(sqSrc, sqDst);
                return sqPin != sqSrc && this.squares[sqPin] == 0;
            }
            case 5: 
            case 6: {
                int delta;
                if (Position.SAME_RANK(sqSrc, sqDst)) {
                    delta = sqDst < sqSrc ? -1 : 1;
                } else if (Position.SAME_FILE(sqSrc, sqDst)) {
                    delta = sqDst < sqSrc ? -16 : 16;
                } else {
                    return false;
                }
                int sqPin = sqSrc + delta;
                while (sqPin != sqDst && this.squares[sqPin] == 0) {
                    sqPin += delta;
                }
                if (sqPin == sqDst) {
                    return pcDst == 0 || pcSrc - pcSelfSide == 5;
                }
                if (pcDst > 0 && pcSrc - pcSelfSide == 6) {
                    sqPin += delta;
                    while (sqPin != sqDst && this.squares[sqPin] == 0) {
                        sqPin += delta;
                    }
                    return sqPin == sqDst;
                }
                return false;
            }
            case 7: {
                if (Position.AWAY_HALF(sqDst, this.sdPlayer) && (sqDst == sqSrc - 1 || sqDst == sqSrc + 1)) {
                    return true;
                }
                return sqDst == Position.SQUARE_FORWARD(sqSrc, this.sdPlayer);
            }
        }
        return false;
    }

    public boolean checked(int sd) {
        int pcSelfSide = Position.SIDE_TAG(sd);
        int pcOppSide = Position.OPP_SIDE_TAG(sd);
        int sqSrc = 0;
        while (sqSrc < 256) {
            if (this.squares[sqSrc] == pcSelfSide + 1) {
                if (this.squares[Position.SQUARE_FORWARD(sqSrc, sd)] == pcOppSide + 7) {
                    return true;
                }
                int delta = -1;
                while (delta <= 1) {
                    if (this.squares[sqSrc + delta] == pcOppSide + 7) {
                        return true;
                    }
                    delta += 2;
                }
                int i = 0;
                while (i < 4) {
                    if (this.squares[sqSrc + ADVISOR_DELTA[i]] == 0) {
                        int j = 0;
                        while (j < 2) {
                            byte pcDst = this.squares[sqSrc + KNIGHT_CHECK_DELTA[i][j]];
                            if (pcDst == pcOppSide + 4) {
                                return true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < 4) {
                    byte pcDst;
                    int delta2 = KING_DELTA[i];
                    int sqDst = sqSrc + delta2;
                    while (Position.IN_BOARD(sqDst)) {
                        pcDst = this.squares[sqDst];
                        if (pcDst > 0) {
                            if (pcDst != pcOppSide + 5 && pcDst != pcOppSide + 1) break;
                            return true;
                        }
                        sqDst += delta2;
                    }
                    sqDst += delta2;
                    while (Position.IN_BOARD(sqDst)) {
                        pcDst = this.squares[sqDst];
                        if (pcDst > 0) {
                            if (pcDst != pcOppSide + 6) break;
                            return true;
                        }
                        sqDst += delta2;
                    }
                    ++i;
                }
            }
            ++sqSrc;
        }
        return false;
    }

    public boolean isMate() {
        int[] mvs = new int[128];
        int moves = this.generateAllMoves(mvs);
        int i = 0;
        while (i < moves) {
            if (this.makeMove(mvs[i])) {
                this.undoMakeMove();
                return false;
            }
            ++i;
        }
        return true;
    }

    public int mateValue() {
        return this.distance - 1000;
    }

    public int drawValue() {
        return (this.distance & 1) == 0 ? -20 : 20;
    }

    public int evaluate() {
        return (this.sdPlayer == 0 ? this.vlWhite - this.vlBlack : this.vlBlack - this.vlWhite) + 3;
    }

    public boolean nullOkay() {
        return (this.sdPlayer == 0 ? this.vlWhite : this.vlBlack) > 200;
    }

    public boolean nullSafe() {
        return (this.sdPlayer == 0 ? this.vlWhite : this.vlBlack) > 400;
    }

    public boolean inCheck() {
        return this.chkList[this.moveNum - 1];
    }

    public int repValue(int vlRep) {
        int vlReturn = ((vlRep & 2) == 0 ? 0 : this.mateValue()) + ((vlRep & 4) == 0 ? 0 : -this.mateValue());
        return vlReturn == 0 ? this.drawValue() : vlReturn;
    }

    public int repStatus() {
        return this.repStatus(1);
    }

    public int repStatus(int recur) {
        int recurLocal = recur;
        boolean selfSide = false;
        boolean perpCheck = true;
        boolean oppPerpCheck = true;
        int index = this.moveNum - 1;
        while (this.mvList[index] > 0 && this.pcList[index] == 0) {
            if (selfSide) {
                boolean bl = perpCheck = perpCheck && this.chkList[index];
                if (this.keyList[index] == this.zobristKey && --recurLocal == 0) {
                    return 1 + (perpCheck ? 2 : 0) + (oppPerpCheck ? 4 : 0);
                }
            } else {
                oppPerpCheck = oppPerpCheck && this.chkList[index];
            }
            selfSide = !selfSide;
            --index;
        }
        return 0;
    }

    public Position mirror() {
        Position pos = new Position();
        pos.clearBoard();
        int sq = 0;
        while (sq < 256) {
            byte pc = this.squares[sq];
            if (pc > 0) {
                pos.addPiece(Position.MIRROR_SQUARE(sq), pc);
            }
            ++sq;
        }
        if (this.sdPlayer == 1) {
            pos.changeSide();
        }
        return pos;
    }

    public int bookMove() {
        boolean mirror = false;
        int lock = this.zobristLock;
        int index = Position.binarySearch(lock, Book.Lock.BOOK_LOCK, 0, 2074);
        if (index < 0) {
            mirror = true;
            lock = this.mirror().zobristLock;
            index = Position.binarySearch(lock, Book.Lock.BOOK_LOCK, 0, 2074);
        }
        if (index < 0) {
            return 0;
        }
        --index;
        while (index >= 0 && Book.Lock.BOOK_LOCK[index] == lock) {
            --index;
        }
        int[] mvs = new int[128];
        int[] vls = new int[128];
        int value = 0;
        int moves = 0;
        ++index;
        while (index < 2074 && Book.Lock.BOOK_LOCK[index] == lock) {
            int mv;
            int n = mv = mirror ? Position.MIRROR_MOVE(Book.Move.BOOK_MOVE[index]) : Book.Move.BOOK_MOVE[index];
            if (this.legalMove(mv)) {
                mvs[moves] = mv;
                vls[moves] = Book.Value.BOOK_VALUE[index];
                value += vls[moves];
                if (++moves == 128) break;
            }
            ++index;
        }
        if (value == 0) {
            return 0;
        }
        value = Math.abs(random.nextInt()) % value;
        index = 0;
        while (index < moves) {
            if ((value -= vls[index]) < 0) break;
            ++index;
        }
        return mvs[index];
    }

    public int historyIndex(int mv) {
        return (this.squares[Position.SRC(mv)] - 8 << 8) + Position.DST(mv);
    }

    public static class BookItem {
        public int zobristLock;
        public int mv;
        public int vl;

        public BookItem(int zobristLock, int mv, int vl) {
            this.zobristLock = zobristLock;
            this.mv = mv;
            this.vl = vl;
        }
    }

    public static class RC4 {
        public int[] state = new int[256];
        public int x = 0;
        public int y = 0;

        public void swap(int i, int j) {
            int t = this.state[i];
            this.state[i] = this.state[j];
            this.state[j] = t;
        }

        public RC4(byte[] key) {
            int i = 0;
            while (i < 256) {
                this.state[i] = i;
                ++i;
            }
            int j = 0;
            int i2 = 0;
            while (i2 < 256) {
                j = j + this.state[i2] + key[i2 % key.length] & 0xFF;
                this.swap(i2, j);
                ++i2;
            }
        }

        public int nextByte() {
            this.x = this.x + 1 & 0xFF;
            this.y = this.y + this.state[this.x] & 0xFF;
            this.swap(this.x, this.y);
            int t = this.state[this.x] + this.state[this.y] & 0xFF;
            return this.state[t];
        }

        public int nextLong() {
            int n0 = this.nextByte();
            int n1 = this.nextByte();
            int n2 = this.nextByte();
            int n3 = this.nextByte();
            return n0 + (n1 << 8) + (n2 << 16) + (n3 << 24);
        }
    }
}

