/*
 * Decompiled with CFR 0.152.
 */
package ui;

import basic.KConfig;
import basic.Resource;

public class Skin {
    public static final byte TYPE_NOROTATE = 0;
    public static final byte TYPE_ALLROTATE = 1;
    public static final byte TYPE_LRROTATE = 2;
    public static final byte TYPE_UDROTATE = 3;
    public byte type = 0;
    private short skinImage;
    public static byte LT = 0;
    public static byte LD = 1;
    public static byte RT = (byte)2;
    public static byte RD = (byte)3;
    public static byte L = 0;
    public static byte T = 1;
    public static byte R = (byte)2;
    public static byte D = (byte)3;
    public static byte X = 0;
    public static byte Y = 1;
    public static byte W = (byte)2;
    public static byte H = (byte)3;
    public static byte P = (byte)4;
    public short[][] angleSite;
    private short ltx;
    private short lty;
    private short ldx;
    private short ldy;
    private short rtx;
    private short rty;
    private short rdx;
    private short rdy;
    public short[][] borderSite;
    private short leftBorderCycleNum;
    private short topBorderCycleNum;
    private short downBorderCycleNum;
    private short rightBorderCycleNum;
    public byte isDrawGround = 1;
    public int[] groundColor;

    public Skin() {
    }

    public Skin(Skin sk) {
        this.skinImage = sk.skinImage;
        this.angleSite = sk.angleSite;
        this.borderSite = sk.borderSite;
        this.isDrawGround = sk.isDrawGround;
        this.groundColor = sk.groundColor;
    }

    public void loadIni(String obj) {
        int j2;
        int i2;
        KConfig conf = Resource.getKConfig((String)obj);
        String imageName = conf.getStringProp("Image", "a");
        this.skinImage = Resource.findImgIndex((String)imageName);
        if (this.skinImage == -1) {
            return;
        }
        this.type = (byte)conf.getIntProp("type", 0);
        this.angleSite = new short[4][4];
        for (i2 = 0; i2 < this.angleSite.length; ++i2) {
            for (j2 = 0; j2 < 4; ++j2) {
                this.angleSite[i2][j2] = (short)conf.getIntProp("A" + i2 + j2, 0);
            }
        }
        this.borderSite = new short[4][5];
        for (i2 = 0; i2 < this.borderSite.length; ++i2) {
            for (j2 = 0; j2 < 5; ++j2) {
                this.borderSite[i2][j2] = (short)conf.getIntProp("B" + i2 + j2, 0);
            }
        }
        this.isDrawGround = (byte)conf.getIntProp("ISGROUND", 0);
        this.groundColor = new int[4];
        for (i2 = 0; i2 < this.groundColor.length; ++i2) {
            this.groundColor[i2] = Integer.parseInt(conf.getStringProp("C" + i2, "0"), 16);
        }
    }

    private void drawGround(int x2, int y2, int width, int height, int layout) {
        if (this.isDrawGround != 0 && this.isDrawGround != 10) {
            Resource.addRect((byte)1, (int)(x2 + this.borderSite[L][P] + this.borderSite[L][W]), (int)(y2 + this.borderSite[T][P] + this.borderSite[T][H]), (int)(width - this.borderSite[L][W] - this.borderSite[L][P] - this.borderSite[R][W] - this.borderSite[R][P]), (int)(height - this.borderSite[T][H] - this.borderSite[T][P] - this.borderSite[D][H] - this.borderSite[D][P]), (boolean)true, (int)20, (int)this.groundColor[this.isDrawGround - 1], (int)layout);
        }
    }

    private void drawAngle(int layout) {
        Resource.addImage((int)this.skinImage, (int)this.ltx, (int)this.lty, (short[])this.angleSite[LT], (int)20, (int)0, (int)layout);
        Resource.addImage((int)this.skinImage, (int)this.ldx, (int)this.ldy, (short[])this.angleSite[LD], (int)20, (int)0, (int)layout);
        Resource.addImage((int)this.skinImage, (int)this.rtx, (int)this.rty, (short[])this.angleSite[RT], (int)20, (int)0, (int)layout);
        Resource.addImage((int)this.skinImage, (int)this.rdx, (int)this.rdy, (short[])this.angleSite[RD], (int)20, (int)0, (int)layout);
    }

    private void drawBorder(int x2, int y2, int width, int height, int layout) {
        int tempX = x2;
        int tempY = y2;
        x2 += this.borderSite[L][P];
        int lbh = y2 + this.angleSite[LT][H];
        for (int i2 = 0; i2 < this.leftBorderCycleNum; ++i2) {
            Resource.addImage((int)this.skinImage, (int)x2, (int)lbh, (short[])this.borderSite[L], (int)20, (int)0, (int)layout);
            lbh += this.borderSite[L][H];
        }
        Resource.addImage((int)this.skinImage, (int)x2, (int)lbh, (int)this.borderSite[L][X], (int)this.borderSite[L][Y], (int)this.borderSite[L][W], (int)(this.ldy - lbh), (int)20, (int)0, (int)layout);
        x2 = tempX;
        y2 += this.borderSite[T][P];
        int tbw = x2 + this.angleSite[LT][W];
        for (int i3 = 0; i3 < this.topBorderCycleNum; ++i3) {
            Resource.addImage((int)this.skinImage, (int)tbw, (int)y2, (short[])this.borderSite[T], (int)20, (int)0, (int)layout);
            tbw += this.borderSite[T][W];
        }
        Resource.addImage((int)this.skinImage, (int)tbw, (int)y2, (int)this.borderSite[T][X], (int)this.borderSite[T][Y], (int)(this.rtx - tbw), (int)this.borderSite[T][H], (int)20, (int)0, (int)layout);
        y2 = tempY;
        y2 -= this.borderSite[D][P];
        int dbw = x2 + this.angleSite[LD][W];
        for (int i4 = 0; i4 < this.downBorderCycleNum; ++i4) {
            Resource.addImage((int)this.skinImage, (int)dbw, (int)(y2 + height - this.borderSite[D][H]), (short[])this.borderSite[D], (int)20, (int)0, (int)layout);
            dbw += this.borderSite[D][W];
        }
        Resource.addImage((int)this.skinImage, (int)dbw, (int)(y2 + height - this.borderSite[D][H]), (int)this.borderSite[D][X], (int)this.borderSite[D][Y], (int)(this.rdx - dbw), (int)this.borderSite[D][H], (int)20, (int)0, (int)layout);
        y2 = tempY;
        x2 = tempX;
        x2 -= this.borderSite[R][P];
        int rbh = y2 + this.angleSite[RT][H];
        for (int i5 = 0; i5 < this.rightBorderCycleNum; ++i5) {
            Resource.addImage((int)this.skinImage, (int)(x2 + width - this.borderSite[R][W]), (int)rbh, (short[])this.borderSite[R], (int)20, (int)0, (int)layout);
            rbh += this.borderSite[R][H];
        }
        Resource.addImage((int)this.skinImage, (int)(x2 + width - this.borderSite[R][W]), (int)rbh, (int)this.borderSite[R][X], (int)this.borderSite[R][Y], (int)this.borderSite[R][W], (int)(this.rdy - rbh), (int)20, (int)0, (int)layout);
    }

    private void count(int x2, int y2, int width, int height) {
        this.ltx = (short)x2;
        this.lty = (short)y2;
        this.ldx = (short)x2;
        this.ldy = (short)(y2 + height - this.angleSite[LD][H]);
        this.rtx = (short)(x2 + width - this.angleSite[RT][W]);
        this.rty = (short)y2;
        this.rdx = (short)(x2 + width - this.angleSite[RD][W]);
        this.rdy = (short)(y2 + height - this.angleSite[RD][H]);
        this.leftBorderCycleNum = this.borderSite[L][H] == 0 ? (short)0 : (short)((height - this.angleSite[LT][H] - this.angleSite[LD][H]) / this.borderSite[L][H]);
        this.topBorderCycleNum = this.borderSite[T][W] == 0 ? (short)0 : (short)((width - this.angleSite[LT][W] - this.angleSite[RT][W]) / this.borderSite[T][W]);
        this.downBorderCycleNum = this.borderSite[D][W] == 0 ? (short)0 : (short)((width - this.angleSite[LD][W] - this.angleSite[RT][W]) / this.borderSite[D][W]);
        this.rightBorderCycleNum = this.borderSite[R][H] == 0 ? (short)0 : (short)((height - this.angleSite[RT][H] - this.angleSite[RD][W]) / this.borderSite[R][H]);
    }

    public void drawRect(int x2, int y2, int width, int height) {
        this.drawLayRect(x2, y2, width, height, 2000);
    }

    public void drawLayRect(int x2, int y2, int width, int height, int layout) {
        this.count(x2, y2, width, height);
        this.drawGround(x2, y2, width, height, layout);
        this.drawBorder(x2, y2, width, height, layout);
        this.drawAngle(layout);
    }

    public void drawRect(int x2, int y2, int width, int height, int bgT) {
        byte old = this.isDrawGround;
        this.isDrawGround = (byte)bgT;
        this.drawRect(x2, y2, width, height);
        this.isDrawGround = old;
    }

    public void clear() {
        Resource.removeOneImage((int)this.skinImage);
        this.skinImage = (short)-1;
    }
}

