/*
 * Decompiled with CFR 0.152.
 */
public class GVL2_XTextField_Eng
implements GVL2_KeyMapping {
    public static final int FIELD_TYPE_ENGLISH = 10;
    public static final int FIELD_TYPE_NUMBER = 11;
    public static final int FIELD_TYPE_ANY = 12;
    static final int RESULT_NONE = 0;
    static final int RESULT_CANCELED = 1;
    static final int RESULT_CONFIRMED = 2;
    public static final int CURSOR_TIME_MAX = 3000;
    private StringBuffer buff;
    private int max;
    private int history;
    private int keyCnt;
    private char lastKey;
    private int fieldType;
    private int cursor;
    private long cursorTime;

    public GVL2_XTextField_Eng(String s, int m, int nFieldType) {
        this.buff = new StringBuffer(s);
        this.max = m;
        this.fieldType = nFieldType;
        this.keyCnt = 0;
        this.lastKey = (char)32;
        this.cursor = s.length();
    }

    public int getCursor() {
        return this.cursor;
    }

    private void cursorMove(int value) {
        if (this.cursor + value >= 0 && this.cursor + value <= this.max - 1 && this.getLength() == this.cursor + value) {
            this.cursor += value;
            this.cursorTimeInit();
        }
    }

    private void cursorTimeInit() {
        this.cursorTime = System.currentTimeMillis();
    }

    public boolean cursorTimeCheck() {
        if (System.currentTimeMillis() - this.cursorTime >= 3000L && this.getLength() == this.getCursor() + 1) {
            this.cursorTimeInit();
            this.cursorMove(1);
            return true;
        }
        return false;
    }

    public String getString() {
        StringBuffer tBuff = new StringBuffer(this.buff.toString());
        if (tBuff.length() > 0) {
            tBuff.setCharAt(0, Character.toUpperCase(this.buff.charAt(0)));
        }
        this.cursorTimeCheck();
        return tBuff.toString();
    }

    public void setString(String s) {
        this.buff = new StringBuffer(s);
    }

    public int getLength() {
        int rt = this.buff.length() == 0 ? 0 : this.buff.length();
        return rt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int keyPressed(int key) {
        int idx = this.buff.length() - 1;
        if (key == -7 || key == -8) {
            if (idx < 0) return 1;
            this.buff.setLength(idx);
            this.history = key;
            this.keyCnt = 0;
            this.cursorMove(-1);
            return 0;
        } else if (key == -4) {
            this.cursorMove(1);
            if (idx < 0) return 0;
            this.history = key;
            this.keyCnt = 0;
            return 0;
        } else {
            if (key == -5 || key == -6) {
                if (idx < 0) return 0;
                return 2;
            }
            if (this.fieldType == 10 && key >= 50 && key <= 57 || this.fieldType == 12 && key >= 48 && key <= 57) {
                char first = 'A';
                int num = 3;
                this.cursorTimeInit();
                switch (key) {
                    case 48: {
                        first = '0';
                        num = 0;
                        break;
                    }
                    case 49: {
                        first = '1';
                        num = 0;
                        break;
                    }
                    case 50: {
                        break;
                    }
                    case 51: {
                        first = 'D';
                        break;
                    }
                    case 52: {
                        first = 'G';
                        break;
                    }
                    case 53: {
                        first = 'J';
                        break;
                    }
                    case 54: {
                        first = 'M';
                        break;
                    }
                    case 55: {
                        first = 'P';
                        num = 4;
                        break;
                    }
                    case 56: {
                        first = 'T';
                        break;
                    }
                    case 57: {
                        first = 'W';
                        num = 4;
                    }
                }
                if (this.lastKey != first) {
                    this.keyCnt = 0;
                }
                this.lastKey = first;
                ++this.keyCnt;
                if (this.buff.length() == this.getCursor()) {
                    this.buff.append(first);
                    this.history = key;
                    this.keyCnt = 1;
                    return 0;
                } else if (this.fieldType == 12 && num == 0) {
                    if (this.buff.length() >= this.max) return 0;
                    if (this.buff.length() != 0 && this.buff.length() != this.getCursor()) {
                        this.cursorMove(1);
                    }
                    this.buff.append(first);
                    this.history = key;
                    this.keyCnt = 0;
                    return 0;
                } else if (idx >= 0 && this.history == key) {
                    char myChar = ' ';
                    myChar = (char)(first + (this.keyCnt - 1) % num);
                    if (this.fieldType != 10 && this.fieldType == 12 && this.keyCnt - 1 == num) {
                        myChar = (char)key;
                        this.keyCnt = 0;
                    }
                    this.buff.setCharAt(idx, myChar);
                    return 0;
                } else {
                    if (this.buff.length() >= this.max) return 0;
                    if (this.buff.length() != 0) {
                        this.cursorMove(1);
                    }
                    this.buff.append(first);
                    this.history = key;
                }
                return 0;
            } else {
                if (this.fieldType != 11 || key < 48 || key > 57 || this.buff.length() >= this.max) return 0;
                if (this.buff.length() != 0) {
                    this.cursorMove(1);
                }
                this.buff.append((char)key);
            }
        }
        return 0;
    }
}

