/*
 * Decompiled with CFR 0.152.
 */
package zrong.res;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import zrong.res.Res;
import zrong.util.SystemAPI;

public class Png
extends Res {
    byte type;
    short[][] allRefs;
    short width;
    short height;
    byte[] pngData;
    Image image;
    public byte colorNum;
    public short pltesSize;
    public int[] pltes;
    public byte[] pixData;
    public Image[] colorImage;
    byte[][] iTxt_iDat_iHdrData;
    byte[][] pLte_tRnsData;

    protected Png(Image image) {
        this.image = image;
    }

    public short[] getSelRefInfo(int n) {
        if (n > this.allRefs.length - 1) {
            n = this.allRefs.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        return this.allRefs[n];
    }

    protected Png(int n) {
        this.type = (byte)n;
    }

    public int getType() {
        return this.type;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        if (this.image == null) {
            try {
                this.setImage(Image.createImage((InputStream)new ByteArrayInputStream(this.pngData)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getColorImage(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.colorImage.length - 1) {
            n = this.colorImage.length - 1;
        }
        if (this.colorImage[n] == null) {
            int n2 = this.pltesSize * n;
            int[] nArray = new int[this.pixData.length];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = this.pltes[n2 + (this.pixData[n3] & 0xFF)];
                ++n3;
            }
            this.colorImage[n] = Image.createRGBImage((int[])nArray, (int)this.width, (int)this.height, (boolean)true);
        }
        return this.colorImage[n];
    }

    public void clearImage() {
        this.image = null;
        if (this.colorImage != null) {
            this.colorImage = new Image[this.colorImage.length];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadNormalImage(DataInputStream dataInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.width = dataInputStream.readShort();
            this.height = dataInputStream.readShort();
            this.loadAllRefs(dataInputStream);
            dataInputStream.readByte();
            int n = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            dataInputStream.read(byArray);
            byteArrayOutputStream.write(Res.pngFileHead);
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Res.pngFileEnd);
            this.pngData = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        SystemAPI.closeByteArrayOutputStream(byteArrayOutputStream);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadColorImage(DataInputStream var1_1) {
        var2_2 = null;
        try {
            this.width = var1_1.readShort();
            this.height = var1_1.readShort();
            this.loadAllRefs(var1_1);
            var1_1.readByte();
            var3_3 = var1_1.readInt();
            var4_5 = new byte[var3_3];
            var1_1.read(var4_5);
            var2_2 = new ByteArrayInputStream(var4_5);
            var5_6 = new DataInputStream(var2_2);
            var6_7 = var5_6.readByte();
            var7_8 = var5_6.readByte() & 255;
            var8_9 = new int[var6_7 * var7_8];
            var9_10 = 0;
            if (true) ** GOTO lbl28
        }
        catch (Exception var3_4) {
            var3_4.printStackTrace();
            return;
        }
        do {
            var8_9[var9_10] = var5_6.readInt();
            ++var9_10;
lbl28:
            // 2 sources

        } while (var9_10 < var8_9.length);
        var10_11 = var5_6.readInt();
        var11_12 = new byte[var10_11];
        var12_13 = 0;
        while (var12_13 < var10_11) {
            var11_12[var12_13] = var5_6.readByte();
            ++var12_13;
        }
        this.colorNum = var6_7;
        this.pltesSize = (short)var7_8;
        this.pltes = var8_9;
        this.pixData = var11_12;
        this.colorImage = new Image[this.colorNum];
        SystemAPI.closeByteArrayInputStream(var2_2);
    }

    public void readColorImgData(DataInputStream dataInputStream) {
        try {
            int n;
            this.width = dataInputStream.readShort();
            this.height = dataInputStream.readShort();
            this.loadAllRefs(dataInputStream);
            dataInputStream.readByte();
            int n2 = dataInputStream.readByte();
            this.iTxt_iDat_iHdrData = new byte[n2][];
            int n3 = 0;
            while (n3 < n2) {
                n = dataInputStream.readInt();
                byte[] byArray = new byte[n];
                dataInputStream.read(byArray);
                this.iTxt_iDat_iHdrData[n3] = byArray;
                ++n3;
            }
            n = dataInputStream.readByte();
            this.colorNum = (byte)(n / 2);
            this.colorImage = new Image[n / 2];
            this.pLte_tRnsData = new byte[n][];
            int n4 = 0;
            while (n4 < n) {
                int n5 = dataInputStream.readInt();
                byte[] byArray = new byte[n5];
                dataInputStream.read(byArray);
                this.pLte_tRnsData[n4] = byArray;
                ++n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getColorImg(int var1_1) {
        block10: {
            if (var1_1 < 0) {
                var1_1 = 0;
            }
            if (var1_1 > this.colorImage.length - 1) {
                var1_1 = this.colorImage.length - 1;
            }
            var2_2 = null;
            try {
                if (this.colorImage[var1_1] != null) break block10;
                var2_2 = new ByteArrayOutputStream();
                var2_2.write(Res.pngFileHead);
                var3_3 = new byte[this.iTxt_iDat_iHdrData.length + 2][];
                var3_3[0] = this.iTxt_iDat_iHdrData[0];
                var3_3[1] = this.iTxt_iDat_iHdrData[1];
                var3_3[2] = this.pLte_tRnsData[var1_1 * 2];
                var3_3[3] = this.pLte_tRnsData[var1_1 * 2 + 1];
                var4_5 = 4;
                if (true) ** GOTO lbl28
            }
            catch (Exception var3_4) {
                var3_4.printStackTrace();
                SystemAPI.closeByteArrayOutputStream(var2_2);
                try {
                    return this.colorImage[var1_1];
                }
                catch (Throwable var7_8) {
                    SystemAPI.closeByteArrayOutputStream(var2_2);
                    throw var7_8;
                }
            }
            do {
                var3_3[var4_5] = this.iTxt_iDat_iHdrData[2 + var4_5 - 4];
                ++var4_5;
lbl28:
                // 2 sources

            } while (var4_5 < var3_3.length);
            var5_6 = 1;
            while (var5_6 < var3_3.length) {
                if (var3_3[var5_6] != null && var3_3[var5_6].length > 4) {
                    var2_2.write(Png.getChunkBytes(Res.pngFileChunkTypeList[var5_6 > 4 ? 4 : var5_6], var3_3[var5_6]));
                }
                ++var5_6;
            }
            var2_2.write(Res.pngFileEnd);
            var6_7 = var2_2.toByteArray();
            this.colorImage[var1_1] = Image.createImage((InputStream)new ByteArrayInputStream(var6_7));
            var2_2.close();
        }
        SystemAPI.closeByteArrayOutputStream(var2_2);
        return this.colorImage[var1_1];
    }

    public static byte[] getChunkBytes(String string, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 8];
        int n = byArray.length - 4;
        byArray2[0] = (byte)(n >>> 24);
        byArray2[1] = (byte)(n >>> 16);
        byArray2[2] = (byte)(n >>> 8);
        byArray2[3] = (byte)n;
        System.arraycopy(string.getBytes(), 0, byArray2, 4, 4);
        System.arraycopy(byArray, 0, byArray2, 8, byArray.length);
        return byArray2;
    }

    public void loadAllRefs(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        this.allRefs = new short[n][4];
        int n2 = 0;
        while (n2 < n) {
            this.allRefs[n2][0] = dataInputStream.readShort();
            this.allRefs[n2][1] = dataInputStream.readShort();
            this.allRefs[n2][2] = dataInputStream.readShort();
            this.allRefs[n2][3] = dataInputStream.readShort();
            if (this.allRefs[n2][0] < 0) {
                short[] sArray = this.allRefs[n2];
                sArray[2] = (short)(sArray[2] + this.allRefs[n2][0]);
                this.allRefs[n2][0] = 0;
            }
            if (this.allRefs[n2][1] < 0) {
                short[] sArray = this.allRefs[n2];
                sArray[3] = (short)(sArray[3] + this.allRefs[n2][1]);
                this.allRefs[n2][1] = 0;
            }
            if (this.allRefs[n2][0] + this.allRefs[n2][2] > this.width) {
                this.allRefs[n2][2] = (short)(this.width - this.allRefs[n2][0]);
            }
            if (this.allRefs[n2][1] + this.allRefs[n2][3] > this.height) {
                this.allRefs[n2][3] = (short)(this.height - this.allRefs[n2][1]);
            }
            ++n2;
        }
    }

    public void destroy() {
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Image image;
        short s = 0;
        int n8 = 0;
        short s2 = this.width;
        short s3 = this.height;
        if (n4 != -1) {
            if (n4 > this.allRefs.length - 1) {
                n4 = this.allRefs.length - 1;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            s = this.allRefs[n4][0];
            n8 = this.allRefs[n4][1];
            s2 = this.allRefs[n4][2];
            s3 = this.allRefs[n4][3];
        }
        if ((image = this.type == 1 ? this.getImage() : this.getColorImg(n3)) == null) {
            return;
        }
        Res.drawRegion(graphics, image, s, n8, s2, s3, n6, n, n2, n7);
    }
}

