/*
 * Decompiled with CFR 0.152.
 */
package zrong.res;

import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import zrong.res.Png;
import zrong.res.ResManager;
import zrong.res.SpriteInfo;

public abstract class Res {
    public static final byte RES_TYPE_NULL = 0;
    public static final byte RES_TYPE_IMAGE = 1;
    public static final byte RES_TYPE_COLORIMAGE = 13;
    public static final byte RES_TYPE_SPRITE = 3;
    public static final byte RES_TYPE_MAP = 4;
    public short id;
    public boolean isLocalRes;
    public static short[][] resIndex;
    public static byte[] colorIndex;
    protected static String[] pngFileChunkTypeList;
    protected static final byte[] pngFileHead;
    protected static final byte[] pngFileEnd;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int[] TRANS_ARRAYS;
    public static final int DEF_NONE = 0;
    public static final int DEF_ROT90 = 1;
    public static final int DEF_ROT180 = 2;
    public static final int DEF_ROT270 = 3;
    public static final int DEF_MIRROR = 4;
    public static final int DEF_MIRROR_ROT90 = 5;
    public static final int DEF_MIRROR_ROT180 = 6;
    public static final int DEF_MIRROR_ROT270 = 7;
    public static final int[] TRANS_RESULT;
    public static final int NOKIA_TRANS_NONE = 0;
    public static final int NOKIA_TRANS_ROT90 = 90;
    public static final int NOKIA_TRANS_ROT180 = 180;
    public static final int NOKIA_TRANS_ROT270 = 270;
    public static final int NOKIA_TRANS_MIRROR = 8192;
    public static final int NOKIA_TRANS_MIRROR_ROT90 = 8282;
    public static final int NOKIA_TRANS_MIRROR_ROT180 = 16384;
    public static final int NOKIA_TRANS_MIRROR_ROT270 = 16474;
    public static final int[] NOKIA_TRANS_ARRAYS;
    public static final String pngPath = "/png/";
    public static final String commPath = "/resbig/";

    public abstract void draw(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void destroy();

    public static int colorResIndex(int n) {
        int n2 = 0;
        while (n2 < resIndex.length) {
            if (n == resIndex[n2][0]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static Res getRes(int n) {
        return ResManager.getRes(n, true);
    }

    public static Res getRes(DataInputStream dataInputStream) throws IOException {
        short s = dataInputStream.readShort();
        byte by = dataInputStream.readByte();
        switch (by) {
            case 1: {
                Png png = new Png(1);
                png.loadNormalImage(dataInputStream);
                png.id = s;
                return png;
            }
            case 13: {
                Png png = new Png(13);
                png.readColorImgData(dataInputStream);
                png.id = s;
                return png;
            }
            case 3: {
                SpriteInfo spriteInfo = new SpriteInfo();
                spriteInfo.load(dataInputStream);
                spriteInfo.id = s;
                return spriteInfo;
            }
            case 4: {
                break;
            }
        }
        dataInputStream.close();
        return null;
    }

    public static Png getPng(int n) {
        Res res = ResManager.getRes(n, true);
        if (res != null) {
            return (Png)res;
        }
        return null;
    }

    public static SpriteInfo getSpriteInfo(int n) {
        Res res = Res.getRes(n);
        if (res != null) {
            return (SpriteInfo)res;
        }
        return null;
    }

    public static Res getMapRes(int n) {
        Res res = ResManager.getRes(n, true);
        if (res != null) {
            return res;
        }
        return null;
    }

    public static void drawRegion(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        graphics.drawRegion(image, n, n2, n3, n4, TRANS_ARRAYS[n5], n6, n7, n8);
    }

    public static int[] getAuthOff(int n, int n2, int n3) {
        int[] nArray = new int[2];
        if ((n & 4) != 0) {
            nArray[0] = 0;
        } else if ((n & 1) != 0) {
            nArray[0] = n2 / 2;
        } else if ((n & 8) != 0) {
            nArray[0] = n2;
        }
        if ((n & 0x10) != 0) {
            nArray[1] = 0;
        } else if ((n & 2) != 0) {
            nArray[1] = n3 / 2;
        } else if ((n & 0x20) != 0) {
            nArray[1] = n3;
        }
        return nArray;
    }

    public static int[] getTransOff(Image image, int n, int[] nArray) {
        int[] nArray2 = new int[4];
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        nArray2[2] = nArray[2];
        nArray2[3] = nArray[3];
        switch (n) {
            case 0: {
                nArray2[0] = nArray[0];
                nArray2[1] = nArray[1];
                break;
            }
            case 5: {
                nArray2[0] = nArray[1];
                nArray2[1] = n2 - nArray[0] - nArray[2];
                nArray2[2] = nArray[3];
                nArray2[3] = nArray[2];
                break;
            }
            case 3: {
                nArray2[0] = n2 - nArray[0] - nArray[2];
                nArray2[1] = n3 - nArray[3] - nArray[1];
                break;
            }
            case 6: {
                nArray2[0] = n3 - nArray[3] - nArray[1];
                nArray2[1] = nArray[0];
                nArray2[2] = nArray[3];
                nArray2[3] = nArray[2];
                break;
            }
            case 2: {
                nArray2[0] = n2 - nArray[0] - nArray[2];
                nArray2[1] = nArray[1];
                break;
            }
            case 7: {
                nArray2[0] = n3 - nArray[3] - nArray[1];
                nArray2[1] = n2 - nArray[0] - nArray[2];
                nArray2[2] = nArray[3];
                nArray2[3] = nArray[2];
                break;
            }
            case 1: {
                nArray2[0] = nArray[0];
                nArray2[1] = n3 - nArray[3] - nArray[1];
                break;
            }
            case 4: {
                nArray2[0] = nArray[1];
                nArray2[1] = nArray[0];
                nArray2[2] = nArray[3];
                nArray2[3] = nArray[2];
            }
        }
        return nArray2;
    }

    public static int[] getTransOff(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = new int[2];
        switch (n) {
            case 0: {
                nArray[0] = n4;
                nArray[1] = n5;
                break;
            }
            case 1: {
                nArray[0] = n3 - n7 - n5;
                nArray[1] = n4;
                break;
            }
            case 2: {
                nArray[0] = n2 - n4 - n6;
                nArray[1] = n3 - n7 - n5;
                break;
            }
            case 3: {
                nArray[0] = n5;
                nArray[1] = n2 - n4 - n6;
                break;
            }
            case 4: {
                nArray[0] = n2 - n4 - n6;
                nArray[1] = n5;
                break;
            }
            case 5: {
                nArray[0] = n3 - n7 - n5;
                nArray[1] = n2 - n4 - n6;
                break;
            }
            case 6: {
                nArray[0] = n4;
                nArray[1] = n3 - n7 - n5;
                break;
            }
            case 7: {
                nArray[0] = n5;
                nArray[1] = n4;
            }
        }
        return nArray;
    }

    public static int[] getTransOff(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[2];
        switch (n) {
            case 0: {
                nArray[0] = n4;
                nArray[1] = n5;
                break;
            }
            case 1: {
                nArray[0] = n3 - n5;
                nArray[1] = n4;
                break;
            }
            case 2: {
                nArray[0] = n2 - n4;
                nArray[1] = n3 - n5;
                break;
            }
            case 3: {
                nArray[0] = n5;
                nArray[1] = n2 - n4;
                break;
            }
            case 4: {
                nArray[0] = n2 - n4;
                nArray[1] = n5;
                break;
            }
            case 5: {
                nArray[0] = n3 - n5;
                nArray[1] = n2 - n4;
                break;
            }
            case 6: {
                nArray[0] = n4;
                nArray[1] = n3 - n5;
                break;
            }
            case 7: {
                nArray[0] = n5;
                nArray[1] = n4;
            }
        }
        return nArray;
    }

    public static int autoRunSprite(int n, int n2, int n3, long l, long l2) {
        SpriteInfo spriteInfo = Res.getSpriteInfo(n);
        return Res.autoRunSprite(spriteInfo, n2, n3, l, l2);
    }

    public static int autoRunSprite(Res res, int n, int n2, long l, long l2) {
        if (res == null) {
            return -1;
        }
        if (!(res instanceof SpriteInfo)) {
            return 0;
        }
        SpriteInfo spriteInfo = (SpriteInfo)res;
        int n3 = spriteInfo.delay;
        n3 = 100;
        int n4 = spriteInfo.getSeriesSize(n);
        if (l2 - l >= (long)n3) {
            return ++n2 >= n4 ? 0 : n2;
        }
        return -1;
    }

    public static int autoRunSprite(Res res, int n, int n2, long l, long l2, long l3) {
        if (res == null) {
            return -1;
        }
        if (!(res instanceof SpriteInfo)) {
            return 0;
        }
        SpriteInfo spriteInfo = (SpriteInfo)res;
        int n3 = spriteInfo.getSeriesSize(n);
        if (l2 - l >= l3) {
            return ++n2 >= n3 ? 0 : n2;
        }
        return -1;
    }

    public static int getOffX(int n, int n2) {
        Res res = Res.getRes(n);
        return Res.getOffX(res, n2);
    }

    public static int getOffX(Res res, int n) {
        if (res instanceof SpriteInfo) {
            return ((SpriteInfo)res).getBaseX_series(n);
        }
        return 0;
    }

    public static int getOffY(int n, int n2) {
        Res res = Res.getRes(n);
        return Res.getOffY(res, n2);
    }

    public static int getOffY(Res res, int n) {
        if (res instanceof SpriteInfo) {
            return ((SpriteInfo)res).getBaseY_series(n);
        }
        return 0;
    }

    public static int getWidth(int n, int n2) {
        Res res = Res.getRes(n);
        return Res.getWidth(res, n2);
    }

    public static int getWidth(Res res, int n) {
        if (res != null) {
            if (res instanceof Png) {
                if (n == -1) {
                    return ((Png)res).getWidth();
                }
                return ((Png)res).getSelRefInfo(n)[2];
            }
            if (res instanceof SpriteInfo) {
                return ((SpriteInfo)res).getWidth(n);
            }
        }
        return 0;
    }

    public static int getHeight(int n, int n2) {
        Res res = Res.getRes(n);
        return Res.getHeight(res, n2);
    }

    public static int getHeight(Res res, int n) {
        if (res != null) {
            if (res instanceof Png) {
                if (n == -1) {
                    return ((Png)res).getHeight();
                }
                return ((Png)res).getSelRefInfo(n)[3];
            }
            if (res instanceof SpriteInfo) {
                return ((SpriteInfo)res).getHeight(n);
            }
        }
        return 0;
    }

    public static boolean inField(int n, int n2, int n3, int n4, int n5, int n6) {
        return n3 + n5 >= n && n4 + n6 >= n2 && n3 <= n + 240 && n4 <= n2 + 320;
    }

    public static void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Res res = Res.getRes(n);
        if (res != null) {
            res.draw(graphics, n2, n3, n5, n4, n6, n7, n8);
        }
    }

    public static void draw(Graphics graphics, Res res, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        graphics.setClip(0, 0, 240, 320);
        if (res != null) {
            res.draw(graphics, n, n2, n4, n3, n5, n6, n7);
        }
    }

    public static Image creatImage(String string) {
        try {
            return Image.createImage((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static {
        pngFileChunkTypeList = new String[]{"tEXt", "IHDR", "PLTE", "tRNS", "IDAT"};
        pngFileHead = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        pngFileEnd = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        TRANS_ARRAYS = new int[]{0, 1, 2, 3, 2, 7, 1, 4};
        TRANS_RESULT = new int[]{0, 6, 4, 2};
        NOKIA_TRANS_ARRAYS = new int[]{0, 16384, 8192, 180, 16474, 90, 270, 8282};
    }
}

