/*
 * Decompiled with CFR 0.152.
 */
package zrong.res;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import zrong.res.Png;
import zrong.res.Res;

public class SpriteInfo
extends Res {
    public Vector frames = new Vector();
    public Vector allPngId = new Vector();
    public short[] baseX_Series;
    public short[] baseY_Series;
    short[] width;
    short[] height;
    public short delay;

    protected SpriteInfo() {
    }

    void load(DataInputStream dataInputStream) throws IOException {
        this.frames.removeAllElements();
        this.delay = dataInputStream.readShort();
        int n = dataInputStream.readByte();
        this.baseX_Series = new short[n];
        this.baseY_Series = new short[n];
        this.width = new short[n];
        this.height = new short[n];
        int n2 = 0;
        while (n2 < n) {
            Vector<SpriteFrame> vector = new Vector<SpriteFrame>();
            int n3 = dataInputStream.readByte();
            this.width[n2] = dataInputStream.readShort();
            this.height[n2] = dataInputStream.readShort();
            this.baseX_Series[n2] = dataInputStream.readShort();
            this.baseY_Series[n2] = dataInputStream.readShort();
            int n4 = 0;
            while (n4 < n3) {
                SpriteFrame spriteFrame = new SpriteFrame();
                spriteFrame.load(dataInputStream);
                vector.addElement(spriteFrame);
                ++n4;
            }
            this.frames.addElement(vector);
            ++n2;
        }
    }

    public void destroy() {
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n4;
        int n9 = n5;
        if (n8 < 0 || n8 >= this.frames.size()) {
            return;
        }
        Vector vector = (Vector)this.frames.elementAt(n8);
        if (n9 >= vector.size()) {
            return;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        ((SpriteFrame)vector.elementAt(n9)).draw(graphics, n - this.getBaseX_series(n8), n2 - this.getBaseY_series(n8), this.getWidth(n8), this.getHeight(n8), n3, n6, n7);
    }

    public short getBaseX_series(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.baseX_Series.length - 1) {
            n = this.baseX_Series.length - 1;
        }
        return this.baseX_Series[n];
    }

    public short getBaseY_series(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.baseY_Series.length - 1) {
            n = this.baseY_Series.length - 1;
        }
        return this.baseY_Series[n];
    }

    public int getSeriesSize(int n) {
        if (n < 0 || n >= this.frames.size()) {
            return -1;
        }
        Vector vector = (Vector)this.frames.elementAt(n);
        return vector.size();
    }

    public int getWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.width.length - 1) {
            n = this.width.length - 1;
        }
        return this.width[n];
    }

    public int getHeight(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.height.length - 1) {
            n = this.height.length - 1;
        }
        return this.height[n];
    }

    class SpriteFrame {
        Res[] refsRes;
        short[] refsInfoOne;
        short[] refsInfoTwo;
        short[] refsInfoThree;

        SpriteFrame() {
        }

        public void load(DataInputStream dataInputStream) throws IOException {
            dataInputStream.readShort();
            int n = dataInputStream.readByte();
            if (n < 0) {
                n = 0xFF & n;
            }
            this.refsRes = new Res[n];
            this.refsInfoOne = new short[n];
            this.refsInfoTwo = new short[n];
            this.refsInfoThree = new short[n];
            short[] sArray = new short[n];
            byte[] byArray = new byte[n];
            short[] sArray2 = new short[n];
            short[] sArray3 = new short[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                sArray[n2] = dataInputStream.readShort();
                int n3 = Res.colorResIndex(sArray[n2]);
                byArray2[n2] = n3 != -1 ? Res.colorIndex[n3] : 63;
                this.refsRes[n2] = Res.getRes(sArray[n2]);
                byArray3[n2] = dataInputStream.readByte();
                sArray2[n2] = dataInputStream.readShort();
                sArray3[n2] = dataInputStream.readShort();
                byArray[n2] = dataInputStream.readByte();
                this.refsInfoOne[n2] = (short)((byArray[n2] << 13) + sArray[n2]);
                this.refsInfoTwo[n2] = (short)((byArray2[n2] << 9) + sArray2[n2]);
                this.refsInfoThree[n2] = (short)((byArray3[n2] << 9) + sArray3[n2]);
                Integer n4 = new Integer(sArray[n2]);
                if (!SpriteInfo.this.allPngId.contains(n4)) {
                    SpriteInfo.this.allPngId.addElement(n4);
                }
                ++n2;
            }
        }

        public int getRefsId(int n) {
            return (short)(this.refsInfoOne[n] & 0x1FFF);
        }

        public int getRefIndex(int n) {
            return this.refsInfoThree[n] >>> 9 & 0x7F;
        }

        public int getRefsFlip(int n) {
            return this.refsInfoOne[n] >> 13;
        }

        public int getRefsX(int n) {
            return (short)(this.refsInfoTwo[n] & 0x1FF);
        }

        public int getRefsY(int n) {
            return this.refsInfoThree[n] & 0x1FF;
        }

        public int getColorIndex(int n) {
            short s = (short)(this.refsInfoTwo[n] >>> 9);
            return s == 63 ? -1 : (int)s;
        }

        public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            int n8 = 0;
            while (n8 < this.refsRes.length) {
                if (this.refsRes[n8] == null) {
                    this.refsRes[n8] = Res.getRes(this.getRefsId(n8));
                }
                if (this.refsRes[n8] != null && this.refsRes[n8] instanceof Png) {
                    int n9 = this.getColorIndex(n8);
                    if (((Png)this.refsRes[n8]).type == 13 && n5 != -1 && n5 <= ((Png)this.refsRes[n8]).colorNum) {
                        n9 = n5;
                    }
                    short[] sArray = ((Png)this.refsRes[n8]).getSelRefInfo(this.getRefIndex(n8));
                    int[] nArray = this.setSpriteFrame(sArray, this.getRefsX(n8), this.getRefsY(n8), n3, n4, this.getRefsFlip(n8), n6);
                    int n10 = nArray[0];
                    int n11 = nArray[1];
                    int n12 = nArray[2];
                    this.refsRes[n8].draw(graphics, n + n10, n2 + n11, n9, this.getRefIndex(n8), 0, n12, n7);
                }
                ++n8;
            }
        }

        public int[] setSpriteFrame(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
            int[] nArray = new int[3];
            short s = sArray[2];
            short s2 = sArray[3];
            if (n6 == 2) {
                if (n5 == 0) {
                    n5 = 2;
                } else if (n5 == 2) {
                    n5 = 0;
                } else if (n5 == 1) {
                    n5 = 3;
                } else if (n5 == 3) {
                    n5 = 1;
                }
                n = n3 - n - s;
            } else if (n6 == 1) {
                if (n5 == 0) {
                    n5 = 1;
                } else if (n5 == 1) {
                    n5 = 0;
                } else if (n5 == 2) {
                    n5 = 3;
                } else if (n5 == 3) {
                    n5 = 2;
                }
                n2 = n4 - n2 - s2;
            } else if (n6 == 3) {
                if (n5 == 0) {
                    n5 = 3;
                } else if (n5 == 1) {
                    n5 = 2;
                } else if (n5 == 2) {
                    n5 = 1;
                } else if (n5 == 3) {
                    n5 = 0;
                }
                n = n3 - n - s;
                n2 = n4 - n2 - s2;
            }
            nArray[0] = n;
            nArray[1] = n2;
            nArray[2] = n5;
            return nArray;
        }
    }
}

