/*
 * Decompiled with CFR 0.152.
 */
package com.movaya.license.rms;

import com.movaya.license.structure.LicenseBlock;
import com.movaya.license.structure.Resolve;
import javax.microedition.rms.RecordStore;

public final class RmsManager {
    private static final String RECORD_STORM_NAME_PREFIX = "movaya.license";
    private RecordStore m_recordStore = null;
    private int recordIndex = 1;
    private String recordStoreName = "";
    private Resolve resolve = new Resolve();

    public RmsManager(int licenseId) throws Exception {
        this.recordStoreName = RECORD_STORM_NAME_PREFIX.concat(String.valueOf(licenseId));
        this.m_recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
    }

    private void insert(LicenseBlock lic) throws Exception {
        if (lic == null) {
            throw new NullPointerException("The parameter licenseBlock is null.");
        }
        byte[] data = lic.generate();
        this.m_recordStore.addRecord(data, 0, data.length);
    }

    public LicenseBlock query(int licenseId) throws Exception {
        block4: {
            try {
                if (this.getRecordSize() <= 0) break block4;
                LicenseBlock rmslic = null;
                rmslic = this.resolve.resolve(this.m_recordStore.getRecord(this.recordIndex));
                if (rmslic.getLicenseId() == licenseId) {
                    return rmslic;
                }
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        throw new Exception("RecordStore ".concat(this.recordStoreName).concat(" is empty."));
    }

    public void update(LicenseBlock lic) throws Exception {
        if (this.getRecordSize() > 0) {
            LicenseBlock rmslic = null;
            rmslic = this.resolve.resolve(this.m_recordStore.getRecord(this.recordIndex));
            if (rmslic.getLicenseId() == lic.getLicenseId()) {
                byte[] data = lic.generate();
                this.m_recordStore.setRecord(this.recordIndex, data, 0, data.length);
            }
        } else {
            this.insert(lic);
        }
    }

    private int getRecordSize() {
        try {
            return this.m_recordStore.getNumRecords();
        }
        catch (Exception e2) {
            return 0;
        }
    }
}

